/*
 * Decompiled with CFR 0.152.
 */
package las.gui;

import cmn.cmnLASFileListStruct;
import cmn.cmnLASFileStruct;
import cmn.cmnStruct;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import las.gui.lasFilesFrameObservable;
import las.gui.lasFilesTable;
import las.lasFileDataStruct;
import las.lasFileDataUtility;
import las3.io.las3Read;
import las3.las3ListStruct;

public class lasFilesFrame
extends JFrame
implements ActionListener,
Observer {
    private Observable pNotifier = null;
    private iqstratStruct stStruct = null;
    private cmnStruct stCMN = null;
    private cmnLASFileListStruct stList = null;
    private Observable notifier = null;
    private lasFilesTable pTable = null;
    private las3Read pRead = null;
    private las3ListStruct stLAS3 = null;
    private lasFileDataStruct stLASFileData = null;
    private double dStart = 0.0;
    private double dEnd = 2000.0;
    private int iColorlith = 0;
    private JButton btnSelect = new JButton();
    private JButton btnCancel = new JButton();

    public lasFilesFrame(iqstratStruct iqstratStruct2, Observable observable, cmnLASFileListStruct cmnLASFileListStruct2) {
        try {
            this.stStruct = iqstratStruct2;
            this.stCMN = iqstratStruct2.stCMN;
            this.pNotifier = observable;
            this.stList = cmnLASFileListStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.notifier = new lasFilesFrameObservable();
        this.notifier.addObserver(this);
        this.setTitle("Select LAS File");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnSelect.setFont(new Font("Dialog", 1, 11));
        this.btnSelect.setText("Select");
        this.btnSelect.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        jPanel2.setLayout(new BorderLayout());
        this.pTable = new lasFilesTable(this.stList);
        jScrollPane = this.pTable.getScrollPane();
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.btnSelect, null);
        jPanel.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)jScrollPane, "Center");
        this.setSize(new Dimension(600, 200));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public las3ListStruct getLAS3() {
        return this.stLAS3;
    }

    public lasFileDataStruct getLASDataStructure() {
        return this.stLASFileData;
    }

    public double getStartingDepth() {
        return this.dStart;
    }

    public double getEndingDepth() {
        return this.dEnd;
    }

    public int getColorlith() {
        return this.iColorlith;
    }

    private void select() {
        cmnLASFileStruct cmnLASFileStruct2 = this.pTable.getRow();
        this.pRead = new las3Read(this.notifier, this.stStruct);
        this.pRead.setPath("URL", cmnLASFileStruct2.sDirectory, cmnLASFileStruct2.sFilename);
    }

    public void close() {
        this.pNotifier = null;
        this.stStruct = null;
        this.stCMN = null;
        this.notifier = null;
        this.stList = null;
        if (this.stLAS3 != null) {
            this.stLAS3.delete();
        }
        this.stLAS3 = null;
        if (this.stLASFileData != null) {
            this.stLASFileData.delete();
        }
        this.stLASFileData = null;
        if (this.pRead != null) {
            this.pRead.delete();
        }
        this.pRead = null;
        if (this.pTable != null) {
            this.pTable.close();
        }
        this.pTable = null;
        this.btnSelect = null;
        this.btnCancel = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSelect) {
            this.select();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.close();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        if (string.equals("LAS 3 - Curves Selected")) {
            if (this.pRead != null) {
                this.stLASFileData = lasFileDataUtility.copy(this.pRead.getLASData());
                this.dStart = this.stLASFileData.depthStart;
                this.dEnd = this.stLASFileData.depthEnd;
                this.iColorlith = this.stLASFileData.iColorlithDefault;
                this.pRead.delete();
                this.pRead = null;
            }
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("KGS LAS File Loaded"));
            }
        }
    }
}

