/*
 * Decompiled with CFR 0.152.
 */
package kgs.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kgs.kgsMeasSectDataStruct;
import kgs.kgsMeasSectListStruct;
import kgs.kgsMeasSectStruct;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadMeasSectXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    public static final int NOERROR = 0;
    public static final int ERROR = -1;
    public static final String ROOTNAME = "outcrop";
    public static final String RECORDS = "records";
    public static final String LOCATION = "location";
    public static final String INFO = "info";
    public static final String KID = "mid";
    public static final String NAME = "name";
    public static final String ERROR_VAL = "error";
    public static final String STATE = "state";
    public static final String STATE_CODE = "state_cd";
    public static final String COUNTY = "county";
    public static final String COUNTY_CODE = "county_cd";
    public static final String TOWNSHIP = "town";
    public static final String TOWNSHIP_DIR = "town_dir";
    public static final String RANGE = "range";
    public static final String RANGE_DIR = "range_dir";
    public static final String SECTION = "section";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String GROUND_LEVEL = "gl";
    public static final String COMMENTS = "comments";
    public static final String MEASURED = "meas_by";
    public static final String DATA = "data";
    public static final String KEY = "key";
    public static final String UNIT_ORDER = "order";
    public static final String UNIT_NO = "no";
    public static final String DESCRIPTION = "desc";
    public static final String THICKNESS = "thickness";
    public static final String UNITS = "units";
    private int iError = 0;
    private String sError = new String("");
    private static final int _BEGIN = 0;
    private static final int _LOCATION = 1;
    private static final int _INFO = 2;
    private static final int _COMMENTS = 3;
    private static final int _DATA = 4;
    private int iData = 0;
    private int iType = 0;
    private int iSections = 0;
    private int iBeds = 0;
    private int iCount = -1;
    private int iRows = -1;
    private int iComments = 0;
    private kgsMeasSectListStruct stList = new kgsMeasSectListStruct();
    private boolean bContinue = false;

    public ReadMeasSectXMLFile() {
        this.iType = 0;
    }

    public ReadMeasSectXMLFile(int n) {
        this.iType = n;
    }

    public kgsMeasSectListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        if (this.iRows > 0) {
            ++this.iRows;
        }
        this.stList.iRows = this.iRows;
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    this.iError = -1;
                    this.sError = new String(exception.toString());
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    this.iError = -1;
                    this.sError = new String(exception.toString());
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    this.iError = -1;
                    this.sError = new String(exception.toString());
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            this.iError = -1;
            this.sError = new String("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n" + sAXParseException.getMessage());
            System.out.println(this.sError);
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(LOCATION)) {
            this.iData = 1;
            this.iComments = 0;
        }
        if (string4.equals(INFO)) {
            this.iData = 2;
            this.iComments = 0;
            ++this.iCount;
            if (this.iCount < this.iSections) {
                this.stList.stItem[this.iCount] = new kgsMeasSectStruct();
            }
        }
        if (string4.equals(COMMENTS)) {
            this.iData = 3;
            this.iComments = 1;
        }
        if (string4.equals(DATA)) {
            this.iData = 4;
            this.iComments = 0;
            if (!this.bContinue) {
                ++this.iRows;
                if (this.iRows < this.iBeds) {
                    this.stList.stData[this.iRows] = new kgsMeasSectDataStruct();
                }
            }
        }
        if (attributes != null) {
            block8: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    switch (this.iData) {
                        case 0: {
                            this.iSections = cmnString.stringToInt(string7.trim());
                            if (this.iSections <= 0) break;
                            this.stList.stItem = new kgsMeasSectStruct[this.iSections];
                            this.stList.iCount = this.iSections;
                            break;
                        }
                        case 1: {
                            this.iBeds = cmnString.stringToInt(string7.trim());
                            if (this.iBeds <= 0) break;
                            this.stList.stData = new kgsMeasSectDataStruct[this.iBeds];
                            this.stList.iRows = this.iBeds;
                        }
                    }
                }
                if (this.iCount <= -1) continue;
                switch (this.iData) {
                    case 2: {
                        if (this.iCount >= this.iSections) continue block8;
                        this.stList.stItem[this.iCount] = this.ParseLoc(string5, string7.trim(), this.stList.stItem[this.iCount]);
                        continue block8;
                    }
                    case 4: {
                        if (this.iRows >= this.iBeds) continue block8;
                        this.stList.stData[this.iRows] = this.ParseData(string5, string7.trim(), this.stList.stData[this.iRows]);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.iComments == 1) {
            this.stList.stItem[this.iCount].sComments = new String(this.stList.stItem[this.iCount].sComments + " " + string.trim());
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        this.iError = -1;
        this.sError = new String(sAXParseException.toString());
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this.iError = -1;
        this.sError = new String("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n" + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private kgsMeasSectStruct ParseLoc(String string, String string2, kgsMeasSectStruct kgsMeasSectStruct2) {
        if (string.equals(KID)) {
            kgsMeasSectStruct2.sKID = new String(string2);
        }
        if (string.equals(NAME)) {
            kgsMeasSectStruct2.sName = new String(string2);
        }
        if (string.equals(ERROR_VAL)) {
            this.iError = -1;
            this.sError = new String(string2);
            kgsMeasSectStruct2.sError = new String(this.sError);
        }
        if (string.equals(STATE)) {
            kgsMeasSectStruct2.state = new String(string2);
        }
        if (string.equals(STATE_CODE) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.iState = cmnString.stringToInt(string2);
        }
        if (string.equals(COUNTY)) {
            kgsMeasSectStruct2.sCounty = new String(string2);
        }
        if (string.equals(COUNTY_CODE) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.iCounty = cmnString.stringToInt(string2);
        }
        if (string.equals(TOWNSHIP) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.iTownship = cmnString.stringToInt(string2);
        }
        if (string.equals(TOWNSHIP_DIR)) {
            kgsMeasSectStruct2.sTownship = new String(string2);
        }
        if (string.equals(RANGE) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.iRange = cmnString.stringToInt(string2);
        }
        if (string.equals(RANGE_DIR)) {
            kgsMeasSectStruct2.sRange = new String(string2);
        }
        if (string.equals(SECTION) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.iSection = cmnString.stringToInt(string2);
        }
        if (string.equals(LATITUDE) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONGITUDE) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(GROUND_LEVEL) && cmnString.isNumeric(string2)) {
            kgsMeasSectStruct2.dGL = cmnString.stringToDouble(string2);
        }
        if (string.equals(MEASURED)) {
            kgsMeasSectStruct2.sMeasuredBy = new String(string2);
        }
        return kgsMeasSectStruct2;
    }

    private kgsMeasSectDataStruct ParseData(String string, String string2, kgsMeasSectDataStruct kgsMeasSectDataStruct2) {
        String string3 = "";
        if (!this.bContinue) {
            if (string.equals(KEY)) {
                kgsMeasSectDataStruct2.sKEY = new String(string2);
            }
            if (string.equals(UNIT_ORDER)) {
                kgsMeasSectDataStruct2.sOrder = new String(string2);
            }
            if (string.equals(UNIT_NO)) {
                kgsMeasSectDataStruct2.sUnitNo = new String(string2);
            }
            if (string.equals(THICKNESS)) {
                kgsMeasSectDataStruct2.dThickness = cmnString.isNumeric(string2) ? cmnString.stringToDouble(string2) : this.getThickness(string2);
            }
            if (string.equals(UNITS)) {
                kgsMeasSectDataStruct2.sUnits = new String(string2);
                if (kgsMeasSectDataStruct2.sUnits.equals("m.") || kgsMeasSectDataStruct2.sUnits.equals("m")) {
                    kgsMeasSectDataStruct2.dThickness = 3.281 * kgsMeasSectDataStruct2.dThickness;
                    kgsMeasSectDataStruct2.sUnits = new String("ft.");
                }
                if (kgsMeasSectDataStruct2.sUnits.equals("in.")) {
                    kgsMeasSectDataStruct2.dThickness /= 12.0;
                    kgsMeasSectDataStruct2.sUnits = new String("ft.");
                }
            }
        }
        if (string.equals(DESCRIPTION)) {
            string3 = new String(ReadMeasSectXMLFile.removePAREN(string2));
            kgsMeasSectDataStruct2.sDescription = !this.bContinue ? new String(string3) : new String(kgsMeasSectDataStruct2.sDescription + " " + string3);
            this.bContinue = ReadMeasSectXMLFile.checkCont(string3);
        }
        return kgsMeasSectDataStruct2;
    }

    private double getThickness(String string) {
        double d = 0.0;
        String[] stringArray = null;
        String string2 = new String("[- ]+");
        int n = 0;
        int n2 = 2;
        int n3 = 0;
        double[] dArray = new double[]{0.0, 0.0, 0.0};
        stringArray = string.split(string2);
        n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (n3 >= n2 || !cmnString.isNumeric(stringArray[i])) continue;
            dArray[n3] = cmnString.stringToDouble(stringArray[i]);
            ++n3;
        }
        if (n3 == 1) {
            d = dArray[0];
        } else if (n3 == 2) {
            d = (dArray[0] + dArray[1]) / 2.0;
        }
        return d;
    }

    public static String removePAREN(String string) {
        String string2 = new String("");
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '(' || cArray[i] == ')') continue;
                string2 = new String(string2 + cArray[i]);
            }
        }
        return string2;
    }

    public static boolean checkCont(String string) {
        boolean bl = false;
        String string2 = new String(string.toUpperCase());
        if (string2.contains("CON'T-->")) {
            bl = true;
        }
        return bl;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

