/*
 * Decompiled with CFR 0.152.
 */
package kgs.gui;

import brine.brineListStruct;
import brine.brineStruct;
import brine.io.ReadBrineDataXMLFile;
import cmn.cmnString;
import iqstrat.iqstratHeadersStruct;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import kgs.gui.kgsBrineFrameFocusAdapter;
import kgs.gui.kgsBrineTable;
import kgs.io.ReadMeasSectXMLFile;
import kgs.kgsMeasSectListStruct;
import las3.las3LoadWellHeader;

public class kgsBrineFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private int iTownship = 0;
    private String sTownship = "S";
    private int iRange = 0;
    private String sRange = "E";
    private int iSection = 0;
    private String sPath = "";
    private static final int _LEASE = 1;
    private static final int _TRS = 2;
    private static final int _COUNTY = 3;
    private int iSearch = 1;
    private kgsBrineTable pTable = null;
    private brineListStruct stList = null;
    private brineStruct stBrine = null;
    private brineListStruct stData = null;
    private iqstratHeadersStruct stHeader = null;
    private int _COUNTIES = 0;
    private int[] _CODES = null;
    private String[] _NAMES = null;
    private JPanel pnlKGSTextSearch = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private JRadioButton rbLease = new JRadioButton();
    private JRadioButton rbTRS = new JRadioButton();
    private JRadioButton rbCounty = new JRadioButton();
    private JButton btnSearch = new JButton();
    private JTextField txtText = new JTextField();
    private JTextField txtTownship = new JTextField();
    private JRadioButton rbNorth = new JRadioButton();
    private JRadioButton rbSouth = new JRadioButton();
    private JTextField txtRange = new JTextField();
    private JRadioButton rbEast = new JRadioButton();
    private JRadioButton rbWest = new JRadioButton();
    private JButton[] btn = null;
    private JTextField txtSection = new JTextField();
    private JButton btnSelect = new JButton();
    private JMenuItem mExit = null;

    public kgsBrineFrame(Observable observable) {
        try {
            this.notifier = observable;
            this.getCounties();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel13 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        JScrollPane jScrollPane2 = new JScrollPane();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Search for Data in Kansas Geological Survey Database:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Search By:");
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Township:");
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Range:");
        TitledBorder titledBorder5 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Section:");
        TitledBorder titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Enter Partial Lease Name:");
        TitledBorder titledBorder7 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "List of Brine Samples:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder5.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder6.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder7.setTitleFont(new Font("Dialog", 1, 11));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Close Dialog");
        this.mExit = new JMenuItem("Close");
        this.mExit.addActionListener(this);
        jMenu.add(this.mExit);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.setTitle("Search for KGS Brine Data");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout());
        jPanel3.setLayout(new BorderLayout());
        this.btnSearch.setFont(new Font("Dialog", 1, 11));
        this.btnSearch.setActionCommand("btnSearch");
        this.btnSearch.setText("Search");
        this.btnSearch.addActionListener(this);
        jPanel4.setBorder(titledBorder2);
        jPanel4.setLayout(new BorderLayout());
        jPanel5.setLayout(new GridLayout(3, 1));
        this.rbLease.setFont(new Font("Dialog", 1, 11));
        this.rbLease.setText("Lease Name");
        this.rbLease.setHorizontalAlignment(10);
        this.rbLease.addActionListener(this);
        this.rbTRS.setFont(new Font("Dialog", 1, 11));
        this.rbTRS.setSelected(true);
        this.rbTRS.setText("Sec. Town. Range");
        this.rbTRS.setHorizontalAlignment(10);
        this.rbTRS.addActionListener(this);
        this.rbCounty.setFont(new Font("Dialog", 1, 11));
        this.rbCounty.setText("Counties");
        this.rbCounty.setHorizontalAlignment(10);
        this.rbCounty.addActionListener(this);
        this.pnlKGSTextSearch.setLayout(this.cardLayout);
        jPanel6.setBorder(titledBorder6);
        jPanel6.setLayout(new BorderLayout());
        this.txtText.setText("");
        this.txtText.setColumns(50);
        this.txtText.addFocusListener(new kgsBrineFrameFocusAdapter(this));
        jPanel7.setLayout(new GridLayout());
        jPanel8.setBorder(titledBorder3);
        jPanel8.setLayout(new BorderLayout());
        this.txtTownship.setText("0");
        this.txtTownship.setColumns(3);
        this.txtTownship.setHorizontalAlignment(11);
        this.txtTownship.addFocusListener(new kgsBrineFrameFocusAdapter(this));
        this.rbNorth.setText("N");
        this.rbNorth.addActionListener(this);
        this.rbSouth.setSelected(true);
        this.rbSouth.setText("S");
        this.rbSouth.addActionListener(this);
        jPanel9.setBorder(titledBorder4);
        jPanel9.setLayout(new BorderLayout());
        this.txtRange.setText("0");
        this.txtRange.setColumns(3);
        this.txtRange.setHorizontalAlignment(11);
        this.txtRange.addFocusListener(new kgsBrineFrameFocusAdapter(this));
        this.rbEast.setSelected(true);
        this.rbEast.setText("E");
        this.rbEast.addActionListener(this);
        this.rbWest.setText("W");
        this.rbWest.addActionListener(this);
        jPanel10.setBorder(titledBorder5);
        jPanel10.setLayout(new BorderLayout());
        this.txtSection.setText("0");
        this.txtSection.setColumns(3);
        this.txtSection.setHorizontalAlignment(11);
        this.txtSection.addFocusListener(new kgsBrineFrameFocusAdapter(this));
        jPanel11.setLayout(new BorderLayout());
        jPanel11.setPreferredSize(new Dimension(412, 60));
        if (this._COUNTIES > 0) {
            n = (this._COUNTIES + 1) / 2;
            jPanel12.setLayout(new GridLayout(n, 2));
            this.btn = new JButton[this._COUNTIES];
            for (int i = 0; i < this._COUNTIES; ++i) {
                this.btn[i] = new JButton();
                this.btn[i].setFont(new Font("Dialog", 1, 11));
                if (this._NAMES[i] != null) {
                    this.btn[i].setText(this._NAMES[i]);
                }
                this.btn[i].addActionListener(this);
                jPanel12.add((Component)this.btn[i], null);
            }
        }
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBorder(titledBorder7);
        this.pTable = new kgsBrineTable();
        jScrollPane2 = this.pTable.getScrollPane();
        jPanel13.setLayout(new BorderLayout());
        this.btnSelect.setFont(new Font("Dialog", 1, 11));
        this.btnSelect.setText("Load Data");
        this.btnSelect.addActionListener(this);
        this.setButtons();
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)jPanel4, "Center");
        jPanel4.add((Component)jPanel5, "West");
        jPanel5.add((Component)this.rbLease, null);
        jPanel5.add((Component)this.rbTRS, null);
        jPanel5.add((Component)this.rbCounty, null);
        buttonGroup.add(this.rbLease);
        buttonGroup.add(this.rbTRS);
        buttonGroup.add(this.rbCounty);
        jPanel4.add((Component)this.pnlKGSTextSearch, "Center");
        this.pnlKGSTextSearch.add((Component)jPanel7, "TRS");
        jPanel7.add((Component)jPanel10, null);
        jPanel10.add((Component)this.txtSection, "East");
        this.pnlKGSTextSearch.add((Component)jPanel6, "TEXT");
        jPanel6.add((Component)this.txtText, "Center");
        this.pnlKGSTextSearch.add((Component)jPanel11, "COUNTY");
        jPanel11.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)jPanel12, null);
        jPanel7.add((Component)jPanel8, null);
        jPanel8.add((Component)this.txtTownship, "West");
        jPanel8.add((Component)this.rbNorth, "Center");
        jPanel8.add((Component)this.rbSouth, "East");
        buttonGroup2.add(this.rbNorth);
        buttonGroup2.add(this.rbSouth);
        jPanel7.add((Component)jPanel9, null);
        jPanel9.add((Component)this.txtRange, "West");
        jPanel9.add((Component)this.rbEast, "East");
        jPanel9.add((Component)this.rbWest, "Center");
        buttonGroup3.add(this.rbEast);
        buttonGroup3.add(this.rbWest);
        jPanel.add((Component)jPanel3, "South");
        jPanel3.add((Component)this.btnSearch, "Center");
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)jScrollPane2, "Center");
        jPanel2.add((Component)jPanel13, "South");
        jPanel13.add((Component)this.btnSelect, "Center");
        this.setSize(new Dimension(540, 700));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(true);
        this.setVisible(true);
    }

    public brineListStruct getData() {
        return this.stData;
    }

    public iqstratHeadersStruct getHeader() {
        return this.stHeader;
    }

    private void getList() {
        ReadBrineDataXMLFile readBrineDataXMLFile = new ReadBrineDataXMLFile(1);
        this.stList = readBrineDataXMLFile.Process(this.sPath);
        this.pTable.repopulateList(this.stList);
    }

    private void getCounties() {
        kgsMeasSectListStruct kgsMeasSectListStruct2 = kgsBrineFrame.readCounties();
        if (kgsMeasSectListStruct2 != null) {
            this._COUNTIES = kgsMeasSectListStruct2.iCount;
            this._CODES = new int[this._COUNTIES];
            this._NAMES = new String[this._COUNTIES];
            for (int i = 0; i < this._COUNTIES; ++i) {
                this._CODES[i] = kgsMeasSectListStruct2.stItem[i].iCounty;
                this._NAMES[i] = new String(kgsMeasSectListStruct2.stItem[i].sCounty);
            }
        }
    }

    public static kgsMeasSectListStruct readCounties() {
        kgsMeasSectListStruct kgsMeasSectListStruct2 = null;
        ReadMeasSectXMLFile readMeasSectXMLFile = new ReadMeasSectXMLFile(1);
        kgsMeasSectListStruct2 = readMeasSectXMLFile.Process("http://chasm.kgs.ku.edu/ords/iqstrat.brine_data_pkg.getCounties?");
        String string = readMeasSectXMLFile.GetError();
        if (string.length() > 0) {
            JOptionPane.showMessageDialog(null, string, "ERROR", 0);
        }
        return kgsMeasSectListStruct2;
    }

    private void setButtons() {
        if (this.btnSearch != null) {
            this.btnSearch.setEnabled(true);
            if (this.rbCounty.isSelected()) {
                this.btnSearch.setEnabled(false);
            }
        }
        if (this.btnSelect != null) {
            this.btnSelect.setEnabled(false);
            if (this.pTable.getTotalRows() > 0) {
                this.btnSelect.setEnabled(true);
            }
        }
    }

    private brineListStruct setHeader(brineListStruct brineListStruct2) {
        double d = 0.0;
        double d2 = 0.0;
        String[] stringArray = null;
        int[] nArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (brineListStruct2 != null) {
            int n4;
            this.stHeader = new iqstratHeadersStruct();
            stringArray = new String[brineListStruct2.iCount];
            nArray = new int[brineListStruct2.iCount];
            for (n4 = 0; n4 < brineListStruct2.iCount; ++n4) {
                stringArray[n4] = new String("");
                nArray[n4] = 0;
            }
            for (n4 = 0; n4 < brineListStruct2.iCount; ++n4) {
                if (brineListStruct2.stItem[n4].sAPI.length() > 0) {
                    this.stHeader.sAPI = new String(brineListStruct2.stItem[n4].sAPI);
                    brineListStruct2.sAPI = new String(brineListStruct2.stItem[n4].sAPI);
                }
                if (brineListStruct2.stItem[n4].sName.length() > 0) {
                    this.stHeader.sName = new String(brineListStruct2.stItem[n4].sName);
                    brineListStruct2.sName = new String(brineListStruct2.stItem[n4].sName);
                }
                if (brineListStruct2.stItem[n4].sField.length() > 0) {
                    this.stHeader.sField = new String(brineListStruct2.stItem[n4].sField);
                    brineListStruct2.sField = new String(brineListStruct2.stItem[n4].sField);
                }
                if (brineListStruct2.stItem[n4].sCounty.length() > 0) {
                    this.stHeader.sCounty = new String(brineListStruct2.stItem[n4].sCounty);
                    brineListStruct2.sCounty = new String(brineListStruct2.stItem[n4].sCounty);
                }
                if (brineListStruct2.stItem[n4].state.length() > 0) {
                    this.stHeader.state = new String(brineListStruct2.stItem[n4].state);
                    brineListStruct2.state = new String(brineListStruct2.stItem[n4].state);
                }
                if (brineListStruct2.stItem[n4].sLocation.length() > 0) {
                    this.stHeader.sLocation = new String(brineListStruct2.stItem[n4].sLocation);
                    this.stHeader = las3LoadWellHeader.parseSTR(this.stHeader.sLocation, this.stHeader);
                    brineListStruct2.sLocation = new String(brineListStruct2.stItem[n4].sLocation);
                }
                if (brineListStruct2.stItem[n4].dLatitude != 0.0) {
                    this.stHeader.dLatitude = brineListStruct2.stItem[n4].dLatitude;
                    brineListStruct2.dLatitude = brineListStruct2.stItem[n4].dLatitude;
                }
                if (brineListStruct2.stItem[n4].dLongitude != 0.0) {
                    this.stHeader.dLongitude = brineListStruct2.stItem[n4].dLongitude;
                    brineListStruct2.dLongitude = brineListStruct2.stItem[n4].dLongitude;
                }
                if (brineListStruct2.stItem[n4].dKB > 0.0) {
                    this.stHeader.dKB = brineListStruct2.stItem[n4].dKB;
                    brineListStruct2.dKB = brineListStruct2.stItem[n4].dKB;
                }
                if (brineListStruct2.stItem[n4].dGL > 0.0) {
                    this.stHeader.dGL = brineListStruct2.stItem[n4].dGL;
                    brineListStruct2.dGL = brineListStruct2.stItem[n4].dGL;
                }
                if (brineListStruct2.stItem[n4].dDF > 0.0) {
                    this.stHeader.dDF = brineListStruct2.stItem[n4].dDF;
                    brineListStruct2.dDF = brineListStruct2.stItem[n4].dDF;
                }
                if (brineListStruct2.stItem[n4].dTOP > d) {
                    d = brineListStruct2.stItem[n4].dTOP;
                }
                if (brineListStruct2.stItem[n4].dBASE > d2) {
                    d2 = brineListStruct2.stItem[n4].dBASE;
                }
                if (brineListStruct2.stItem[n4].source.length() > 0) {
                    brineListStruct2.source = new String(brineListStruct2.stItem[n4].source);
                }
                if (brineListStruct2.stItem[n4].sRecovery.length() > 0) {
                    brineListStruct2.sRecovery = new String(brineListStruct2.stItem[n4].sRecovery);
                }
                if (brineListStruct2.stItem[n4].sFORM.length() <= 0) continue;
                n2 = 0;
                for (int i = 0; i < n3; ++i) {
                    if (!stringArray[i].equals(brineListStruct2.stItem[n4].sFORM)) continue;
                    int n5 = i;
                    nArray[n5] = nArray[n5] + 1;
                    n2 = 1;
                }
                if (n2 != 0) continue;
                stringArray[n3] = new String(brineListStruct2.stItem[n4].sFORM);
                nArray[n3] = 1;
                ++n3;
            }
            if (d > 0.0 && d2 > 0.0) {
                this.stHeader.depth = d2 - d;
            }
            if (d > 0.0) {
                brineListStruct2.depthStart = d;
            }
            if (d2 > 0.0) {
                brineListStruct2.depthEnd = d2;
            }
            if (n3 > 0) {
                n2 = -1;
                for (n4 = 0; n4 < n3; ++n4) {
                    if (nArray[n4] <= n) continue;
                    n = nArray[n4];
                    n2 = n4;
                }
                brineListStruct2.sFormation = new String(stringArray[n2]);
            }
        }
        return brineListStruct2;
    }

    private void loadData() {
        this.stData = this.pTable.getData();
        this.stData = this.setHeader(this.stData);
        if (this.stData != null) {
            this.notifier.notifyObservers(new String("KGS Brine Loaded"));
        }
    }

    public void close() {
        this.notifier = null;
        this.sTownship = "S";
        this.sRange = "W";
        this.sPath = "";
        this._CODES = null;
        this._NAMES = null;
        if (this.pTable != null) {
            this.pTable.close();
        }
        this.pTable = null;
        if (this.stList != null) {
            this.stList.delete();
        }
        this.stList = null;
        this.stBrine = null;
        this.stData = null;
        this.pnlKGSTextSearch = null;
        this.cardLayout = null;
        this.rbLease = null;
        this.rbTRS = null;
        this.rbCounty = null;
        this.btnSearch = null;
        this.txtText = null;
        this.txtTownship = null;
        this.rbNorth = null;
        this.rbSouth = null;
        this.txtRange = null;
        this.rbEast = null;
        this.rbWest = null;
        this.txtSection = null;
        for (int i = 0; i < this._COUNTIES; ++i) {
            this.btn[i] = null;
        }
        this.btnSelect = null;
        this.mExit = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSearch) {
            this.getList();
        }
        if (actionEvent.getSource() == this.rbLease) {
            this.iSearch = 1;
            this.cardLayout.show(this.pnlKGSTextSearch, "TEXT");
        }
        if (actionEvent.getSource() == this.rbTRS) {
            this.iSearch = 2;
            this.cardLayout.show(this.pnlKGSTextSearch, "TRS");
        }
        if (actionEvent.getSource() == this.rbCounty) {
            this.iSearch = 3;
            this.cardLayout.show(this.pnlKGSTextSearch, "COUNTY");
        }
        if (actionEvent.getSource() == this.rbNorth) {
            this.sTownship = "N";
        }
        if (actionEvent.getSource() == this.rbSouth) {
            this.sTownship = "S";
        }
        if (actionEvent.getSource() == this.rbEast) {
            this.sRange = "E";
        }
        if (actionEvent.getSource() == this.rbWest) {
            this.sRange = "W";
        }
        for (int i = 0; i < this._COUNTIES; ++i) {
            if (actionEvent.getSource() != this.btn[i]) continue;
            this.sPath = "http://chasm.kgs.ku.edu/ords/iqstrat.brine_data_pkg.getXML?county=" + this._NAMES[i];
            this.getList();
        }
        if (actionEvent.getSource() == this.btnSelect) {
            this.loadData();
        }
        this.setButtons();
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtText && this.txtText.getText().length() > 0) {
            this.sPath = "http://chasm.kgs.ku.edu/ords/iqstrat.brine_data_pkg.getXML?sLease=" + this.txtText.getText();
        }
        if (focusEvent.getSource() == this.txtTownship) {
            bl = true;
            string2 = this.txtTownship.getText();
            string = new String("Township Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtRange) {
            bl = true;
            string2 = this.txtRange.getText();
            string = new String("Range Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtSection) {
            bl = true;
            string2 = this.txtSection.getText();
            string = new String("Section Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtTownship) {
                    this.iTownship = cmnString.stringToInt(this.txtTownship.getText());
                }
                if (focusEvent.getSource() == this.txtRange) {
                    this.iRange = cmnString.stringToInt(this.txtRange.getText());
                }
                if (focusEvent.getSource() == this.txtSection) {
                    this.iSection = cmnString.stringToInt(this.txtSection.getText());
                }
                if (this.iTownship > 0 && this.iRange > 0 && this.iSection > 0) {
                    this.sPath = "http://chasm.kgs.ku.edu/ords/iqstrat.brine_data_pkg.getXML?iTownship=" + this.iTownship + "&sTownship=" + this.sTownship + "&iRange=" + this.iRange + "&sRange=" + this.sRange + "&iSection=" + this.iSection;
                } else if (this.iTownship > 0 && this.iRange > 0) {
                    this.sPath = "http://chasm.kgs.ku.edu/ords/iqstrat.brine_data_pkg.getXML?iTownship=" + this.iTownship + "&sTownship=" + this.sTownship + "&iRange=" + this.iRange + "&sRange=" + this.sRange;
                }
            }
        }
    }
}

