/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.plot;

import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class iqstratPlotRemarks
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private static final int CHARS = 32;
    private static final int CHAR_H = 7;
    private iqstratRemarkListStruct stRemarks = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public iqstratPlotRemarks(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stRemarks = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public iqstratRemarkListStruct getRemarksData() {
        return this.stRemarks;
    }

    private int getNextDepth(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (n > -1 && this.stRemarks != null) {
            for (int i = n; i < this.stRemarks.iCount; ++i) {
                d = this.stRemarks.stItem[i].depthStart;
                d2 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d2;
                if (n3 != -1 || n4 <= n2) continue;
                n3 = i;
                break;
            }
        }
        return n3;
    }

    private int getNextDepth(int n, double d) {
        int n2 = -1;
        int n3 = (int)d;
        d = n3;
        if (n > -1 && this.stRemarks != null) {
            for (int i = n; i < this.stRemarks.iCount; ++i) {
                if (n2 != -1 || !(this.stRemarks.stItem[i].depthStart >= this.stRemarks.stItem[n].depthEnd + d)) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    private int getNextDepth(int n) {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (n > -1 && this.stRemarks != null) {
            for (int i = n; i < this.stRemarks.iCount; ++i) {
                d2 = this.stRemarks.stItem[i].depthStart;
                d3 = this.stRemarks.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d;
                n5 = n4 - n3;
                if (n2 != -1 || !(d2 >= this.stRemarks.stItem[n].depthEnd) || n5 < 7) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setRemarksData(iqstratRemarkListStruct iqstratRemarkListStruct2) {
        this.stRemarks = iqstratRemarkListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        double d = 0.0;
        double d2 = 0.0;
        int n4 = n2 / 5;
        int n5 = n + n2;
        int n6 = 0;
        boolean bl5 = false;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n6 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n, n6, n5, n6);
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n5, 25, n5, 100 + this.iLogHeight);
        for (n3 = 0; n3 <= n2; n3 += n4) {
            if (n3 != 0 && n3 != n2) continue;
            graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
        }
        graphics.setColor(Color.black);
        graphics.drawString("Remarks", n + 2 * n4, 39);
        graphics.drawLine(n, 25, n5, 25);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n5, 25, n5, 100 + this.iLogHeight);
    }

    public void drawRemarks(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        Font font = new Font("Monospaced", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        String string4 = new String("[ ,;]+");
        String[] stringArray = null;
        graphics.setFont(font);
        graphics.setColor(Color.black);
        d4 = (double)iqstratTracksStruct.SCALE[this.iScale] / 8.0;
        if (this.stRemarks != null) {
            for (int i = 0; i < this.stRemarks.iCount; ++i) {
                if (this.stRemarks.stItem[i] == null) continue;
                d2 = this.stRemarks.stItem[i].depthStart;
                d3 = this.stRemarks.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n5 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n5 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d;
                n7 = n5;
                if (this.iDataType == 1) {
                    n7 = n6;
                }
                if (n6 - n5 < 7) {
                    n6 = n5 + 7 + 2;
                }
                if (n5 < 100 || n6 <= 100 || n5 >= this.iHeight || n6 > this.iHeight) continue;
                n8 = n7 += 7;
                string = this.stRemarks.stItem[i].sText;
                string = new String(string.replace('\t', ' '));
                string = new String(string.replace('\n', ' '));
                stringArray = string.split(string4);
                n10 = stringArray.length;
                string3 = new String("");
                for (int j = 0; j < n10; ++j) {
                    string2 = new String(stringArray[j]);
                    n11 = string3.length();
                    if (n11 + (n12 = string2.length() + 1) < 32) {
                        string3 = new String(string3 + " " + string2);
                        continue;
                    }
                    if (n7 < n6) {
                        graphics.drawString(string3, n + 5, n7);
                    } else {
                        n8 = n6 - 3;
                    }
                    string3 = new String(string2);
                    n7 += 7;
                }
                n9 = this.getNextDepth(i, n8);
                if (n9 > 0 && n9 - 1 > i) {
                    i = n9 - 1;
                }
                if (string3.length() == 0 || n7 >= n6) continue;
                graphics.drawString(string3, n + 5, n7);
            }
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n3, 25, n3, 100 + this.iLogHeight);
        graphics.drawLine(n4, 25, n4, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 1;
        if (n == 84) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n2, n3);
            this.drawRemarks(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

