/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.io;

import cmn.cmnString;
import iqstrat.iqstratFilesListStruct;
import iqstrat.iqstratFilesStruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadFilesXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    public static final int NOERROR = 0;
    public static final int ERROR = -1;
    public static final String ROOTNAME = "files";
    public static final String RECORDS = "records";
    public static final String DATA = "data";
    public static final String KID = "kid";
    public static final String ERROR_VAL = "error";
    public static final String USER_KID = "user";
    public static final String HEADER_KID = "header";
    public static final String DATA_TYPE = "type";
    public static final String FILE_TYPE = "file";
    public static final String URL_PATH = "url";
    public static final String PATH = "path";
    public static final String FILENAME = "name";
    private int iError = 0;
    private String sError = new String("");
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private iqstratFilesListStruct stList = new iqstratFilesListStruct();

    public ReadFilesXMLFile() {
        this.iType = 0;
    }

    public ReadFilesXMLFile(int n) {
        this.iType = n;
    }

    public iqstratFilesListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            this.iError = -1;
            this.sError = new String("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n" + sAXParseException.getMessage());
            System.out.println(this.sError);
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(DATA)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new iqstratFilesStruct();
            }
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.stList.iCount = this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stList.stItem = new iqstratFilesStruct[this.iRows];
                    }
                }
                if (this.iCount <= -1 || this.iCount >= this.iRows) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        this.iError = -1;
        this.sError = new String("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId() + "\n" + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private iqstratFilesStruct ParseData(String string, String string2, iqstratFilesStruct iqstratFilesStruct2) {
        if (string.equals(KID)) {
            iqstratFilesStruct2.sKEY = new String(string2);
        }
        if (string.equals(USER_KID)) {
            iqstratFilesStruct2.sUser = new String(string2);
        }
        if (string.equals(HEADER_KID)) {
            iqstratFilesStruct2.sHeader = new String(string2);
        }
        if (string.equals(DATA_TYPE)) {
            iqstratFilesStruct2.sType = new String(string2);
        }
        if (string.equals(FILE_TYPE)) {
            iqstratFilesStruct2.sFile = new String(string2);
        }
        if (string.equals(URL_PATH)) {
            iqstratFilesStruct2.sURL = new String(string2);
        }
        if (string.equals(PATH)) {
            iqstratFilesStruct2.sPath = new String(string2);
        }
        if (string.equals(FILENAME)) {
            iqstratFilesStruct2.sFilename = new String(string2);
        }
        if (string.equals(ERROR_VAL)) {
            if (string2.length() > 0) {
                this.iError = -1;
            }
            this.sError = new String(string2);
        }
        return iqstratFilesStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

