/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.gui;

import brine.brineListStruct;
import cmn.cmnStruct;
import horizon.bio.bioStratListStruct;
import horizon.env.envListStruct;
import horizon.regions.regionsListStruct;
import horizon.seq.seqListStruct;
import horizon.strat.stratListStruct;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratStruct;
import iqstrat.plot.iqstratPlot;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.image.BufferedImage;
import java.util.Observable;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import las.gui.lasConvertFrame;
import las.lasFileDataStruct;
import lith.gui.lithImageTrackFrame;
import lith.lithology.lithologyListStruct;
import lith.rock.rockColumnListStruct;
import lith.texture.textureListStruct;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataStruct;
import rock.color.rockColorListStruct;
import rock.fossil.fossilListStruct;
import rock.phi.phiListStruct;
import rock.rockDataListStruct;
import rock.rockFileDataStruct;
import rock.rockImagesListStruct;
import rock.sedimentary.sedimentaryListStruct;

public class iqstratPlotPanel
extends JPanel {
    private int iDataType = -1;
    private JFrame parent = null;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int iUnit = 0;
    private int[] iStatus = null;
    private iqstratStruct stStruct = null;
    private int iWidth = 0;
    private int iHeight = 0;
    private iqstratPlot plot = null;
    private ScrollPane scroll = new ScrollPane();
    private Panel panel = new Panel();
    private Cursor normalCursor = null;
    private Cursor mouseCursor = null;

    public iqstratPlotPanel(int n, JFrame jFrame, double d, double d2, int n2, int[] nArray, Cursor cursor, Cursor cursor2) {
        try {
            this.iDataType = n;
            this.parent = jFrame;
            this.depthStart = d;
            this.depthEnd = d2;
            this.iScale = n2;
            this.iStatus = nArray;
            this.normalCursor = cursor;
            this.mouseCursor = cursor2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public iqstratPlotPanel(JFrame jFrame, iqstratStruct iqstratStruct2, int[] nArray, Cursor cursor, Cursor cursor2) {
        try {
            this.parent = jFrame;
            this.stStruct = iqstratStruct2;
            this.iDataType = iqstratStruct2.iDataType;
            this.depthStart = iqstratStruct2.depthStart;
            this.depthEnd = iqstratStruct2.depthEnd;
            this.iScale = iqstratStruct2.iScale;
            this.iUnit = iqstratStruct2.iUnit;
            this.iStatus = nArray;
            this.normalCursor = cursor;
            this.mouseCursor = cursor2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        Panel panel = new Panel();
        this.setLayout(new BorderLayout());
        panel.setLayout(new BorderLayout());
        this.plot = new iqstratPlot(this.stStruct, this.iStatus, this.normalCursor, this.mouseCursor);
        this.iWidth = 50 + this.plot.getPlotWidth();
        this.iHeight = this.plot.getPlotHeight();
        this.panel.setLayout(new BorderLayout());
        this.panel.setPreferredSize(new Dimension(this.iWidth, this.iHeight));
        this.add((Component)panel, "Center");
        panel.add((Component)this.scroll, "Center");
        this.scroll.add((Component)this.panel, null);
        this.panel.add((Component)this.plot, "Center");
    }

    public void close() {
        this.iStatus = null;
        this.scroll = null;
        this.panel = null;
        this.normalCursor = null;
        this.mouseCursor = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    public void refresh() {
        if (this.plot != null) {
            this.plot.refresh();
        }
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public textureListStruct getTexture() {
        textureListStruct textureListStruct2 = null;
        if (this.plot != null) {
            textureListStruct2 = this.plot.getTexture();
        }
        return textureListStruct2;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        if (this.plot != null) {
            bufferedImage = this.plot.getImage();
        }
        return bufferedImage;
    }

    public int getDataEntryPanel() {
        return this.plot.getDataEntryPanel();
    }

    public double getStartingDepth() {
        return this.plot.getStartingDepth();
    }

    public double getEndingDepth() {
        return this.plot.getEndingDepth();
    }

    public void setObservable(Observable observable) {
        if (this.plot != null) {
            this.plot.setObservable(observable);
        }
    }

    public void setCommon(cmnStruct cmnStruct2) {
        if (this.plot != null) {
            this.plot.setCommon(cmnStruct2);
        }
    }

    public void setTitles(String string, String string2) {
        if (this.plot != null) {
            this.plot.setTitles(string, string2);
        }
    }

    public void setScale(int n, double d, double d2) {
        if (this.plot != null) {
            this.plot.setScale(n, d, d2);
            this.iWidth = 50 + this.plot.getPlotWidth();
            this.iHeight = this.plot.getPlotHeight();
            this.panel.setPreferredSize(new Dimension(this.iWidth, this.iHeight));
        }
        this.scroll.doLayout();
        this.panel.doLayout();
    }

    public void setPlotLimits(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        if (this.plot != null) {
            this.plot.setPlotLimits(dArray, dArray2, dArray3);
        }
    }

    public void setTextfield(JTextField jTextField) {
        if (this.plot != null) {
            this.plot.setTextfield(jTextField);
        }
    }

    public void setSelected(int[] nArray) {
        if (this.plot != null) {
            this.plot.setSelected(nArray);
        }
    }

    public void setImageTrackFrame(lithImageTrackFrame lithImageTrackFrame2) {
        if (this.plot != null) {
            this.plot.setImageTrackFrame(lithImageTrackFrame2);
        }
    }

    public void setConvertFrame(lasConvertFrame lasConvertFrame2) {
        if (this.plot != null) {
            this.plot.setConvertFrame(lasConvertFrame2);
        }
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        if (this.plot != null) {
            this.plot.setLASFileData(lasFileDataStruct2);
        }
    }

    public void setLASTrackSize(int n) {
        if (this.plot != null) {
            this.plot.setLASTrackSize(n);
        }
    }

    public void setRockFileData(rockFileDataStruct rockFileDataStruct2) {
        if (this.plot != null) {
            this.plot.setRockFileData(rockFileDataStruct2);
        }
    }

    public void setLASRockColumn(lithologyListStruct lithologyListStruct2) {
        if (this.plot != null) {
            this.plot.setLASRockColumn(lithologyListStruct2);
        }
    }

    public void setLASRockColumnByRT(lithologyListStruct lithologyListStruct2) {
        if (this.plot != null) {
            this.plot.setLASRockColumnByRT(lithologyListStruct2);
        }
    }

    public void setColorlith(int n) {
        if (this.plot != null) {
            this.plot.setColorlith(n);
        }
    }

    public void setPHI(int n) {
        if (this.plot != null) {
            this.plot.setPHI(n);
        }
    }

    public void setPfeffer(pfefferDataStruct pfefferDataStruct2) {
        if (this.plot != null) {
            this.plot.setPfeffer(pfefferDataStruct2);
        }
    }

    public void setPfefferList(pfefferDataListStruct pfefferDataListStruct2) {
        if (this.plot != null) {
            this.plot.setPfefferList(pfefferDataListStruct2);
        }
    }

    public void setOHM(int n, double d, double d2) {
        if (this.plot != null) {
            this.plot.setOHM(n, d, d2);
        }
    }

    public void setPHI(int n, double d, double d2) {
        if (this.plot != null) {
            this.plot.setPHI(n, d, d2);
        }
    }

    public void setImageData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        if (this.plot != null) {
            this.plot.setImageData(dArray, dArray2, dArray3);
        }
    }

    public void setTops(stratListStruct stratListStruct2) {
        if (this.plot != null) {
            this.plot.setTops(stratListStruct2);
        }
    }

    public void setSequence(seqListStruct seqListStruct2) {
        if (this.plot != null) {
            this.plot.setSequence(seqListStruct2);
        }
    }

    public void setTops(regionsListStruct regionsListStruct2) {
        if (this.plot != null) {
            this.plot.setTops(regionsListStruct2);
        }
    }

    public void setDepEnvrionment(envListStruct envListStruct2) {
        if (this.plot != null) {
            this.plot.setDepEnvrionment(envListStruct2);
        }
    }

    public void setBrine(brineListStruct brineListStruct2) {
        if (this.plot != null) {
            this.plot.setBrine(brineListStruct2);
        }
    }

    public void setRockData(rockDataListStruct rockDataListStruct2) {
        if (this.plot != null) {
            this.plot.setRockData(rockDataListStruct2);
        }
    }

    public void setRockImages(rockImagesListStruct rockImagesListStruct2) {
        if (this.plot != null) {
            this.plot.setRockImages(rockImagesListStruct2);
        }
    }

    public void setRockColumn(rockColumnListStruct rockColumnListStruct2) {
        if (this.plot != null) {
            this.plot.setRockColumn(rockColumnListStruct2);
        }
    }

    public void setPHI(phiListStruct phiListStruct2) {
        if (this.plot != null) {
            this.plot.setPHI(phiListStruct2);
        }
    }

    public void setFossils(fossilListStruct fossilListStruct2) {
        if (this.plot != null) {
            this.plot.setFossils(fossilListStruct2);
        }
    }

    public void setBioStrat(bioStratListStruct bioStratListStruct2) {
        if (this.plot != null) {
            this.plot.setBioStrat(bioStratListStruct2);
        }
    }

    public void setStructures(sedimentaryListStruct sedimentaryListStruct2) {
        if (this.plot != null) {
            this.plot.setStructures(sedimentaryListStruct2);
        }
    }

    public void setRockColorData(rockColorListStruct rockColorListStruct2) {
        if (this.plot != null) {
            this.plot.setRockColorData(rockColorListStruct2);
        }
    }

    public void setRemarks(iqstratRemarkListStruct iqstratRemarkListStruct2) {
        if (this.plot != null) {
            this.plot.setRemarks(iqstratRemarkListStruct2);
        }
    }

    public void modifyWidths(int n, int n2, int n3) {
        if (this.plot != null) {
            this.plot.modifyWidths(n, n2, n3);
            this.iWidth = 50 + this.plot.getPlotWidth();
            this.iHeight = this.plot.getPlotHeight();
            this.panel.setPreferredSize(new Dimension(this.iWidth, this.iHeight));
        }
        this.scroll.doLayout();
        this.panel.doLayout();
    }
}

