/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.gui;

import brine.brineListStruct;
import cmn.cmnStruct;
import horizon.bio.bioStratListStruct;
import horizon.env.envListStruct;
import horizon.regions.regionsListStruct;
import horizon.seq.seqListStruct;
import horizon.strat.stratListStruct;
import iqstrat.gui.iqstratPlotPanel;
import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.Observable;
import javax.swing.JFrame;
import javax.swing.JTextField;
import las.gui.lasConvertFrame;
import las.lasFileDataStruct;
import lith.gui.lithImageTrackFrame;
import lith.lithology.lithologyListStruct;
import lith.rock.rockColumnListStruct;
import lith.texture.textureListStruct;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataStruct;
import rock.color.rockColorListStruct;
import rock.fossil.fossilListStruct;
import rock.phi.phiListStruct;
import rock.rockDataListStruct;
import rock.rockFileDataStruct;
import rock.rockImagesListStruct;
import rock.sedimentary.sedimentaryListStruct;

public class iqstratPlotFrame
extends JFrame
implements ActionListener {
    private int iDataType = -1;
    private JFrame parent = null;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int iUnit = 0;
    private int[] iStatus = null;
    private iqstratStruct stStruct = null;
    private int iFrameX = -1;
    private int iFrameY = -1;
    private int iFrameWidth = -1;
    private int iFrameHeight = -1;
    private int iControlWidth = 250;
    private int iScreenWidth = 0;
    private int iScreenHigh = 0;
    private iqstratPlotPanel plot = null;
    private iqstratHeadersStruct stHeader = null;
    private JTextField txtName = new JTextField();
    private Cursor normalCursor = null;
    private Cursor mouseCursor = null;

    public iqstratPlotFrame(JFrame jFrame, iqstratStruct iqstratStruct2, int[] nArray, int n, int n2, int n3, int n4, int n5) {
        try {
            this.parent = jFrame;
            this.stStruct = iqstratStruct2;
            this.iDataType = iqstratStruct2.iDataType;
            this.depthStart = iqstratStruct2.depthStart;
            this.depthEnd = iqstratStruct2.depthEnd;
            this.iScale = iqstratStruct2.iScale;
            this.iUnit = iqstratStruct2.iUnit;
            this.iStatus = nArray;
            this.iControlWidth = n;
            this.iFrameX = n2;
            this.iFrameY = n3;
            this.iFrameWidth = n4;
            this.iFrameHeight = n5;
            this.normalCursor = new Cursor(0);
            this.mouseCursor = new Cursor(12);
            this.jbInit();
            this.addWindowListener(new iqstratPlotFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String string = "Plot Well: ";
        Dimension dimension = null;
        if (this.iDataType == 1) {
            string = "Plot Outcrop: ";
        }
        this.setTitle(string);
        this.getContentPane().setLayout(new BorderLayout());
        this.plot = new iqstratPlotPanel(this, this.stStruct, this.iStatus, this.normalCursor, this.mouseCursor);
        this.getContentPane().add((Component)this.plot, "Center");
        dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.iScreenWidth = dimension.width;
        this.iScreenHigh = dimension.height - 50;
        if (this.iFrameX == -1 && this.iFrameY == -1) {
            this.setSize(this.iScreenWidth - this.iControlWidth, this.iScreenHigh);
            this.setLocation(this.iControlWidth + 1, 1);
        } else {
            this.setSize(this.iFrameWidth, this.iFrameHeight);
            this.setLocation(this.iFrameX, this.iFrameY);
        }
        this.setVisible(true);
    }

    public void close() {
        this.parent = null;
        this.iStatus = null;
        this.stStruct = null;
        this.stHeader = null;
        this.txtName = null;
        this.normalCursor = null;
        this.mouseCursor = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
    }

    public void refresh() {
        if (this.plot != null) {
            this.plot.refresh();
        }
    }

    public int getPlotWidth() {
        return this.plot.getPlotWidth();
    }

    public int getPlotHeight() {
        return this.plot.getPlotHeight();
    }

    public textureListStruct getTexture() {
        textureListStruct textureListStruct2 = null;
        if (this.plot != null) {
            textureListStruct2 = this.plot.getTexture();
        }
        return textureListStruct2;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        if (this.plot != null) {
            bufferedImage = this.plot.getImage();
        }
        return bufferedImage;
    }

    public int getDataEntryPanel() {
        return this.plot.getDataEntryPanel();
    }

    public double getStartingDepth() {
        return this.plot.getStartingDepth();
    }

    public double getEndingDepth() {
        return this.plot.getEndingDepth();
    }

    public void setObservable(Observable observable) {
        if (this.plot != null) {
            this.plot.setObservable(observable);
        }
    }

    public void setCommon(cmnStruct cmnStruct2) {
        if (this.plot != null) {
            this.plot.setCommon(cmnStruct2);
        }
    }

    public void setTextfield(JTextField jTextField) {
        if (this.plot != null) {
            this.plot.setTextfield(jTextField);
        }
    }

    public void setTextfieldName(JTextField jTextField) {
        this.txtName = jTextField;
    }

    public void setScale(int n, double d, double d2) {
        this.iScale = n;
        this.depthStart = d2;
        this.depthEnd = d;
        if (this.plot != null) {
            this.plot.setScale(n, d, d2);
            this.plot.updateUI();
        }
    }

    public void setPlotLimits(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        if (this.plot != null) {
            this.plot.setPlotLimits(dArray, dArray2, dArray3);
        }
    }

    public int getLocationX() {
        return this.getLocation().x;
    }

    public int getLocationY() {
        return this.getLocation().y;
    }

    public int getFrameWidth() {
        return this.getSize().width;
    }

    public int getFrameHeight() {
        return this.getSize().height;
    }

    public void setSelected(int[] nArray) {
        if (this.plot != null) {
            this.plot.setSelected(nArray);
        }
    }

    public void setImageTrackFrame(lithImageTrackFrame lithImageTrackFrame2) {
        if (this.plot != null) {
            this.plot.setImageTrackFrame(lithImageTrackFrame2);
        }
    }

    public void setConvertFrame(lasConvertFrame lasConvertFrame2) {
        if (this.plot != null) {
            this.plot.setConvertFrame(lasConvertFrame2);
        }
    }

    public void setHeaders(iqstratHeadersStruct iqstratHeadersStruct2) {
        String string = "";
        String string2 = "";
        this.stHeader = iqstratHeadersStruct2;
        if (this.stHeader != null) {
            this.stHeader.iType = this.stStruct.iDataType;
            string = this.stStruct.iDataType == 0 ? (this.stHeader.sAPI.length() > 3 ? new String(this.stHeader.sName + " (" + this.stHeader.sAPI + ")") : new String(this.stHeader.sName)) : new String(this.stHeader.sName);
            if (this.txtName != null) {
                this.txtName.setText(this.stHeader.sName);
            }
            if (this.stHeader.iTownship > 0 && this.stHeader.iRange > 0 && this.stHeader.iSection > 0) {
                string = new String(string + " T: " + this.stHeader.iTownship + this.stHeader.sTownship + " R: " + this.stHeader.iRange + this.stHeader.sRange + " S: " + this.stHeader.iSection);
            }
            string2 = new String("    ");
            if (this.stHeader.dLatitude != 0.0) {
                string2 = new String(string2 + "Latitude: " + this.stHeader.dLatitude + " ");
            }
            if (this.stHeader.dLongitude != 0.0) {
                string2 = new String(string2 + "Longitude: " + this.stHeader.dLongitude + " ");
            }
            if (this.stHeader.dGL > 0.0) {
                string2 = new String(string2 + "Elevation (GL): " + this.stHeader.dGL + " ");
            } else if (this.stHeader.dKB > 0.0) {
                string2 = new String(string2 + "Elevation (KB): " + this.stHeader.dKB + " ");
            }
            if (this.stHeader.depth > 0.0) {
                string2 = this.stStruct.iDataType == 0 ? new String(string2 + "Depth: " + this.stHeader.depth + " ") : new String(string2 + "Height: " + this.stHeader.depth + " ");
            }
        }
        if (this.plot != null) {
            this.plot.setTitles(string, string2);
        }
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        if (this.plot != null) {
            this.plot.setLASFileData(lasFileDataStruct2);
        }
    }

    public void setLASTrackSize(int n) {
        if (this.plot != null) {
            this.plot.setLASTrackSize(n);
        }
    }

    public void setRockFileData(rockFileDataStruct rockFileDataStruct2) {
        if (this.plot != null) {
            this.plot.setRockFileData(rockFileDataStruct2);
        }
    }

    public void setLASRockColumn(lithologyListStruct lithologyListStruct2) {
        if (this.plot != null) {
            this.plot.setLASRockColumn(lithologyListStruct2);
        }
    }

    public void setLASRockColumnByRT(lithologyListStruct lithologyListStruct2) {
        if (this.plot != null) {
            this.plot.setLASRockColumnByRT(lithologyListStruct2);
        }
    }

    public void setColorlith(int n) {
        if (this.plot != null) {
            this.plot.setColorlith(n);
        }
    }

    public void setPHI(int n) {
        if (this.plot != null) {
            this.plot.setPHI(n);
        }
    }

    public void setPfeffer(pfefferDataStruct pfefferDataStruct2) {
        if (this.plot != null) {
            this.plot.setPfeffer(pfefferDataStruct2);
        }
    }

    public void setPfefferList(pfefferDataListStruct pfefferDataListStruct2) {
        if (this.plot != null) {
            this.plot.setPfefferList(pfefferDataListStruct2);
        }
    }

    public void setOHM(int n, double d, double d2) {
        if (this.plot != null) {
            this.plot.setOHM(n, d, d2);
        }
    }

    public void setPHI(int n, double d, double d2) {
        if (this.plot != null) {
            this.plot.setPHI(n, d, d2);
        }
    }

    public void setImageData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        if (this.plot != null) {
            this.plot.setImageData(dArray, dArray2, dArray3);
        }
    }

    public void setTops(stratListStruct stratListStruct2) {
        if (this.plot != null) {
            this.plot.setTops(stratListStruct2);
        }
    }

    public void setSequence(seqListStruct seqListStruct2) {
        if (this.plot != null) {
            this.plot.setSequence(seqListStruct2);
        }
    }

    public void setTops(regionsListStruct regionsListStruct2) {
        if (this.plot != null) {
            this.plot.setTops(regionsListStruct2);
        }
    }

    public void setDepEnvrionment(envListStruct envListStruct2) {
        if (this.plot != null) {
            this.plot.setDepEnvrionment(envListStruct2);
        }
    }

    public void setBrine(brineListStruct brineListStruct2) {
        if (this.plot != null) {
            this.plot.setBrine(brineListStruct2);
        }
    }

    public void setRockData(rockDataListStruct rockDataListStruct2) {
        if (this.plot != null) {
            this.plot.setRockData(rockDataListStruct2);
        }
    }

    public void setRockImages(rockImagesListStruct rockImagesListStruct2) {
        if (this.plot != null) {
            this.plot.setRockImages(rockImagesListStruct2);
        }
    }

    public void setRockColumn(rockColumnListStruct rockColumnListStruct2) {
        if (this.plot != null) {
            this.plot.setRockColumn(rockColumnListStruct2);
        }
    }

    public void setPHI(phiListStruct phiListStruct2) {
        if (this.plot != null) {
            this.plot.setPHI(phiListStruct2);
        }
    }

    public void setFossils(fossilListStruct fossilListStruct2) {
        if (this.plot != null) {
            this.plot.setFossils(fossilListStruct2);
        }
    }

    public void setBioStrat(bioStratListStruct bioStratListStruct2) {
        if (this.plot != null) {
            this.plot.setBioStrat(bioStratListStruct2);
        }
    }

    public void setStructures(sedimentaryListStruct sedimentaryListStruct2) {
        if (this.plot != null) {
            this.plot.setStructures(sedimentaryListStruct2);
        }
    }

    public void setRockColorData(rockColorListStruct rockColorListStruct2) {
        if (this.plot != null) {
            this.plot.setRockColorData(rockColorListStruct2);
        }
    }

    public void setRemarks(iqstratRemarkListStruct iqstratRemarkListStruct2) {
        if (this.plot != null) {
            this.plot.setRemarks(iqstratRemarkListStruct2);
        }
    }

    public void modifyWidths(int n, int n2, int n3) {
        if (this.plot != null) {
            this.plot.modifyWidths(n, n2, n3);
            this.plot.updateUI();
        }
    }

    public class iqstratPlotFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            iqstratPlotFrame.this.close();
            System.exit(0);
        }
    }
}

