/*
 * Decompiled with CFR 0.152.
 */
package iqstrat.gui;

import brine.brineListStruct;
import cmn.cmnLASFileListStruct;
import cmn.cmnString;
import dst.dstListStruct;
import gui.guiMemoryFrame;
import gui.guiSearchDirectoryFrame;
import horizon.bio.bioStratListStruct;
import horizon.bio.bioStratUtility;
import horizon.bio.gui.bioDataEntryFrame;
import horizon.env.envListStruct;
import horizon.env.envUtility;
import horizon.gui.horizonEnterDataFrame;
import horizon.regions.gui.regionsPerfFrame;
import horizon.regions.regionsListStruct;
import horizon.regions.regionsUtility;
import horizon.seq.seqListStruct;
import horizon.seq.seqUtility;
import horizon.strat.stratListStruct;
import horizon.strat.stratUtility;
import iqstrat.gui.iqstratAvailablePanel;
import iqstrat.gui.iqstratControlPlotFrameFocusAdapter;
import iqstrat.gui.iqstratControlPlotFrameObservable;
import iqstrat.gui.iqstratHeadersFrame;
import iqstrat.gui.iqstratPlotFrame;
import iqstrat.gui.iqstratShaleFrame;
import iqstrat.gui.iqstratTracksTable;
import iqstrat.io.iqstratIO_Files;
import iqstrat.iqstratControlPlotData;
import iqstrat.iqstratControlStruct;
import iqstrat.iqstratControlUtility;
import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratHeadersUtility;
import iqstrat.iqstratPlotLoad;
import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratRemarkUtility;
import iqstrat.iqstratShaleListStruct;
import iqstrat.iqstratShaleUtility;
import iqstrat.iqstratStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import kgs.io.kgsIOUser;
import las.gui.lasConvertFrame;
import las.gui.lasThinTrackFrame;
import las.lasFileDataStruct;
import las.lasFileDataUtility;
import las.lasPlotLimitsUtility;
import las.plot.lasPlotLimitsFrame;
import las3.gui.las3FileFrame;
import las3.las3ListStruct;
import las3.las3LoadLogData;
import lith.gui.lithImageTrackFrame;
import lith.lithology.lithologyListStruct;
import lith.rock.rockColumnListStruct;
import lith.rock.rockColumnUtility;
import lith.texture.textureListStruct;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataStruct;
import pfeffer.pfefferPlotLimitsUtility;
import rock.color.rockColorListStruct;
import rock.color.rockColorUtility;
import rock.fossil.fossilListStruct;
import rock.fossil.fossilUtility;
import rock.gui.rockObsEntryFrame;
import rock.phi.phiListStruct;
import rock.phi.phiUtility;
import rock.plot.rockPlotLimitsFrame;
import rock.rockDataListStruct;
import rock.rockFileDataStruct;
import rock.rockFileDataUtility;
import rock.rockImagesListStruct;
import rock.rockPlotLimitsUtility;
import rock.sedimentary.sedimentaryListStruct;
import rock.sedimentary.sedimentaryUtility;
import util.BrowserControl;
import util.SwingWorker;
import util.utilMemory;
import util.utilWaitAnimation;

public class iqstratControlPlotFrame
extends JFrame
implements ActionListener,
Observer {
    private Observable notifier = null;
    private int iAction = -1;
    private JFrame parent = null;
    private iqstratStruct stStruct = null;
    private int iSource = 0;
    private iqstratHeadersStruct stHeader = null;
    public static final int _HEADERS = 0;
    public static final int _LAS3 = 1;
    public static final int _LAS = 2;
    public static final int _ROCK = 3;
    public static final int _ROCK_IMAGES = 4;
    public static final int _TOPS = 5;
    public static final int _SEQ_STRAT = 6;
    public static final int _PERFORATION = 7;
    public static final int _DEP_ENV = 19;
    public static final int _BIO_STRAT = 18;
    public static final int _BRINE = 17;
    public static final int _ROCK_COLUMN = 20;
    public static final int _LITHOLOGY = 8;
    public static final int _TEXTURE = 9;
    public static final int _ROCK_PHI = 10;
    public static final int _SED_STRUCT = 11;
    public static final int _FOSSILS = 12;
    public static final int _ROCK_COLOR = 13;
    public static final int _REMARKS = 14;
    public static final int _PFEFFER = 15;
    public static final int _SHALE = 16;
    private static final int _DEFAULT = 0;
    private static final int _USER = 1;
    private int iPanel = 0;
    private int iConfig = 0;
    private double dStart = 0.0;
    private double dEnd = 2000.0;
    private double dStartOrig = 0.0;
    private double dEndOrig = 2000.0;
    private int iLASSize = 1;
    private static final int _PC = 0;
    private static final int _KGS = 1;
    private static final int _NOTES = 2;
    private static final int _STRAT_UNIT = 3;
    private static final int _LAS_3_FILE = 4;
    private static final int _ROCK_ENTRY = 5;
    private static final int _TOPS_ENTRY = 6;
    private static final int _CONVERT = 7;
    private static final int _MEAS_SECT = 8;
    private static final int _GEO_REPORT = 9;
    private static final int _GR_SHALE = 10;
    private static final int _XSECTION = 11;
    private static final int _ROCK_DATA = 12;
    private static final int _PERF = 13;
    private static final int _BRINE_DATA = 14;
    private static final int _DEP_ENV_DATA = 15;
    private static final int _BIO_ENTRY = 16;
    private static final int _HTML = 0;
    private static final int _PDF = 1;
    private int iDocument = 0;
    private las3FileFrame p3File = null;
    private int iScale = 6;
    private int[] iStatus = null;
    private int[] iSelected = null;
    private static final int _C_LAS = 1;
    private static final int _C_CORE = 2;
    private static final int _C_PFEFFER = 5;
    private int iData = 1;
    private double[][] orig_las = null;
    private double[][] orig_pf = null;
    private double[][] orig_core = null;
    private double[][] data_las = null;
    private double[][] data_pf = null;
    private double[][] data_core = null;
    private int iFrameX = -1;
    private int iFrameY = -1;
    private int iFrameWidth = -1;
    private int iFrameHeight = -1;
    private int iControlWidth = 325;
    private int iScreenWidth = 0;
    private int iScreenHigh = 0;
    private iqstratAvailablePanel pnlDefaultList = null;
    private iqstratTracksTable pTracks = null;
    private iqstratPlotFrame plotframe = null;
    private guiSearchDirectoryFrame pSearch = null;
    private guiMemoryFrame pMemory = null;
    private iqstratShaleFrame pShaleFrame = null;
    private iqstratHeadersFrame pHeaders = null;
    private rockObsEntryFrame pObsEntry = null;
    private horizonEnterDataFrame pTopsEntry = null;
    private regionsPerfFrame perfFrame = null;
    private bioDataEntryFrame pBioEntry = null;
    private lasThinTrackFrame pnlThinTrack = null;
    private lithImageTrackFrame pnlImageTrack = null;
    private lasPlotLimitsFrame pLimitsLAS = null;
    private rockPlotLimitsFrame pLimitsCORE = null;
    public static final int _EDIT_PANEL = 0;
    public static final int _AVAILABLE = 1;
    public int iThin = 0;
    public int iTHINPHI = 0;
    private static final int _PHI_IMAGE = 0;
    private static final int _OHM_IMAGE = 1;
    public int iPHI = 0;
    public double dPHIMin = 0.0;
    public double dPHIMax = 0.3;
    public int iPHITool = 8;
    public int iOHM = 0;
    public double dOHMMin = 0.0;
    public double dOHMMax = 500.0;
    public int iOHMTool = 18;
    private double[][] dRt = null;
    private double[][] dPhit = null;
    private double[][] dPhi = null;
    private lasConvertFrame pConvert = null;
    private iqstratControlStruct stControl = new iqstratControlStruct();
    private cmnLASFileListStruct stFiles = null;
    private las3ListStruct stLAS3Data = null;
    private lasFileDataStruct stLASFileData = null;
    private lithologyListStruct stLASLithology = null;
    private lithologyListStruct stRTLithology = null;
    private textureListStruct stLASTexture = null;
    private int iColorlith = 0;
    private iqstratShaleListStruct stShale = null;
    private regionsListStruct stTops = null;
    private stratListStruct stStrat = null;
    private seqListStruct stSequence = null;
    private regionsListStruct stOther = null;
    private envListStruct stDepEnv = null;
    private bioStratListStruct stBio = null;
    private dstListStruct stDST = null;
    private brineListStruct stBrine = null;
    private rockDataListStruct stCore = null;
    private rockImagesListStruct stImages = null;
    private lithologyListStruct stRockLithology = null;
    private lithologyListStruct stPlotLithology = null;
    private textureListStruct stTexture = null;
    private textureListStruct stPlotTexture = null;
    private phiListStruct stPHI = null;
    private fossilListStruct stFossil = null;
    private sedimentaryListStruct stSedimentary = null;
    private rockColorListStruct stRockColor = null;
    private iqstratRemarkListStruct stRemarks = null;
    private rockColumnListStruct stColumn = null;
    private rockFileDataStruct stRockData = null;
    private pfefferDataStruct stPfeffer = null;
    private pfefferDataListStruct stFlowUnits = null;
    private JTextField txtCursorDepth = new JTextField();
    private JLabel lblScale = new JLabel();
    private JTextField txtStart = new JTextField();
    private JTextField txtEnd = new JTextField();
    private static final String BTN_RESET = "Reset Depth";
    private static final String BTN_MODIFY = "Modify Depth";
    private JButton btnReset = new JButton();
    private JButton btnModify = new JButton();
    private JLabel lblName = new JLabel();
    private JLabel lblAPI = new JLabel();
    private JLabel lblStatus = new JLabel();
    private JLabel lblLat = new JLabel();
    private JLabel lblLong = new JLabel();
    private JLabel lblTD = new JLabel();
    private JLabel lblElev = new JLabel();
    private JButton btnHeader = new JButton();
    private static final String BTN_DEFAULT = "Default";
    private static final String BTN_USER = "User";
    private static final String BTN_CREATE = "Create User Defined";
    private JButton btnDefault = new JButton();
    private JButton btnUser = new JButton();
    private JButton btnUp = new JButton();
    private JButton btnDown = new JButton();
    private JButton btnLimitsLAS = new JButton();
    private JButton btnLimitsCORE = new JButton();
    private static final String LBL_START_DEPTH = "Start Depth:";
    private static final String LBL_CURSOR_DEPTH = "Cursor:";
    private static final String LBL_TRACKS = "Stratigraphic Plot Tracks:";
    private static final String LBL_SCALE_RANGE = "Depth Scale & Range:";
    private static final String LBL_END_DEPTH = "End Depth:";
    private static final String LBL_TITLE = "Control";
    private static final String LBL_NAME = "Name:";
    private static final String LBL_TRACK_BTNS = "Show Available Tracks by Type of Data:";
    private JPanel pnlPlotTracks = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private JMenuItem mSave = null;
    private JMenuItem mPDF = null;
    private JMenuItem memory = null;
    private JMenuItem mExit = null;
    private JMenuItem mShale = null;
    private JMenuItem mRockObsFrame = null;
    private JMenuItem mPerf = null;
    private JMenuItem mBioFrame = null;
    private JMenuItem mHelp = null;
    private static final String[] scale = new String[]{"1 ft/in", "2 ft/in", "5 ft/in", "10 ft/in", "20 ft/in", "50 ft/in", "100 ft/in", "200 ft/in"};
    private JRadioButtonMenuItem m1 = null;
    private JRadioButtonMenuItem m2 = null;
    private JRadioButtonMenuItem m5 = null;
    private JRadioButtonMenuItem m10 = null;
    private JRadioButtonMenuItem m20 = null;
    private JRadioButtonMenuItem m50 = null;
    private JRadioButtonMenuItem m100 = null;
    private JRadioButtonMenuItem m200 = null;

    public iqstratControlPlotFrame(JFrame jFrame, iqstratStruct iqstratStruct2) {
        try {
            this.parent = jFrame;
            this.stStruct = iqstratStruct2;
            this.dStart = iqstratStruct2.depthStart;
            this.dEnd = iqstratStruct2.depthEnd;
            this.dStartOrig = iqstratStruct2.depthStart;
            this.dEndOrig = iqstratStruct2.depthEnd;
            this.jbInit();
            this.addWindowListener(new iqstratControlPlotFrame_WindowListener());
            this.setInitialConfiguration(this.iConfig);
            this.plot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public iqstratControlPlotFrame(iqstratStruct iqstratStruct2, int n) {
        try {
            this.stStruct = iqstratStruct2;
            this.iAction = n;
            this.dStart = iqstratStruct2.depthStart;
            this.dEnd = iqstratStruct2.depthEnd;
            this.dStartOrig = iqstratStruct2.depthStart;
            this.dEndOrig = iqstratStruct2.depthEnd;
            this.jbInit();
            this.addWindowListener(new iqstratControlPlotFrame_WindowListener());
            this.setInitialConfiguration(this.iConfig);
            this.plot();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JPanel jPanel14 = new JPanel();
        JPanel jPanel15 = new JPanel();
        JPanel jPanel16 = new JPanel();
        JPanel jPanel17 = new JPanel();
        JPanel jPanel18 = new JPanel();
        JPanel jPanel19 = new JPanel();
        JPanel jPanel20 = new JPanel();
        JPanel jPanel21 = new JPanel();
        JPanel jPanel22 = new JPanel();
        JPanel jPanel23 = new JPanel();
        JPanel jPanel24 = new JPanel();
        JPanel jPanel25 = new JPanel();
        JPanel jPanel26 = new JPanel();
        JPanel jPanel27 = new JPanel();
        JPanel jPanel28 = new JPanel();
        JPanel jPanel29 = new JPanel();
        JPanel jPanel30 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        JMenu jMenu2 = new JMenu("Depth Scale");
        JMenu jMenu3 = new JMenu("Data Entry Dialog");
        JMenu jMenu4 = new JMenu("Help");
        ButtonGroup buttonGroup = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), LBL_START_DEPTH);
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), LBL_CURSOR_DEPTH);
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), LBL_TRACKS);
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder4 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), LBL_SCALE_RANGE);
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder5 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), LBL_END_DEPTH);
        titledBorder5.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), LBL_NAME);
        titledBorder6.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder7 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), LBL_TRACK_BTNS);
        titledBorder7.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder8 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Modify Track Order");
        titledBorder8.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder9 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Header Information:");
        titledBorder9.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder10 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Change Log & Core Plot Limits");
        titledBorder10.setTitleFont(new Font("Dialog", 1, 11));
        this.mSave = new JMenuItem("Save Data");
        this.mSave.addActionListener(this);
        this.mPDF = new JMenuItem("Create PDF Document of Profile Plot");
        this.mPDF.addActionListener(this);
        this.memory = new JMenuItem("Display Available Memory Dialog");
        this.memory.addActionListener(this);
        this.mExit = new JMenuItem("Exit");
        this.mExit.addActionListener(this);
        jMenuBar.setFont(new Font("Dialog", 1, 11));
        jMenu.setFont(new Font("Dialog", 1, 12));
        jMenu2.setFont(new Font("Dialog", 1, 12));
        jMenu3.setFont(new Font("Dialog", 1, 12));
        jMenu4.setFont(new Font("Dialog", 1, 12));
        jMenu.add(this.mSave);
        jMenu.addSeparator();
        jMenu.add(this.mPDF);
        jMenu.addSeparator();
        jMenu.add(this.memory);
        jMenu.addSeparator();
        jMenu.addSeparator();
        jMenu.add(this.mExit);
        this.mShale = new JMenuItem("Gamma Ray Ranges");
        this.mShale.addActionListener(this);
        this.mPerf = new JMenuItem("Perforation Entry Frame");
        this.mPerf.addActionListener(this);
        this.mRockObsFrame = new JMenuItem("Rock Description Entry Frame");
        this.mRockObsFrame.addActionListener(this);
        this.mBioFrame = new JMenuItem("Fossil Species Name Entry Frame");
        this.mBioFrame.addActionListener(this);
        jMenu3.add(this.mShale);
        jMenu3.add(this.mPerf);
        jMenu3.add(this.mRockObsFrame);
        this.mHelp = new JMenuItem("Help");
        this.mHelp.addActionListener(this);
        jMenu4.add(this.mHelp);
        this.m1 = new JRadioButtonMenuItem("1 ft / in");
        this.m1.setHorizontalTextPosition(4);
        this.m1.addActionListener(this);
        buttonGroup.add(this.m1);
        this.m2 = new JRadioButtonMenuItem("2 ft / in");
        this.m2.setHorizontalTextPosition(4);
        this.m2.addActionListener(this);
        buttonGroup.add(this.m2);
        this.m5 = new JRadioButtonMenuItem("5 ft / in");
        this.m5.setHorizontalTextPosition(4);
        this.m5.addActionListener(this);
        buttonGroup.add(this.m5);
        this.m10 = new JRadioButtonMenuItem("10 ft / in");
        this.m10.setHorizontalTextPosition(4);
        this.m10.addActionListener(this);
        buttonGroup.add(this.m10);
        this.m20 = new JRadioButtonMenuItem("20 ft / in");
        this.m20.setHorizontalTextPosition(4);
        this.m20.addActionListener(this);
        buttonGroup.add(this.m20);
        this.m50 = new JRadioButtonMenuItem("50 ft / in");
        this.m50.setHorizontalTextPosition(4);
        this.m50.addActionListener(this);
        buttonGroup.add(this.m50);
        this.m100 = new JRadioButtonMenuItem("100 ft / in");
        this.m100.setSelected(true);
        this.m100.setHorizontalTextPosition(4);
        this.m100.addActionListener(this);
        buttonGroup.add(this.m100);
        this.m200 = new JRadioButtonMenuItem("200 ft / in");
        this.m200.setHorizontalTextPosition(4);
        this.m200.addActionListener(this);
        buttonGroup.add(this.m200);
        jMenu2.add(this.m1);
        jMenu2.add(this.m2);
        jMenu2.add(this.m5);
        jMenu2.add(this.m10);
        jMenu2.add(this.m20);
        jMenu2.add(this.m50);
        jMenu2.add(this.m100);
        jMenu2.add(this.m200);
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        jMenuBar.add(jMenu3);
        jMenuBar.add(jMenu4);
        this.setJMenuBar(jMenuBar);
        this.setTitle(LBL_TITLE);
        this.getContentPane().setLayout(new BorderLayout());
        this.notifier = new iqstratControlPlotFrameObservable();
        this.notifier.addObserver(this);
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(10, 120));
        jPanel23.setLayout(new BorderLayout());
        jPanel24.setBorder(titledBorder9);
        jPanel24.setLayout(new BorderLayout());
        jPanel28.setLayout(new GridLayout(2, 1));
        jPanel29.setLayout(new BorderLayout());
        this.lblName.setText("Name: ");
        jPanel30.setLayout(new GridLayout());
        this.lblAPI.setText("API: ");
        this.lblStatus.setText("Status:");
        jPanel25.setLayout(new BorderLayout());
        jPanel26.setLayout(new GridLayout());
        this.lblLat.setText("Lat: ");
        this.lblLong.setText("Long: ");
        jPanel27.setLayout(new GridLayout());
        this.lblTD.setText("Depth:");
        this.lblElev.setText("Elev (GL):");
        this.btnHeader.setFont(new Font("Dialog", 1, 11));
        this.btnHeader.setText("Edit Header Information");
        this.btnHeader.addActionListener(this);
        this.pConvert = new lasConvertFrame(this.notifier);
        this.pnlDefaultList = new iqstratAvailablePanel(this.notifier);
        this.getSelected();
        jPanel20.setLayout(new BorderLayout());
        jPanel20.setBorder(titledBorder8);
        jPanel22.setLayout(new BorderLayout());
        this.pTracks = new iqstratTracksTable(this.iSelected);
        jScrollPane2 = this.pTracks.getScrollPane();
        jPanel21.setLayout(new GridLayout());
        this.btnUp.setFont(new Font("Dialog", 1, 11));
        this.btnUp.setText("Move Up");
        this.btnUp.addActionListener(this);
        this.btnDown.setFont(new Font("Dialog", 1, 11));
        this.btnDown.setText("Move Down");
        this.btnDown.addActionListener(this);
        jPanel16.setBorder(titledBorder2);
        jPanel16.setLayout(new BorderLayout());
        this.txtCursorDepth.setEditable(false);
        this.txtCursorDepth.setText("0.0");
        this.txtCursorDepth.setHorizontalAlignment(11);
        jPanel2.setLayout(new GridLayout(4, 2));
        jPanel3.setLayout(new BorderLayout());
        jPanel4.setBorder(titledBorder4);
        jPanel4.setPreferredSize(new Dimension(10, 120));
        jPanel4.setLayout(new BorderLayout());
        jPanel5.setLayout(new BorderLayout());
        this.lblScale.setFont(new Font("Dialog", 1, 14));
        this.lblScale.setHorizontalAlignment(0);
        this.lblScale.setText("Depth Scale: " + scale[this.iScale]);
        jPanel6.setLayout(new BorderLayout());
        jPanel8.setLayout(new GridLayout());
        jPanel9.setBorder(titledBorder);
        jPanel9.setLayout(new BorderLayout());
        this.txtStart.setText("" + this.dStart);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new iqstratControlPlotFrameFocusAdapter(this));
        jPanel10.setBorder(titledBorder5);
        jPanel10.setLayout(new BorderLayout());
        this.txtEnd.setText("" + this.dEnd);
        this.txtEnd.setHorizontalAlignment(11);
        this.txtEnd.addFocusListener(new iqstratControlPlotFrameFocusAdapter(this));
        jPanel7.setLayout(new GridLayout());
        this.btnReset.setFont(new Font("Dialog", 1, 11));
        this.btnReset.setPreferredSize(new Dimension(67, 20));
        this.btnReset.setText(BTN_RESET);
        this.btnReset.addActionListener(this);
        this.btnModify.setFont(new Font("Dialog", 1, 11));
        this.btnModify.setPreferredSize(new Dimension(71, 20));
        this.btnModify.setText(BTN_MODIFY);
        this.btnModify.addActionListener(this);
        jPanel11.setLayout(new BorderLayout());
        jPanel11.setBorder(titledBorder3);
        jPanel14.setLayout(new BorderLayout());
        this.pnlPlotTracks.setLayout(this.cardLayout);
        jPanel12.setLayout(new GridLayout());
        jPanel12.setBorder(titledBorder10);
        this.btnLimitsLAS.setFont(new Font("Dialog", 1, 11));
        this.btnLimitsLAS.setText("Log Data");
        this.btnLimitsLAS.setBackground(new Color(204, 255, 153));
        this.btnLimitsLAS.addActionListener(this);
        this.btnLimitsCORE.setEnabled(false);
        this.btnLimitsCORE.setFont(new Font("Dialog", 1, 11));
        this.btnLimitsCORE.setText("Core Data");
        this.btnLimitsCORE.setBackground(new Color(255, 204, 102));
        this.btnLimitsCORE.addActionListener(this);
        jPanel13.setLayout(new BorderLayout());
        jPanel15.setLayout(new GridLayout());
        jPanel17.setLayout(new BorderLayout());
        jPanel18.setLayout(new BorderLayout());
        this.btnDefault.setFont(new Font("Dialog", 1, 11));
        this.btnDefault.setText(BTN_DEFAULT);
        this.btnDefault.addActionListener(this);
        this.btnUser.setFont(new Font("Dialog", 1, 11));
        this.btnUser.setText(BTN_USER);
        this.btnUser.addActionListener(this);
        this.setTrackPanelColors();
        this.setButtons();
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)jPanel23, "Center");
        jPanel23.add((Component)jPanel24, "Center");
        jPanel24.add((Component)jPanel28, "North");
        jPanel28.add((Component)jPanel29, null);
        jPanel29.add((Component)this.lblName, "West");
        jPanel28.add((Component)jPanel30, null);
        jPanel30.add((Component)this.lblAPI, "West");
        jPanel30.add((Component)this.lblStatus, "Center");
        jPanel24.add((Component)jPanel25, "Center");
        jPanel25.add((Component)jPanel26, "North");
        jPanel26.add((Component)this.lblLat, null);
        jPanel26.add((Component)this.lblLong, null);
        jPanel25.add((Component)jPanel27, "Center");
        jPanel27.add((Component)this.lblTD, null);
        jPanel27.add((Component)this.lblElev, null);
        jPanel24.add((Component)this.btnHeader, "South");
        this.getContentPane().add((Component)jPanel3, "Center");
        jPanel3.add((Component)jPanel4, "North");
        jPanel4.add((Component)jPanel5, "North");
        jPanel6.add((Component)this.lblScale, "North");
        jPanel4.add((Component)jPanel6, "Center");
        jPanel6.add((Component)jPanel8, "Center");
        jPanel8.add((Component)jPanel16, null);
        jPanel16.add((Component)this.txtCursorDepth, "Center");
        jPanel8.add((Component)jPanel9, null);
        jPanel9.add((Component)this.txtStart, "Center");
        jPanel8.add((Component)jPanel10, null);
        jPanel10.add((Component)this.txtEnd, "Center");
        jPanel6.add((Component)jPanel7, "South");
        jPanel7.add((Component)this.btnReset, null);
        jPanel7.add((Component)this.btnModify, null);
        jPanel3.add((Component)jPanel11, "Center");
        jPanel11.add((Component)jPanel12, "North");
        jPanel12.add((Component)this.btnLimitsLAS, null);
        jPanel12.add((Component)this.btnLimitsCORE, null);
        jPanel11.add((Component)jPanel13, "South");
        jPanel13.add((Component)jPanel15, "Center");
        jPanel15.add((Component)this.btnDefault, null);
        jPanel15.add((Component)this.btnUser, null);
        jPanel11.add((Component)jPanel14, "Center");
        jPanel14.add((Component)this.pnlPlotTracks, "Center");
        this.pnlPlotTracks.add((Component)jPanel17, "DEFAULT");
        jPanel17.add((Component)this.pnlDefaultList, "Center");
        this.pnlPlotTracks.add((Component)jPanel20, "MODIFY");
        jPanel20.add((Component)jPanel21, "South");
        jPanel21.add((Component)this.btnUp, null);
        jPanel21.add((Component)this.btnDown, null);
        jPanel20.add((Component)jPanel22, "Center");
        jPanel22.add((Component)jScrollPane2, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.iScreenWidth = dimension.width;
        this.iScreenHigh = dimension.height - 50;
        this.setSize(new Dimension(this.iControlWidth, dimension.height - 50));
        this.setLocation(1, 1);
        this.setVisible(true);
    }

    protected ImageIcon createImageIcon(String string) {
        URL uRL = this.getClass().getResource(string);
        ImageIcon imageIcon = null;
        if (uRL != null) {
            imageIcon = new ImageIcon(uRL);
        } else {
            System.err.println("Couldn't find file: " + string);
        }
        return imageIcon;
    }

    private void getData(int n) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        switch (n) {
            case 0: {
                this.setWellHeaderLabels();
                this.plotframe.setHeaders(this.stHeader);
                break;
            }
            case 2: {
                if (this.stLASFileData == null) break;
                this.stLASFileData = las3LoadLogData.normalizeDepth(this.stHeader, this.stLASFileData);
                this.ImageTrackFrame();
                this.setLimits(0);
                this.setLimits(1);
                this.dStart = this.stLASFileData.depthStart;
                this.dEnd = this.stLASFileData.depthEnd;
                this.iColorlith = this.stLASFileData.iColorlithDefault;
                this.setScale(this.iScale, this.dEnd, this.dStart);
                this.dStartOrig = this.dStart;
                this.dEndOrig = this.dEnd;
                this.txtStart.setText("" + this.dStart);
                this.txtEnd.setText("" + this.dEnd);
                d = this.dEnd - this.dStart;
                if (d < 10.0) {
                    this.changeScale(0);
                } else if (d < 20.0) {
                    this.changeScale(1);
                } else if (d < 50.0) {
                    this.changeScale(2);
                } else if (d < 100.0) {
                    this.changeScale(3);
                } else if (d < 200.0) {
                    this.changeScale(4);
                } else if (d < 500.0) {
                    this.changeScale(5);
                } else {
                    this.changeScale(6);
                }
                this.pConvert.setLAS(lasFileDataUtility.copy(this.stLASFileData));
                this.stLASLithology = iqstratControlPlotData.computeLithologyFromLAS(0, this.stLASFileData, this.stStruct.stSymbols);
                this.stRTLithology = iqstratControlPlotData.computeLithologyFromLAS(6, this.stLASFileData, this.stStruct.stSymbols);
                this.plotframe.setLASFileData(this.stLASFileData);
                this.plotframe.setLASRockColumn(this.stLASLithology);
                this.plotframe.setLASRockColumnByRT(this.stRTLithology);
                this.plotframe.setColorlith(this.iColorlith);
                this.stLASTexture = this.plotframe.getTexture();
                this.plotframe.setPHI(this.iTHINPHI);
                this.plotframe.setImageTrackFrame(this.pnlImageTrack);
                this.plotframe.setOHM(this.iOHMTool, this.dOHMMax, this.dOHMMin);
                this.plotframe.setPHI(this.iPHITool, this.dPHIMax, this.dPHIMin);
                this.WaitCompute();
                break;
            }
            case 16: {
                if (this.stLASFileData != null) {
                    this.stLASFileData.stList = iqstratShaleUtility.copyList(this.stShale);
                }
                this.plot();
                break;
            }
            case 17: {
                if (this.stBrine == null) break;
                this.plotframe.setBrine(this.stBrine);
                break;
            }
            case 3: {
                if (this.stCore == null) break;
                if (this.stLASFileData == null) {
                    this.dStart = this.stCore.depthStart;
                    this.dEnd = this.stCore.depthEnd;
                    this.dStartOrig = this.dStart;
                    this.dEndOrig = this.dEnd;
                    this.txtStart.setText("" + this.dStart);
                    this.txtEnd.setText("" + this.dEnd);
                }
                this.plotframe.setRockData(this.stCore);
                break;
            }
            case 4: {
                this.plotframe.setRockImages(this.stImages);
                break;
            }
            case 5: {
                this.plotframe.setTops(this.stStrat);
                break;
            }
            case 6: {
                this.plotframe.setSequence(this.stSequence);
                break;
            }
            case 19: {
                this.plotframe.setDepEnvrionment(this.stDepEnv);
                break;
            }
            case 7: {
                this.plotframe.setTops(this.stOther);
                break;
            }
            case 20: {
                this.plotframe.setRockColumn(this.stColumn);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                this.plotframe.setPHI(this.stPHI);
                break;
            }
            case 11: {
                this.plotframe.setStructures(this.stSedimentary);
                this.modifyWidths();
                break;
            }
            case 12: {
                this.plotframe.setFossils(this.stFossil);
                this.modifyWidths();
                break;
            }
            case 18: {
                this.plotframe.setBioStrat(this.stBio);
                this.modifyWidths();
                break;
            }
            case 13: {
                this.plotframe.setRockColorData(this.stRockColor);
                break;
            }
            case 14: {
                this.plotframe.setRemarks(this.stRemarks);
            }
        }
        this.setConfiguration(this.iConfig);
    }

    private void getData(int n, int n2) {
        switch (n2) {
            case 2: {
                this.stLASFileData = lasFileDataUtility.copy(iqstratPlotLoad.getLAS(n, this.pConvert));
                if (this.stLASFileData == null) break;
                this.pConvert.setLAS(lasFileDataUtility.copy(this.stLASFileData));
                break;
            }
            case 16: {
                this.stShale = iqstratShaleUtility.copyList(iqstratPlotLoad.getShale(this.pShaleFrame));
                if (this.stLASFileData != null) {
                    this.stLASFileData.stList = iqstratShaleUtility.copyList(this.stShale);
                }
                this.stLASLithology = iqstratControlPlotData.computeLithologyFromLAS(0, this.stLASFileData, this.stStruct.stSymbols);
                this.plot();
                break;
            }
            case 5: {
                this.stStrat = stratUtility.copyList(iqstratPlotLoad.getTops(this.pTopsEntry));
                this.plotframe.setTops(this.stStrat);
                break;
            }
            case 6: {
                this.stSequence = seqUtility.copyList(iqstratPlotLoad.getSeqStrat(this.pTopsEntry));
                this.plotframe.setSequence(this.stSequence);
                break;
            }
            case 19: {
                this.stDepEnv = envUtility.copyList(iqstratPlotLoad.getDepEnv(this.pTopsEntry));
                this.plotframe.setDepEnvrionment(this.stDepEnv);
                break;
            }
            case 7: {
                this.stOther = regionsUtility.copyList(iqstratPlotLoad.getPerf(this.perfFrame));
                this.plotframe.setTops(this.stOther);
                break;
            }
            case 17: {
                this.plotframe.setBrine(this.stBrine);
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            case 20: {
                this.stColumn = rockColumnUtility.copyList(iqstratPlotLoad.getRockColumn(this.stStruct, this.stRemarks));
                this.plotframe.setRockColumn(this.stColumn);
                break;
            }
            case 10: {
                this.stPHI = phiUtility.copyList(iqstratPlotLoad.getPorosity(this.stStruct, this.stRemarks));
                this.plotframe.setPHI(this.stPHI);
                break;
            }
            case 11: {
                this.stSedimentary = sedimentaryUtility.copyList(iqstratPlotLoad.getSedStruct(this.stStruct, this.stRemarks));
                this.plotframe.setStructures(this.stSedimentary);
                this.modifyWidths();
                break;
            }
            case 12: {
                this.stFossil = fossilUtility.copyList(iqstratPlotLoad.getFossils(this.stStruct, this.stRemarks));
                this.plotframe.setFossils(this.stFossil);
                this.modifyWidths();
                break;
            }
            case 18: {
                this.stBio = bioStratUtility.copyList(iqstratPlotLoad.getGeneraList(this.pBioEntry));
                this.plotframe.setBioStrat(this.stBio);
                this.modifyWidths();
                break;
            }
            case 13: {
                this.stRockColor = rockColorUtility.copyList(iqstratPlotLoad.getColor(this.stStruct, this.stRemarks));
                this.plotframe.setRockColorData(this.stRockColor);
                break;
            }
            case 14: {
                this.stRemarks = iqstratRemarkUtility.copyList(iqstratPlotLoad.getRemarks(this.pObsEntry));
                this.plotframe.setRemarks(this.stRemarks);
            }
        }
    }

    private void getGeoReportData() {
        double d = 0.0;
        if (this.stRemarks != null) {
            if (this.stPlotTexture != null && this.stLASFileData == null) {
                this.dStart = this.stPlotTexture.depthStart;
                this.dEnd = this.stPlotTexture.depthEnd;
                this.stStruct.depthStart = this.stPlotTexture.depthStart;
                this.stStruct.depthEnd = this.stPlotTexture.depthEnd;
                this.stStruct.depthStep = iqstratTracksStruct._SCALE[this.stPlotTexture.iUnit];
            }
            if (this.stColumn != null && this.stLASFileData == null) {
                this.stColumn = rockColumnUtility.computeDepthRange(this.stColumn);
                this.dStart = this.stColumn.depthStart;
                this.dEnd = this.stColumn.depthEnd;
                this.stStruct.depthStart = this.stColumn.depthStart;
                this.stStruct.depthEnd = this.stColumn.depthEnd;
            }
            if (this.dEnd > this.dStart) {
                this.dStartOrig = this.dStart;
                this.dEndOrig = this.dEnd;
                this.txtStart.setText("" + this.dStart);
                this.txtEnd.setText("" + this.dEnd);
                d = this.dEnd - this.dStart;
                if (this.stHeader == null) {
                    this.stHeader = new iqstratHeadersStruct();
                }
                this.stHeader.depth = d;
                this.setConfiguration(2);
                this.getSelected();
                this.plotframe.setSelected(this.iSelected);
                if (d < 10.0) {
                    this.changeScale(0);
                } else if (d < 20.0) {
                    this.changeScale(1);
                } else if (d < 50.0) {
                    this.changeScale(2);
                } else if (d < 100.0) {
                    this.changeScale(3);
                } else if (d < 200.0) {
                    this.changeScale(4);
                } else if (d < 500.0) {
                    this.changeScale(5);
                } else {
                    this.changeScale(6);
                }
                this.setWellHeaderLabels();
                this.plotframe.setHeaders(this.stHeader);
            }
            if (this.stCore == null && this.stRockData == null && this.stPlotTexture != null) {
                this.stRockData = rockFileDataUtility.buildNew(0, this.dStart, this.dEnd);
                this.stRockData = rockFileDataUtility.addData(this.stPlotTexture, this.stRockData);
                this.stRockData = rockFileDataUtility.lithologyCurves(this.stRockData);
                this.plotframe.setRockFileData(this.stRockData);
                this.setButtons();
            }
        }
    }

    private void ThinTrackFrame() {
        if (this.pnlThinTrack != null) {
            this.pnlThinTrack.close();
        }
        this.pnlThinTrack = null;
        this.pnlThinTrack = new lasThinTrackFrame(this.notifier, this.stLASFileData);
    }

    private void ImageTrackFrame() {
        if (this.pnlImageTrack != null) {
            this.pnlImageTrack.close();
        }
        this.pnlImageTrack = null;
        this.pnlImageTrack = new lithImageTrackFrame(this.notifier, this.stLASFileData);
    }

    private void getSelected() {
        this.iSelected = this.pnlDefaultList.getSelected();
    }

    private void getLASTrackSize() {
        this.iLASSize = this.pnlDefaultList.getLASTrackSize();
        if (this.plotframe != null) {
            this.plotframe.setLASTrackSize(this.iLASSize);
        }
        if (this.plotframe != null) {
            this.plotframe.setSelected(this.iSelected);
        }
    }

    private void getThinPorosity(int n) {
        this.iThin = 0;
        this.stControl.iThin = 0;
        for (int i = 0; i < this.iSelected.length; ++i) {
            if (this.iSelected[i] != 35) continue;
            this.iThin = 1;
            this.stControl.iThin = 1;
        }
        switch (n) {
            case 0: {
                if (this.pnlThinTrack == null) break;
                this.iTHINPHI = this.pnlThinTrack.getPHI();
                this.stControl.iTHINPHI = this.pnlThinTrack.getPHI();
                this.pnlThinTrack.setVisible(false);
                break;
            }
            case 1: {
                if (this.pnlDefaultList == null) break;
                this.iTHINPHI = this.pnlDefaultList.getThinCurve();
                this.stControl.iTHINPHI = this.pnlDefaultList.getThinCurve();
            }
        }
        if (this.plotframe != null) {
            this.plotframe.setPHI(this.iTHINPHI);
        }
    }

    private void getImageTrack() {
        int n = this.pnlImageTrack.getTrack();
        switch (n) {
            case 0: {
                this.iOHM = 0;
                this.stControl.iOHM = 0;
                for (int i = 0; i < this.iSelected.length; ++i) {
                    if (this.iSelected[i] != 2) continue;
                    this.iOHM = 1;
                    this.stControl.iOHM = 1;
                }
                this.iOHMTool = this.pnlImageTrack.getTool();
                this.dOHMMax = this.pnlImageTrack.getMaximum();
                this.dOHMMin = this.pnlImageTrack.getMinimum();
                this.stControl.iOHMTool = this.pnlImageTrack.getTool();
                this.stControl.dOHMMax = this.pnlImageTrack.getMaximum();
                this.stControl.dOHMMin = this.pnlImageTrack.getMinimum();
                if (this.plotframe == null) break;
                this.plotframe.setOHM(this.iOHMTool, this.dOHMMax, this.dOHMMin);
                break;
            }
            case 1: {
                this.iPHI = 0;
                this.stControl.iPHI = 0;
                for (int i = 0; i < this.iSelected.length; ++i) {
                    if (this.iSelected[i] != 11) continue;
                    this.iPHI = 1;
                    this.stControl.iPHI = 1;
                }
                this.iPHITool = this.pnlImageTrack.getTool();
                this.dPHIMax = this.pnlImageTrack.getMaximum();
                this.dPHIMin = this.pnlImageTrack.getMinimum();
                this.stControl.iPHITool = this.pnlImageTrack.getTool();
                this.stControl.dPHIMax = this.pnlImageTrack.getMaximum();
                this.stControl.dPHIMin = this.pnlImageTrack.getMinimum();
                if (this.plotframe == null) break;
                this.plotframe.setPHI(this.iPHITool, this.dPHIMax, this.dPHIMin);
            }
        }
        this.pnlImageTrack.setVisible(false);
        this.WaitCompute();
    }

    private void getImageTrack(int n, int n2) {
        boolean bl = false;
        switch (n2) {
            case 0: {
                this.iOHM = 0;
                this.stControl.iOHM = 0;
                for (int i = 0; i < this.iSelected.length; ++i) {
                    if (this.iSelected[i] != 2) continue;
                    this.iOHM = 1;
                    this.stControl.iOHM = 1;
                    bl = true;
                }
                this.iOHMTool = this.pnlDefaultList.getOHMCurve();
                this.stControl.iOHMTool = this.pnlDefaultList.getOHMCurve();
                if (this.plotframe == null) break;
                this.plotframe.setOHM(this.iOHMTool, this.dOHMMax, this.dOHMMin);
                break;
            }
            case 1: {
                this.iPHI = 0;
                this.stControl.iPHI = 0;
                for (int i = 0; i < this.iSelected.length; ++i) {
                    if (this.iSelected[i] != 11) continue;
                    this.iPHI = 1;
                    this.stControl.iPHI = 1;
                    bl = true;
                }
                this.iPHITool = this.pnlDefaultList.getPHICurve();
                this.stControl.iPHITool = this.pnlDefaultList.getPHICurve();
                if (this.plotframe == null) break;
                this.plotframe.setPHI(this.iPHITool, this.dPHIMax, this.dPHIMin);
            }
        }
        if (bl) {
            this.WaitCompute();
        }
    }

    private void modifyWidths() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        n2 = sedimentaryUtility.computeWidth(this.stSedimentary);
        n = fossilUtility.computeWidth(this.stFossil);
        n3 = bioStratUtility.computeWidth(this.stBio);
        if (this.plotframe != null) {
            this.plotframe.modifyWidths(n, n2, n3);
        }
    }

    private iqstratControlStruct getControl() {
        int n = 0;
        iqstratControlStruct iqstratControlStruct2 = new iqstratControlStruct();
        iqstratControlStruct2.depthStart = this.dStart;
        iqstratControlStruct2.depthEnd = this.dEnd;
        iqstratControlStruct2.iScale = this.iScale;
        iqstratControlStruct2.iPanel = this.iPanel;
        iqstratControlStruct2.iConfig = this.iConfig;
        if (this.iSelected != null) {
            iqstratControlStruct2.iTracks = this.iSelected;
            for (n = 0; n < this.iSelected.length; ++n) {
                if (this.iSelected[n] != 35) continue;
                iqstratControlStruct2.iThin = 1;
            }
            for (n = 0; n < this.iSelected.length; ++n) {
                if (this.iSelected[n] != 11 && this.iSelected[n] != 12) continue;
                iqstratControlStruct2.iPHI = 1;
            }
            for (n = 0; n < this.iSelected.length; ++n) {
                if (this.iSelected[n] != 2 && this.iSelected[n] != 3) continue;
                iqstratControlStruct2.iOHM = 1;
            }
        }
        iqstratControlStruct2.iTHINPHI = this.iTHINPHI;
        iqstratControlStruct2.dPHIMin = this.dPHIMin;
        iqstratControlStruct2.dPHIMax = this.dPHIMax;
        iqstratControlStruct2.iPHITool = this.iPHITool;
        iqstratControlStruct2.dOHMMin = this.dOHMMin;
        iqstratControlStruct2.dOHMMax = this.dOHMMax;
        iqstratControlStruct2.iOHMTool = this.iOHMTool;
        iqstratControlStruct2 = iqstratControlUtility.addConversionData(this.stLASFileData, iqstratControlStruct2);
        return iqstratControlStruct2;
    }

    public void setData(iqstratControlStruct iqstratControlStruct2, iqstratHeadersStruct iqstratHeadersStruct2, cmnLASFileListStruct cmnLASFileListStruct2, lasFileDataStruct lasFileDataStruct2, iqstratShaleListStruct iqstratShaleListStruct2, stratListStruct stratListStruct2, seqListStruct seqListStruct2, regionsListStruct regionsListStruct2, envListStruct envListStruct2, bioStratListStruct bioStratListStruct2, brineListStruct brineListStruct2, rockDataListStruct rockDataListStruct2, rockImagesListStruct rockImagesListStruct2, rockColumnListStruct rockColumnListStruct2, phiListStruct phiListStruct2, fossilListStruct fossilListStruct2, sedimentaryListStruct sedimentaryListStruct2, rockColorListStruct rockColorListStruct2, iqstratRemarkListStruct iqstratRemarkListStruct2) {
        double d = 0.0;
        int n = -1;
        this.stControl = iqstratControlStruct2;
        this.stHeader = iqstratHeadersStruct2;
        this.stFiles = cmnLASFileListStruct2;
        this.stLASFileData = lasFileDataStruct2;
        this.stShale = iqstratShaleListStruct2;
        this.stStrat = stratListStruct2;
        this.stSequence = seqListStruct2;
        this.stOther = regionsListStruct2;
        this.stDepEnv = envListStruct2;
        this.stBio = bioStratListStruct2;
        this.stBrine = brineListStruct2;
        this.stCore = rockDataListStruct2;
        this.stImages = rockImagesListStruct2;
        this.stColumn = rockColumnListStruct2;
        this.stPHI = phiListStruct2;
        this.stFossil = fossilListStruct2;
        this.stSedimentary = sedimentaryListStruct2;
        this.stRockColor = rockColorListStruct2;
        this.stRemarks = iqstratRemarkUtility.copyList(iqstratRemarkListStruct2);
        if (rockDataListStruct2 != null) {
            this.btnLimitsCORE.setEnabled(true);
        }
        this.getData(0);
        this.getData(2);
        this.getData(5);
        this.getData(6);
        this.getData(19);
        this.getData(7);
        this.getData(16);
        this.getData(17);
        this.getData(3);
        this.getData(14);
        this.getData(20);
        this.getData(10);
        this.getData(12);
        this.getData(11);
        this.getData(13);
        this.getData(18);
        this.getGeoReportData();
        this.setControl(iqstratControlStruct2);
        switch (this.iAction) {
            case 2: {
                this.iConfig = 1;
                break;
            }
            case 3: {
                this.iConfig = 3;
                break;
            }
            case 4: 
            case 5: {
                this.iConfig = 2;
                break;
            }
            case 0: 
            case 6: {
                this.iConfig = 0;
            }
        }
        this.setConfiguration(this.iConfig);
        if (lasFileDataStruct2 != null && cmnString.isNumeric(lasFileDataStruct2.sVersion)) {
            d = cmnString.stringToDouble(lasFileDataStruct2.sVersion);
        }
        if (d != 3.0) {
            n = this.pnlDefaultList.getThinCurve();
            if (n != -1) {
                this.iThin = 1;
                this.iTHINPHI = n;
                this.plotframe.setPHI(this.iTHINPHI);
            }
            if ((n = this.pnlDefaultList.getOHMCurve()) != -1) {
                this.iOHM = 1;
                this.iOHMTool = n;
                this.plotframe.setOHM(this.iOHMTool, this.dOHMMax, this.dOHMMin);
            }
            if ((n = this.pnlDefaultList.getPHICurve()) != -1) {
                this.iPHI = 1;
                this.iPHITool = n;
                this.plotframe.setPHI(this.iPHITool, this.dPHIMax, this.dPHIMin);
            }
        }
    }

    private void setWellHeaderLabels() {
        if (this.stHeader != null) {
            this.lblName.setText("Name: " + this.stHeader.sName);
            this.lblAPI.setText(this.stHeader.sAPI + " ");
            this.lblStatus.setText("Status: " + this.stHeader.status);
            this.lblLat.setText("Lat: " + this.stHeader.dLatitude);
            this.lblLong.setText("Long: " + this.stHeader.dLongitude);
            this.lblTD.setText("Depth: " + this.stHeader.depth);
            this.lblElev.setText("Elev: ");
            if (this.stHeader.dGL > 0.0) {
                this.lblElev.setText("Elev (GL): " + this.stHeader.dGL);
            } else if (this.stHeader.dKB > 0.0) {
                this.lblElev.setText("Elev (KB): " + this.stHeader.dKB);
            } else if (this.stHeader.dDF > 0.0) {
                this.lblElev.setText("Elev (DF): " + this.stHeader.dDF);
            }
        } else {
            this.lblName.setText("Name: ");
            this.lblAPI.setText(" ");
            this.lblStatus.setText("Status: ");
            this.lblLat.setText("Lat: ");
            this.lblLong.setText("Long: ");
            this.lblTD.setText("Depth: ");
            this.lblElev.setText("Elev: ");
        }
    }

    private void setButtons() {
        this.m1.setSelected(false);
        this.m2.setSelected(false);
        this.m5.setSelected(false);
        this.m10.setSelected(false);
        this.m20.setSelected(false);
        this.m50.setSelected(false);
        this.m100.setSelected(false);
        this.m200.setSelected(false);
        switch (this.iScale) {
            case 0: {
                this.m1.setSelected(true);
                break;
            }
            case 1: {
                this.m2.setSelected(true);
                break;
            }
            case 2: {
                this.m5.setSelected(true);
                break;
            }
            case 3: {
                this.m10.setSelected(true);
                break;
            }
            case 4: {
                this.m20.setSelected(true);
                break;
            }
            case 5: {
                this.m50.setSelected(true);
                break;
            }
            case 6: {
                this.m100.setSelected(true);
                break;
            }
            case 7: {
                this.m200.setSelected(true);
            }
        }
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        if (this.pTracks.getTotalRows() > 0) {
            this.btnUp.setEnabled(true);
            this.btnDown.setEnabled(true);
        }
    }

    private void setLimits(int n) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = -1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = null;
        if (this.stLASFileData != null) {
            switch (n) {
                case 0: {
                    n2 = this.iPHITool;
                    d2 = this.dPHIMin;
                    d3 = this.dPHIMax;
                    if (!bl3 && this.stLASFileData.checkData(8)) {
                        n2 = 8;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(7)) {
                        n2 = 7;
                        bl3 = true;
                    }
                    if (bl3 || !this.stLASFileData.checkData(9)) break;
                    n2 = 9;
                    bl3 = true;
                    break;
                }
                case 1: {
                    n2 = this.iOHMTool;
                    d2 = this.dOHMMin;
                    d3 = this.dOHMMax;
                    if (!bl3 && this.stLASFileData.checkData(18)) {
                        n2 = 18;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(19)) {
                        n2 = 19;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(20)) {
                        n2 = 20;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(33)) {
                        n2 = 33;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(32)) {
                        n2 = 32;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(31)) {
                        n2 = 31;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(30)) {
                        n2 = 30;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(29)) {
                        n2 = 29;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(28)) {
                        n2 = 28;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(26)) {
                        n2 = 26;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(27)) {
                        n2 = 27;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(15)) {
                        n2 = 15;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(14)) {
                        n2 = 14;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(16)) {
                        n2 = 16;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(17)) {
                        n2 = 17;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(21)) {
                        n2 = 21;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(22)) {
                        n2 = 22;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(23)) {
                        n2 = 23;
                        bl3 = true;
                    }
                    if (!bl3 && this.stLASFileData.checkData(24)) {
                        n2 = 24;
                        bl3 = true;
                    }
                    if (bl3 || !this.stLASFileData.checkData(25)) break;
                    n2 = 25;
                    bl3 = true;
                }
            }
            dArray = this.stLASFileData.getData(n2);
            if (dArray != null) {
                for (int i = 0; i < dArray.length; ++i) {
                    d = this.stLASFileData.dNull;
                    if (n2 >= 7 && n2 <= 9) {
                        d = dArray[i];
                    } else if (n2 >= 18 && n2 <= 33) {
                        d = 1000.0 / dArray[i];
                    }
                    if (!bl2) {
                        if (!(d > this.stLASFileData.dNull)) continue;
                        d2 = d;
                        d3 = d;
                        bl2 = true;
                        continue;
                    }
                    if (!(d > this.stLASFileData.dNull)) continue;
                    if (d2 > d) {
                        d2 = d;
                    }
                    if (!(d3 < d)) continue;
                    d3 = d;
                }
            }
            switch (n) {
                case 0: {
                    this.dPHIMin = d2;
                    this.dPHIMax = d3;
                    this.iPHITool = n2;
                    break;
                }
                case 1: {
                    this.dOHMMin = d2;
                    this.dOHMMax = d3;
                    this.iOHMTool = n2;
                }
            }
        }
    }

    public void setOrderPanel(int n) {
        this.iPanel = n;
        this.stControl.iPanel = n;
        switch (n) {
            case 0: {
                this.cardLayout.show(this.pnlPlotTracks, "DEFAULT");
                this.pnlDefaultList.setByAction(this.iAction, this.stLASFileData, this.stSequence, this.stStrat, this.stDepEnv, this.stBrine, this.stCore, this.stImages, this.stColumn, this.stRockLithology, this.stTexture, this.stPHI, this.stFossil, this.stBio, this.stSedimentary, this.stRockColor, this.stRemarks);
                this.pnlDefaultList.setNotify();
                break;
            }
            case 1: {
                this.pTracks.setData(this.iSelected);
                this.cardLayout.show(this.pnlPlotTracks, "MODIFY");
            }
        }
    }

    private void setInitialConfiguration(int n) {
        this.iConfig = n;
        this.stControl.iConfig = n;
        this.setConfiguration(n);
        this.pnlDefaultList.setNotify();
        this.pTracks.setData(this.iSelected);
    }

    private void setConfiguration(int n) {
        this.pnlDefaultList.setByAction(this.iAction, this.stLASFileData, this.stSequence, this.stStrat, this.stDepEnv, this.stBrine, this.stCore, this.stImages, this.stColumn, this.stRockLithology, this.stTexture, this.stPHI, this.stFossil, this.stBio, this.stSedimentary, this.stRockColor, this.stRemarks);
        this.iConfig = n;
        this.stControl.iConfig = n;
        this.pnlDefaultList.setNotify();
        this.pTracks.setData(this.iSelected);
    }

    public void setFront() {
        this.toFront();
        if (this.plotframe != null) {
            this.plotframe.toFront();
        }
    }

    public void setScale(int n, double d, double d2) {
        if (this.plotframe != null) {
            this.plotframe.setScale(n, d, d2);
        }
    }

    private void setDepth() {
        double d = 0.0;
        this.dStart = cmnString.stringToDouble(this.txtStart.getText());
        this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
        if (this.dEnd < this.dStart) {
            d = this.dEnd;
            this.dEnd = this.dStart;
            this.dStart = d;
        }
        this.txtStart.setText("" + this.dStart);
        this.txtEnd.setText("" + this.dEnd);
        this.stControl.depthStart = this.dStart;
        this.stControl.depthEnd = this.dEnd;
        this.setScale(this.iScale, this.dEnd, this.dStart);
        this.WaitCompute();
    }

    private void setDefaultDepth() {
        this.txtStart.setText("" + this.dStartOrig);
        this.txtEnd.setText("" + this.dEndOrig);
        this.dStart = this.dStartOrig;
        this.dEnd = this.dEndOrig;
        this.setScale(this.iScale, this.dEnd, this.dStart);
        this.WaitCompute();
    }

    private void setTrackPanelColors() {
        this.btnDefault.setBackground(new Color(100, 50, 0));
        this.btnDefault.setForeground(new Color(240, 240, 0));
        this.btnUser.setBackground(new Color(100, 50, 0));
        this.btnUser.setForeground(new Color(240, 240, 0));
        switch (this.iPanel) {
            case 0: {
                this.btnDefault.setBackground(new Color(240, 240, 0));
                this.btnDefault.setForeground(new Color(100, 50, 0));
                break;
            }
            case 1: {
                this.btnUser.setBackground(new Color(240, 240, 0));
                this.btnUser.setForeground(new Color(100, 50, 0));
            }
        }
    }

    private void setControl(iqstratControlStruct iqstratControlStruct2) {
        if (iqstratControlStruct2 != null) {
            this.stControl = iqstratControlUtility.copy(iqstratControlStruct2);
            this.iThin = iqstratControlStruct2.iThin;
            this.iTHINPHI = iqstratControlStruct2.iTHINPHI;
            this.iPHI = iqstratControlStruct2.iPHI;
            this.dPHIMin = iqstratControlStruct2.dPHIMin;
            this.dPHIMax = iqstratControlStruct2.dPHIMax;
            this.iPHITool = iqstratControlStruct2.iPHITool;
            this.iOHM = iqstratControlStruct2.iOHM;
            this.dOHMMin = iqstratControlStruct2.dOHMMin;
            this.dOHMMax = iqstratControlStruct2.dOHMMax;
            this.iOHMTool = iqstratControlStruct2.iOHMTool;
            if (iqstratControlStruct2.depthStart != iqstratControlStruct2.depthEnd) {
                this.dStart = iqstratControlStruct2.depthStart;
                this.dEnd = iqstratControlStruct2.depthEnd;
                this.iScale = iqstratControlStruct2.iScale;
                this.txtStart.setText("" + this.dStart);
                this.txtEnd.setText("" + this.dEnd);
            }
            this.setConfiguration(iqstratControlStruct2.iConfig);
            if (this.plotframe != null) {
                this.plotframe.setSelected(this.iSelected);
                this.plotframe.setPHI(this.iTHINPHI);
                this.plotframe.setOHM(this.iOHMTool, this.dOHMMax, this.dOHMMin);
                this.plotframe.setPHI(this.iPHITool, this.dPHIMax, this.dPHIMin);
            }
            if (this.stLASFileData != null) {
                this.stLASFileData = lasFileDataUtility.addConversionData(iqstratControlStruct2, this.stLASFileData);
                if (this.pConvert != null) {
                    this.pConvert.setLAS(lasFileDataUtility.copy(this.stLASFileData));
                }
            }
            this.setScale(this.iScale, this.dEnd, this.dStart);
        }
    }

    public void setLimits(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        this.data_las = dArray;
        this.data_core = dArray2;
        this.data_pf = dArray3;
        if (this.plotframe != null) {
            this.plotframe.setPlotLimits(dArray, dArray2, dArray3);
        }
    }

    private void Compute() {
        this.dRt = null;
        this.dPhit = null;
        this.dPhi = null;
        if (this.stLASFileData != null) {
            this.dRt = lasFileDataUtility.setData(0, this.iOHMTool, this.dStart, this.dEnd, this.stLASFileData);
            this.dPhit = lasFileDataUtility.setData(1, this.iPHITool, this.dStart, this.dEnd, this.stLASFileData);
            if (this.plotframe != null) {
                this.plotframe.setImageData(this.dRt, this.dPhit, this.dPhi);
                this.plotframe.refresh();
            }
        }
    }

    private void WaitCompute() {
        URL uRL = null;
        try {
            uRL = new URL("http://www.kgs.ku.edu/stratigraphic/IQSTRAT//");
        }
        catch (Exception exception) {
            System.out.println("Wrong Image Directory" + exception);
        }
        final utilWaitAnimation utilWaitAnimation2 = new utilWaitAnimation(uRL);
        utilWaitAnimation2.startAnimation();
        SwingWorker swingWorker = new SwingWorker(){

            @Override
            public Object construct() {
                iqstratControlPlotFrame.this.Compute();
                return "OK";
            }

            @Override
            public void finished() {
                utilWaitAnimation2.stopAnimation();
            }
        };
        swingWorker.start();
    }

    private void plot() {
        Object var1_1 = null;
        String string = "Plot Well: ";
        String string2 = "";
        String string3 = "";
        this.stStruct.depthStart = this.dStart;
        this.stStruct.depthEnd = this.dEnd;
        this.stStruct.iScale = this.iScale;
        if (this.stStruct.iDataType == 1) {
            string = "Plot Outcrop: ";
        }
        if (this.plotframe != null) {
            this.iFrameX = this.plotframe.getLocation().x;
            this.iFrameY = this.plotframe.getLocation().y;
            this.iFrameWidth = this.plotframe.getSize().width;
            this.iFrameHeight = this.plotframe.getSize().height;
            this.plotframe.close();
            this.plotframe = null;
        }
        this.plotframe = new iqstratPlotFrame(this, this.stStruct, this.iSelected, this.iControlWidth, this.iFrameX, this.iFrameY, this.iFrameWidth, this.iFrameHeight);
        this.plotframe.setTextfield(this.txtCursorDepth);
        this.plotframe.setHeaders(this.stHeader);
        this.plotframe.setLASFileData(this.stLASFileData);
        this.plotframe.setLASRockColumn(this.stLASLithology);
        this.plotframe.setLASRockColumnByRT(this.stRTLithology);
        this.plotframe.setColorlith(this.iColorlith);
        this.plotframe.setPfeffer(this.stPfeffer);
        this.plotframe.setPfefferList(this.stFlowUnits);
        this.plotframe.setTops(this.stStrat);
        this.plotframe.setSequence(this.stSequence);
        this.plotframe.setTops(this.stOther);
        this.plotframe.setDepEnvrionment(this.stDepEnv);
        this.plotframe.setBioStrat(this.stBio);
        this.plotframe.setBrine(this.stBrine);
        this.plotframe.setRockData(this.stCore);
        this.plotframe.setRockImages(this.stImages);
        this.plotframe.setRockColumn(this.stColumn);
        this.plotframe.setPHI(this.stPHI);
        this.plotframe.setFossils(this.stFossil);
        this.plotframe.setStructures(this.stSedimentary);
        this.plotframe.setRockColorData(this.stRockColor);
        this.plotframe.setRemarks(this.stRemarks);
        this.plotframe.setRockFileData(this.stRockData);
        this.modifyWidths();
        this.plotframe.setPHI(this.iTHINPHI);
        this.plotframe.setImageTrackFrame(this.pnlImageTrack);
        this.plotframe.setOHM(this.iOHMTool, this.dOHMMax, this.dOHMMin);
        this.plotframe.setPHI(this.iPHITool, this.dPHIMax, this.dPHIMin);
        this.plotframe.setConvertFrame(this.pConvert);
        this.plotframe.setObservable(this.notifier);
        this.plotframe.setCommon(this.stStruct.stCMN);
        this.plotframe.toFront();
    }

    private void Find_Plot_Limits(int n) {
        this.iData = n;
        if (this.orig_las == null) {
            this.orig_las = lasPlotLimitsUtility.initialize(this.stLASFileData);
            this.data_las = lasPlotLimitsUtility.copy(this.orig_las);
        }
        if (this.orig_core == null) {
            this.orig_core = rockPlotLimitsUtility.initialize(this.stCore);
            this.data_core = rockPlotLimitsUtility.copy(this.orig_core);
        }
        if (this.orig_pf == null) {
            this.orig_pf = pfefferPlotLimitsUtility.initialize();
            this.data_pf = pfefferPlotLimitsUtility.copy(this.orig_pf);
        }
        switch (n) {
            case 1: {
                if (this.pLimitsLAS != null) {
                    this.pLimitsLAS.close();
                }
                this.pLimitsLAS = null;
                this.pLimitsLAS = new lasPlotLimitsFrame(this.notifier, this.orig_las, this.data_las);
                break;
            }
            case 2: {
                if (this.pLimitsCORE != null) {
                    this.pLimitsCORE.close();
                }
                this.pLimitsCORE = null;
                this.pLimitsCORE = new rockPlotLimitsFrame(this.notifier, this.orig_core, this.data_core);
            }
        }
    }

    private void moveUp() {
        int n = this.pTracks.getSelectedRow();
        int n2 = n - 1;
        int n3 = -1;
        if (n2 > -1) {
            n3 = this.iSelected[n];
            this.iSelected[n] = this.iSelected[n2];
            this.iSelected[n2] = n3;
        }
        this.stControl.iTracks = this.iSelected;
        this.pTracks.setData(this.iSelected);
        if (n2 > -1) {
            this.pTracks.setSelectedRow(n2);
        }
        if (this.plotframe != null) {
            this.plotframe.setSelected(this.iSelected);
        }
    }

    private void moveDown() {
        int n = this.pTracks.getSelectedRow();
        int n2 = n + 1;
        int n3 = -1;
        if (n2 < this.iSelected.length) {
            n3 = this.iSelected[n];
            this.iSelected[n] = this.iSelected[n2];
            this.iSelected[n2] = n3;
        }
        this.stControl.iTracks = this.iSelected;
        this.pTracks.setData(this.iSelected);
        if (n2 < this.iSelected.length) {
            this.pTracks.setSelectedRow(n2);
        }
        if (this.plotframe != null) {
            this.plotframe.setSelected(this.iSelected);
        }
    }

    private void save() {
        if (this.p3File != null) {
            this.p3File.close();
        }
        this.p3File = null;
        this.p3File = new las3FileFrame(this.notifier, this.stStruct, this.stFiles, this.stHeader, this.stLASFileData, this.stCore, this.stBrine, this.stImages, this.stStrat, this.stSequence, this.stDepEnv, this.stOther, this.stBio, this.stDST, this.getControl(), this.stShale, this.stFlowUnits, this.stRemarks);
    }

    private boolean checkData() {
        boolean bl = false;
        if (this.stRemarks != null && this.stRemarks.iCount > 0) {
            bl = true;
        }
        if (this.stCore != null && this.stCore.iCount > 0) {
            bl = true;
        }
        return bl;
    }

    private void changeScale(int n) {
        this.iScale = n;
        this.lblScale.setText("Depth Scale: " + scale[n]);
        this.setScale(n, this.dEnd, this.dStart);
    }

    private void createPDF() {
        iqstratIO_Files.createImage(this.stStruct, this.plotframe.getImage());
        iqstratIO_Files.createHTML(this.stStruct);
        if (this.plotframe != null) {
            iqstratIO_Files.createDRA(this.stStruct, this.stHeader, this.plotframe.getPlotWidth(), this.plotframe.getPlotHeight(), this.dStart, this.dEnd);
        }
        this.stStruct.sDirectory = new String("");
        this.stStruct.sName = new String("");
    }

    private void showMemory() {
        if (this.pMemory != null) {
            this.pMemory.close();
        }
        this.pMemory = null;
        this.pMemory = new guiMemoryFrame();
        this.pMemory.setMemory();
    }

    public void closeOtherOBSData() {
        if (this.stColumn != null) {
            this.stColumn.delete();
        }
        this.stColumn = null;
        if (this.stRockLithology != null) {
            this.stRockLithology.delete();
        }
        this.stRockLithology = null;
        if (this.stPlotLithology != null) {
            this.stPlotLithology.delete();
        }
        this.stPlotLithology = null;
        if (this.stTexture != null) {
            this.stTexture.delete();
        }
        this.stTexture = null;
        if (this.stPlotTexture != null) {
            this.stPlotTexture.delete();
        }
        this.stPlotTexture = null;
        if (this.stPHI != null) {
            this.stPHI.delete();
        }
        this.stPHI = null;
        if (this.stFossil != null) {
            this.stFossil.delete();
        }
        this.stFossil = null;
        if (this.stBio != null) {
            this.stBio.delete();
        }
        this.stBio = null;
        if (this.stSedimentary != null) {
            this.stSedimentary.delete();
        }
        this.stSedimentary = null;
        if (this.stRockColor != null) {
            this.stRockColor.delete();
        }
        this.stRockColor = null;
    }

    public void closeOBSData() {
        if (this.stRockLithology != null) {
            this.stRockLithology.delete();
        }
        this.stRockLithology = null;
        if (this.stPlotLithology != null) {
            this.stPlotLithology.delete();
        }
        this.stPlotLithology = null;
        if (this.stTexture != null) {
            this.stTexture.delete();
        }
        this.stTexture = null;
        if (this.stPlotTexture != null) {
            this.stPlotTexture.delete();
        }
        this.stPlotTexture = null;
        if (this.stPHI != null) {
            this.stPHI.delete();
        }
        this.stPHI = null;
        if (this.stFossil != null) {
            this.stFossil.delete();
        }
        this.stFossil = null;
        if (this.stBio != null) {
            this.stBio.delete();
        }
        this.stBio = null;
        if (this.stSedimentary != null) {
            this.stSedimentary.delete();
        }
        this.stSedimentary = null;
        if (this.stRockColor != null) {
            this.stRockColor.delete();
        }
        this.stRockColor = null;
        if (this.stRemarks != null) {
            this.stRemarks.delete();
        }
        this.stRemarks = null;
    }

    public void closeData() {
        if (this.stHeader != null) {
            this.stHeader.delete();
        }
        this.stHeader = null;
        if (this.stFiles != null) {
            this.stFiles.delete();
        }
        this.stFiles = null;
        if (this.stLAS3Data != null) {
            this.stLAS3Data.delete();
        }
        this.stLAS3Data = null;
        if (this.stLASFileData != null) {
            this.stLASFileData.delete();
        }
        this.stLASFileData = null;
        if (this.stLASLithology != null) {
            this.stLASLithology.delete();
        }
        this.stLASLithology = null;
        if (this.stRTLithology != null) {
            this.stRTLithology.delete();
        }
        this.stRTLithology = null;
        if (this.stLASTexture != null) {
            this.stLASTexture.delete();
        }
        this.stLASTexture = null;
        if (this.stShale != null) {
            this.stShale.delete();
        }
        this.stShale = null;
        if (this.stPfeffer != null) {
            this.stPfeffer.delete();
        }
        this.stPfeffer = null;
        if (this.stFlowUnits != null) {
            this.stFlowUnits.delete();
        }
        this.stFlowUnits = null;
        if (this.stTops != null) {
            this.stTops.delete();
        }
        this.stTops = null;
        if (this.stStrat != null) {
            this.stStrat.delete();
        }
        this.stStrat = null;
        if (this.stSequence != null) {
            this.stSequence.delete();
        }
        this.stSequence = null;
        if (this.stOther != null) {
            this.stOther.delete();
        }
        this.stOther = null;
        if (this.stDepEnv != null) {
            this.stDepEnv.delete();
        }
        this.stDepEnv = null;
        if (this.stBio != null) {
            this.stBio.delete();
        }
        this.stBio = null;
        if (this.stBrine != null) {
            this.stBrine.delete();
        }
        this.stBrine = null;
        if (this.stDST != null) {
            this.stDST.delete();
        }
        this.stDST = null;
        if (this.stCore != null) {
            this.stCore.delete();
        }
        this.stCore = null;
        if (this.stImages != null) {
            this.stImages.delete();
        }
        this.stImages = null;
        if (this.stRockColor != null) {
            this.stRockColor.delete();
        }
        this.stRockColor = null;
        if (this.stRockLithology != null) {
            this.stRockLithology.delete();
        }
        this.stRockLithology = null;
        if (this.stPlotLithology != null) {
            this.stPlotLithology.delete();
        }
        this.stPlotLithology = null;
        if (this.stTexture != null) {
            this.stTexture.delete();
        }
        this.stTexture = null;
        if (this.stPlotTexture != null) {
            this.stPlotTexture.delete();
        }
        this.stPlotTexture = null;
        if (this.stPHI != null) {
            this.stPHI.delete();
        }
        this.stPHI = null;
        if (this.stFossil != null) {
            this.stFossil.delete();
        }
        this.stFossil = null;
        if (this.stSedimentary != null) {
            this.stSedimentary.delete();
        }
        this.stSedimentary = null;
        if (this.stRemarks != null) {
            this.stRemarks.delete();
        }
        this.stRemarks = null;
        if (this.stColumn != null) {
            this.stColumn.delete();
        }
        this.stColumn = null;
        this.dRt = null;
        this.dPhit = null;
        this.dPhi = null;
    }

    public void closeTopsDataEntry() {
        if (this.pTopsEntry != null) {
            this.pTopsEntry.close();
        }
        this.pTopsEntry = null;
    }

    public void closeRockObsDataEntry() {
        if (this.pObsEntry != null) {
            this.pObsEntry.close();
        }
        this.pObsEntry = null;
    }

    public void closeBioDataEntry() {
        if (this.pBioEntry != null) {
            this.pBioEntry.close();
        }
        this.pBioEntry = null;
    }

    public void close() {
        this.notifier = null;
        Object var1_1 = null;
        this.closeData();
        this.orig_las = null;
        this.orig_pf = null;
        this.data_las = null;
        this.data_pf = null;
        if (this.pSearch != null) {
            this.pSearch.close();
        }
        this.pSearch = null;
        if (this.pnlDefaultList != null) {
            this.pnlDefaultList.close();
        }
        this.pnlDefaultList = null;
        if (this.pTracks != null) {
            this.pTracks.close();
        }
        this.pTracks = null;
        this.iStatus = null;
        this.iSelected = null;
        if (this.pMemory != null) {
            this.pMemory.close();
        }
        this.pMemory = null;
        if (this.pHeaders != null) {
            this.pHeaders.close();
        }
        this.pHeaders = null;
        if (this.pShaleFrame != null) {
            this.pShaleFrame.close();
        }
        this.pShaleFrame = null;
        if (this.perfFrame != null) {
            this.perfFrame.close();
        }
        this.perfFrame = null;
        this.closeRockObsDataEntry();
        this.closeTopsDataEntry();
        this.closeBioDataEntry();
        if (this.p3File != null) {
            this.p3File.close();
        }
        this.p3File = null;
        if (this.pnlThinTrack != null) {
            this.pnlThinTrack.close();
        }
        this.pnlThinTrack = null;
        if (this.pnlImageTrack != null) {
            this.pnlImageTrack.close();
        }
        this.pnlImageTrack = null;
        if (this.pConvert != null) {
            this.pConvert.close();
        }
        this.pConvert = null;
        if (this.pLimitsLAS != null) {
            this.pLimitsLAS.close();
        }
        this.pLimitsLAS = null;
        if (this.pLimitsCORE != null) {
            this.pLimitsCORE.close();
        }
        this.pLimitsCORE = null;
        this.mSave = null;
        this.mPDF = null;
        this.memory = null;
        this.mExit = null;
        this.mShale = null;
        this.mPerf = null;
        this.mRockObsFrame = null;
        this.mBioFrame = null;
        this.mHelp = null;
        this.lblScale = null;
        this.m1 = null;
        this.m2 = null;
        this.m5 = null;
        this.m10 = null;
        this.m20 = null;
        this.m50 = null;
        this.m100 = null;
        this.m200 = null;
        this.txtCursorDepth = null;
        this.txtStart = null;
        this.txtEnd = null;
        this.btnReset = null;
        this.btnModify = null;
        this.lblName = null;
        this.lblAPI = null;
        this.lblStatus = null;
        this.lblLat = null;
        this.lblLong = null;
        this.lblTD = null;
        this.lblElev = null;
        this.btnHeader = null;
        this.btnLimitsLAS = null;
        this.btnLimitsCORE = null;
        this.btnDefault = null;
        this.btnUser = null;
        this.btnUp = null;
        this.btnDown = null;
        this.pnlPlotTracks = null;
        this.cardLayout = null;
        if (this.plotframe != null) {
            this.plotframe.close();
        }
        this.plotframe = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String string2 = "";
        if (this.pMemory != null) {
            this.pMemory.setMemory();
        }
        if (actionEvent.getSource() == this.memory) {
            this.showMemory();
        }
        if (actionEvent.getSource() == this.mShale) {
            if (this.pShaleFrame != null) {
                this.pShaleFrame.close();
            }
            this.pShaleFrame = null;
            this.pShaleFrame = new iqstratShaleFrame(this.notifier, this.stShale);
        }
        if (actionEvent.getSource() == this.mPerf) {
            if (this.perfFrame != null) {
                this.perfFrame.close();
            }
            this.perfFrame = null;
            this.perfFrame = new regionsPerfFrame(this.notifier, this.stOther);
        }
        if (actionEvent.getSource() == this.btnHeader) {
            if (this.pHeaders != null) {
                this.pHeaders.close();
            }
            this.pHeaders = null;
            this.pHeaders = new iqstratHeadersFrame(this.stStruct.stCMN, this.notifier, this.stHeader);
        }
        if (actionEvent.getSource() == this.mRockObsFrame) {
            this.closeRockObsDataEntry();
            this.pObsEntry = new rockObsEntryFrame(this.notifier, this.stStruct);
            this.pObsEntry.setRemarksData(this.stRemarks);
        }
        if (actionEvent.getSource() == this.mBioFrame) {
            this.closeBioDataEntry();
            this.pBioEntry = new bioDataEntryFrame(this.notifier, this.stStruct);
            this.pBioEntry.setData(this.stBio);
        }
        if (actionEvent.getSource() == this.m200) {
            this.changeScale(7);
        }
        if (actionEvent.getSource() == this.m100) {
            this.changeScale(6);
        }
        if (actionEvent.getSource() == this.m50) {
            this.changeScale(5);
        }
        if (actionEvent.getSource() == this.m20) {
            this.changeScale(4);
        }
        if (actionEvent.getSource() == this.m10) {
            this.changeScale(3);
        }
        if (actionEvent.getSource() == this.m5) {
            this.changeScale(2);
        }
        if (actionEvent.getSource() == this.m2) {
            this.changeScale(1);
        }
        if (actionEvent.getSource() == this.m1) {
            this.changeScale(0);
        }
        if (actionEvent.getSource() == this.btnLimitsLAS) {
            this.Find_Plot_Limits(1);
        }
        if (actionEvent.getSource() == this.btnLimitsCORE) {
            this.Find_Plot_Limits(2);
        }
        if (actionEvent.getSource() == this.btnReset) {
            this.setDefaultDepth();
        }
        if (actionEvent.getSource() == this.btnModify) {
            this.setDepth();
        }
        if (actionEvent.getSource() == this.btnDefault) {
            this.setOrderPanel(0);
        }
        if (actionEvent.getSource() == this.btnUser) {
            this.setOrderPanel(1);
        }
        this.setTrackPanelColors();
        if (actionEvent.getSource() == this.btnUp) {
            this.moveUp();
        }
        if (actionEvent.getSource() == this.btnDown) {
            this.moveDown();
        }
        this.setButtons();
        if (actionEvent.getSource() == this.mSave) {
            this.save();
        }
        if (actionEvent.getSource() == this.mPDF) {
            this.iDocument = 1;
            string2 = kgsIOUser.getHomeDir();
            this.stStruct.sDirectory = new String(string2);
            this.stStruct.sName = new String("Profile");
            this.pSearch = new guiSearchDirectoryFrame(this.notifier, string2, "Profile", ".png");
        }
        if (actionEvent.getSource() == this.mHelp) {
            BrowserControl.displayURL("http://www.kgs.ku.edu/stratigraphic/PROFILE/HELP/");
        }
        utilMemory.free();
        if (this.pMemory != null) {
            this.pMemory.setMemory();
        }
        if (this.pMemory != null) {
            this.pMemory.toFront();
        }
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Start Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtEnd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("End Depth Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtStart) {
                    this.dStart = cmnString.stringToDouble(this.txtStart.getText());
                }
                if (focusEvent.getSource() == this.txtEnd) {
                    this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
                }
            }
        }
        utilMemory.free();
        if (this.pMemory != null) {
            this.pMemory.setMemory();
        }
        if (this.pMemory != null) {
            this.pMemory.toFront();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        boolean bl = false;
        String string2 = new String("0");
        String string3 = new String("0");
        String string4 = new String("");
        String string5 = new String("");
        boolean bl2 = false;
        if (this.pMemory != null) {
            this.pMemory.setMemory();
        }
        if (string.equals("Change Thin Porosity Data")) {
            this.ThinTrackFrame();
        }
        if (string.equals("Thin Porosity Changed")) {
            this.getThinPorosity(0);
            this.plotframe.refresh();
        }
        if (string.equals("Image Track Changed")) {
            this.getImageTrack();
        }
        if (string.equals("Well Header Information Data Selected") && this.pHeaders != null) {
            this.pHeaders.getData();
        }
        if (string.equals("Status Selected") && this.pHeaders != null) {
            this.pHeaders.getStatus();
        }
        if (string.equals("Change Header Information")) {
            this.stHeader = iqstratHeadersUtility.copy(this.pHeaders.getWellHeader());
            this.setWellHeaderLabels();
            this.plot();
            this.pHeaders.close();
            this.pHeaders = null;
        }
        if (string.equals("Shale data ready")) {
            this.getData(10, 16);
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("Get LAS Track Size")) {
            this.getLASTrackSize();
        }
        if (string.equals("Available Track Panel Changed")) {
            this.getSelected();
            if (this.plotframe != null) {
                this.plotframe.setSelected(this.iSelected);
            }
        }
        if (string.equals("Available Track Panel - Group Changed")) {
            this.pnlDefaultList.setByGroup(this.stLASFileData, this.stStrat, this.stBrine, this.stCore, this.stImages, this.stBio, this.stColumn, this.stPHI, this.stFossil, this.stSedimentary, this.stRockColor, this.stRemarks);
            this.getThinPorosity(1);
            this.getImageTrack(1, 0);
            this.getImageTrack(1, 1);
            if (this.notifier != null) {
                this.notifier.notifyObservers(new String("Available Track Panel Changed"));
            }
        }
        if (string.equals("Available Track Panel - Data Changed")) {
            this.pnlDefaultList.setByGroup(this.stLASFileData, this.stStrat, this.stBrine, this.stCore, this.stImages, this.stBio, this.stColumn, this.stPHI, this.stFossil, this.stSedimentary, this.stRockColor, this.stRemarks);
            if (this.notifier != null) {
                this.notifier.notifyObservers(new String("Available Track Panel Changed"));
            }
        }
        if (string.equals("Colorlith Changed")) {
            // empty if block
        }
        if (string.equals("Select Well Stratigraphic Units")) {
            this.getData(3, 5);
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("Stratigraphic Units modified")) {
            this.getData(6, 5);
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("Sequence Stratigraphy Changed")) {
            this.getData(6, 6);
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("Depositional Environment Changed")) {
            this.getData(6, 19);
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("Peforation Data Changed")) {
            this.getData(13, 7);
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("Bio Stratigraphy Changed")) {
            this.getData(16, 18);
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("ADD or MODIFY Remarks Data") || string.equals("REMOVE Remarks Data") || string.equals("REMOVE All Remarks Data")) {
            this.closeOtherOBSData();
            this.plot();
            this.getData(5, 14);
            if (this.stRemarks != null) {
                if (this.stColumn == null) {
                    this.getData(9, 20);
                }
                if (this.stFossil == null) {
                    this.getData(9, 12);
                }
                if (this.stSedimentary == null) {
                    this.getData(9, 11);
                }
                if (this.stRockColor == null) {
                    this.getData(9, 13);
                }
                if (this.stPHI == null) {
                    this.getData(9, 10);
                }
            }
            if (this.plotframe != null) {
                this.plotframe.refresh();
            }
        }
        if (string.equals("Log Values Converted")) {
            this.getData(7, 2);
        }
        this.setButtons();
        if (string.equals("Directory Path Selected")) {
            switch (this.iDocument) {
                case 0: {
                    break;
                }
                case 1: {
                    if (this.pSearch != null) {
                        this.stStruct.sDirectory = new String(this.pSearch.getPath());
                        this.stStruct.sName = new String(this.pSearch.getFile());
                    }
                    this.createPDF();
                }
            }
            if (this.pSearch != null) {
                this.pSearch.close();
            }
            this.pSearch = null;
        }
        if (string.equals("Directory Path Cancel")) {
            switch (this.iDocument) {
                case 0: {
                    break;
                }
                case 1: {
                    this.createPDF();
                }
            }
            if (this.pSearch != null) {
                this.pSearch.close();
            }
            this.pSearch = null;
        }
        if (string.equals("Display Horizon Data Entry")) {
            this.closeTopsDataEntry();
            this.pTopsEntry = new horizonEnterDataFrame(this.notifier, this.stStruct);
            this.pTopsEntry.setData(this.stHeader);
            this.pTopsEntry.setTopsData(this.stStrat);
            this.pTopsEntry.setSeqList(this.stSequence);
            this.pTopsEntry.setEnvList(this.stDepEnv);
            if (this.plotframe != null) {
                this.pTopsEntry.setDataType(this.plotframe.getDataEntryPanel());
                this.pTopsEntry.setDepthRange(this.plotframe.getStartingDepth(), this.plotframe.getEndingDepth());
            }
        }
        if (string.equals("LAS Plot Limits Changed") && this.pLimitsLAS != null) {
            this.data_las = lasPlotLimitsUtility.copy(this.pLimitsLAS.getLASLimits());
            this.orig_las = lasPlotLimitsUtility.copy(this.pLimitsLAS.getLASOriginal());
            this.plotframe.setPlotLimits(this.data_las, this.data_core, this.data_pf);
        }
        if (string.equals("CORE Plot Limits Changed") && this.pLimitsCORE != null) {
            this.data_core = rockPlotLimitsUtility.copy(this.pLimitsCORE.getCORELimits());
            this.orig_core = rockPlotLimitsUtility.copy(this.pLimitsCORE.getCOREOriginal());
            this.plotframe.setPlotLimits(this.data_las, this.data_core, this.data_pf);
        }
        if (string.equals("Close LAS Plot Limits")) {
            if (this.pLimitsLAS != null) {
                this.pLimitsLAS.close();
            }
            this.pLimitsLAS = null;
        }
        if (string.equals("Close CORE Plot Limits")) {
            if (this.pLimitsCORE != null) {
                this.pLimitsCORE.close();
            }
            this.pLimitsCORE = null;
        }
        if (string.equals("Close PROFILE Plot")) {
            this.close();
        }
        if (string.equals("MEMORY CHANGE")) {
            // empty if block
        }
        utilMemory.free();
        if (this.pMemory != null) {
            this.pMemory.setMemory();
        }
        if (this.pMemory != null) {
            this.pMemory.toFront();
        }
    }

    public class iqstratControlPlotFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            iqstratControlPlotFrame.this.close();
        }
    }
}

