/*
 * Decompiled with CFR 0.152.
 */
package horizon.strat.plot;

import horizon.strat.stratListStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class stratPlotTrack
extends Canvas {
    private boolean bSonic = false;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    public static final int _TOTAL = 25;
    public static final int _ERA = 24;
    public static final int _SYSTEM = 23;
    public static final int _SUBSYSTEM = 22;
    public static final int _SERIES = 21;
    public static final int _STAGE = 20;
    public static final int _GROUP = 19;
    public static final int _SUBGROUP = 18;
    public static final int _FORMATION = 9;
    private static final int CHARS = 45;
    private static final int CHAR_H = 8;
    private stratListStruct stStrat = null;
    private stratListStruct stICS = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public stratPlotTrack(int n, double d, double d2, int n2, stratListStruct stratListStruct2) {
        this.iDataType = n;
        this.stICS = stratListStruct2;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public stratPlotTrack(boolean bl, int n, double d, double d2, int n2, stratListStruct stratListStruct2) {
        this.bSonic = bl;
        this.iDataType = n;
        this.stICS = stratListStruct2;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stStrat = null;
        this.stICS = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public stratListStruct getTopsData() {
        return this.stStrat;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setData(stratListStruct stratListStruct2) {
        this.stStrat = stratListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = true;
        double d = 0.0;
        double d2 = 0.0;
        int n6 = n2 / 25;
        int n7 = n + n2;
        int n8 = 0;
        int n9 = 0;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n8 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n9 = this.iDataType == 1 ? this.iHeight - (n3 + n4 * n5) : n3 + n4 * n5 + 100;
                if (n9 < 100 || n9 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n9, n7, n9);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n8, n7, n8);
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
        for (n3 = 0; n3 <= n2; n3 += n6) {
            if (n3 != 0 && n3 != n2) continue;
            graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
        }
        graphics.setColor(Color.black);
        graphics.drawString("Members", n + 2 * n6, 67);
        graphics.drawString("Formations", n + 11 * n6, 67);
        graphics.drawLine(n, 45, n7, 45);
        graphics.drawLine(n + 9 * n6, 45, n + 9 * n6, 100 + this.iLogHeight);
        graphics.drawLine(n + 18 * n6, 45, n + 18 * n6, 100 + this.iLogHeight);
        graphics.drawLine(n + 19 * n6, 45, n + 19 * n6, 100 + this.iLogHeight);
        graphics.drawLine(n + 20 * n6, 45, n + 20 * n6, 100 + this.iLogHeight);
        graphics.drawLine(n + 21 * n6, 45, n + 21 * n6, 100 + this.iLogHeight);
        graphics.drawLine(n + 22 * n6, 45, n + 22 * n6, 100 + this.iLogHeight);
        graphics.drawLine(n + 23 * n6, 45, n + 23 * n6, 100 + this.iLogHeight);
        graphics.drawLine(n + 24 * n6, 45, n + 24 * n6, 100 + this.iLogHeight);
        graphics.drawString("Stratigraphic Units", n + 6 * n6, 39);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Era", 65, -1 * (n + 24 * n6));
        graphics2D.drawString("System", 55, -1 * (n + 23 * n6));
        graphics2D.drawString("Subsystem", 45, -1 * (n + 22 * n6));
        graphics2D.drawString("Series", 55, -1 * (n + 21 * n6));
        graphics2D.drawString("Stage", 55, -1 * (n + 20 * n6));
        graphics2D.drawString("Group", 55, -1 * (n + 19 * n6));
        graphics2D.drawString("Subgroup", 45, -1 * (n + 18 * n6));
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n, 25, n7, 25);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void drawData(Graphics graphics, int n, int n2) {
        int n3 = n2 / 25;
        int n4 = n + n2;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = n;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stStrat != null) {
            for (int i = 0; i < this.stStrat.iCount; ++i) {
                switch (this.stStrat.stItem[i].iRank) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        bl = false;
                        break;
                    }
                    case 11: {
                        bl2 = true;
                        bl = true;
                        n5 = n + 9 * n3;
                        break;
                    }
                    case 0: 
                    case 12: 
                    case 13: {
                        bl2 = false;
                        bl = true;
                        n5 = n;
                    }
                }
                if (!bl) continue;
                d2 = this.bSonic ? this.stStrat.stItem[i].dTimeStart : this.stStrat.stItem[i].depthStart;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d;
                }
                n7 = n6;
                bl = false;
                if (this.bSonic) {
                    if (this.stStrat.stItem[i].dTimeEnd > this.stStrat.stItem[i].dTimeStart) {
                        bl = true;
                    }
                } else if (this.stStrat.stItem[i].depthEnd > this.stStrat.stItem[i].depthStart) {
                    bl = true;
                }
                if (bl) {
                    d3 = this.bSonic ? this.stStrat.stItem[i].dTimeEnd : this.stStrat.stItem[i].depthEnd;
                    d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                    n7 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n7 = this.iHeight - (int)d;
                    }
                }
                n8 = (n6 + n7) / 2;
                if (n6 < 100 || n6 >= this.iHeight) continue;
                if (bl2) {
                    graphics.drawLine(n, n6, n + 18 * n3, n6);
                    graphics.drawLine(n, n7, n + 18 * n3, n7);
                    graphics.drawString(this.stStrat.stItem[i].sName, n5, n6 + 10);
                    continue;
                }
                graphics.setColor(Color.gray);
                graphics.drawLine(n, n6, n + n3, n6);
                graphics.drawLine(n + 2 * n3, n6, n + 3 * n3, n6);
                graphics.drawLine(n + 4 * n3, n6, n + 5 * n3, n6);
                graphics.drawLine(n + 6 * n3, n6, n + 7 * n3, n6);
                graphics.setColor(Color.black);
                graphics.drawString(this.stStrat.stItem[i].sName, n5, n6 + 10);
            }
        }
    }

    public void drawData(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 / 25;
        int n5 = n2 + n3;
        boolean bl = false;
        int n6 = n2;
        boolean bl2 = false;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl3 = false;
        int n10 = 0;
        int n11 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        double d4 = 0.0;
        double d5 = 0.0;
        String string2 = "";
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stStrat != null) {
            for (int i = 0; i < this.stStrat.iCount; ++i) {
                Graphics2D graphics2D;
                bl = false;
                bl3 = false;
                switch (n) {
                    case 2: {
                        n6 = n2 + 24 * n4;
                        if (this.stStrat.stItem[i].sEra.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].sEra);
                        }
                        string2 = new String(this.stStrat.stItem[i].sEra);
                        break;
                    }
                    case 3: {
                        n6 = n2 + 23 * n4;
                        if (this.stStrat.stItem[i].system.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].system);
                        }
                        string2 = new String(this.stStrat.stItem[i].system);
                        break;
                    }
                    case 5: {
                        n6 = n2 + 22 * n4;
                        if (this.stStrat.stItem[i].subSystem.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].subSystem);
                        }
                        string2 = new String(this.stStrat.stItem[i].subSystem);
                        break;
                    }
                    case 4: {
                        n6 = n2 + 21 * n4;
                        if (this.stStrat.stItem[i].series.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].series);
                        }
                        string2 = new String(this.stStrat.stItem[i].series);
                        break;
                    }
                    case 6: {
                        n6 = n2 + 21 * n4;
                        if (this.stStrat.stItem[i].subSeries.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].subSeries);
                        }
                        string2 = new String(this.stStrat.stItem[i].subSeries);
                        break;
                    }
                    case 7: {
                        n6 = n2 + 20 * n4;
                        if (this.stStrat.stItem[i].stage.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].stage);
                        }
                        string2 = new String(this.stStrat.stItem[i].stage);
                        break;
                    }
                    case 9: {
                        n6 = n2 + 19 * n4;
                        if (this.stStrat.stItem[i].sGroup.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].sGroup);
                        }
                        string2 = new String(this.stStrat.stItem[i].sGroup);
                        break;
                    }
                    case 10: {
                        n6 = n2 + 18 * n4;
                        if (this.stStrat.stItem[i].subGroup.length() <= 0) break;
                        bl3 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].subGroup);
                        }
                        string2 = new String(this.stStrat.stItem[i].subGroup);
                        break;
                    }
                }
                if (this.bSonic) {
                    d8 = this.stStrat.stItem[i].dTimeStart;
                    d9 = this.stStrat.stItem[i].dTimeEnd;
                } else {
                    d8 = this.stStrat.stItem[i].depthStart;
                    d9 = this.stStrat.stItem[i].depthEnd;
                }
                if ((bl3 || i == this.stStrat.iCount - 1) && string.length() > 0) {
                    if (string.equals(string2) && bl3) {
                        if (!bl2) {
                            bl2 = true;
                            d4 = d8;
                            d5 = d8;
                        }
                        if (d8 > d5) {
                            d5 = d8;
                        }
                        if (d9 > d8 && d9 > d5) {
                            d5 = d9;
                        }
                    }
                    if (!string.equals(string2) || i == this.stStrat.iCount - 1) {
                        bl = true;
                        if (!bl2) {
                            bl2 = true;
                            d4 = d8;
                            d5 = d8;
                            if (d9 > d8) {
                                d5 = d9;
                            }
                        }
                        d6 = d8;
                        d7 = d8;
                        if (d9 > d8) {
                            d7 = d9;
                        }
                    }
                }
                if (!bl) continue;
                d2 = d4;
                d3 = d5;
                if (d2 <= this.depthStart && d3 < this.depthStart || d2 > this.depthEnd && d3 >= this.depthEnd) {
                    bl = false;
                }
                if (bl) {
                    if (d2 < this.depthStart) {
                        d2 = this.depthStart;
                    }
                    if (d3 > this.depthEnd) {
                        d3 = this.depthEnd;
                    }
                    d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                    n7 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n7 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                    n8 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n8 = this.iHeight - (int)d;
                    }
                    n9 = (n7 + n8) / 2;
                    if (n > 6) {
                        graphics.drawLine(n2, n7, n6 + n4, n7);
                    }
                    graphics2D = (Graphics2D)graphics;
                    graphics2D.rotate(1.5707963267948966);
                    n10 = string.length();
                    n11 = n9 - 7 * n10 / 2;
                    if (n11 < n7) {
                        n11 = n7;
                    }
                    if (n11 >= 100) {
                        graphics.drawString(string, n11, -1 * n6);
                    }
                    graphics2D.rotate(-1.5707963267948966);
                }
                if (i == this.stStrat.iCount - 1 && !string.equals(string2)) {
                    string = new String(string2);
                    d4 = d6;
                    d5 = d7;
                    d2 = d4;
                    d3 = d5;
                    if (d2 <= this.depthStart && d3 < this.depthStart || d2 > this.depthEnd && d3 >= this.depthEnd) {
                        bl = false;
                    }
                    if (bl) {
                        if (d2 < this.depthStart) {
                            d2 = this.depthStart;
                        }
                        if (d3 > this.depthEnd) {
                            d3 = this.depthEnd;
                        }
                        d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                        n7 = 100 + (int)d;
                        if (this.iDataType == 1) {
                            n7 = this.iHeight - (int)d;
                        }
                        d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                        n8 = 100 + (int)d;
                        if (this.iDataType == 1) {
                            n8 = this.iHeight - (int)d;
                        }
                        n9 = (n7 + n8) / 2;
                        if (n > 6) {
                            graphics.drawLine(n2, n7, n6 + n4, n7);
                        }
                        graphics2D = (Graphics2D)graphics;
                        graphics2D.rotate(1.5707963267948966);
                        n10 = string.length();
                        n11 = n9 - 7 * n10 / 2;
                        if (n11 < n7) {
                            n11 = n7;
                        }
                        if (n11 >= 100) {
                            graphics.drawString(string, n11, -1 * n6);
                        }
                        graphics2D.rotate(-1.5707963267948966);
                    }
                }
                string = new String(string2);
                d4 = d6;
                d5 = d7;
            }
        }
    }

    public void drawBackground(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 / 25;
        int n7 = 0;
        int n8 = -1;
        boolean bl = false;
        String string = "";
        String[] stringArray = null;
        String string2 = "";
        double[][] dArray = null;
        int n9 = 0;
        int n10 = n2;
        int n11 = 0;
        int n12 = 0;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        String string3 = "";
        int n13 = 255;
        int n14 = 255;
        int n15 = 255;
        if (this.stStrat != null) {
            block14: for (n4 = 0; n4 < this.stStrat.iCount; ++n4) {
                switch (n) {
                    case 2: {
                        n10 = 24 * n6;
                        if (!string.equals(this.stStrat.stItem[n4].sEra) && this.stStrat.stItem[n4].sEra.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].sEra);
                        continue block14;
                    }
                    case 3: {
                        n10 = 23 * n6;
                        if (!string.equals(this.stStrat.stItem[n4].system) && this.stStrat.stItem[n4].system.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].system);
                        continue block14;
                    }
                    case 5: {
                        n10 = 22 * n6;
                        if (!string.equals(this.stStrat.stItem[n4].subSystem) && this.stStrat.stItem[n4].subSystem.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].subSystem);
                        continue block14;
                    }
                    case 4: {
                        n10 = 21 * n6;
                        string2 = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                        if (!string.equals(string2) && this.stStrat.stItem[n4].series.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                        continue block14;
                    }
                    case 6: {
                        n10 = 21 * n6;
                        string2 = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                        if (!string.equals(string2) && this.stStrat.stItem[n4].subSeries.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                        continue block14;
                    }
                }
            }
            string = new String("");
            if (n7 > 0) {
                stringArray = new String[n7];
                dArray = new double[n7][2];
                for (n5 = 0; n5 < n7; ++n5) {
                    stringArray[n5] = new String("");
                    dArray[n5][0] = 0.0;
                    dArray[n5][1] = 0.0;
                }
                n8 = -1;
                for (n4 = 0; n4 < this.stStrat.iCount; ++n4) {
                    bl = false;
                    if (this.bSonic) {
                        d4 = this.stStrat.stItem[n4].dTimeStart;
                        d5 = this.stStrat.stItem[n4].dTimeEnd;
                    } else {
                        d4 = this.stStrat.stItem[n4].depthStart;
                        d5 = this.stStrat.stItem[n4].depthEnd;
                    }
                    switch (n) {
                        case 2: {
                            if (!string.equals(this.stStrat.stItem[n4].sEra) && this.stStrat.stItem[n4].sEra.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].sEra);
                                if (++n8 < n7) {
                                    dArray[n8][0] = d4;
                                }
                            }
                            if (this.stStrat.stItem[n4].sEra.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 3: {
                            if (!string.equals(this.stStrat.stItem[n4].system) && this.stStrat.stItem[n4].system.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].system);
                                if (++n8 < n7) {
                                    dArray[n8][0] = d4;
                                }
                            }
                            if (this.stStrat.stItem[n4].system.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 5: {
                            if (!string.equals(this.stStrat.stItem[n4].subSystem) && this.stStrat.stItem[n4].subSystem.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].subSystem);
                                if (++n8 < n7) {
                                    dArray[n8][0] = d4;
                                }
                            }
                            if (this.stStrat.stItem[n4].subSystem.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 4: {
                            string2 = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                            if (!string.equals(string2) && this.stStrat.stItem[n4].series.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                                if (++n8 < n7) {
                                    dArray[n8][0] = d4;
                                }
                            }
                            if (string2.length() <= 1 || this.stStrat.stItem[n4].series.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 6: {
                            string2 = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                            if (!string.equals(string2) && this.stStrat.stItem[n4].subSeries.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                                if (++n8 < n7) {
                                    dArray[n8][0] = d4;
                                }
                            }
                            if (string2.length() <= 1 || this.stStrat.stItem[n4].subSeries.length() <= 0) break;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl || n8 >= n7 || n8 <= -1) continue;
                    stringArray[n8] = new String(string);
                    dArray[n8][1] = d5 == 0.0 || d5 < d4 ? d4 : d5;
                }
                for (n4 = 0; n4 < n7; ++n4) {
                    d2 = dArray[n4][0];
                    d3 = dArray[n4][1];
                    bl = true;
                    if (d2 <= this.depthStart && d3 < this.depthStart || d2 > this.depthEnd && d3 >= this.depthEnd) {
                        bl = false;
                    }
                    if (!bl) continue;
                    if (d2 < this.depthStart) {
                        d2 = this.depthStart;
                    }
                    if (d3 > this.depthEnd) {
                        d3 = this.depthEnd;
                    }
                    d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                    n11 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n11 = this.iHeight - (int)d;
                    }
                    d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                    n12 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n12 = this.iHeight - (int)d;
                    }
                    n9 = n12 - n11;
                    if (this.stICS == null) continue;
                    for (n5 = 0; n5 < this.stICS.iCount; ++n5) {
                        if (n != 4 && n != 6) {
                            string3 = new String(this.stICS.stItem[n5].sName.toLowerCase());
                        } else if (n == 4) {
                            string3 = new String(this.stICS.stItem[n5].system.toLowerCase() + " " + this.stICS.stItem[n5].sName.toLowerCase());
                        } else if (n == 6) {
                            string3 = new String(this.stICS.stItem[n5].subSystem.toLowerCase() + " " + this.stICS.stItem[n5].sName.toLowerCase());
                        }
                        if (!string3.equals(stringArray[n4].toLowerCase())) continue;
                        n13 = this.stICS.stItem[n5].iRed;
                        n14 = this.stICS.stItem[n5].iGreen;
                        n15 = this.stICS.stItem[n5].iBlue;
                    }
                    graphics.setColor(new Color(n13, n14, n15));
                    graphics.fillRect(n2, n11, n10 + n6, n9);
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 2;
        if (n == 53) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawBackground(graphics, 2, n2, n3);
            this.drawBackground(graphics, 3, n2, n3);
            this.drawBackground(graphics, 4, n2, n3);
            this.drawBackground(graphics, 5, n2, n3);
            this.drawBackground(graphics, 6, n2, n3);
            this.drawGrid(graphics, n2, n3);
            this.drawData(graphics, n2, n3);
            this.drawData(graphics, 2, n2, n3);
            this.drawData(graphics, 3, n2, n3);
            this.drawData(graphics, 4, n2, n3);
            this.drawData(graphics, 5, n2, n3);
            this.drawData(graphics, 6, n2, n3);
            this.drawData(graphics, 7, n2, n3);
            this.drawData(graphics, 9, n2, n3);
            this.drawData(graphics, 10, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

