/*
 * Decompiled with CFR 0.152.
 */
package horizon.strat.plot;

import horizon.strat.stratListStruct;
import horizon.strat.stratStruct;
import horizon.strat.stratUtility;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import javax.swing.JTextField;

public class stratPlotState
extends Canvas
implements MouseListener,
MouseMotionListener {
    private Observable notifier = null;
    private stratListStruct stStrat = null;
    private stratListStruct stICS = null;
    private String sFormation = "";
    private String sRank = "";
    private int iRank = 0;
    private String system = "ALL";
    private stratStruct stSelected = null;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = 6;
    private int iStartTrack = 0;
    private int iWidthTrack = 300;
    private double dIncrementDepth = 0.0;
    private int iStartDepthLabel = 10;
    private int iWidth = 300;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;
    public static final int _TOTAL = 25;
    public static final int _ERA = 24;
    public static final int _SYSTEM = 23;
    public static final int _SUBSYSTEM = 22;
    public static final int _SERIES = 21;
    public static final int _STAGE = 20;
    public static final int _GROUP = 19;
    public static final int _SUBGROUP = 18;
    public static final int _FORMATION = 9;
    private JTextField txtRank = null;
    private JTextField txtName = null;

    public stratPlotState(stratListStruct stratListStruct2, stratListStruct stratListStruct3) {
        this.stICS = stratListStruct2;
        this.stStrat = stratListStruct3;
        this.initDepthRange();
        this.setPlotHeight(this.iScale, this.depthEnd, this.depthStart);
        this.setBackground(Color.white);
    }

    public stratPlotState(Observable observable, stratListStruct stratListStruct2, stratListStruct stratListStruct3) {
        this.notifier = observable;
        this.stICS = stratListStruct2;
        this.stStrat = stratListStruct3;
        this.initDepthRange();
        this.setPlotHeight(this.iScale, this.depthEnd, this.depthStart);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public void close() {
        this.notifier = null;
        this.stICS = null;
        this.stStrat = null;
        this.system = null;
        if (this.stSelected != null) {
            this.stSelected.delete();
        }
        this.stSelected = null;
        this.txtRank = null;
        this.txtName = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public stratStruct getData() {
        return this.stSelected;
    }

    private void initDepthRange() {
        if (this.stStrat != null) {
            this.depthStart = this.stStrat.stItem[0].depthStart;
            this.depthEnd = this.stStrat.stItem[0].depthEnd;
            for (int i = 0; i < this.stStrat.iCount; ++i) {
                if (!(this.depthEnd < this.stStrat.stItem[i].depthEnd)) continue;
                this.depthEnd = this.stStrat.stItem[i].depthEnd;
            }
        }
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
    }

    public void setScale(int n) {
        this.setScale(n, this.depthEnd, this.depthStart);
    }

    public void setScale(int n, double d, double d2) {
        this.setPlotHeight(n, d, d2);
        this.repaint();
    }

    public void setSystem(int n, String string) {
        int n2 = -1;
        this.iRank = n;
        this.system = new String(string);
        if (this.stStrat != null) {
            this.depthStart = 0.0;
            this.depthEnd = 0.0;
            if (string.equals("ALL")) {
                this.initDepthRange();
            } else {
                block4: for (int i = 0; i < this.stStrat.iCount; ++i) {
                    switch (n) {
                        case 3: {
                            if (!this.stStrat.stItem[i].system.equals(string)) continue block4;
                            if (n2 == -1) {
                                this.depthStart = this.stStrat.stItem[i].depthStart;
                                this.depthEnd = this.stStrat.stItem[i].depthEnd;
                                ++n2;
                            }
                            if (!(this.depthEnd < this.stStrat.stItem[i].depthEnd)) continue block4;
                            this.depthEnd = this.stStrat.stItem[i].depthEnd;
                            continue block4;
                        }
                        case 5: {
                            if (!this.stStrat.stItem[i].subSystem.equals(string)) continue block4;
                            if (n2 == -1) {
                                this.depthStart = this.stStrat.stItem[i].depthStart;
                                this.depthEnd = this.stStrat.stItem[i].depthEnd;
                                ++n2;
                            }
                            if (!(this.depthEnd < this.stStrat.stItem[i].depthEnd)) continue block4;
                            this.depthEnd = this.stStrat.stItem[i].depthEnd;
                        }
                    }
                }
            }
            this.setScale(this.iScale, this.depthEnd, this.depthStart);
        }
    }

    public void setTextFields(JTextField jTextField, JTextField jTextField2) {
        this.txtRank = jTextField;
        this.txtName = jTextField2;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.iWidthTrack / 25;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        this.sRank = new String("");
        this.sFormation = new String("");
        if (n < this.iStartTrack + 9 * n3) {
            this.sRank = new String("Member/Bed");
            n4 = 12;
            n5 = 13;
        } else if (n < this.iStartTrack + 18 * n3) {
            this.sRank = new String("Formation");
            n4 = 11;
        } else if (n < this.iStartTrack + 19 * n3) {
            this.sRank = new String("Subgroup");
            n4 = 10;
        } else if (n < this.iStartTrack + 20 * n3) {
            this.sRank = new String("Group");
            n4 = 9;
        } else if (n < this.iStartTrack + 21 * n3) {
            this.sRank = new String("Stage");
            n4 = 7;
        } else if (n < this.iStartTrack + 22 * n3) {
            this.sRank = new String("Series/Subseries");
            n4 = 4;
            n5 = 6;
        } else if (n < this.iStartTrack + 23 * n3) {
            this.sRank = new String("Subsystem");
            n4 = 5;
        } else if (n < this.iStartTrack + 24 * n3) {
            this.sRank = new String("System");
            n4 = 3;
        } else if (n < this.iStartTrack + 25 * n3) {
            this.sRank = new String("Era");
            n4 = 2;
        }
        d = this.depthStart + (double)(n2 - 100) * (this.depthEnd - this.depthStart) / (double)this.iLogHeight;
        if (this.stStrat != null) {
            for (int i = 0; i < this.stStrat.iCount; ++i) {
                if (n4 != this.stStrat.stItem[i].iRank && n5 != this.stStrat.stItem[i].iRank) continue;
                d2 = this.stStrat.stItem[i].depthEnd;
                if (this.stStrat.stItem[i].depthStart == this.stStrat.stItem[i].depthEnd) {
                    d2 = this.stStrat.stItem[i].depthEnd + 5.0;
                }
                if (!(d >= this.stStrat.stItem[i].depthStart) || !(d < d2)) continue;
                this.sFormation = new String(this.stStrat.stItem[i].sName);
            }
        }
        if (this.txtRank != null) {
            this.txtRank.setText(this.sRank);
        }
        if (this.txtName != null) {
            this.txtName.setText(this.sFormation);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = this.iWidthTrack / 25;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        if (this.stSelected != null) {
            this.stSelected.delete();
        }
        this.stSelected = null;
        if (n < this.iStartTrack + 9 * n3) {
            n4 = 12;
            n5 = 13;
        } else if (n < this.iStartTrack + 18 * n3) {
            n4 = 11;
        } else if (n < this.iStartTrack + 19 * n3) {
            n4 = 10;
        } else if (n < this.iStartTrack + 20 * n3) {
            n4 = 9;
        } else if (n < this.iStartTrack + 21 * n3) {
            n4 = 7;
        } else if (n < this.iStartTrack + 22 * n3) {
            n4 = 4;
            n5 = 6;
        } else if (n < this.iStartTrack + 23 * n3) {
            n4 = 5;
        } else if (n < this.iStartTrack + 24 * n3) {
            n4 = 3;
        } else if (n < this.iStartTrack + 25 * n3) {
            n4 = 2;
        }
        d = this.depthStart + (double)(n2 - 100) * (this.depthEnd - this.depthStart) / (double)this.iLogHeight;
        if (this.stStrat != null) {
            for (int i = 0; i < this.stStrat.iCount; ++i) {
                if (n4 != this.stStrat.stItem[i].iRank && n5 != this.stStrat.stItem[i].iRank) continue;
                d2 = this.stStrat.stItem[i].depthEnd;
                if (this.stStrat.stItem[i].depthStart == this.stStrat.stItem[i].depthEnd) {
                    d2 = this.stStrat.stItem[i].depthEnd + 5.0;
                }
                if (!(d >= this.stStrat.stItem[i].depthStart) || !(d < d2)) continue;
                this.stSelected = stratUtility.copy(this.stStrat.stItem[i]);
                if (this.notifier == null) continue;
                this.notifier.notifyObservers(new String("State Stratigraphic Unit Selected"));
            }
        }
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = true;
        double d = 0.0;
        double d2 = 0.0;
        int n3 = n2 / 25;
        int n4 = n + n2;
        boolean bl6 = false;
        boolean bl7 = false;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString("Members", n + 4 * n3 / 2, 67);
        graphics.drawString("Formations", n + 11 * n3, 67);
        graphics.drawLine(n, 45, n4, 45);
        graphics.drawLine(n + 9 * n3, 45, n + 9 * n3, 100 + this.iHeight);
        graphics.drawLine(n + 18 * n3, 45, n + 18 * n3, 100 + this.iHeight);
        graphics.drawLine(n + 19 * n3, 45, n + 19 * n3, 100 + this.iHeight);
        graphics.drawLine(n + 20 * n3, 45, n + 20 * n3, 100 + this.iHeight);
        graphics.drawLine(n + 21 * n3, 45, n + 21 * n3, 100 + this.iHeight);
        graphics.drawLine(n + 22 * n3, 45, n + 22 * n3, 100 + this.iHeight);
        graphics.drawLine(n + 23 * n3, 45, n + 23 * n3, 100 + this.iHeight);
        graphics.drawLine(n + 24 * n3, 45, n + 24 * n3, 100 + this.iHeight);
        graphics.drawString("Stratigraphic Units", n + 8 * n3, 39);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Era", 65, -1 * (n + 24 * n3));
        graphics2D.drawString("System", 55, -1 * (n + 23 * n3));
        graphics2D.drawString("Subsystem", 45, -1 * (n + 22 * n3));
        graphics2D.drawString("Series", 55, -1 * (n + 21 * n3));
        graphics2D.drawString("Stage", 55, -1 * (n + 20 * n3));
        graphics2D.drawString("Group", 55, -1 * (n + 19 * n3));
        graphics2D.drawString("Subgroup", 45, -1 * (n + 18 * n3));
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n, 25, n4, 25);
        graphics.drawLine(n, 100, n4, 100);
        graphics.drawLine(n, 25, n, 100 + this.iHeight);
        graphics.drawLine(n4, 25, n4, 100 + this.iHeight);
    }

    public void drawBackground(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n3 / 25;
        int n7 = 0;
        int n8 = -1;
        boolean bl = false;
        String string = "";
        String[] stringArray = null;
        String string2 = "";
        double[][] dArray = null;
        int n9 = 0;
        int n10 = n2;
        int n11 = 0;
        int n12 = 0;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string3 = "";
        int n13 = 255;
        int n14 = 255;
        int n15 = 255;
        if (this.stStrat != null) {
            block14: for (n4 = 0; n4 < this.stStrat.iCount; ++n4) {
                switch (n) {
                    case 2: {
                        n10 = 24 * n6;
                        if (!string.equals(this.stStrat.stItem[n4].sEra) && this.stStrat.stItem[n4].sEra.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].sEra);
                        continue block14;
                    }
                    case 3: {
                        n10 = 23 * n6;
                        if (!string.equals(this.stStrat.stItem[n4].system) && this.stStrat.stItem[n4].system.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].system);
                        continue block14;
                    }
                    case 5: {
                        n10 = 22 * n6;
                        if (!string.equals(this.stStrat.stItem[n4].subSystem) && this.stStrat.stItem[n4].subSystem.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].subSystem);
                        continue block14;
                    }
                    case 4: {
                        n10 = 21 * n6;
                        string2 = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                        if (!string.equals(string2) && this.stStrat.stItem[n4].series.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                        continue block14;
                    }
                    case 6: {
                        n10 = 21 * n6;
                        string2 = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                        if (!string.equals(string2) && this.stStrat.stItem[n4].subSeries.length() > 0) {
                            ++n7;
                        }
                        string = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                        continue block14;
                    }
                }
            }
            string = new String("");
            if (n7 > 0) {
                stringArray = new String[n7];
                dArray = new double[n7][2];
                for (n5 = 0; n5 < n7; ++n5) {
                    stringArray[n5] = new String("");
                    dArray[n5][0] = 0.0;
                    dArray[n5][1] = 0.0;
                }
                n8 = -1;
                for (n4 = 0; n4 < this.stStrat.iCount; ++n4) {
                    bl = false;
                    switch (n) {
                        case 2: {
                            if (!string.equals(this.stStrat.stItem[n4].sEra) && this.stStrat.stItem[n4].sEra.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].sEra);
                                if (++n8 < n7) {
                                    dArray[n8][0] = this.stStrat.stItem[n4].depthStart;
                                }
                            }
                            if (this.stStrat.stItem[n4].sEra.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 3: {
                            if (!string.equals(this.stStrat.stItem[n4].system) && this.stStrat.stItem[n4].system.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].system);
                                if (++n8 < n7) {
                                    dArray[n8][0] = this.stStrat.stItem[n4].depthStart;
                                }
                            }
                            if (this.stStrat.stItem[n4].system.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 5: {
                            if (!string.equals(this.stStrat.stItem[n4].subSystem) && this.stStrat.stItem[n4].subSystem.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].subSystem);
                                if (++n8 < n7) {
                                    dArray[n8][0] = this.stStrat.stItem[n4].depthStart;
                                }
                            }
                            if (this.stStrat.stItem[n4].subSystem.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 4: {
                            string2 = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                            if (!string.equals(string2) && this.stStrat.stItem[n4].series.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].system + " " + this.stStrat.stItem[n4].series);
                                if (++n8 < n7) {
                                    dArray[n8][0] = this.stStrat.stItem[n4].depthStart;
                                }
                            }
                            if (string2.length() <= 1 || this.stStrat.stItem[n4].series.length() <= 0) break;
                            bl = true;
                            break;
                        }
                        case 6: {
                            string2 = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                            if (!string.equals(string2) && this.stStrat.stItem[n4].subSeries.length() > 0) {
                                string = new String(this.stStrat.stItem[n4].subSystem + " " + this.stStrat.stItem[n4].subSeries);
                                if (++n8 < n7) {
                                    dArray[n8][0] = this.stStrat.stItem[n4].depthStart;
                                }
                            }
                            if (string2.length() <= 1 || this.stStrat.stItem[n4].subSeries.length() <= 0) break;
                            bl = true;
                            break;
                        }
                    }
                    if (!bl || n8 >= n7 || n8 <= -1) continue;
                    stringArray[n8] = new String(string);
                    dArray[n8][1] = this.stStrat.stItem[n4].depthEnd;
                }
                for (n4 = 0; n4 < n7; ++n4) {
                    d2 = dArray[n4][0];
                    d3 = dArray[n4][1];
                    bl = true;
                    if (d2 < this.depthStart && d3 < this.depthStart || d2 > this.depthEnd && d3 > this.depthEnd) {
                        bl = false;
                    }
                    if (!bl) continue;
                    if (d2 < this.depthStart) {
                        d2 = this.depthStart;
                    }
                    if (d3 > this.depthEnd) {
                        d3 = this.depthEnd;
                    }
                    d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                    n11 = 100 + (int)d;
                    d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                    n12 = 100 + (int)d;
                    n9 = n12 - n11;
                    if (this.stICS == null) continue;
                    for (n5 = 0; n5 < this.stICS.iCount; ++n5) {
                        if (n != 4 && n != 6) {
                            string3 = new String(this.stICS.stItem[n5].sName.toLowerCase());
                        } else if (n == 4) {
                            string3 = new String(this.stICS.stItem[n5].system.toLowerCase() + " " + this.stICS.stItem[n5].sName.toLowerCase());
                        } else if (n == 6) {
                            string3 = new String(this.stICS.stItem[n5].subSystem.toLowerCase() + " " + this.stICS.stItem[n5].sName.toLowerCase());
                        }
                        if (!string3.equals(stringArray[n4].toLowerCase())) continue;
                        n13 = this.stICS.stItem[n5].iRed;
                        n14 = this.stICS.stItem[n5].iGreen;
                        n15 = this.stICS.stItem[n5].iBlue;
                    }
                    graphics.setColor(new Color(n13, n14, n15));
                    graphics.fillRect(n2, n11, n10 + n6, n9);
                }
            }
        }
    }

    public void drawData(Graphics graphics, int n, int n2) {
        int n3 = n2 / 25;
        int n4 = n + n2;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = n;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stStrat != null) {
            for (int i = 0; i < this.stStrat.iCount; ++i) {
                switch (this.stStrat.stItem[i].iRank) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: {
                        bl = false;
                        break;
                    }
                    case 11: {
                        bl2 = true;
                        bl = true;
                        n5 = n + 9 * n3;
                        break;
                    }
                    case 0: 
                    case 12: 
                    case 13: {
                        bl2 = false;
                        bl = true;
                        n5 = n;
                    }
                }
                if (!bl) continue;
                d2 = this.stStrat.stItem[i].depthStart;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n7 = n6 = 100 + (int)d;
                if (this.stStrat.stItem[i].depthEnd > this.stStrat.stItem[i].depthStart) {
                    d3 = this.stStrat.stItem[i].depthEnd;
                    d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                    n7 = 100 + (int)d;
                }
                n8 = (n6 + n7) / 2;
                if ((n6 <= 100 || n6 >= this.iHeight || n7 <= 100 || n7 >= this.iHeight) && (n8 <= 100 || n8 >= this.iHeight)) continue;
                if (bl2) {
                    graphics.drawLine(n, n6, n + 18 * n3, n6);
                    graphics.drawLine(n, n7, n + 18 * n3, n7);
                    graphics.drawString(this.stStrat.stItem[i].sName, n5, n6 + 10);
                    continue;
                }
                graphics.setColor(Color.gray);
                graphics.drawLine(n, n6, n + n3, n6);
                graphics.drawLine(n + 2 * n3, n6, n + 3 * n3, n6);
                graphics.drawLine(n + 4 * n3, n6, n + 5 * n3, n6);
                graphics.drawLine(n + 6 * n3, n6, n + 7 * n3, n6);
                graphics.setColor(Color.black);
                graphics.drawString(this.stStrat.stItem[i].sName, n5, n6 + 10);
            }
        }
    }

    public void drawData(Graphics graphics, int n, int n2, int n3) {
        int n4 = n3 / 25;
        int n5 = n2 + n3;
        boolean bl = false;
        int n6 = n2;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        boolean bl2 = false;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        String string = "";
        double d4 = 0.0;
        double d5 = 0.0;
        String string2 = "";
        double d6 = 0.0;
        double d7 = 0.0;
        int n10 = 0;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stStrat != null) {
            for (int i = 0; i < this.stStrat.iCount; ++i) {
                Graphics2D graphics2D;
                bl = false;
                bl2 = false;
                switch (n) {
                    case 2: {
                        n6 = n2 + 24 * n4;
                        if (this.stStrat.stItem[i].sEra.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].sEra);
                        }
                        string2 = new String(this.stStrat.stItem[i].sEra);
                        break;
                    }
                    case 3: {
                        n6 = n2 + 23 * n4;
                        if (this.stStrat.stItem[i].system.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].system);
                        }
                        string2 = new String(this.stStrat.stItem[i].system);
                        break;
                    }
                    case 5: {
                        n6 = n2 + 22 * n4;
                        if (this.stStrat.stItem[i].subSystem.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].subSystem);
                        }
                        string2 = new String(this.stStrat.stItem[i].subSystem);
                        break;
                    }
                    case 4: {
                        n6 = n2 + 21 * n4;
                        if (this.stStrat.stItem[i].series.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].series);
                        }
                        string2 = new String(this.stStrat.stItem[i].series);
                        break;
                    }
                    case 6: {
                        n6 = n2 + 21 * n4;
                        if (this.stStrat.stItem[i].subSeries.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].subSeries);
                        }
                        string2 = new String(this.stStrat.stItem[i].subSeries);
                        break;
                    }
                    case 7: {
                        n6 = n2 + 20 * n4;
                        if (this.stStrat.stItem[i].stage.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].stage);
                        }
                        string2 = new String(this.stStrat.stItem[i].stage);
                        break;
                    }
                    case 9: {
                        n6 = n2 + 19 * n4;
                        if (this.stStrat.stItem[i].sGroup.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].sGroup);
                        }
                        string2 = new String(this.stStrat.stItem[i].sGroup);
                        break;
                    }
                    case 10: {
                        n6 = n2 + 18 * n4;
                        if (this.stStrat.stItem[i].subGroup.length() <= 0) break;
                        bl2 = true;
                        if (string.length() == 0) {
                            string = new String(this.stStrat.stItem[i].subGroup);
                        }
                        string2 = new String(this.stStrat.stItem[i].subGroup);
                        break;
                    }
                }
                if (bl2 || i == this.stStrat.iCount - 1) {
                    if (!string.equals(string2) || i == this.stStrat.iCount - 1) {
                        bl = true;
                        d6 = this.stStrat.stItem[i].depthStart;
                        d7 = this.stStrat.stItem[i].depthEnd;
                    } else {
                        if (d4 == 0.0) {
                            d4 = this.stStrat.stItem[i].depthStart;
                        }
                        d5 = this.stStrat.stItem[i].depthEnd;
                    }
                }
                if (!bl) continue;
                d2 = d4;
                d3 = d5;
                if (d2 < this.depthStart && d3 <= this.depthStart || d2 >= this.depthEnd && d3 > this.depthEnd) {
                    bl = false;
                }
                if (bl) {
                    if (d2 < this.depthStart) {
                        d2 = this.depthStart;
                    }
                    if (d3 > this.depthEnd) {
                        d3 = this.depthEnd;
                    }
                    d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                    n7 = 100 + (int)d;
                    d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                    n8 = 100 + (int)d;
                    n9 = (n7 + n8) / 2;
                    if (n > 6) {
                        graphics.drawLine(n2, n7, n6 + n4, n7);
                    }
                    graphics2D = (Graphics2D)graphics;
                    graphics2D.rotate(1.5707963267948966);
                    n10 = string.length();
                    if (n9 - 7 * n10 / 2 >= 100) {
                        graphics.drawString(string, n9 - 7 * n10 / 2, -1 * n6);
                    }
                    graphics2D.rotate(-1.5707963267948966);
                }
                if (i == this.stStrat.iCount - 1 && !string.equals(string2)) {
                    string = new String(string2);
                    d4 = d6;
                    d5 = d7;
                    d2 = d4;
                    d3 = d5;
                    if (d2 < this.depthStart && d3 < this.depthStart || d2 > this.depthEnd && d3 > this.depthEnd) {
                        bl = false;
                    }
                    if (bl) {
                        if (d2 < this.depthStart) {
                            d2 = this.depthStart;
                        }
                        if (d3 > this.depthEnd) {
                            d3 = this.depthEnd;
                        }
                        d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                        n7 = 100 + (int)d;
                        d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                        n8 = 100 + (int)d;
                        n9 = (n7 + n8) / 2;
                        if (n > 6) {
                            graphics.drawLine(n2, n7, n6 + n4, n7);
                        }
                        graphics2D = (Graphics2D)graphics;
                        graphics2D.rotate(1.5707963267948966);
                        n10 = string.length();
                        if (n9 - 7 * n10 / 2 >= 100) {
                            graphics2D.drawString(string, n9 - 7 * n10 / 2, -1 * n6);
                        }
                        graphics2D.rotate(-1.5707963267948966);
                    }
                }
                string = new String(string2);
                d4 = d6;
                d5 = d7;
            }
        }
    }

    public void draw(Graphics graphics) {
        this.drawBackground(graphics, 2, this.iStartTrack, this.iWidthTrack);
        this.drawBackground(graphics, 3, this.iStartTrack, this.iWidthTrack);
        this.drawBackground(graphics, 4, this.iStartTrack, this.iWidthTrack);
        this.drawBackground(graphics, 5, this.iStartTrack, this.iWidthTrack);
        this.drawBackground(graphics, 6, this.iStartTrack, this.iWidthTrack);
        this.drawGrid(graphics, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 2, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 3, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 4, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 5, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 6, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 7, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 9, this.iStartTrack, this.iWidthTrack);
        this.drawData(graphics, 10, this.iStartTrack, this.iWidthTrack);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

