/*
 * Decompiled with CFR 0.152.
 */
package horizon.strat.gui;

import cmn.cmnString;
import horizon.strat.gui.stratTable;
import horizon.strat.stratListStruct;
import horizon.strat.stratUtility;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import kgs.io.kgsIORead;

public class stratKGSFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private stratListStruct stList = null;
    private stratListStruct stKGS = null;
    private stratTable pUsers = null;
    private stratTable pKGS = null;
    private stratListStruct stKGSStandard = null;
    private static final int _REPLACE = 0;
    private static final int _ADD = 1;
    private static final int _MERGE = 2;
    private int iMode = 0;
    private int iSources = 0;
    private String[] sources = null;
    private int iTotal = 0;
    private JPanel[] pSource = null;
    private JRadioButton[] rb = null;
    private JRadioButton rbReplace = new JRadioButton();
    private JRadioButton rbAdd = new JRadioButton();
    private JRadioButton rbMerge = new JRadioButton();
    private JButton btnMove = new JButton();
    private JButton btnMoveAll = new JButton();
    private JButton btnClearKGS = new JButton();
    private JButton btnClearUser = new JButton();
    private JButton btnRemove = new JButton();
    private JButton btnRemoveAll = new JButton();
    private JButton btnLoad = new JButton();
    private JButton btnClose = new JButton();

    public stratKGSFrame(Observable observable, stratListStruct stratListStruct2, stratListStruct stratListStruct3) {
        try {
            this.notifier = observable;
            this.stKGS = stratListStruct2;
            this.stList = stratListStruct3;
            this.stKGSStandard = kgsIORead.ReadKGSStratUnits(1);
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JScrollPane jScrollPane2 = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JScrollPane jScrollPane3 = new JScrollPane();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "KGS Stratigraphic Units:");
        TitledBorder titledBorder2 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "User's Stratigraphic Units:");
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Add to User's Stratigraphic Units List:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        this.setTitle("Move/Merge KGS Data.");
        this.getContentPane().setLayout(new GridLayout(2, 1));
        jPanel.setBorder(titledBorder);
        jPanel.setLayout(new BorderLayout());
        jPanel2.setPreferredSize(new Dimension(180, 10));
        jPanel2.setLayout(new BorderLayout());
        this.sources = stratUtility.getSourceNames(this.stKGS);
        if (this.sources != null) {
            this.iSources = this.sources.length;
        }
        this.iTotal = this.iSources;
        if (this.iTotal > 0) {
            if (this.iSources > 10) {
                jPanel3.setPreferredSize(new Dimension(150, this.iSources * 25));
                jPanel3.setLayout(new GridLayout(this.iSources, 1));
            } else {
                jPanel3.setPreferredSize(new Dimension(150, 250));
                jPanel3.setLayout(new GridLayout(10, 1));
            }
            this.pSource = new JPanel[this.iTotal];
            this.rb = new JRadioButton[this.iTotal];
            for (int i = 0; i < this.iTotal; ++i) {
                this.pSource[i] = new JPanel();
                this.pSource[i].setLayout(new BorderLayout());
                this.pSource[i].setBorder(BorderFactory.createEtchedBorder());
                this.rb[i] = new JRadioButton();
                this.rb[i].setFont(new Font("Dialog", 1, 11));
                this.rb[i].setHorizontalAlignment(2);
                if (i == 0) {
                    this.rb[i].setSelected(true);
                }
                this.rb[i].setText(this.sources[i]);
                this.rb[i].addActionListener(this);
                buttonGroup2.add(this.rb[i]);
                jPanel3.add((Component)this.pSource[i], null);
                this.pSource[i].add((Component)this.rb[i], "West");
            }
        }
        jPanel4.setLayout(new BorderLayout());
        jPanel5.setLayout(new GridLayout());
        jPanel5.setBorder(titledBorder3);
        this.rbReplace.setFont(new Font("Dialog", 1, 11));
        this.rbReplace.setHorizontalAlignment(0);
        this.rbReplace.setSelected(true);
        this.rbReplace.setText("Remove & Replace");
        this.rbReplace.addActionListener(this);
        this.rbAdd.setFont(new Font("Dialog", 1, 11));
        this.rbAdd.setHorizontalAlignment(0);
        this.rbAdd.setText("Add to List");
        this.rbAdd.addActionListener(this);
        this.rbMerge.setFont(new Font("Dialog", 1, 11));
        this.rbMerge.setHorizontalAlignment(0);
        this.rbMerge.setText("Add New Units Only");
        this.rbMerge.addActionListener(this);
        jPanel6.setLayout(new BorderLayout());
        this.pKGS = new stratTable(this.stKGS);
        jScrollPane2 = this.pKGS.getScrollPane();
        this.btnMove.setFont(new Font("Dialog", 1, 11));
        this.btnMove.setText("Add");
        this.btnMove.addActionListener(this);
        this.btnMoveAll.setFont(new Font("Dialog", 1, 11));
        this.btnMoveAll.setText("Add All");
        this.btnMoveAll.addActionListener(this);
        this.btnClearKGS.setFont(new Font("Dialog", 1, 11));
        this.btnClearKGS.setText("Clear Selection");
        this.btnClearKGS.addActionListener(this);
        jPanel8.setBorder(titledBorder2);
        jPanel8.setLayout(new BorderLayout());
        this.pUsers = new stratTable(this.stList);
        jScrollPane3 = this.pUsers.getScrollPane();
        this.pUsers.setFilter(0);
        jPanel9.setPreferredSize(new Dimension(125, 10));
        jPanel9.setLayout(new GridLayout(3, 1));
        this.btnClearUser.setFont(new Font("Dialog", 1, 11));
        this.btnClearUser.setPreferredSize(new Dimension(120, 25));
        this.btnClearUser.setText("Clear Selection");
        this.btnClearUser.addActionListener(this);
        this.btnRemove.setFont(new Font("Dialog", 1, 11));
        this.btnRemove.setPreferredSize(new Dimension(120, 25));
        this.btnRemove.setText("Remove");
        this.btnRemove.addActionListener(this);
        this.btnRemoveAll.setFont(new Font("Dialog", 1, 11));
        this.btnRemoveAll.setPreferredSize(new Dimension(120, 25));
        this.btnRemoveAll.setText("Remove All");
        this.btnRemoveAll.addActionListener(this);
        this.btnLoad.setFont(new Font("Dialog", 1, 11));
        this.btnLoad.setPreferredSize(new Dimension(120, 25));
        this.btnLoad.setText("Load Data");
        this.btnLoad.addActionListener(this);
        this.btnClose.setFont(new Font("Dialog", 1, 11));
        this.btnClose.setPreferredSize(new Dimension(120, 25));
        this.btnClose.setText("Close");
        this.btnClose.addActionListener(this);
        this.getContentPane().add((Component)jPanel, null);
        jPanel.add((Component)jPanel2, "West");
        jPanel2.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)jPanel3, null);
        jPanel.add((Component)jPanel4, "Center");
        jPanel4.add((Component)jPanel5, "North");
        jPanel5.add((Component)this.rbReplace, null);
        jPanel5.add((Component)this.rbAdd, null);
        jPanel5.add((Component)this.rbMerge, null);
        buttonGroup.add(this.rbReplace);
        buttonGroup.add(this.rbAdd);
        buttonGroup.add(this.rbMerge);
        jPanel4.add((Component)jPanel6, "Center");
        jPanel6.add((Component)jScrollPane2, "Center");
        jPanel4.add((Component)jPanel7, "South");
        jPanel7.add((Component)this.btnMove, null);
        jPanel7.add((Component)this.btnMoveAll, null);
        jPanel7.add((Component)this.btnClearKGS, null);
        this.getContentPane().add((Component)jPanel8, null);
        jPanel8.add((Component)jScrollPane3, "Center");
        jPanel8.add((Component)jPanel9, "East");
        jPanel9.add((Component)jPanel10, null);
        jPanel10.add((Component)this.btnClearUser, null);
        jPanel9.add((Component)jPanel11, null);
        jPanel11.add((Component)this.btnRemove, null);
        jPanel11.add((Component)this.btnRemoveAll, null);
        jPanel9.add((Component)jPanel12, null);
        jPanel12.add((Component)this.btnLoad, null);
        jPanel12.add((Component)this.btnClose, null);
        this.setSize(new Dimension(650, 650));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(false);
        this.setVisible(true);
    }

    public stratListStruct getDownloadData() {
        this.stList.sTOPS = new String("Kansas Geological Survey Database");
        this.stList.sTOPDR = new String("Log Depth");
        return this.stList;
    }

    private void add() {
        stratListStruct stratListStruct2 = null;
        String string = cmnString.UniqueName();
        stratListStruct2 = this.pKGS.getSelected(2);
        if (stratListStruct2 != null) {
            block5: for (int i = 0; i < stratListStruct2.iCount; ++i) {
                if (!(stratListStruct2.stItem[i].depthStart > 0.0)) continue;
                if (stratListStruct2.stItem[i].stratKEY.equals("0")) {
                    stratListStruct2.stItem[i].stratKEY = new String(stratListStruct2.stItem[i].sKEY);
                    stratListStruct2.stItem[i].sKEY = new String(string + "_" + i);
                }
                switch (this.iMode) {
                    case 0: {
                        this.stList = stratUtility.ReplaceWith(stratListStruct2.stItem[i], this.stList);
                        this.stList = stratUtility.fillBaseDepth(this.stList, this.stKGSStandard);
                        continue block5;
                    }
                    case 1: {
                        this.stList = stratUtility.add(stratListStruct2.stItem[i], this.stList);
                        continue block5;
                    }
                    case 2: {
                        this.stList = stratUtility.addNewOnly(stratListStruct2.stItem[i], this.stList);
                        this.stList = stratUtility.fillBaseDepth(this.stList, this.stKGSStandard);
                    }
                }
            }
            this.pUsers.clear();
            this.pUsers.repopulateList(this.stList);
        }
        this.pKGS.clear();
    }

    private void addAll() {
        stratListStruct stratListStruct2 = null;
        String string = cmnString.UniqueName();
        stratListStruct2 = this.pKGS.getSelected(1);
        if (stratListStruct2 != null) {
            block5: for (int i = 0; i < stratListStruct2.iCount; ++i) {
                if (!(stratListStruct2.stItem[i].depthStart > 0.0)) continue;
                if (stratListStruct2.stItem[i].stratKEY.equals("0")) {
                    stratListStruct2.stItem[i].stratKEY = new String(stratListStruct2.stItem[i].sKEY);
                    stratListStruct2.stItem[i].sKEY = new String(string + "_" + i);
                }
                switch (this.iMode) {
                    case 0: {
                        this.stList = stratUtility.ReplaceWith(stratListStruct2.stItem[i], this.stList);
                        this.stList = stratUtility.fillBaseDepth(this.stList, this.stKGSStandard);
                        continue block5;
                    }
                    case 1: {
                        this.stList = stratUtility.add(stratListStruct2.stItem[i], this.stList);
                        continue block5;
                    }
                    case 2: {
                        this.stList = stratUtility.addNewOnly(stratListStruct2.stItem[i], this.stList);
                        this.stList = stratUtility.fillBaseDepth(this.stList, this.stKGSStandard);
                    }
                }
            }
            this.pUsers.clear();
            this.pUsers.repopulateList(this.stList);
        }
        this.pKGS.clear();
    }

    private void removeUnit() {
        stratListStruct stratListStruct2 = null;
        stratListStruct2 = this.pUsers.getSelected(2);
        if (stratListStruct2 != null) {
            for (int i = 0; i < stratListStruct2.iCount; ++i) {
                this.stList = stratUtility.remove(stratListStruct2.stItem[i].sKID, stratListStruct2.stItem[i].sKEY, this.stList);
            }
        }
        this.pUsers.clear();
        this.pUsers.repopulateList(this.stList);
    }

    private void removeAllUnits() {
        if (this.stList != null) {
            this.stList.delete();
        }
        this.stList = null;
        this.pUsers.repopulateList(this.stList);
    }

    public void close() {
        this.notifier = null;
        this.stList = null;
        this.stKGS = null;
        this.pUsers = null;
        this.pKGS = null;
        if (this.stKGSStandard != null) {
            this.stKGSStandard.delete();
        }
        this.stKGSStandard = null;
        this.rbReplace = null;
        this.rbAdd = null;
        this.rbMerge = null;
        this.btnMove = null;
        this.btnMoveAll = null;
        this.btnClearKGS = null;
        this.btnClearUser = null;
        this.btnRemove = null;
        this.btnRemoveAll = null;
        this.btnLoad = null;
        this.btnClose = null;
        this.sources = null;
        this.pSource = null;
        this.rb = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < this.iTotal; ++i) {
            if (actionEvent.getSource() != this.rb[i]) continue;
            this.pKGS.clear();
            this.pKGS.setSource(this.sources[i]);
        }
        if (actionEvent.getSource() == this.rbReplace) {
            this.iMode = 0;
        }
        if (actionEvent.getSource() == this.rbAdd) {
            this.iMode = 1;
        }
        if (actionEvent.getSource() == this.rbMerge) {
            this.iMode = 2;
        }
        if (actionEvent.getSource() == this.btnMove) {
            this.add();
        }
        if (actionEvent.getSource() == this.btnMoveAll) {
            this.addAll();
        }
        if (actionEvent.getSource() == this.btnClearKGS) {
            this.pKGS.clear();
        }
        if (actionEvent.getSource() == this.btnClearUser) {
            this.pUsers.clear();
        }
        if (actionEvent.getSource() == this.btnRemove) {
            this.removeUnit();
        }
        if (actionEvent.getSource() == this.btnRemoveAll) {
            this.removeAllUnits();
        }
        if (actionEvent.getSource() == this.btnLoad) {
            this.notifier.notifyObservers(new String("KGS Source Selected"));
        }
        if (actionEvent.getSource() == this.btnClose) {
            this.close();
        }
    }
}

