/*
 * Decompiled with CFR 0.152.
 */
package horizon.gui;

import cmn.cmnString;
import horizon.env.envListStruct;
import horizon.env.gui.envDataEntryPanel;
import horizon.gui.horizonEnterDataFrameFocusAdapter;
import horizon.seq.gui.seqPanel;
import horizon.seq.seqListStruct;
import horizon.strat.gui.stratDataEntryPanel;
import horizon.strat.stratListStruct;
import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import util.BrowserControl;

public class horizonEnterDataFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private iqstratStruct stStruct = null;
    private double dStart = 0.0;
    private double dEnd = 0.0;
    private seqPanel pSequence = null;
    private stratDataEntryPanel pRegions = null;
    private envDataEntryPanel pEnv = null;
    public static final int _TOPS = 0;
    public static final int _SEQ = 1;
    public static final int _ENV = 2;
    private int iPanel = 0;
    private JRadioButton rbTops = new JRadioButton();
    private JRadioButton rbSeq = new JRadioButton();
    private JRadioButton rbEnv = new JRadioButton();
    private JButton btnClose = new JButton();
    private JButton btnHelp = new JButton();
    private TitledBorder titledBorderData = null;
    private TitledBorder titledBorderEntry = null;
    private CardLayout cardLayout = new CardLayout();
    private JPanel pnlData = new JPanel();
    private JTextField txtStart = new JTextField();
    private JTextField txtEnd = new JTextField();
    JPanel pnlTops = new JPanel();

    public horizonEnterDataFrame(Observable observable, iqstratStruct iqstratStruct2) {
        try {
            this.notifier = observable;
            this.stStruct = iqstratStruct2;
            this.jbInit();
            this.addWindowListener(new horizonEnterDataFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Starting Depth:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Ending Depth:");
        this.titledBorderEntry = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Data Entry Panel: ");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        this.titledBorderEntry.setTitleFont(new Font("Dialog", 1, 11));
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("Enter Horizon Data:");
        jPanel.setLayout(new GridLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.rbTops.setFont(new Font("Dialog", 1, 11));
        this.rbTops.setHorizontalAlignment(0);
        this.rbTops.setSelected(true);
        this.rbTops.setText("Stratigraphic Units");
        this.rbTops.addActionListener(this);
        this.rbSeq.setFont(new Font("Dialog", 1, 11));
        this.rbSeq.setHorizontalAlignment(0);
        this.rbSeq.setSelected(false);
        this.rbSeq.setText("Sequence Stratigraphy");
        this.rbSeq.addActionListener(this);
        this.rbEnv.setFont(new Font("Dialog", 1, 11));
        this.rbEnv.setHorizontalAlignment(0);
        this.rbEnv.setSelected(false);
        this.rbEnv.setText("Depositional Environment");
        this.rbEnv.addActionListener(this);
        jPanel3.setBorder(BorderFactory.createEtchedBorder());
        this.btnClose.setFont(new Font("Dialog", 1, 11));
        this.btnClose.setMaximumSize(new Dimension(71, 25));
        this.btnClose.setPreferredSize(new Dimension(75, 25));
        this.btnClose.setText("Cancel");
        this.btnClose.addActionListener(this);
        this.btnHelp.setFont(new Font("Dialog", 1, 11));
        this.btnHelp.setPreferredSize(new Dimension(75, 25));
        this.btnHelp.setText("Help");
        this.btnHelp.addActionListener(this);
        jPanel2.setLayout(new BorderLayout());
        this.pnlData.setLayout(this.cardLayout);
        this.pnlData.setBorder(this.titledBorderEntry);
        jPanel4.setLayout(new GridLayout());
        jPanel6.setBorder(titledBorder);
        jPanel6.setLayout(new BorderLayout());
        this.txtStart.setText("" + this.dStart);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new horizonEnterDataFrameFocusAdapter(this));
        jPanel5.setBorder(titledBorder2);
        jPanel5.setLayout(new BorderLayout());
        this.txtEnd.setText("" + this.dEnd);
        this.txtEnd.setHorizontalAlignment(11);
        this.txtEnd.addFocusListener(new horizonEnterDataFrameFocusAdapter(this));
        this.pSequence = new seqPanel(this.notifier);
        this.pSequence.setStartText(this.txtStart);
        this.pSequence.setEndText(this.txtEnd);
        this.pRegions = new stratDataEntryPanel(this.notifier, this.stStruct);
        this.pRegions.setDepthTextfields(this.txtStart, this.txtEnd);
        this.pEnv = new envDataEntryPanel(this.notifier, this.stStruct);
        this.pEnv.setStartText(this.txtStart);
        this.pEnv.setEndText(this.txtEnd);
        this.getContentPane().add((Component)jPanel, "North");
        if (this.stStruct.bLAS[12]) {
            jPanel.add((Component)this.rbSeq, null);
        }
        jPanel.add((Component)this.rbTops, null);
        if (this.stStruct.bLAS[20]) {
            jPanel.add((Component)this.rbEnv, null);
        }
        buttonGroup.add(this.rbSeq);
        buttonGroup.add(this.rbTops);
        buttonGroup.add(this.rbEnv);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)this.pnlData, "Center");
        this.pnlData.add((Component)this.pSequence, "SEQ");
        this.pnlData.add((Component)this.pRegions, "TOPS");
        this.pnlData.add((Component)this.pEnv, "ENV");
        jPanel2.add((Component)jPanel4, "North");
        jPanel4.add((Component)jPanel6, null);
        jPanel6.add((Component)this.txtStart, "Center");
        jPanel4.add((Component)jPanel5, null);
        jPanel5.add((Component)this.txtEnd, "Center");
        this.getContentPane().add((Component)jPanel3, "South");
        jPanel3.add((Component)this.btnClose, null);
        jPanel3.add((Component)this.btnHelp, null);
        this.setBorders();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(600, dimension.height - 50));
        this.setLocation((dimension.width - this.getSize().width) / 2, 10);
        this.setVisible(true);
    }

    public seqListStruct getSeqList() {
        return this.pSequence.getList();
    }

    public stratListStruct getTopsData() {
        return this.pRegions.getListData();
    }

    public envListStruct getEnvList() {
        return this.pEnv.getList();
    }

    public void setDataType(int n) {
        this.iPanel = n;
        this.rbTops.setSelected(false);
        this.rbSeq.setSelected(false);
        switch (n) {
            case 0: {
                this.rbTops.setSelected(true);
                this.cardLayout.show(this.pnlData, "TOPS");
                break;
            }
            case 1: {
                this.rbSeq.setSelected(true);
                this.cardLayout.show(this.pnlData, "SEQ");
                break;
            }
            case 2: {
                this.rbEnv.setSelected(true);
                this.cardLayout.show(this.pnlData, "ENV");
            }
        }
        this.setBorders();
    }

    public void setDepthRange(double d, double d2) {
        this.dStart = d;
        this.txtStart.setText("" + this.dStart);
        this.dEnd = d2;
        this.txtEnd.setText("" + this.dEnd);
        this.pSequence.setDepthRange(d, d2);
        this.pRegions.setDepthRange(d, d2);
        this.pEnv.setDepthRange(d, d2);
    }

    public void setData(iqstratHeadersStruct iqstratHeadersStruct2) {
        this.pRegions.setData(iqstratHeadersStruct2);
    }

    public void setTopsData(stratListStruct stratListStruct2) {
        this.pRegions.setListData(stratListStruct2);
    }

    public void setSeqList(seqListStruct seqListStruct2) {
        this.pSequence.setData(seqListStruct2);
    }

    public void setEnvList(envListStruct envListStruct2) {
        this.pEnv.setData(envListStruct2);
    }

    private void setBorders() {
        switch (this.iPanel) {
            case 0: {
                this.titledBorderEntry.setTitle("Data Entry Panel: Formation Tops");
                break;
            }
            case 1: {
                this.titledBorderEntry.setTitle("Data Entry Panel: Sequence Stratigraphy");
                break;
            }
            case 2: {
                this.titledBorderEntry.setTitle("Data Entry Panel: Depositional Environment");
            }
        }
        this.pnlData.updateUI();
    }

    public void close() {
        this.notifier = null;
        this.stStruct = null;
        if (this.pSequence != null) {
            this.pSequence.close();
        }
        this.pSequence = null;
        if (this.pEnv != null) {
            this.pEnv.close();
        }
        this.pEnv = null;
        this.rbTops = null;
        this.rbSeq = null;
        this.rbEnv = null;
        this.btnClose = null;
        this.btnHelp = null;
        this.titledBorderData = null;
        this.cardLayout = null;
        this.pnlData = null;
        this.txtStart = null;
        this.txtEnd = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbTops) {
            this.iPanel = 0;
            this.cardLayout.show(this.pnlData, "TOPS");
        }
        if (actionEvent.getSource() == this.rbSeq) {
            this.iPanel = 1;
            this.cardLayout.show(this.pnlData, "SEQ");
        }
        if (actionEvent.getSource() == this.rbEnv) {
            this.iPanel = 2;
            this.cardLayout.show(this.pnlData, "ENV");
        }
        if (actionEvent.getSource() == this.btnHelp) {
            switch (this.iPanel) {
                case 0: {
                    BrowserControl.displayURL("http://www.kgs.ku.edu/stratigraphic/PROFILE/HELP/DATA_ENTRY/tops/");
                    break;
                }
                case 1: {
                    BrowserControl.displayURL("http://www.kgs.ku.edu/stratigraphic/PROFILE/HELP/DATA_ENTRY/seq_strat/");
                    break;
                }
            }
        }
        this.setBorders();
        if (actionEvent.getSource() == this.btnClose) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Start Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtEnd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("End Depth Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                this.dStart = cmnString.stringToDouble(this.txtStart.getText());
                this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
                this.setDepthRange(this.dStart, this.dEnd);
            }
        }
    }

    public class horizonEnterDataFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            horizonEnterDataFrame.this.close();
        }
    }
}

