/*
 * Decompiled with CFR 0.152.
 */
package horizon.env.plot;

import horizon.env.envListStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class envPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private envListStruct stDepEnv = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public envPlotTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stDepEnv = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public envListStruct getFossilData() {
        return this.stDepEnv;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setData(envListStruct envListStruct2) {
        this.stDepEnv = envListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = n2 / 14;
        int n8 = n + n2;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n4 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n6 = this.iIncrementY / 5;
            for (int i = 0; i < 5; ++i) {
                n5 = this.iDataType == 1 ? this.iHeight - (n3 + i * n6) : n3 + i * n6 + 100;
                if (n5 < 100 || n5 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n5, n8, n5);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n4, n8, n4);
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
        for (n3 = 0; n3 <= n2; n3 += n7) {
            if (n3 == 0 || n3 == n2) {
                graphics.drawLine(n3 + n, 25, n3 + n, 100 + this.iLogHeight);
                continue;
            }
            graphics.drawLine(n3 + n, 100, n3 + n, 100 + this.iLogHeight);
        }
        graphics.setColor(Color.black);
        graphics.drawString("Environment", n + n7, 35);
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(new Color(165, 42, 42));
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(n + 3, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Continental", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 3), -45.0);
        graphics.drawLine(n + 1 * n7, 45, n + 1 * n7, 100 + this.iLogHeight);
        graphics.setColor(new Color(160, 82, 45));
        graphics2D.translate(n + n7 + 2, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Coastal", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + n7 + 2), -45.0);
        graphics.setColor(new Color(128, 128, 255));
        graphics2D.translate(n + 2 * n7 + 2, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Fresh", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 2 * n7 + 2), -45.0);
        graphics.setColor(new Color(102, 205, 170));
        graphics2D.translate(n + 3 * n7 + 2, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Brackish", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 3 * n7 + 2), -45.0);
        graphics.setColor(new Color(102, 205, 170));
        graphics2D.translate(n + 4 * n7 + 2, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Hypersaline", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 4 * n7 + 2), -45.0);
        graphics.setColor(new Color(0, 0, 180));
        graphics2D.drawString("Neritic", n + 6 * n7, 53);
        graphics.drawLine(n + 5 * n7, 45, n + 5 * n7, 100 + this.iLogHeight);
        graphics.setColor(Color.gray);
        graphics2D.translate(n + 5 * n7 + 2, 55);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString(" 0-2 m", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 5 * n7 + 2), -55.0);
        graphics2D.translate(n + 6 * n7 + 2, 55);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString(" 2-10 m", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 6 * n7 + 2), -55.0);
        graphics2D.translate(n + 7 * n7 + 2, 55);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString(" 10-30 m", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 7 * n7 + 2), -55.0);
        graphics.setColor(new Color(0, 0, 180));
        graphics2D.drawString("M", n + 8 * n7 + 2, 93);
        graphics2D.drawString("O", n + 9 * n7 + 2, 93);
        graphics.setColor(new Color(0, 0, 130));
        graphics2D.translate(n + 10 * n7 + 2, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Bathyal", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 10 * n7 + 2), -45.0);
        graphics2D.drawString("U", n + 10 * n7 + 2, 93);
        graphics2D.drawString("M", n + 11 * n7, 93);
        graphics2D.drawString("L", n + 12 * n7 + 2, 93);
        graphics.drawLine(n + 10 * n7, 45, n + 10 * n7, 100 + this.iLogHeight);
        graphics.setColor(new Color(0, 0, 100));
        graphics2D.translate(n + 13 * n7 + 2, 45);
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Abyssal", 0, 0);
        graphics2D.rotate(-1.5707963267948966);
        graphics2D.translate(-1.0 * (double)(n + 13 * n7 + 2), -45.0);
        graphics.drawLine(n + 13 * n7, 45, n + 13 * n7, 100 + this.iLogHeight);
        graphics.setColor(new Color(160, 82, 45));
        graphics.fillRect(n + 0 * n7, 95, 10, 5);
        graphics.setColor(new Color(210, 180, 140));
        graphics.fillRect(n + 1 * n7, 95, 10, 5);
        graphics.setColor(new Color(124, 252, 0));
        graphics.fillRect(n + 2 * n7, 95, 10, 5);
        graphics.setColor(new Color(102, 205, 170));
        graphics.fillRect(n + 3 * n7, 95, 10, 5);
        graphics.setColor(new Color(102, 205, 170));
        graphics.fillRect(n + 4 * n7, 95, 10, 5);
        graphics.setColor(new Color(127, 255, 212));
        graphics.fillRect(n + 5 * n7, 95, 10, 5);
        graphics.setColor(new Color(0, 255, 255));
        graphics.fillRect(n + 6 * n7, 95, 10, 5);
        graphics.setColor(new Color(135, 206, 235));
        graphics.fillRect(n + 7 * n7, 95, 10, 5);
        graphics.setColor(new Color(0, 191, 255));
        graphics.fillRect(n + 8 * n7, 95, 10, 5);
        graphics.setColor(new Color(0, 178, 238));
        graphics.fillRect(n + 9 * n7, 95, 10, 5);
        graphics.setColor(new Color(128, 128, 255));
        graphics.fillRect(n + 10 * n7, 95, 10, 5);
        graphics.setColor(new Color(65, 128, 255));
        graphics.fillRect(n + 11 * n7, 95, 10, 5);
        graphics.setColor(new Color(0, 0, 255));
        graphics.fillRect(n + 12 * n7, 95, 10, 5);
        graphics.setColor(new Color(0, 0, 180));
        graphics.fillRect(n + 13 * n7, 95, 10, 5);
        graphics.setColor(Color.black);
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n8, 25);
        graphics.drawLine(n, 100, n8, 100);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
    }

    public void drawData(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int[] nArray = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        boolean bl = false;
        int n11 = 0;
        if (this.stDepEnv != null) {
            for (int i = 0; i < this.stDepEnv.iCount; ++i) {
                int n12;
                for (n12 = 0; n12 < nArray.length; ++n12) {
                    nArray[n12] = 0;
                }
                nArray[0] = this.stDepEnv.stItem[i].icontl;
                nArray[1] = this.stDepEnv.stItem[i].icstl;
                nArray[2] = this.stDepEnv.stItem[i].ifrsh;
                nArray[3] = this.stDepEnv.stItem[i].ibrcksh;
                nArray[4] = this.stDepEnv.stItem[i].ihyper;
                nArray[5] = this.stDepEnv.stItem[i].ishore;
                nArray[6] = this.stDepEnv.stItem[i].ioff_tran;
                nArray[7] = this.stDepEnv.stItem[i].ioffshr;
                nArray[8] = this.stDepEnv.stItem[i].ishlf_m;
                nArray[9] = this.stDepEnv.stItem[i].ishlf_o;
                nArray[10] = this.stDepEnv.stItem[i].ibthyl_u;
                nArray[11] = this.stDepEnv.stItem[i].ibthyl_m;
                nArray[12] = this.stDepEnv.stItem[i].ibthyl_l;
                nArray[13] = this.stDepEnv.stItem[i].iabyssl;
                d2 = this.stDepEnv.stItem[i].depthStart;
                d3 = this.stDepEnv.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                if ((n5 = Math.abs(n4 - n3)) == 0) {
                    n5 = 1;
                }
                if (n3 < 100 || n4 <= 100 || n3 >= this.iHeight || n4 > this.iHeight) continue;
                for (n12 = 0; n12 < nArray.length; ++n12) {
                    if (nArray[n12] <= 4) continue;
                    switch (n12) {
                        case 0: {
                            n8 = 160;
                            n9 = 82;
                            n10 = 45;
                            break;
                        }
                        case 1: {
                            n8 = 210;
                            n9 = 180;
                            n10 = 140;
                            break;
                        }
                        case 2: {
                            n8 = 124;
                            n9 = 252;
                            n10 = 0;
                            break;
                        }
                        case 3: {
                            n8 = 102;
                            n9 = 205;
                            n10 = 170;
                            break;
                        }
                        case 4: {
                            n8 = 102;
                            n9 = 205;
                            n10 = 170;
                            break;
                        }
                        case 5: {
                            n8 = 127;
                            n9 = 255;
                            n10 = 212;
                            break;
                        }
                        case 6: {
                            n8 = 0;
                            n9 = 255;
                            n10 = 255;
                            break;
                        }
                        case 7: {
                            n8 = 135;
                            n9 = 206;
                            n10 = 235;
                            break;
                        }
                        case 8: {
                            n8 = 0;
                            n9 = 191;
                            n10 = 255;
                            break;
                        }
                        case 9: {
                            n8 = 0;
                            n9 = 178;
                            n10 = 238;
                            break;
                        }
                        case 10: {
                            n8 = 128;
                            n9 = 128;
                            n10 = 255;
                            break;
                        }
                        case 11: {
                            n8 = 65;
                            n9 = 128;
                            n10 = 255;
                            break;
                        }
                        case 12: {
                            n8 = 0;
                            n9 = 0;
                            n10 = 255;
                            break;
                        }
                        case 13: {
                            n8 = 0;
                            n9 = 0;
                            n10 = 180;
                        }
                    }
                    if (nArray[n12] < 5) {
                        n8 = n11 = 255 - 20 * nArray[n12];
                        n9 = n11;
                        n10 = n11;
                    }
                    graphics.setColor(new Color(n8, n9, n10));
                    n6 = n + n12 * 10;
                    n7 = 10;
                    graphics.fillRect(n6, n3, n7, n5);
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 2;
        if (n == 54) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n2, n3);
            this.drawData(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

