/*
 * Decompiled with CFR 0.152.
 */
package horizon.env.gui;

import cmn.cmnString;
import horizon.env.envListStruct;
import horizon.env.envMatrixStruct;
import horizon.env.envStruct;
import horizon.env.envUtility;
import horizon.env.gui.envDataEntryPanelFocusAdapter;
import horizon.env.gui.envMatrixTable;
import horizon.env.gui.envTable;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import util.BrowserControl;
import util.utilBrowser;

public class envDataEntryPanel
extends JPanel
implements ActionListener {
    private Observable notifier = null;
    private iqstratStruct stStruct = null;
    public static final int _ADD = 0;
    public static final int _MODIFY = 1;
    private int iAction = 0;
    public static final int _CONTI = 0;
    public static final int _TRANS = 1;
    public static final int _MARINE = 2;
    public static final String[] TYPE = new String[]{"Continental", "Transitional", "Marine"};
    private int iPanel = 0;
    private utilBrowser pBrowser = null;
    private double dStart = 0.0;
    private double dEnd = 0.0;
    private JTextField txtStart = null;
    private JTextField txtEnd = null;
    private envTable pTable = null;
    private envMatrixTable pXTable = null;
    private envListStruct stList = null;
    private envStruct stModify = null;
    private String sKEY = "0";
    private String sEnv = "";
    private String sDesc = "";
    private String sModel = "";
    private String sType = "";
    private String sGroup = "";
    private String subgroup = "";
    private int[] iLevel = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private JButton btnSelect = new JButton();
    private JButton btnLevel = new JButton();
    private JButton btnAdd = new JButton();
    private JButton btnClear = new JButton();
    private JButton btnModify = new JButton();
    private JButton btnRemove = new JButton();
    private JButton btnRemoveAll = new JButton();
    private JButton[] btnColors = null;
    private JTextField txtEnv = new JTextField();
    private JTextArea txtRemarks = new JTextArea();
    private JTextField txtModel = new JTextField();
    private JTextField txtType = new JTextField();
    private JTextField txtGroup = new JTextField();
    private JTextField txtSubgroup = new JTextField();
    private JRadioButton rbConti = new JRadioButton();
    private JRadioButton rbTrans = new JRadioButton();
    private JRadioButton rbMarine = new JRadioButton();
    private TitledBorder titledBorderEntry = null;
    private CardLayout cardLayout = new CardLayout();
    private JPanel pnlData = new JPanel();

    public envDataEntryPanel(Observable observable, iqstratStruct iqstratStruct2) {
        try {
            this.notifier = observable;
            this.stStruct = iqstratStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JPanel jPanel11 = new JPanel();
        JPanel jPanel12 = new JPanel();
        JPanel jPanel13 = new JPanel();
        JPanel jPanel14 = new JPanel();
        JPanel jPanel15 = new JPanel();
        JPanel jPanel16 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JLabel jLabel5 = new JLabel();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.titledBorderEntry = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Data Entry Panel: ");
        this.titledBorderEntry.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Environment:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Comments:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Model:");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Type of Environment:");
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder5 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Environment Group:");
        titledBorder5.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder6 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Environment Subgroup:");
        titledBorder6.setTitleFont(new Font("Dialog", 1, 11));
        this.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new GridLayout());
        this.rbConti.setFont(new Font("Dialog", 1, 11));
        this.rbConti.setHorizontalAlignment(0);
        this.rbConti.setSelected(true);
        this.rbConti.setText("Continental");
        this.rbConti.addActionListener(this);
        this.rbTrans.setFont(new Font("Dialog", 1, 11));
        this.rbTrans.setHorizontalAlignment(0);
        this.rbTrans.setText("Transitional");
        this.rbTrans.addActionListener(this);
        this.rbMarine.setFont(new Font("Dialog", 1, 11));
        this.rbMarine.setHorizontalAlignment(0);
        this.rbMarine.setText("Marine");
        this.rbMarine.addActionListener(this);
        this.pnlData.setLayout(new BorderLayout());
        this.pnlData.setBorder(this.titledBorderEntry);
        this.pXTable = new envMatrixTable();
        jScrollPane2 = this.pXTable.getScrollPane();
        this.btnSelect.setFont(new Font("Dialog", 1, 11));
        this.btnSelect.setText("Select");
        this.btnSelect.addActionListener(this);
        this.btnLevel.setFont(new Font("Dialog", 1, 11));
        this.btnLevel.setText("Level & Colors");
        this.btnLevel.addActionListener(this);
        jPanel5.setLayout(new BorderLayout());
        jPanel11.setLayout(new BorderLayout());
        jLabel.setText("Environment:           ");
        jLabel.setFont(new Font("Monospaced", 1, 11));
        this.txtEnv.setText("");
        this.txtEnv.addFocusListener(new envDataEntryPanelFocusAdapter(this));
        jPanel12.setBorder(titledBorder2);
        jPanel12.setLayout(new BorderLayout());
        jPanel12.setPreferredSize(new Dimension(10, 100));
        this.txtRemarks.setText("");
        this.txtRemarks.setColumns(3);
        this.txtRemarks.setLineWrap(true);
        this.txtRemarks.setWrapStyleWord(true);
        jPanel10.setLayout(new GridLayout(5, 1));
        jPanel13.setLayout(new BorderLayout());
        jLabel2.setText("Sedimentary Model:     ");
        jLabel2.setFont(new Font("Monospaced", 1, 11));
        this.txtModel.setText("");
        jPanel14.setLayout(new BorderLayout());
        jLabel3.setText("Type of Environement:  ");
        jLabel3.setFont(new Font("Monospaced", 1, 11));
        this.txtType.setText("");
        jPanel15.setLayout(new BorderLayout());
        jLabel4.setText("Environement Group:    ");
        jLabel4.setFont(new Font("Monospaced", 1, 11));
        this.txtGroup.setText("");
        jPanel16.setLayout(new BorderLayout());
        jLabel5.setText("Environement Subgroup: ");
        jLabel5.setFont(new Font("Monospaced", 1, 11));
        this.txtSubgroup.setText("");
        jPanel6.setLayout(new GridLayout());
        this.btnColors = new JButton[14];
        for (int i = 0; i < 14; ++i) {
            this.btnColors[i] = new JButton();
            this.btnColors[i].setFont(new Font("Dialog", 1, 10));
            if (i < 10) {
                this.btnColors[i].setText("" + i);
            } else if (i == 10) {
                this.btnColors[i].setText("A");
            } else if (i == 11) {
                this.btnColors[i].setText("B");
                this.btnColors[i].setForeground(Color.gray);
            } else if (i == 12) {
                this.btnColors[i].setText("C");
                this.btnColors[i].setForeground(Color.gray);
            } else if (i == 13) {
                this.btnColors[i].setText("D");
                this.btnColors[i].setForeground(Color.gray);
            }
            this.btnColors[i].addActionListener(this);
            jPanel6.add((Component)this.btnColors[i], null);
        }
        this.setColors();
        jPanel7.setPreferredSize(new Dimension(10, 250));
        jPanel7.setLayout(new BorderLayout());
        jPanel8.setLayout(new GridLayout());
        this.btnAdd.setFont(new Font("Dialog", 1, 11));
        this.btnAdd.setText("Add Data to List");
        this.btnAdd.addActionListener(this);
        this.btnClear.setFont(new Font("Dialog", 1, 11));
        this.btnClear.setText("Clear");
        this.btnClear.addActionListener(this);
        this.pTable = new envTable();
        jScrollPane = this.pTable.getScrollPane();
        this.btnModify.setFont(new Font("Dialog", 1, 11));
        this.btnModify.setText("Modify");
        this.btnModify.addActionListener(this);
        this.btnRemove.setFont(new Font("Dialog", 1, 11));
        this.btnRemove.setText("Remove");
        this.btnRemove.addActionListener(this);
        this.btnRemoveAll.setFont(new Font("Dialog", 1, 11));
        this.btnRemoveAll.setText("Remove All");
        this.btnRemoveAll.addActionListener(this);
        this.add((Component)jPanel2, "North");
        jPanel2.add((Component)this.rbConti, null);
        jPanel2.add((Component)this.rbTrans, null);
        jPanel2.add((Component)this.rbMarine, null);
        buttonGroup.add(this.rbConti);
        buttonGroup.add(this.rbTrans);
        buttonGroup.add(this.rbMarine);
        this.add((Component)jPanel, "Center");
        jPanel.add((Component)this.pnlData, "Center");
        this.pnlData.add((Component)jScrollPane2, "Center");
        this.pnlData.add((Component)jPanel4, "South");
        jPanel4.add((Component)this.btnSelect, null);
        jPanel4.add((Component)this.btnLevel, null);
        jPanel.add((Component)jPanel5, "South");
        jPanel5.add((Component)jPanel10, "North");
        jPanel10.add((Component)jPanel11, null);
        jPanel11.add((Component)jLabel, "West");
        jPanel11.add((Component)this.txtEnv, "Center");
        jPanel10.add((Component)jPanel13, null);
        jPanel13.add((Component)jLabel2, "West");
        jPanel13.add((Component)this.txtModel, "Center");
        jPanel10.add((Component)jPanel14, null);
        jPanel14.add((Component)jLabel3, "West");
        jPanel14.add((Component)this.txtType, "Center");
        jPanel10.add((Component)jPanel15, null);
        jPanel15.add((Component)jLabel4, "West");
        jPanel15.add((Component)this.txtGroup, "Center");
        jPanel10.add((Component)jPanel16, null);
        jPanel16.add((Component)jLabel5, "West");
        jPanel16.add((Component)this.txtSubgroup, "Center");
        jPanel5.add((Component)jPanel12, "Center");
        jPanel12.add((Component)this.txtRemarks, "Center");
        jPanel5.add((Component)jPanel6, "South");
        this.add((Component)jPanel7, "South");
        jPanel7.add((Component)jPanel8, "North");
        jPanel8.add((Component)this.btnAdd, null);
        jPanel8.add((Component)this.btnClear, null);
        jPanel7.add((Component)jScrollPane, "Center");
        jPanel7.add((Component)jPanel9, "South");
        jPanel9.add((Component)this.btnModify, null);
        jPanel9.add((Component)this.btnRemove, null);
        jPanel9.add((Component)this.btnRemoveAll, null);
        this.setBorders();
    }

    public envStruct getData() {
        envStruct envStruct2 = new envStruct();
        if (this.sKEY.equals("0")) {
            this.sKEY = new String(cmnString.UniqueName());
        }
        envStruct2.sKEY = new String(this.sKEY);
        envStruct2.depthStart = this.dStart;
        if (this.dEnd <= this.dStart) {
            this.dEnd = this.dStart + 0.5;
        }
        envStruct2.depthEnd = this.dEnd;
        envStruct2.dBed = (double)((int)((this.dEnd - this.dStart) * 100.0)) / 100.0;
        envStruct2.icontl = this.iLevel[0];
        envStruct2.icstl = this.iLevel[1];
        envStruct2.ifrsh = this.iLevel[2];
        envStruct2.ibrcksh = this.iLevel[3];
        envStruct2.ihyper = this.iLevel[4];
        envStruct2.ishore = this.iLevel[5];
        envStruct2.ioff_tran = this.iLevel[6];
        envStruct2.ioffshr = this.iLevel[7];
        envStruct2.ishlf_m = this.iLevel[8];
        envStruct2.ishlf_o = this.iLevel[9];
        envStruct2.ibthyl_u = this.iLevel[10];
        envStruct2.ibthyl_m = this.iLevel[11];
        envStruct2.ibthyl_l = this.iLevel[12];
        envStruct2.iabyssl = this.iLevel[13];
        envStruct2.sDepEnv = new String(this.sEnv);
        envStruct2.sDescrip = new String(this.sDesc);
        envStruct2.iType = -1;
        for (int i = 0; i < 3; ++i) {
            if (!this.sModel.equals(TYPE[i])) continue;
            envStruct2.iType = i;
        }
        envStruct2.sType = new String(this.sModel);
        envStruct2.sGroup = new String(this.sType);
        envStruct2.sGroup2 = new String(this.sGroup);
        envStruct2.sGroup3 = new String(this.subgroup);
        return envStruct2;
    }

    public envListStruct getList() {
        return this.stList;
    }

    public void setDepthRange(double d, double d2) {
        this.dStart = d;
        this.dEnd = d2;
        this.setButtons();
    }

    public void setStartText(JTextField jTextField) {
        this.txtStart = jTextField;
    }

    public void setEndText(JTextField jTextField) {
        this.txtEnd = jTextField;
    }

    public void setData(envListStruct envListStruct2) {
        this.stList = envListStruct2;
        this.pTable.setData(envListStruct2);
    }

    public void setAction(int n) {
        this.iAction = n;
        switch (n) {
            case 0: {
                this.btnAdd.setText("Add Data to List");
                break;
            }
            case 1: {
                this.btnAdd.setText("Modify Data in List");
            }
        }
        this.setButtons();
    }

    private void setButtons() {
        this.btnAdd.setEnabled(true);
        this.btnModify.setEnabled(false);
        this.btnRemove.setEnabled(false);
        this.btnRemoveAll.setEnabled(false);
        if (this.pTable.getTotalRows() > 0) {
            this.btnModify.setEnabled(true);
            this.btnRemove.setEnabled(true);
            this.btnRemoveAll.setEnabled(true);
        }
    }

    private void setBorders() {
        this.pXTable.setData(this.iPanel);
        switch (this.iPanel) {
            case 0: {
                this.titledBorderEntry.setTitle("Continental Environment Types");
                break;
            }
            case 1: {
                this.titledBorderEntry.setTitle("Transitional Environment Types");
                break;
            }
            case 2: {
                this.titledBorderEntry.setTitle("Marine Environment Types");
            }
        }
        this.pnlData.updateUI();
    }

    private void setColors() {
        block16: for (int i = 0; i < 14; ++i) {
            this.btnColors[i].setBackground(new Color(255, 255, 255));
            if (this.iLevel[i] <= 0) continue;
            switch (i) {
                case 0: {
                    this.btnColors[i].setBackground(new Color(160, 82, 45));
                    continue block16;
                }
                case 1: {
                    this.btnColors[i].setBackground(new Color(210, 180, 140));
                    continue block16;
                }
                case 2: {
                    this.btnColors[i].setBackground(new Color(124, 252, 0));
                    continue block16;
                }
                case 3: {
                    this.btnColors[i].setBackground(new Color(102, 205, 170));
                    continue block16;
                }
                case 4: {
                    this.btnColors[i].setBackground(new Color(102, 205, 170));
                    continue block16;
                }
                case 5: {
                    this.btnColors[i].setBackground(new Color(127, 255, 212));
                    continue block16;
                }
                case 6: {
                    this.btnColors[i].setBackground(new Color(0, 255, 255));
                    continue block16;
                }
                case 7: {
                    this.btnColors[i].setBackground(new Color(135, 206, 235));
                    continue block16;
                }
                case 8: {
                    this.btnColors[i].setBackground(new Color(0, 191, 255));
                    continue block16;
                }
                case 9: {
                    this.btnColors[i].setBackground(new Color(0, 178, 238));
                    continue block16;
                }
                case 10: {
                    this.btnColors[i].setBackground(new Color(128, 128, 255));
                    continue block16;
                }
                case 11: {
                    this.btnColors[i].setBackground(new Color(65, 128, 255));
                    continue block16;
                }
                case 12: {
                    this.btnColors[i].setBackground(new Color(0, 0, 255));
                    continue block16;
                }
                case 13: {
                    this.btnColors[i].setBackground(new Color(0, 0, 180));
                }
            }
        }
    }

    private void setXSelect() {
        int n = -1;
        String string = "";
        Object var3_3 = null;
        if (this.pXTable != null) {
            n = this.pXTable.getRow();
            this.setWidgets(n);
        }
    }

    private void setWidgets(int n) {
        String string = "";
        char[] cArray = null;
        if (n > -1) {
            this.sModel = new String(envMatrixStruct.ENV[n][0]);
            this.sType = new String(envMatrixStruct.ENV[n][1]);
            this.sGroup = new String(envMatrixStruct.ENV[n][2]);
            this.subgroup = new String(envMatrixStruct.ENV[n][3]);
            this.sEnv = new String(envMatrixStruct.ENV[n][4]);
            string = new String(envMatrixStruct.ENV[n][5]);
            cArray = string.toCharArray();
            for (int i = 0; i < 14; ++i) {
                this.iLevel[i] = 0;
                if (cArray[i] != 'X') continue;
                this.iLevel[i] = 5;
            }
            if (this.sEnv.length() == 0) {
                if (this.sModel.length() > 0) {
                    this.sEnv = new String(this.sModel);
                }
                if (this.sType.length() > 0) {
                    this.sEnv = new String(this.sType);
                }
                if (this.sGroup.length() > 0) {
                    this.sEnv = new String(this.sGroup);
                }
                if (this.subgroup.length() > 0) {
                    this.sEnv = new String(this.subgroup);
                }
            }
            this.txtEnv.setText(this.sEnv);
            this.txtModel.setText(this.sModel);
            this.txtType.setText(this.sType);
            this.txtGroup.setText(this.sGroup);
            this.txtSubgroup.setText(this.subgroup);
            this.setColors();
        }
    }

    private void setWidgets(envStruct envStruct2) {
        if (envStruct2 != null) {
            this.sKEY = new String(envStruct2.sKEY);
            this.iLevel[0] = envStruct2.icontl;
            this.iLevel[1] = envStruct2.icstl;
            this.iLevel[2] = envStruct2.ifrsh;
            this.iLevel[3] = envStruct2.ibrcksh;
            this.iLevel[4] = envStruct2.ihyper;
            this.iLevel[5] = envStruct2.ishore;
            this.iLevel[6] = envStruct2.ioff_tran;
            this.iLevel[7] = envStruct2.ioffshr;
            this.iLevel[8] = envStruct2.ishlf_m;
            this.iLevel[9] = envStruct2.ishlf_o;
            this.iLevel[10] = envStruct2.ibthyl_u;
            this.iLevel[11] = envStruct2.ibthyl_m;
            this.iLevel[12] = envStruct2.ibthyl_l;
            this.iLevel[13] = envStruct2.iabyssl;
            this.sModel = new String(envStruct2.sType);
            this.sType = new String(envStruct2.sGroup);
            this.sGroup = new String(envStruct2.sGroup2);
            this.subgroup = new String(envStruct2.sGroup3);
            this.sDesc = new String(envStruct2.sDescrip);
            this.sEnv = new String(envStruct2.sDepEnv);
            this.txtEnv.setText(this.sEnv);
            this.txtModel.setText(this.sModel);
            this.txtType.setText(this.sType);
            this.txtGroup.setText(this.sGroup);
            this.txtSubgroup.setText(this.subgroup);
            this.txtRemarks.setText(this.sDesc);
            this.setColors();
        }
    }

    public void clear() {
        this.sKEY = new String("0");
        this.sModel = new String("");
        this.sType = new String("");
        this.sGroup = new String("");
        this.subgroup = new String("");
        this.sDesc = new String("");
        this.sEnv = new String("");
        for (int i = 0; i < 14; ++i) {
            this.iLevel[i] = 1;
        }
        this.txtEnv.setText(this.sEnv);
        this.txtModel.setText(this.sModel);
        this.txtType.setText(this.sType);
        this.txtGroup.setText(this.sGroup);
        this.txtSubgroup.setText(this.subgroup);
        this.txtRemarks.setText(this.sDesc);
        this.setColors();
        this.setAction(0);
        if (this.stModify != null) {
            this.stModify.delete();
        }
        this.stModify = null;
    }

    private void add() {
        envStruct envStruct2 = this.getData();
        this.stList = this.iAction == 1 ? envUtility.modify(envStruct2.sKEY, envStruct2, this.stList) : envUtility.add(envStruct2, this.stList);
        this.stList = envUtility.bubbleSort(this.stList);
        this.setData(this.stList);
        this.notifier.notifyObservers(new String("Depositional Environment Changed"));
        this.setAction(0);
        this.clear();
    }

    private void modify() {
        String string = "";
        this.setAction(1);
        this.stModify = envUtility.copy(this.pTable.getRowData());
        this.dStart = this.stModify.depthStart;
        this.dEnd = this.stModify.depthEnd;
        if (this.txtStart != null) {
            this.txtStart.setText("" + this.dStart);
        }
        if (this.txtEnd != null) {
            this.txtEnd.setText("" + this.dEnd);
        }
        this.setWidgets(this.stModify);
    }

    private void removeItem() {
        envStruct envStruct2 = envUtility.copy(this.pTable.getRowData());
        this.stList = envUtility.remove(envStruct2.sKEY, this.stList);
        this.setData(this.stList);
        this.notifier.notifyObservers(new String("Depositional Environment Changed"));
    }

    private void removeAllRows() {
        if (this.stList != null) {
            this.stList.delete();
        }
        this.stList = null;
        this.setData(this.stList);
        this.notifier.notifyObservers(new String("Depositional Environment Changed"));
    }

    private void displayLevel() {
        if (!this.stStruct.stCMN.bStandalone) {
            this.pBrowser = new utilBrowser(this.stStruct.stCMN.appletContext, "http://www.kgs.ku.edu/stratigraphic/PROFILE/environment.html");
        } else {
            BrowserControl.displayURL("http://www.kgs.ku.edu/stratigraphic/PROFILE/environment.html");
        }
    }

    public void close() {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbConti) {
            this.iPanel = 0;
        }
        if (actionEvent.getSource() == this.rbTrans) {
            this.iPanel = 1;
        }
        if (actionEvent.getSource() == this.rbMarine) {
            this.iPanel = 2;
        }
        for (int i = 0; i < 14; ++i) {
            if (actionEvent.getSource() != this.btnColors[i]) continue;
            if (this.iLevel[i] > 0) {
                this.iLevel[i] = 0;
            } else if (this.iLevel[i] == 0) {
                this.iLevel[i] = 5;
            }
            this.setColors();
        }
        if (actionEvent.getSource() == this.btnSelect) {
            this.setXSelect();
        }
        if (actionEvent.getSource() == this.btnLevel) {
            this.displayLevel();
        }
        if (actionEvent.getSource() == this.btnAdd) {
            this.add();
        }
        if (actionEvent.getSource() == this.btnClear) {
            this.clear();
        }
        if (actionEvent.getSource() == this.btnModify) {
            this.modify();
        }
        if (actionEvent.getSource() == this.btnRemove) {
            this.removeItem();
        }
        if (actionEvent.getSource() == this.btnRemoveAll) {
            this.removeAllRows();
        }
        this.setButtons();
        this.setBorders();
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        if (focusEvent.getSource() == this.txtEnv) {
            for (int i = 0; i < envMatrixStruct.ENV.length; ++i) {
                for (int j = 0; j < 6; ++j) {
                    if (bl || !this.txtEnv.getText().toLowerCase().equals(envMatrixStruct.ENV[i][j].toLowerCase())) continue;
                    this.setWidgets(i);
                    bl = true;
                }
            }
        }
    }
}

