/*
 * Decompiled with CFR 0.152.
 */
package horizon.bio.io;

import cmn.cmnString;
import horizon.bio.bioStratListStruct;
import horizon.bio.bioStratStruct;
import horizon.strat.stratListStruct;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import parse.parseFossilListStruct;

public class ReadBioStratUnitsXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    public static final String ROOTNAME = "fossils";
    public static final String RECORDS = "records";
    public static final String FOSSIL = "fossil";
    public static final String KEY = "key";
    public static final String ID = "id";
    public static final String SPECIES = "species";
    public static final String GENUS = "genus";
    public static final String TRIBE = "tribe";
    public static final String FAMILY = "family";
    public static final String SUB_FAMILY = "subfamily";
    public static final String SUPER_FAMILY = "superfamily";
    public static final String INFRA_ORDER = "infraorder";
    public static final String SUB_ORDER = "suborder";
    public static final String ORDER = "order";
    public static final String SUB_CLASS = "subclass";
    public static final String CLASS = "class";
    public static final String SUPER_CLASS = "superclass";
    public static final String SUB_PHYLUM = "subphylum";
    public static final String PHYLUM = "phylum";
    public static final String SUPER_PHYLUM = "superphylum";
    public static final String SUB_KINGDOM = "subkingdom";
    public static final String KINGDOM = "kingdom";
    public static final String AGE_TOP = "from";
    public static final String AGE_BASE = "to";
    public static final String TYPE = "type";
    public static final String AUTHOR = "author";
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private int iError = 0;
    private String sError = "";
    private bioStratListStruct stList = new bioStratListStruct();
    private parseFossilListStruct stFossils = null;
    private stratListStruct stICS = null;

    public ReadBioStratUnitsXMLFile() {
        this.iType = 0;
    }

    public ReadBioStratUnitsXMLFile(int n) {
        this.iType = n;
    }

    public bioStratListStruct Process(String string, parseFossilListStruct parseFossilListStruct2, stratListStruct stratListStruct2) {
        this.stFossils = parseFossilListStruct2;
        this.stICS = stratListStruct2;
        this.stList.iCount = 0;
        this.Read(string);
        this.stList.iCount = this.iCount + 1;
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(FOSSIL)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new bioStratStruct();
            }
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stList.stItem = new bioStratStruct[this.iRows];
                    }
                }
                if (this.iCount <= -1 || this.iCount >= this.iRows || !string4.equals(FOSSIL)) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private bioStratStruct ParseData(String string, String string2, bioStratStruct bioStratStruct2) {
        int n = 0;
        if (string.equals(KEY)) {
            bioStratStruct2.sKID = new String(string2);
        }
        if (string.equals(ID)) {
            bioStratStruct2.sKEY = new String(string2);
        }
        if (string.equals(SPECIES)) {
            bioStratStruct2.species = new String(string2);
        }
        if (string.equals(GENUS)) {
            bioStratStruct2.sGenus = new String(string2);
        }
        if (string.equals(TRIBE)) {
            bioStratStruct2.sTribe = new String(string2);
        }
        if (string.equals(SUB_FAMILY)) {
            bioStratStruct2.subfamily = new String(string2);
        }
        if (string.equals(FAMILY)) {
            bioStratStruct2.sFamily = new String(string2);
        }
        if (string.equals(SUPER_FAMILY)) {
            bioStratStruct2.superfamily = new String(string2);
        }
        if (string.equals(INFRA_ORDER)) {
            bioStratStruct2.sInfraorder = new String(string2);
        }
        if (string.equals(SUB_ORDER)) {
            bioStratStruct2.suborder = new String(string2);
        }
        if (string.equals(ORDER)) {
            bioStratStruct2.sOrder = new String(string2);
        }
        if (string.equals(SUB_CLASS)) {
            bioStratStruct2.subclass = new String(string2);
        }
        if (string.equals(CLASS)) {
            bioStratStruct2.sClass = new String(string2);
        }
        if (string.equals(SUPER_CLASS)) {
            bioStratStruct2.superclass = new String(string2);
        }
        if (string.equals(SUB_PHYLUM)) {
            bioStratStruct2.subphylum = new String(string2);
        }
        if (string.equals(PHYLUM)) {
            bioStratStruct2.sPhylum = new String(string2);
        }
        if (string.equals(SUPER_PHYLUM)) {
            bioStratStruct2.superphylum = new String(string2);
        }
        if (string.equals(SUB_KINGDOM)) {
            bioStratStruct2.subkingdom = new String(string2);
        }
        if (string.equals(KINGDOM)) {
            bioStratStruct2.sKingdom = new String(string2);
        }
        if (string.equals(AUTHOR)) {
            bioStratStruct2.sAuthor = new String(string2);
        }
        if (string.equals(AGE_TOP)) {
            if (!bioStratStruct2.sKEY.equals("0")) {
                bioStratStruct2.sKey_e = new String(string2);
                if (this.stICS != null) {
                    for (n = 0; n < this.stICS.iCount; ++n) {
                        if (!bioStratStruct2.sKey_e.equals(this.stICS.stItem[n].sKEY)) continue;
                        bioStratStruct2.dFrom = this.stICS.stItem[n].dAgeStart;
                        bioStratStruct2.system_e = new String(this.stICS.stItem[n].system);
                        bioStratStruct2.series_e = new String(this.stICS.stItem[n].series);
                        bioStratStruct2.subSystem_e = new String(this.stICS.stItem[n].subSystem);
                        bioStratStruct2.subSeries_e = new String(this.stICS.stItem[n].subSeries);
                    }
                }
            } else if (cmnString.isNumeric(string2)) {
                bioStratStruct2.dFrom = cmnString.stringToDouble(string2);
                if (this.stICS != null) {
                    for (n = 0; n < this.stICS.iCount; ++n) {
                        if (!(bioStratStruct2.dFrom >= this.stICS.stItem[n].dAgeStart) || !(bioStratStruct2.dFrom < this.stICS.stItem[n].dAgeEnd)) continue;
                        bioStratStruct2.sKey_e = new String(this.stICS.stItem[n].sKEY);
                        bioStratStruct2.system_e = new String(this.stICS.stItem[n].system);
                        bioStratStruct2.series_e = new String(this.stICS.stItem[n].series);
                        bioStratStruct2.subSystem_e = new String(this.stICS.stItem[n].subSystem);
                        bioStratStruct2.subSeries_e = new String(this.stICS.stItem[n].subSeries);
                    }
                }
            }
        }
        if (string.equals(AGE_BASE)) {
            if (!bioStratStruct2.sKEY.equals("0")) {
                bioStratStruct2.sKey_l = new String(string2);
                if (this.stICS != null) {
                    for (n = 0; n < this.stICS.iCount; ++n) {
                        if (!bioStratStruct2.sKey_l.equals(this.stICS.stItem[n].sKEY)) continue;
                        bioStratStruct2.dTo = this.stICS.stItem[n].dAgeEnd;
                        bioStratStruct2.system_l = new String(this.stICS.stItem[n].system);
                        bioStratStruct2.series_l = new String(this.stICS.stItem[n].series);
                        bioStratStruct2.subSystem_l = new String(this.stICS.stItem[n].subSystem);
                        bioStratStruct2.subSeries_l = new String(this.stICS.stItem[n].subSeries);
                    }
                }
            } else if (cmnString.isNumeric(string2)) {
                bioStratStruct2.dTo = cmnString.stringToDouble(string2);
                if (this.stICS != null) {
                    for (n = 0; n < this.stICS.iCount; ++n) {
                        if (!(bioStratStruct2.dTo > this.stICS.stItem[n].dAgeStart) || !(bioStratStruct2.dTo <= this.stICS.stItem[n].dAgeEnd)) continue;
                        bioStratStruct2.sKey_l = new String(this.stICS.stItem[n].sKEY);
                        bioStratStruct2.system_l = new String(this.stICS.stItem[n].system);
                        bioStratStruct2.series_l = new String(this.stICS.stItem[n].series);
                        bioStratStruct2.subSystem_l = new String(this.stICS.stItem[n].subSystem);
                        bioStratStruct2.subSeries_l = new String(this.stICS.stItem[n].subSeries);
                    }
                }
            }
        }
        if (string.equals(TYPE)) {
            bioStratStruct2.sFossilID = new String(string2);
            if (this.stFossils != null) {
                for (n = 0; n < this.stFossils.iCount; ++n) {
                    if (!bioStratStruct2.sFossilID.equals(this.stFossils.stFossil[n].sID)) continue;
                    bioStratStruct2.sFossil = new String(this.stFossils.stFossil[n].sPhrase);
                }
            }
        }
        return bioStratStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

