/*
 * Decompiled with CFR 0.152.
 */
package horizon.bio.gui;

import horizon.bio.gui.bioFossilsTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import mask.maskSymbolsListStruct;

public class bioFossilsFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private maskSymbolsListStruct st = null;
    private bioFossilsTable pTable = null;
    private String sID = "";
    private String sName = "";
    private JButton btnSelect = new JButton();
    private JButton btnCancel = new JButton();

    public bioFossilsFrame(Observable observable, maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.notifier = observable;
            this.st = maskSymbolsListStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.setTitle("Select a General Fossil Group");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnSelect.setFont(new Font("Dialog", 1, 11));
        this.btnSelect.setText("Select");
        this.btnSelect.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        jPanel2.setLayout(new BorderLayout());
        this.pTable = new bioFossilsTable(this.st);
        jScrollPane = this.pTable.getScrollPane();
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.btnSelect, null);
        jPanel.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)jScrollPane, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(400, dimension.height - 50));
        this.setLocation((dimension.width - this.getSize().width) / 2, 10);
        this.setResizable(false);
        this.setVisible(true);
    }

    public String getID() {
        return this.sID;
    }

    @Override
    public String getName() {
        return this.sName;
    }

    private void select() {
        int n = -1;
        if (this.st != null) {
            n = this.pTable.getRow();
            this.sID = new String(this.st.stItem[n].sID);
            this.sName = new String(this.st.stItem[n].sName);
        }
        this.notifier.notifyObservers(new String("Fossil Selected"));
    }

    public void close() {
        this.notifier = null;
        this.st = null;
        this.pTable = null;
        this.sID = null;
        this.sName = null;
        this.btnSelect = null;
        this.btnCancel = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnSelect) {
            this.select();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.close();
        }
    }
}

