/*
 * Decompiled with CFR 0.152.
 */
package brine.plot;

import brine.math.brineMath;
import brine.plot.brinePlotStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class brineStiffPlot
extends Canvas {
    private brinePlotStruct st = null;
    public static final Color cCA = new Color(160, 160, 160);
    public static final Color cMG = new Color(34, 139, 34);
    public static final Color cNA = new Color(0, 191, 255);
    public static final Color cK = new Color(0, 0, 180);
    public static final Color[] CLR_CATIONS = new Color[]{cCA, cMG, cNA, cK};
    public static final Color cCL = new Color(173, 255, 47);
    public static final Color cBR = new Color(180, 0, 0);
    public static final Color cI = new Color(180, 0, 180);
    public static final Color cSO4 = new Color(102, 102, 0);
    public static final Color cHCO3 = new Color(250, 128, 114);
    public static final Color cCO3 = new Color(255, 182, 193);
    public static final Color[] CLR_ANIONS = new Color[]{cCL, cBR, cI, cSO4, cHCO3, cCO3};
    public static final int _CATIONS = 0;
    public static final int _ANIONS = 1;
    public static final int[] CATIONS = brineMath.CATIONS;
    public static final int[] ANIONS = brineMath.ANIONS;
    private int iWidth = 260;
    private int iHeight = 135;
    private int iXBegin = 40;
    private int iYBegin = 60;
    private int iXWidth = 200;
    private int iYHeight = 75;
    private int[] iX = null;
    private int[] iY = null;

    public brineStiffPlot(brinePlotStruct brinePlotStruct2, int n, int n2) {
        this.st = brinePlotStruct2;
        this.convertDataToPixels(n, n2);
        this.setBackground(Color.white);
    }

    public void close() {
        if (this.st != null) {
            this.st.delete();
        }
        this.st = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        int n = this.getWidth();
        int n2 = this.getHeight();
        bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        this.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setData(brinePlotStruct brinePlotStruct2) {
        this.st = brinePlotStruct2;
        if (this.st != null) {
            this.convertDataToPixels(0, 0);
        }
    }

    private void convertDataToPixels(int n, int n2) {
        int n3 = 0;
        int n4 = 6;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 100.0;
        double d5 = 75.0;
        double d6 = 0.0;
        double d7 = 25.0;
        this.iX = new int[n4];
        this.iY = new int[n4];
        boolean bl = false;
        if (this.st != null) {
            block5: for (int i = 1; i < 4; ++i) {
                d2 = d6 + (double)i * d7;
                n3 = (int)((double)this.iYHeight * (d2 - d6) / (d5 - d6));
                n5 = this.iYBegin + n3;
                switch (i) {
                    case 1: {
                        d = 100.0 - (this.st.per_meql_cations[2] + this.st.per_meql_cations[3]);
                        this.iX[0] = n + this.iXBegin + (int)d;
                        this.iY[0] = n2 + n5;
                        d = this.st.per_meql_anions[0];
                        if (this.st.per_meql_anions[1] > 0.0) {
                            d += this.st.per_meql_anions[1];
                        }
                        if (this.st.per_meql_anions[2] > 0.0) {
                            d += this.st.per_meql_anions[2];
                        }
                        this.iX[1] = n + this.iXBegin + 100 + (int)d;
                        this.iY[1] = n2 + n5;
                        continue block5;
                    }
                    case 2: {
                        d = this.st.per_meql_anions[4] + this.st.per_meql_anions[5];
                        this.iX[2] = n + this.iXBegin + 100 + (int)d;
                        this.iY[2] = n2 + n5;
                        d = 100.0 - this.st.per_meql_cations[0];
                        this.iX[5] = n + this.iXBegin + (int)d;
                        this.iY[5] = n2 + n5;
                        continue block5;
                    }
                    case 3: {
                        d = this.st.per_meql_anions[3];
                        this.iX[3] = n + this.iXBegin + 100 + (int)d;
                        this.iY[3] = n2 + n5;
                        d = 100.0 - this.st.per_meql_cations[1];
                        this.iX[4] = n + this.iXBegin + (int)d;
                        this.iY[4] = n2 + n5;
                    }
                }
            }
        }
    }

    public void drawLinearXAxisGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 200.0;
        double d4 = 0.0;
        double d5 = 25.0;
        Font font = new Font("Monospaced", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n6 = (int)((double)this.iXWidth * d5 / (d3 - d4));
        n4 = this.iXBegin;
        while (n4 < this.iXBegin + this.iXWidth + 5) {
            d = d4 + (double)n3 * d5;
            n5 = (int)((double)this.iXWidth * (d - d4) / (d3 - d4));
            n4 = this.iXBegin + n5;
            if (n4 < this.iXBegin + this.iXWidth + 5) {
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n + n4, n2 + this.iYBegin, n + n4, n2 + this.iYBegin + this.iYHeight);
                graphics.setColor(Color.black);
                d = -100.0 + (double)Math.round(d * 1000.0) / 1000.0;
                n7 = (int)Math.abs(d);
                graphics.drawString("" + n7, n + n4, n2 + this.iYBegin);
            }
            ++n3;
        }
    }

    public void drawLinearYAxisGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        String string = "";
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 75.0;
        double d4 = 0.0;
        double d5 = 25.0;
        Font font = new Font("Monospaced", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n6 = (int)((double)this.iYHeight * d5 / (d3 - d4));
        n4 = this.iYBegin + this.iYHeight;
        block6: for (n3 = 0; n3 < 4; ++n3) {
            d = d4 + (double)n3 * d5;
            n5 = (int)((double)this.iYHeight * (d - d4) / (d3 - d4));
            n4 = this.iYBegin + n5;
            if (n4 <= this.iYBegin - 5) continue;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n + this.iXBegin, n2 + n4, n + this.iXBegin + this.iXWidth, n2 + n4);
            graphics.setColor(Color.black);
            switch (n3) {
                case 0: {
                    continue block6;
                }
                case 1: {
                    string = new String("Na+K");
                    graphics.drawString(string, n + 5, n2 + n4);
                    string = new String("Cl");
                    if (this.st.per_meql_anions[1] > 1.0) {
                        string = new String(string + "+Br");
                    }
                    if (this.st.per_meql_anions[2] > 1.0) {
                        string = new String(string + "+I");
                    }
                    graphics.drawString(string, n + this.iXBegin + this.iXWidth + 5, n2 + n4);
                    continue block6;
                }
                case 2: {
                    string = new String("Ca");
                    graphics.drawString(string, n + 5, n2 + n4);
                    string = new String("HCO3+CO3");
                    graphics.drawString(string, n + this.iXBegin + this.iXWidth + 5, n2 + n4);
                    continue block6;
                }
                case 3: {
                    string = new String("Mg");
                    graphics.drawString(string, n + 5, n2 + n4);
                    string = new String("SO4");
                    graphics.drawString(string, n + this.iXBegin + this.iXWidth + 5, n2 + n4);
                }
            }
        }
    }

    public void drawPlotData(Graphics graphics) {
        graphics.setColor(new Color(0, 180, 0));
        if (this.iX != null) {
            graphics.fillPolygon(this.iX, this.iY, 6);
        }
    }

    public void draw(Graphics graphics, int n, int n2) {
        String string = "";
        int n3 = 0;
        Font font = new Font("Monospaced", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        string = new String("Stiff Diagram");
        n3 = string.length();
        graphics.drawString(string, n + this.iXBegin + 100 - n3 * 4, n2 + this.iYBegin - 40);
        string = new String("Cations");
        n3 = string.length();
        graphics.drawString(string, n + this.iXBegin + 30 - n3 * 4, n2 + this.iYBegin - 20);
        string = new String("% meq/l");
        n3 = string.length();
        graphics.drawString(string, n + this.iXBegin + 100 - n3 * 4, n2 + this.iYBegin - 20);
        string = new String("Anions");
        n3 = string.length();
        graphics.drawString(string, n + this.iXBegin + 170 - n3 * 4, n2 + this.iYBegin - 20);
        this.drawLinearXAxisGrid(graphics, n, n2);
        this.drawLinearYAxisGrid(graphics, n, n2);
        this.drawPlotData(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics, 0, 0);
    }
}

