/*
 * Decompiled with CFR 0.152.
 */
package brine.plot;

import brine.brineListStruct;
import brine.math.brineMath;
import brine.plot.brineCollinsPlot;
import brine.plot.brinePlotListStruct;
import brine.plot.brinePlotStruct;
import brine.plot.brineStiffPlot;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class brineSamplePlot
extends Canvas {
    private int iRow = 0;
    private brineListStruct stBrine = null;
    private brinePlotListStruct st = null;
    private brineStiffPlot plotStiff = null;
    private brineCollinsPlot plotCollins = null;
    public static final int _CATIONS = 0;
    public static final int _ANIONS = 1;
    public static final int[] CATIONS = brineMath.CATIONS;
    public static final int[] ANIONS = brineMath.ANIONS;
    private static final int _HEADER = 200;
    private static final int _TEXT = 20;
    private static final int _TEXT2 = 270;
    private static final int _UNIT = 10;
    private static final int _CA = 60;
    private static final int _MG = 115;
    private static final int _NA = 170;
    private static final int _K = 225;
    private static final int _CL = 280;
    private static final int _BR = 335;
    private static final int _I = 390;
    private static final int _SO4 = 445;
    private static final int _HCO3 = 500;
    private static final int _CO3 = 555;
    private static final int _TOP = 20;
    private static final int _LINE_0 = 40;
    private static final int _LINE_1 = 60;
    private static final int _LINE_2 = 80;
    private static final int _LINE_3 = 100;
    private static final int _LINE_4 = 120;
    private static final int _LINE_5 = 140;
    private static final int _LINE_6 = 160;
    private static final int _LINE_7 = 180;
    private static final int _LINE_8 = 200;
    private static final int _LINE_9 = 220;
    private static final int _LINE_10 = 510;
    private static final int _LINE_11 = 530;
    private static final int _LINE_12 = 550;
    private static final int _LINE_13 = 570;
    private static final int _LINE_14 = 590;
    private static final int _X_STIFF = 10;
    private static final int _Y_STIFF = 290;
    private static final int _X_COLLINS = 325;
    private static final int _Y_COLLINS = 230;
    private int iWidth = 625;
    private int iHeight = 650;

    public brineSamplePlot(brineListStruct brineListStruct2) {
        this.stBrine = brineListStruct2;
        this.setBrineData();
    }

    public void close() {
        if (this.st != null) {
            this.st.delete();
        }
        this.st = null;
        this.stBrine = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        int n = this.getWidth();
        int n2 = this.getHeight();
        bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        this.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setBrineData() {
        int n = 0;
        int n2 = 0;
        this.st = new brinePlotListStruct();
        if (this.stBrine != null) {
            int n3;
            n = brineMath.getRows(1);
            n2 = brineMath.getRows(0);
            this.st = new brinePlotListStruct();
            this.st.iCount = this.stBrine.iCount;
            this.st.stItem = new brinePlotStruct[this.st.iCount];
            for (n3 = 0; n3 < this.stBrine.iCount; ++n3) {
                this.st.stItem[n3] = new brinePlotStruct();
                this.st.stItem[n3].mgl_cations = new double[n2];
                this.st.stItem[n3].meql_cations = new double[n2];
                this.st.stItem[n3].per_meql_cations = new double[n2];
                this.st.stItem[n3].mgl_anions = new double[n];
                this.st.stItem[n3].meql_anions = new double[n];
                this.st.stItem[n3].per_meql_anions = new double[n];
            }
            for (n3 = 0; n3 < this.stBrine.iCount; ++n3) {
                this.st.stItem[n3].depthStart = this.stBrine.stItem[n3].dTOP;
                this.st.stItem[n3].depthEnd = this.stBrine.stItem[n3].dBASE;
                this.st.stItem[n3].mgl_cations = brineMath.get_mg_per_liter(0, n3, this.stBrine);
                this.st.stItem[n3].mgl_anions = brineMath.get_mg_per_liter(1, n3, this.stBrine);
                this.st.stItem[n3].meql_cations = brineMath.mg_to_meq_per_liter(0, this.st.stItem[n3].mgl_cations);
                this.st.stItem[n3].meql_anions = brineMath.mg_to_meq_per_liter(1, this.st.stItem[n3].mgl_anions);
                this.st.stItem[n3].per_meql_cations = brineMath.percent_meq_per_liter(0, this.st.stItem[n3].meql_cations);
                this.st.stItem[n3].per_meql_anions = brineMath.percent_meq_per_liter(1, this.st.stItem[n3].meql_anions);
            }
        }
    }

    public void setRow(int n) {
        this.iRow = n;
        this.plotStiff = new brineStiffPlot(this.st.stItem[n], 10, 290);
        this.plotCollins = new brineCollinsPlot(this.st.stItem[n]);
    }

    public void draw(Graphics graphics) {
        String string = "";
        int n = 0;
        Font font = new Font("Monospaced", 1, 14);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        string = new String("Brine Sample Plot");
        n = string.length();
        graphics.drawString(string, this.iWidth / 2 - n * 4, 20);
        font = new Font("Monospaced", 1, 12);
        graphics.setFont(font);
        if (this.stBrine != null && this.stBrine.stItem[this.iRow] != null) {
            if (this.stBrine.stItem[this.iRow].sName.length() > 0) {
                string = new String(this.stBrine.stItem[this.iRow].sName);
                if (this.stBrine.stItem[this.iRow].sAPI.length() > 0) {
                    string = new String(string + " (" + this.stBrine.stItem[this.iRow].sAPI + ")");
                }
                string = new String("Well: " + string);
                n = string.length();
                graphics.drawString(string, this.iWidth / 2 - n * 4, 40);
            }
            graphics.drawString("State:  " + this.stBrine.stItem[this.iRow].state, 20, 60);
            graphics.drawString("County: " + this.stBrine.stItem[this.iRow].sCounty, 20, 80);
            graphics.drawString("Field:  " + this.stBrine.stItem[this.iRow].sField, 20, 100);
            graphics.drawString("Formation: " + this.stBrine.stItem[this.iRow].sFORM, 270, 60);
            string = new String("" + this.stBrine.stItem[this.iRow].dTOP);
            if (this.stBrine.stItem[this.iRow].dBASE > 0.0) {
                string = new String(string + " - " + this.stBrine.stItem[this.iRow].dBASE);
            }
            graphics.drawString("Depth:     " + string, 270, 80);
            graphics.drawString("Latitude:  " + this.stBrine.stItem[this.iRow].dLatitude, 270, 100);
            graphics.drawString("Longitude: " + this.stBrine.stItem[this.iRow].dLongitude, 270, 120);
            this.plotTable(graphics);
            this.drawDiagrams(graphics);
            font = new Font("Monospaced", 1, 12);
            graphics.setFont(font);
            graphics.setColor(Color.black);
            string = new String("General Analysis");
            n = string.length();
            graphics.drawString(string, this.iWidth / 2 - n * 4, 510);
            if (this.stBrine.stItem[this.iRow].dPH > 0.0) {
                graphics.drawString("PH: " + this.stBrine.stItem[this.iRow].dPH, 20, 530);
            } else {
                graphics.drawString("PH: ", 20, 530);
            }
            if (this.stBrine.stItem[this.iRow].dDEG > 0.0) {
                graphics.drawString("Temp. F deg: " + this.stBrine.stItem[this.iRow].dDEG, 20, 550);
            } else {
                graphics.drawString("Temp. F deg: ", 20, 550);
            }
            if (this.stBrine.stItem[this.iRow].dSPGR > 0.0) {
                graphics.drawString("Specific Gravity: " + this.stBrine.stItem[this.iRow].dSPGR, 20, 570);
            } else {
                graphics.drawString("Specific Gravity: ", 20, 570);
            }
            if (this.stBrine.stItem[this.iRow].dOHM > 0.0) {
                graphics.drawString("Rw: " + this.stBrine.stItem[this.iRow].dOHM, 270, 530);
            } else {
                graphics.drawString("Rw: ", 270, 530);
            }
            if (this.stBrine.stItem[this.iRow].dOHM75 > 0.0) {
                graphics.drawString("Rw @ 75 F deg: " + this.stBrine.stItem[this.iRow].dOHM75, 270, 550);
            } else {
                graphics.drawString("Rw @ 75 F deg: ", 270, 550);
            }
            if (this.stBrine.stItem[this.iRow].dOHME > 0.0) {
                graphics.drawString("Est. Rw: " + this.stBrine.stItem[this.iRow].dOHME, 270, 570);
            } else {
                graphics.drawString("Est. Rw: ", 270, 570);
            }
            string = this.stBrine.stItem[this.iRow].dTDS > 0.0 ? new String("Total Dissolved Solids: " + this.stBrine.stItem[this.iRow].dTDS + " " + "mg/l") : new String("Total Dissolved Solids: ");
            n = string.length();
            graphics.drawString(string, this.iWidth / 2 - n * 4, 590);
        }
    }

    public void plotTable(Graphics graphics) {
        String string = "";
        int n = 0;
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stBrine.stItem[this.iRow].source.length() > 0) {
            string = new String("Source: " + this.stBrine.stItem[this.iRow].source.length());
            n = string.length();
            graphics.drawString(string, this.iWidth / 2 - n * 4, 140);
        }
        graphics.setColor(new Color(0, 180, 0));
        graphics.drawLine(0, 147, this.iWidth, 147);
        graphics.setColor(Color.black);
        graphics.drawString(" Unit ", 10, 160);
        graphics.drawString("Ca    ", 60, 160);
        graphics.drawString("Mg    ", 115, 160);
        graphics.drawString("Na    ", 170, 160);
        graphics.drawString("K     ", 225, 160);
        graphics.drawString("Cl    ", 280, 160);
        graphics.drawString("Br    ", 335, 160);
        graphics.drawString("I     ", 390, 160);
        graphics.drawString("SO4   ", 445, 160);
        graphics.drawString("HCO3  ", 500, 160);
        graphics.drawString("CO3   ", 555, 160);
        graphics.setColor(new Color(0, 180, 0));
        graphics.drawLine(0, 167, this.iWidth, 167);
        graphics.drawLine(56, 147, 56, 222);
        graphics.drawLine(276, 147, 276, 222);
        font = new Font("Monospaced", 1, 10);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString("   mg/l", 10, 180);
        if (this.st.stItem[this.iRow].mgl_cations[0] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_cations[0], 60, 180);
        }
        if (this.st.stItem[this.iRow].mgl_cations[1] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_cations[1], 115, 180);
        }
        if (this.st.stItem[this.iRow].mgl_cations[2] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_cations[2], 170, 180);
        }
        if (this.st.stItem[this.iRow].mgl_cations[3] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_cations[3], 225, 180);
        }
        if (this.st.stItem[this.iRow].mgl_anions[0] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_anions[0], 280, 180);
        }
        if (this.st.stItem[this.iRow].mgl_anions[1] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_anions[1], 335, 180);
        }
        if (this.st.stItem[this.iRow].mgl_anions[2] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_anions[2], 390, 180);
        }
        if (this.st.stItem[this.iRow].mgl_anions[3] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_anions[3], 445, 180);
        }
        if (this.st.stItem[this.iRow].mgl_anions[4] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_anions[4], 500, 180);
        }
        if (this.st.stItem[this.iRow].mgl_anions[5] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].mgl_anions[5], 555, 180);
        }
        graphics.drawString("  meq/l", 10, 200);
        if (this.st.stItem[this.iRow].meql_cations[0] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_cations[0], 60, 200);
        }
        if (this.st.stItem[this.iRow].meql_cations[1] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_cations[1], 115, 200);
        }
        if (this.st.stItem[this.iRow].meql_cations[2] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_cations[2], 170, 200);
        }
        if (this.st.stItem[this.iRow].meql_cations[3] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_cations[3], 225, 200);
        }
        if (this.st.stItem[this.iRow].meql_anions[0] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_anions[0], 280, 200);
        }
        if (this.st.stItem[this.iRow].meql_anions[1] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_anions[1], 335, 200);
        }
        if (this.st.stItem[this.iRow].meql_anions[2] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_anions[2], 390, 200);
        }
        if (this.st.stItem[this.iRow].meql_anions[3] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_anions[3], 445, 200);
        }
        if (this.st.stItem[this.iRow].meql_anions[4] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_anions[4], 500, 200);
        }
        if (this.st.stItem[this.iRow].meql_anions[5] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].meql_anions[5], 555, 200);
        }
        graphics.drawString("% meq/l", 10, 220);
        if (this.st.stItem[this.iRow].per_meql_cations[0] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_cations[0], 60, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_cations[1] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_cations[1], 115, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_cations[2] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_cations[2], 170, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_cations[3] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_cations[3], 225, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_anions[0] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_anions[0], 280, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_anions[1] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_anions[1], 335, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_anions[2] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_anions[2], 390, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_anions[3] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_anions[3], 445, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_anions[4] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_anions[4], 500, 220);
        }
        if (this.st.stItem[this.iRow].per_meql_anions[5] > 0.0) {
            graphics.drawString("" + this.st.stItem[this.iRow].per_meql_anions[5], 555, 220);
        }
        graphics.setColor(new Color(0, 180, 0));
        graphics.drawLine(0, 222, this.iWidth, 222);
    }

    public void drawDiagrams(Graphics graphics) {
        this.plotStiff.draw(graphics, 10, 290);
        this.plotCollins.draw(graphics, 325, 230);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

