/*
 * Decompiled with CFR 0.152.
 */
package brine.plot;

import brine.brineListStruct;
import brine.brineStandardTools;
import brine.math.brineMath;
import brine.plot.brinePlotListStruct;
import brine.plot.brinePlotStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class brinePlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private double dIncrementDepth = 0.0;
    private int iStartDepthLabel = 10;
    public static final Color cCA = new Color(160, 160, 160);
    public static final Color cMG = new Color(34, 139, 34);
    public static final Color cNA = new Color(0, 191, 255);
    public static final Color cK = new Color(0, 0, 180);
    public static final Color[] CLR_CATIONS = new Color[]{cCA, cMG, cNA, cK};
    public static final Color cCL = new Color(173, 255, 47);
    public static final Color cBR = new Color(180, 0, 0);
    public static final Color cI = new Color(180, 0, 180);
    public static final Color cSO4 = new Color(102, 102, 0);
    public static final Color cHCO3 = new Color(250, 128, 114);
    public static final Color cCO3 = new Color(255, 182, 193);
    public static final Color[] CLR_ANIONS = new Color[]{cCL, cBR, cI, cSO4, cHCO3, cCO3};
    public static final int _CATIONS = 0;
    public static final int _ANIONS = 1;
    public static final int[] CATIONS = brineMath.CATIONS;
    public static final int[] ANIONS = brineMath.ANIONS;
    private brinePlotListStruct st = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public brinePlotTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        if (this.st != null) {
            this.st.delete();
        }
        this.st = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
    }

    public void setBrineData(brineListStruct brineListStruct2) {
        int n = 0;
        int n2 = 0;
        this.st = new brinePlotListStruct();
        if (brineListStruct2 != null) {
            int n3;
            n = brineMath.getRows(1);
            n2 = brineMath.getRows(0);
            this.st = new brinePlotListStruct();
            this.st.iCount = brineListStruct2.iCount;
            this.st.stItem = new brinePlotStruct[this.st.iCount];
            for (n3 = 0; n3 < brineListStruct2.iCount; ++n3) {
                this.st.stItem[n3] = new brinePlotStruct();
                this.st.stItem[n3].mgl_cations = new double[n2];
                this.st.stItem[n3].meql_cations = new double[n2];
                this.st.stItem[n3].per_meql_cations = new double[n2];
                this.st.stItem[n3].mgl_anions = new double[n];
                this.st.stItem[n3].meql_anions = new double[n];
                this.st.stItem[n3].per_meql_anions = new double[n];
            }
            for (n3 = 0; n3 < brineListStruct2.iCount; ++n3) {
                this.st.stItem[n3].depthStart = brineListStruct2.stItem[n3].dTOP;
                this.st.stItem[n3].depthEnd = brineListStruct2.stItem[n3].dBASE;
                this.st.stItem[n3].mgl_cations = brineMath.get_mg_per_liter(0, n3, brineListStruct2);
                this.st.stItem[n3].mgl_anions = brineMath.get_mg_per_liter(1, n3, brineListStruct2);
                this.st.stItem[n3].meql_cations = brineMath.mg_to_meq_per_liter(0, this.st.stItem[n3].mgl_cations);
                this.st.stItem[n3].meql_anions = brineMath.mg_to_meq_per_liter(1, this.st.stItem[n3].mgl_anions);
                this.st.stItem[n3].per_meql_cations = brineMath.percent_meq_per_liter(0, this.st.stItem[n3].meql_cations);
                this.st.stItem[n3].per_meql_anions = brineMath.percent_meq_per_liter(1, this.st.stItem[n3].meql_anions);
            }
        }
    }

    public void drawGrid(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = true;
        double d = 0.0;
        double d2 = 0.0;
        int n7 = n3 / 5;
        int n8 = n2 + n3;
        int n9 = n - 58;
        boolean bl3 = false;
        int n10 = 0;
        int n11 = 0;
        double d3 = 0.0;
        double d4 = 100.0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n10 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n11 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n6) : n4 + n5 * n6 + 100;
                if (n11 < 100 || n11 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n2, n11, n8, n11);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n2, n10, n8, n10);
        }
        graphics.setColor(Color.gray);
        graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
        for (n4 = 0; n4 <= n3; n4 += n7) {
            if (n4 == 0 || n4 == n3) {
                graphics.drawLine(n4 + n2, 25, n4 + n2, 100 + this.iLogHeight);
                continue;
            }
            graphics.drawLine(n4 + n2, 100, n4 + n2, 100 + this.iLogHeight);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n8, 25);
        graphics.drawLine(n2, 100, n8, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n8, 25, n8, 100 + this.iLogHeight);
    }

    public void drawTrackLabels(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n5 = -1;
        int n6 = 0;
        String string = "";
        String string2 = "";
        double d = 0.0;
        double d2 = 100.0;
        int n7 = n2 + n3;
        int n8 = n - 58;
        int[] nArray = null;
        Color[] colorArray = null;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        Font font = new Font("Serif", 1, 10);
        graphics.setFont(font);
        switch (n8) {
            case 0: {
                nArray = CATIONS;
                colorArray = CLR_CATIONS;
                n9 = brineMath.getRows(0);
                break;
            }
            case 1: {
                nArray = ANIONS;
                colorArray = CLR_ANIONS;
                n9 = brineMath.getRows(1);
            }
        }
        string = new String("% mg/l");
        n6 = string.length();
        graphics.setColor(Color.black);
        graphics.drawString(string, n2 + n3 / 2 - n6 * 4, 53);
        graphics.drawString("" + d, n2 + 1, 53);
        string2 = new String("" + d2);
        n6 = string2.length();
        graphics.drawString("" + d2, n7 - n6 * 5, 53);
        n5 = 1;
        for (n4 = 0; n4 < n9; ++n4) {
            switch (n4) {
                case 1: 
                case 3: 
                case 5: {
                    n10 = n2 + 10;
                    break;
                }
                case 0: {
                    n10 = n2 + 60;
                    break;
                }
                case 2: {
                    n10 = n2 + 60;
                    n5 = 2;
                    break;
                }
                case 4: {
                    n10 = n2 + 60;
                    n5 = 3;
                }
            }
            graphics.setColor(colorArray[n4]);
            string = new String(brineStandardTools.CURVES[nArray[n4]][1]);
            n6 = string.length();
            n11 = 25 + (n5 + 2) * 14;
            graphics.drawString(string, n10, n11);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n2, 25, n7, 25);
        string = new String(iqstratTracksStruct.BRINE_TRACK_DESC[n8]);
        n6 = string.length();
        graphics.drawString(string, n2 + n3 / 2 - 9 * n6 / 4, 39);
    }

    public void drawTrackCurves(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        int n7 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 100.0;
        double[] dArray = null;
        double d4 = 0.0;
        double d5 = 0.0;
        int n8 = n2 + n3;
        int n9 = n - 58;
        int[] nArray = null;
        Color[] colorArray = null;
        int n10 = 0;
        switch (n9) {
            case 0: {
                nArray = CATIONS;
                colorArray = CLR_CATIONS;
                n10 = brineMath.getRows(0);
                break;
            }
            case 1: {
                nArray = ANIONS;
                colorArray = CLR_ANIONS;
                n10 = brineMath.getRows(1);
            }
        }
        if (this.st != null) {
            for (int i = 0; i < this.st.iCount; ++i) {
                switch (n9) {
                    case 0: {
                        dArray = this.st.stItem[i].per_meql_cations;
                        break;
                    }
                    case 1: {
                        dArray = this.st.stItem[i].per_meql_anions;
                    }
                }
                d4 = this.st.stItem[i].depthStart;
                d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                n6 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d;
                }
                n7 = 4;
                if (this.st.stItem[i].depthEnd > this.st.stItem[i].depthStart) {
                    d4 = this.st.stItem[i].depthEnd;
                    d = (double)this.iLogHeight * (d4 - this.depthStart) / (this.depthEnd - this.depthStart);
                    n7 = 100 + (int)d;
                    if (this.iDataType == 1) {
                        n7 = this.iHeight - (int)d;
                    }
                }
                if (n6 <= 100 || n7 <= 100 || n6 >= this.iHeight || n7 >= this.iHeight) continue;
                n4 = 0;
                if (n6 >= 100 && n6 < this.iHeight) {
                    n4 = 1;
                }
                if (n7 > 100 && n7 <= this.iHeight) {
                    n4 = 2;
                }
                for (int j = 0; j < n10; ++j) {
                    if (!(dArray[j] > 0.0)) continue;
                    d5 = dArray[j];
                    if (d5 < 0.0) {
                        d5 = 0.0;
                    }
                    if (d5 >= 98.0) {
                        d5 = 98.0;
                    }
                    d = (double)n3 * d5 / d3;
                    n5 = n2 + (int)d;
                    graphics.setColor(colorArray[j]);
                    if (n4 != 1 && n4 != 2) continue;
                    if (n4 == 2) {
                        graphics.fillRect(n5, n6, 4, n7 - n6);
                        continue;
                    }
                    graphics.fillRect(n5, n6, 4, 4);
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 4;
        if (n == 58 || n == 59) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n, n2, n3);
            this.drawTrackLabels(graphics, n, n2, n3);
            this.drawTrackCurves(graphics, n, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

