/*
 * Decompiled with CFR 0.152.
 */
package brine.plot;

import brine.brineListStruct;
import brine.math.brineMath;
import brine.plot.brineDiamondPlot;
import brine.plot.brinePlotListStruct;
import brine.plot.brinePlotStruct;
import brine.plot.brineTernaryPlot;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class brinePiperPlot
extends Canvas {
    private int iRow = -1;
    private brineListStruct stBrine = null;
    private brinePlotListStruct st = null;
    private brineTernaryPlot pCations = null;
    private brineTernaryPlot pAnions = null;
    private brineDiamondPlot pDiamond = null;
    public static final int _CATIONS = 0;
    public static final int _ANIONS = 1;
    public static final int[] CATIONS = brineMath.CATIONS;
    public static final int[] ANIONS = brineMath.ANIONS;
    private static final int _TOP = 20;
    private static final int _TOP2 = 40;
    private int iWidth = 650;
    private int iHeight = 650;

    public brinePiperPlot(brineListStruct brineListStruct2) {
        this.stBrine = brineListStruct2;
        this.setBrineData();
    }

    public void close() {
        if (this.st != null) {
            this.st.delete();
        }
        this.st = null;
        this.stBrine = null;
        if (this.pCations != null) {
            this.pCations.close();
        }
        this.pCations = null;
        if (this.pAnions != null) {
            this.pAnions.close();
        }
        this.pAnions = null;
        if (this.pDiamond != null) {
            this.pDiamond.close();
        }
        this.pDiamond = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public BufferedImage getImage() {
        BufferedImage bufferedImage = null;
        int n = this.getWidth();
        int n2 = this.getHeight();
        bufferedImage = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, n, n2);
        this.paint(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    public void setBrineData() {
        int n = 0;
        int n2 = 0;
        this.st = new brinePlotListStruct();
        if (this.stBrine != null) {
            int n3;
            n = brineMath.getRows(1);
            n2 = brineMath.getRows(0);
            this.st = new brinePlotListStruct();
            this.st.iCount = this.stBrine.iCount;
            this.st.stItem = new brinePlotStruct[this.st.iCount];
            for (n3 = 0; n3 < this.stBrine.iCount; ++n3) {
                this.st.stItem[n3] = new brinePlotStruct();
                this.st.stItem[n3].mgl_cations = new double[n2];
                this.st.stItem[n3].meql_cations = new double[n2];
                this.st.stItem[n3].per_meql_cations = new double[n2];
                this.st.stItem[n3].mgl_anions = new double[n];
                this.st.stItem[n3].meql_anions = new double[n];
                this.st.stItem[n3].per_meql_anions = new double[n];
            }
            for (n3 = 0; n3 < this.stBrine.iCount; ++n3) {
                this.st.stItem[n3].depthStart = this.stBrine.stItem[n3].dTOP;
                this.st.stItem[n3].depthEnd = this.stBrine.stItem[n3].dBASE;
                this.st.stItem[n3].mgl_cations = brineMath.get_mg_per_liter(0, n3, this.stBrine);
                this.st.stItem[n3].mgl_anions = brineMath.get_mg_per_liter(1, n3, this.stBrine);
                this.st.stItem[n3].meql_cations = brineMath.mg_to_meq_per_liter(0, this.st.stItem[n3].mgl_cations);
                this.st.stItem[n3].meql_anions = brineMath.mg_to_meq_per_liter(1, this.st.stItem[n3].mgl_anions);
                this.st.stItem[n3].per_meql_cations = brineMath.percent_meq_per_liter(0, this.st.stItem[n3].meql_cations);
                this.st.stItem[n3].per_meql_anions = brineMath.percent_meq_per_liter(1, this.st.stItem[n3].meql_anions);
            }
        }
    }

    public void setRow(int n) {
        this.iRow = n;
    }

    public void drawTitle(Graphics graphics) {
        int n = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        boolean bl = false;
        String string6 = "";
        String string7 = "";
        boolean bl2 = false;
        String string8 = "";
        String string9 = "";
        boolean bl3 = false;
        String string10 = "";
        boolean bl4 = false;
        int n2 = 0;
        Font font = new Font("Monospaced", 1, 16);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        string = new String("Piper Diagram");
        n2 = string.length();
        graphics.drawString(string, this.iWidth / 2 - n2 * 4, 20);
        font = new Font("Monospaced", 1, 14);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        if (this.stBrine != null && this.iRow > -1) {
            if (this.stBrine.stItem[this.iRow].sName.length() > 0) {
                string2 = new String(this.stBrine.stItem[this.iRow].sName);
                if (this.stBrine.sAPI.length() > 0) {
                    string2 = new String(string2 + " (" + this.stBrine.stItem[this.iRow].sAPI + ")");
                }
            }
            if (this.stBrine.iCount == 1) {
                string3 = new String("" + this.stBrine.stItem[this.iRow].dTOP);
                if (this.stBrine.stItem[this.iRow].dBASE > this.stBrine.stItem[this.iRow].dTOP) {
                    string3 = new String("" + this.stBrine.stItem[this.iRow].dTOP + " - " + this.stBrine.stItem[this.iRow].dBASE);
                }
                if (this.stBrine.stItem[this.iRow].sFORM.length() > 0) {
                    string4 = new String(this.stBrine.stItem[this.iRow].sFORM);
                }
            }
        } else if (this.stBrine != null && this.iRow == -1) {
            string5 = "";
            bl = true;
            string7 = "";
            bl2 = true;
            string9 = "";
            bl3 = true;
            for (n = 0; n < this.stBrine.iCount; ++n) {
                if (n == 0) {
                    string5 = new String(this.stBrine.stItem[n].sName);
                    string6 = new String(this.stBrine.stItem[n].sAPI);
                    string7 = new String(this.stBrine.stItem[n].sCounty);
                    string8 = new String(this.stBrine.stItem[n].state);
                    string9 = new String(this.stBrine.stItem[n].sLocation);
                }
                if (!string5.equals(this.stBrine.stItem[n].sName)) {
                    bl = false;
                }
                if (!string7.equals(this.stBrine.stItem[n].sCounty)) {
                    bl2 = false;
                }
                if (string9.equals(this.stBrine.stItem[n].sLocation)) continue;
                bl3 = false;
            }
            if (bl && string5.length() > 0) {
                string2 = new String(string5);
                if (string6.length() > 0) {
                    string2 = new String(string2 + " (" + string6 + ")");
                }
            } else if (bl3 && string9.length() > 8) {
                string2 = new String(string9);
                if (string7.length() > 0) {
                    string2 = new String(string2 + ", " + string7);
                }
                if (string8.length() > 0) {
                    string2 = new String(string2 + ", " + string8);
                }
            } else if (bl2 && string7.length() > 0) {
                string2 = new String(string7);
                if (string8.length() > 0) {
                    string2 = new String(string2 + ", " + string8);
                }
            }
        }
        n2 = string2.length();
        graphics.drawString(string2, this.iWidth / 2 - n2 * 4, 40);
        graphics.drawString(string3, 400, 60);
        graphics.drawString(string4, 400, 80);
    }

    public void drawData(Graphics graphics) {
        Font font = new Font("Monospaced", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.drawString("Sodium (Na)", 75, 150);
        graphics.drawString("Potassium (K)", 75, 170);
        graphics.drawString("Magnesium (Mg)", 75, 190);
        graphics.drawString("Calcium (Ca)", 75, 210);
        this.pCations = new brineTernaryPlot(1);
        this.pCations.setTitle("CATIONS");
        this.pCations.setVerticesTitle(0, "Mg");
        this.pCations.setVerticesTitle(1, "Na+K");
        this.pCations.setVerticesTitle(2, "Ca");
        this.pCations.draw(graphics, 25, 300);
        graphics.drawString("Bicarbonate (HCO3)", 450, 150);
        graphics.drawString("Carbonate (CO3)", 450, 170);
        graphics.drawString("Chloride (Cl)", 450, 190);
        graphics.drawString("Sulfate (SO4)", 450, 210);
        this.pAnions = new brineTernaryPlot(0);
        this.pAnions.setTitle("ANIONS");
        this.pAnions.setVerticesTitle(0, "SO4");
        this.pAnions.setVerticesTitle(1, "Cl");
        this.pAnions.setVerticesTitle(2, "HCO3+CO3");
        this.pAnions.draw(graphics, 325, 300);
        this.pDiamond = new brineDiamondPlot();
        this.pDiamond.setUpperLeftTitle("SO4+Cl");
        this.pDiamond.setLowerLeftTitle("Na+K");
        this.pDiamond.setUpperRightTitle("Ca+Mg");
        this.pDiamond.setLowerRightTitle("CO3+HCO3");
        this.pDiamond.draw(graphics, 175, 40);
        this.drawPoint(graphics);
    }

    public void draw(Graphics graphics) {
        this.drawTitle(graphics);
        this.drawData(graphics);
    }

    public void drawPoint(Graphics graphics) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        if (this.iRow > -1) {
            d = this.st.stItem[this.iRow].per_meql_cations[0];
            d2 = this.st.stItem[this.iRow].per_meql_cations[1];
            d3 = this.st.stItem[this.iRow].per_meql_cations[2] + this.st.stItem[this.iRow].per_meql_cations[3];
            d4 = this.st.stItem[this.iRow].per_meql_anions[0];
            d5 = this.st.stItem[this.iRow].per_meql_anions[3];
            d6 = d4 + d5;
            this.pCations.drawPoint(graphics, 25, 300, d, d2);
            this.pAnions.drawPoint(graphics, 325, 300, d4, d5);
            this.pDiamond.drawPoint(graphics, 175, 40, d3, d6);
        } else {
            for (int i = 0; i < this.st.iCount; ++i) {
                d = this.st.stItem[i].per_meql_cations[0];
                d2 = this.st.stItem[i].per_meql_cations[1];
                d3 = this.st.stItem[i].per_meql_cations[2] + this.st.stItem[i].per_meql_cations[3];
                d4 = this.st.stItem[i].per_meql_anions[0];
                d5 = this.st.stItem[i].per_meql_anions[3];
                d6 = d4 + d5;
                this.pCations.drawPoint(graphics, 25, 300, d, d2);
                this.pAnions.drawPoint(graphics, 325, 300, d4, d5);
                this.pDiamond.drawPoint(graphics, 175, 40, d3, d6);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

