/*
 * Decompiled with CFR 0.152.
 */
package brine.plot;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class brineDiamondPlot
extends Canvas {
    private double dRLower = 0.0;
    private double dRUpper = 100.0;
    private double dRIncrement = 20.0;
    private double dLLower = 0.0;
    private double dLUpper = 100.0;
    private double dLIncrement = 20.0;
    private String sULTitle = "";
    private String sLLTitle = "";
    private String sURTitle = "";
    private String sLRTitle = "";
    private int iXBegin = 10;
    private int iYBegin = 10;
    private int iWidth = 254;
    private int iHeight = 440;

    public brineDiamondPlot() {
        this.setBackground(Color.white);
    }

    public void close() {
        this.sULTitle = null;
        this.sLLTitle = null;
        this.sURTitle = null;
        this.sLRTitle = null;
    }

    public void setUpperLeftTitle(String string) {
        this.sULTitle = new String(string);
    }

    public void setLowerLeftTitle(String string) {
        this.sLLTitle = new String(string);
    }

    public void setUpperRightTitle(String string) {
        this.sURTitle = new String(string);
    }

    public void setLowerRightTitle(String string) {
        this.sLRTitle = new String(string);
    }

    public void drawAxisLabels(Graphics graphics, int n, int n2) {
        graphics.drawString(this.sULTitle, n + this.iXBegin + this.iWidth / 16, n2 + this.iYBegin + this.iHeight / 4);
        graphics.drawString(this.sLLTitle, n + this.iXBegin - 25, n2 + this.iYBegin + this.iHeight / 2 + 20);
        graphics.drawString(this.sURTitle, n + this.iXBegin + 3 * this.iWidth / 4 + 10, n2 + this.iYBegin + this.iHeight / 4);
        graphics.drawString(this.sLRTitle, n + this.iXBegin + this.iWidth, n2 + this.iYBegin + this.iHeight / 2 + 20);
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        this.drawRightGrid(graphics, n, n2);
        this.drawLeftGrid(graphics, n, n2);
    }

    public void drawRightGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n3 = (int)(1.0 + Math.abs(Math.ceil((this.dRUpper - this.dRLower) / this.dRIncrement)));
        for (int i = 0; i < n3; ++i) {
            d = (double)(this.iWidth * i) * this.dRIncrement / (2.0 * Math.abs(this.dRUpper - this.dRLower));
            d2 = ((double)this.iWidth / 2.0 - d) * Math.tan(1.0471975511965976);
            n4 = n + this.iXBegin + (int)d;
            n6 = n2 + this.iYBegin + (int)d2;
            n5 = n + this.iXBegin + this.iWidth / 2 + (int)d;
            n7 = n2 + this.iYBegin + this.iHeight / 2 + (int)d2;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n4, n6, n5, n7);
            graphics.setColor(Color.black);
            n8 = (int)(this.dRUpper - (double)i * this.dRIncrement);
            if (i != 0 && i < n3 - 1) {
                graphics.drawString("" + n8, n5, n7 + 10);
            }
            n8 = (int)(this.dRLower + (double)i * this.dRIncrement);
            if (i == 0 || i >= n3 - 1) continue;
            graphics.drawString("" + n8, n4 - 15, n6 - 5);
        }
    }

    public void drawLeftGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Font font = new Font("Monospaced", 1, 11);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n3 = (int)(1.0 + Math.abs(Math.ceil((this.dLUpper - this.dLLower) / this.dLIncrement)));
        for (int i = 0; i < n3; ++i) {
            d = (double)(this.iWidth * i) * this.dLIncrement / (2.0 * Math.abs(this.dLUpper - this.dLLower));
            d2 = ((double)this.iWidth / 2.0 - d) * Math.tan(1.0471975511965976);
            n4 = n + this.iXBegin + (int)d;
            n6 = n2 + this.iYBegin + this.iHeight - (int)d2;
            n5 = n + this.iXBegin + this.iWidth / 2 + (int)d;
            n7 = n2 + this.iYBegin + this.iHeight / 2 - (int)d2;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(n4, n6, n5, n7);
            graphics.setColor(Color.black);
            n8 = (int)(this.dLUpper - (double)i * this.dLIncrement);
            if (i != 0 && i < n3 - 1) {
                graphics.drawString("" + n8, n5 + 10, n7);
            }
            n8 = (int)(this.dLLower + (double)i * this.dLIncrement);
            if (i == 0 || i >= n3 - 1) continue;
            graphics.drawString("" + n8, n4 - 15, n6);
        }
    }

    public void drawPoint(Graphics graphics, int n, int n2, double d, double d2) {
        int n3 = 0;
        int n4 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        d3 = (double)this.iWidth * (d - this.dLLower) / (this.dLUpper - this.dLLower);
        d4 = (double)this.iWidth * (d2 - this.dRLower) / (this.dRUpper - this.dRLower);
        d5 = d3 - d4 * Math.sin(0.5235987755982988);
        d6 = d4 * Math.cos(0.5235987755982988);
        n3 = (int)(d6 * Math.sin(1.0471975511965976) + d5 * Math.cos(1.0471975511965976));
        n4 = (int)(d6 * Math.cos(1.0471975511965976) - d5 * Math.sin(1.0471975511965976));
        graphics.setColor(Color.red);
        graphics.fillRect(n + this.iXBegin + n3 - 3, n2 + (this.iYBegin + this.iHeight / 2) - n4 - 3, 6, 6);
    }

    public void draw(Graphics graphics, int n, int n2) {
        this.drawAxisLabels(graphics, n, n2);
        this.drawGrid(graphics, n, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

