/*
 * Decompiled with CFR 0.152.
 */
package brine.io;

import brine.brineColumnsStruct;
import brine.brineListStruct;
import brine.brineStruct;
import brine.brineUtility;
import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadBrineDataXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private int iComments = 0;
    public static final String ROOTNAME = "fluid_data";
    public static final String RECORDS = "records";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String MNEMONIC = "mnemonic";
    public static final String NAME = "name";
    public static final String UNIT = "unit";
    public static final String TYPE = "type";
    public static final String DATA = "data";
    public static final String ROW = "row";
    public static final String KEY = "KEY";
    public static final String STATE = "STATE";
    public static final String COUNTY = "COUNTY";
    public static final String FIELD = "FIELD";
    public static final String LOC = "LOC";
    public static final String NAMEA = "NAME";
    public static final String API = "API";
    public static final String LAT = "LAT";
    public static final String LONG = "LONG";
    public static final String KB = "KB";
    public static final String GL = "GL";
    public static final String DF = "DF";
    public static final String TGT = "TGT";
    public static final String FORM = "FORM";
    public static final String AGE = "AGE";
    public static final String SRC = "SRC";
    public static final String DATE = "DATE";
    public static final String TOP = "TOP";
    public static final String BASE = "BASE";
    public static final String _LI = "Li";
    public static final String _NA = "Na";
    public static final String _K = "K";
    public static final String _RB = "RB";
    public static final String _CS = "CS";
    public static final String _NA_K = "Na_K";
    public static final String _BE = "Be";
    public static final String _MG = "Mg";
    public static final String _CA = "Ca";
    public static final String _SR = "Sr";
    public static final String _BA = "Ba";
    public static final String _CR = "Cr";
    public static final String _CRII = "CrII";
    public static final String _CRIII = "CrIII";
    public static final String _MN = "Mn";
    public static final String _MNII = "MnII";
    public static final String _MNIII = "MnIII";
    public static final String _FE = "Fe";
    public static final String _FEII = "FeII";
    public static final String _FEIII = "FeIII";
    public static final String _CO = "Co";
    public static final String _COII = "CoII";
    public static final String _COIII = "CoIII";
    public static final String _NI = "Ni";
    public static final String _NIII = "NiII";
    public static final String _NIIII = "NiIII";
    public static final String _CU = "Cu";
    public static final String _CUII = "CuII";
    public static final String _AG = "Ag";
    public static final String _AU = "Au";
    public static final String _AUIII = "AuIII";
    public static final String _ZN = "Zn";
    public static final String _CD = "Cd";
    public static final String _HG = "Hg";
    public static final String _HGII = "HgII";
    public static final String _AL = "Al";
    public static final String _SN = "Sn";
    public static final String _SNII = "SnII";
    public static final String _SNIV = "SnIV";
    public static final String _PB = "Pb";
    public static final String _PBII = "PbII";
    public static final String _PBIV = "PbIV";
    public static final String _SB = "Sb";
    public static final String _SBIII = "SbIII";
    public static final String _SBV = "SbV";
    public static final String _BI = "Bi";
    public static final String _BIIII = "BiIII";
    public static final String _BIV = "BiV";
    public static final String _NH4 = "NH4";
    public static final String _F = "F";
    public static final String _CL = "Cl";
    public static final String _BR = "Br";
    public static final String _I = "I";
    public static final String _OH = "OH";
    public static final String _BO3 = "BO3";
    public static final String _CO3 = "CO3";
    public static final String _HCO3 = "HCO3";
    public static final String _CLO = "ClO";
    public static final String _CLO2 = "ClO2";
    public static final String _CLO3 = "ClO3";
    public static final String _CLO4 = "ClO4";
    public static final String _CN = "CN";
    public static final String _NCO = "NCO";
    public static final String _OCN = "OCN";
    public static final String _SCN = "SCN";
    public static final String _N = "N";
    public static final String _N3 = "N3";
    public static final String _NO2 = "NO2";
    public static final String _NO3 = "NO3";
    public static final String _CRO4 = "CrO4";
    public static final String _CR2O7 = "Cr2O7";
    public static final String _MNO4 = "MnO4";
    public static final String _P = "P";
    public static final String _PO3 = "PO3";
    public static final String _PO4 = "PO4";
    public static final String _HPO4 = "HPO4";
    public static final String _H2PO4 = "H2PO4";
    public static final String _AS = "As";
    public static final String _SE = "Se";
    public static final String _S = "S";
    public static final String _HS = "HS";
    public static final String _SO3 = "SO3";
    public static final String _HSO3 = "HSO3";
    public static final String _S2O3 = "S2O3";
    public static final String _H2S = "H2S";
    public static final String _SO4 = "SO4";
    public static final String _HSO4 = "HSO4";
    public static final String _B = "B";
    public static final String _BRO3 = "BrO3";
    public static final String _MO = "Mo";
    public static final String _TL = "Tl";
    public static final String _TH = "Th";
    public static final String _V = "V";
    public static final String SOLID = "SOLID";
    public static final String TDS = "TDS";
    public static final String SPGR = "SPGR";
    public static final String SIGMA = "SIGMA";
    public static final String PH = "PH";
    public static final String DEG = "DEG";
    public static final String OHM = "OHM";
    public static final String OHM75 = "OHM75";
    public static final String OHME = "OHME";
    private static final int _NONE = 0;
    private static final int _COLUMNS = 1;
    private static final int _DATA = 2;
    private static final int _ROW = 3;
    private int iData = 0;
    private brineColumnsStruct stColumn = new brineColumnsStruct();
    private brineListStruct stList = new brineListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadBrineDataXMLFile() {
        this.iType = 0;
    }

    public ReadBrineDataXMLFile(int n) {
        this.iType = n;
    }

    public brineListStruct Process(String string) {
        double d = 0.0;
        double d2 = 0.0;
        int n = 0;
        this.Read(string);
        this.stList = brineUtility.computeDepthRange(this.stList);
        this.stList = brineUtility.bubbleSort(this.stList, 1);
        this.stList = brineUtility.addBaseDepth(this.stList);
        for (int i = 0; i < this.stList.iCount; ++i) {
            d = 0.0;
            for (int j = 12; j < 89; ++j) {
                if (!this.stList.checkData(j) || !((d2 = this.stList.getData(j, i)) > 0.0)) continue;
                d += d2;
            }
            n = (int)(d * 10.0);
            d = (double)n / 10.0;
            this.stList.setData(89, i, d);
            this.stList.setData(90, i, d);
        }
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadBrineDataXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadBrineDataXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(COLUMNS)) {
            this.iRows = 0;
            this.iCount = -1;
            this.iData = 1;
        }
        if (string4.equals(COLUMN)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stColumns[this.iCount] = new brineColumnsStruct();
            }
        }
        if (string4.equals(DATA)) {
            this.iRows = 0;
            this.iCount = -1;
            this.iData = 2;
        }
        if (string4.equals(ROW)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new brineStruct();
            }
            this.iData = 3;
        }
        if (attributes != null) {
            block10: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    switch (this.iData) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stColumns = new brineColumnsStruct[this.iRows];
                            this.stList.iColumns = this.iRows;
                            break;
                        }
                        case 2: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem = new brineStruct[this.iRows];
                            this.stList.iCount = this.iRows;
                        }
                    }
                }
                if (this.iCount <= -1) continue;
                switch (this.iData) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        if (this.iCount >= this.iRows) continue block10;
                        this.stList.stColumns[this.iCount] = this.ParseColumns(string5, string7.trim(), this.stList.stColumns[this.iCount]);
                        continue block10;
                    }
                    case 3: {
                        if (this.iCount >= this.iRows) continue block10;
                        this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private brineColumnsStruct ParseColumns(String string, String string2, brineColumnsStruct brineColumnsStruct2) {
        if (string.equals(MNEMONIC)) {
            brineColumnsStruct2.sMnemonic = new String(string2);
        }
        if (string.equals(NAME)) {
            brineColumnsStruct2.sName = new String(string2);
        }
        if (string.equals(UNIT)) {
            brineColumnsStruct2.sUnit = new String(string2);
        }
        if (string.equals(TYPE)) {
            brineColumnsStruct2.sKEY = new String(string2);
        }
        return brineColumnsStruct2;
    }

    private brineListStruct ParseData(String string, String string2, brineListStruct brineListStruct2) {
        if (string.equals(STATE)) {
            brineListStruct2.state = new String(string2);
        }
        if (string.equals(COUNTY)) {
            brineListStruct2.sCounty = new String(string2);
        }
        if (string.equals(FIELD)) {
            brineListStruct2.sField = new String(string2);
        }
        if (string.equals(API)) {
            brineListStruct2.sAPI = new String(string2);
        }
        if (string.equals(NAMEA)) {
            brineListStruct2.sName = new String(string2);
        }
        if (string.equals(LAT) && cmnString.isNumeric(string2)) {
            brineListStruct2.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONG) && cmnString.isNumeric(string2)) {
            brineListStruct2.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(KB) && cmnString.isNumeric(string2)) {
            brineListStruct2.dKB = cmnString.stringToDouble(string2);
        }
        if (string.equals(GL) && cmnString.isNumeric(string2)) {
            brineListStruct2.dGL = cmnString.stringToDouble(string2);
        }
        if (string.equals(DF) && cmnString.isNumeric(string2)) {
            brineListStruct2.dDF = cmnString.stringToDouble(string2);
        }
        if (string.equals(TGT) && cmnString.isNumeric(string2)) {
            brineListStruct2.dTGT = cmnString.stringToDouble(string2);
        }
        if (string.equals(SRC)) {
            brineListStruct2.source = new String(string2);
        }
        if (string.equals(DATE)) {
            brineListStruct2.sAnalyzed = new String(string2);
        }
        return brineListStruct2;
    }

    private brineStruct ParseData(String string, String string2, brineStruct brineStruct2) {
        if (string.equals(KEY)) {
            ++this.stList._KEY;
            brineStruct2.sKID = new String(string2);
            brineStruct2.sKEY = new String(string2);
        }
        if (string.equals(STATE)) {
            brineStruct2.state = new String(string2);
        }
        if (string.equals(COUNTY)) {
            brineStruct2.sCounty = new String(string2);
        }
        if (string.equals(FIELD)) {
            brineStruct2.sField = new String(string2);
        }
        if (string.equals(LOC)) {
            brineStruct2.sLocation = new String(string2);
        }
        if (string.equals(API)) {
            brineStruct2.sAPI = new String(string2);
        }
        if (string.equals(NAMEA)) {
            brineStruct2.sName = new String(string2);
        }
        if (string.equals(LAT) && cmnString.isNumeric(string2)) {
            brineStruct2.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONG) && cmnString.isNumeric(string2)) {
            brineStruct2.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(KB) && cmnString.isNumeric(string2)) {
            brineStruct2.dKB = cmnString.stringToDouble(string2);
        }
        if (string.equals(GL) && cmnString.isNumeric(string2)) {
            brineStruct2.dGL = cmnString.stringToDouble(string2);
        }
        if (string.equals(DF) && cmnString.isNumeric(string2)) {
            brineStruct2.dDF = cmnString.stringToDouble(string2);
        }
        if (string.equals(TGT) && cmnString.isNumeric(string2)) {
            brineStruct2.dTGT = cmnString.stringToDouble(string2);
        }
        if (string.equals(SRC)) {
            brineStruct2.source = new String(string2);
        }
        if (string.equals(DATE)) {
            brineStruct2.sRecovery = new String(string2);
        }
        if (string.equals(TOP) && cmnString.isNumeric(string2)) {
            ++this.stList._TOP;
            brineStruct2.dTOP = cmnString.stringToDouble(string2);
        }
        if (string.equals(BASE) && cmnString.isNumeric(string2)) {
            ++this.stList._BASE;
            brineStruct2.dBASE = cmnString.stringToDouble(string2);
        }
        if (string.equals(FORM)) {
            brineStruct2.sFORM = new String(string2);
        }
        if (string.equals(AGE)) {
            brineStruct2.sAGE = new String(string2);
        }
        if (string.equals(_LI) && cmnString.isNumeric(string2)) {
            ++this.stList._LI;
            brineStruct2.dLI = cmnString.stringToDouble(string2);
        }
        if (string.equals(_NA) && cmnString.isNumeric(string2)) {
            ++this.stList._NA;
            brineStruct2.dNA = cmnString.stringToDouble(string2);
        }
        if (string.equals(_K) && cmnString.isNumeric(string2)) {
            ++this.stList._K;
            brineStruct2.dK = cmnString.stringToDouble(string2);
        }
        if (string.equals(_RB) && cmnString.isNumeric(string2)) {
            ++this.stList._RB;
            brineStruct2.dK = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CS) && cmnString.isNumeric(string2)) {
            ++this.stList._CS;
            brineStruct2.dK = cmnString.stringToDouble(string2);
        }
        if (string.equals(_NA_K) && cmnString.isNumeric(string2)) {
            ++this.stList._NA_K;
            brineStruct2.dNA_K = cmnString.stringToDouble(string2);
            ++this.stList._NA;
            brineStruct2.dNA = brineStruct2.dNA_K / 2.0;
            ++this.stList._K;
            brineStruct2.dK = brineStruct2.dNA_K / 2.0;
        }
        if (string.equals(_BE) && cmnString.isNumeric(string2)) {
            ++this.stList._BE;
            brineStruct2.dBE = cmnString.stringToDouble(string2);
        }
        if (string.equals(_MG) && cmnString.isNumeric(string2)) {
            ++this.stList._MG;
            brineStruct2.dMG = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CA) && cmnString.isNumeric(string2)) {
            ++this.stList._CA;
            brineStruct2.dCA = cmnString.stringToDouble(string2);
        }
        if (string.equals(_SR) && cmnString.isNumeric(string2)) {
            ++this.stList._SR;
            brineStruct2.dSR = cmnString.stringToDouble(string2);
        }
        if (string.equals(_BA) && cmnString.isNumeric(string2)) {
            ++this.stList._BA;
            brineStruct2.dBA = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_CR) || string.equals(_CRII)) && cmnString.isNumeric(string2)) {
            ++this.stList._CR_II;
            brineStruct2.dCR_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CRIII) && cmnString.isNumeric(string2)) {
            ++this.stList._CR_III;
            brineStruct2.dCR_III = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_MN) || string.equals(_MNII)) && cmnString.isNumeric(string2)) {
            ++this.stList._MN_II;
            brineStruct2.dMN_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_MNIII) && cmnString.isNumeric(string2)) {
            ++this.stList._MN_III;
            brineStruct2.dMN_III = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_FE) || string.equals(_FEII)) && cmnString.isNumeric(string2)) {
            ++this.stList._FE_II;
            brineStruct2.dFE_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_FEIII) && cmnString.isNumeric(string2)) {
            ++this.stList._FE_III;
            brineStruct2.dFE_III = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_CO) || string.equals(_COII)) && cmnString.isNumeric(string2)) {
            ++this.stList._CO_II;
            brineStruct2.dCO_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_COIII) && cmnString.isNumeric(string2)) {
            ++this.stList._CO_III;
            brineStruct2.dCO_III = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_NI) || string.equals(_NIII)) && cmnString.isNumeric(string2)) {
            ++this.stList._NI_II;
            brineStruct2.dNI_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_NIIII) && cmnString.isNumeric(string2)) {
            ++this.stList._NI_III;
            brineStruct2.dNI_III = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CU) && cmnString.isNumeric(string2)) {
            ++this.stList._CU_I;
            brineStruct2.dCU_I = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CUII) && cmnString.isNumeric(string2)) {
            ++this.stList._CU_II;
            brineStruct2.dCU_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_AG) && cmnString.isNumeric(string2)) {
            ++this.stList._AG;
            brineStruct2.dAG = cmnString.stringToDouble(string2);
        }
        if (string.equals(_AU) && cmnString.isNumeric(string2)) {
            ++this.stList._AU;
            brineStruct2.dAU = cmnString.stringToDouble(string2);
        }
        if (string.equals(_AUIII) && cmnString.isNumeric(string2)) {
            ++this.stList._AU_III;
            brineStruct2.dAU_III = cmnString.stringToDouble(string2);
        }
        if (string.equals(_ZN) && cmnString.isNumeric(string2)) {
            ++this.stList._ZN;
            brineStruct2.dZN = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CD) && cmnString.isNumeric(string2)) {
            ++this.stList._CD;
            brineStruct2.dCD = cmnString.stringToDouble(string2);
        }
        if (string.equals(_HG) && cmnString.isNumeric(string2)) {
            ++this.stList._HG;
            brineStruct2.dHG = cmnString.stringToDouble(string2);
        }
        if (string.equals(_HGII) && cmnString.isNumeric(string2)) {
            ++this.stList._HG_II;
            brineStruct2.dHG_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_AL) && cmnString.isNumeric(string2)) {
            ++this.stList._AL;
            brineStruct2.dAL = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_SB) || string.equals(_SBIII)) && cmnString.isNumeric(string2)) {
            ++this.stList._SB_III;
            brineStruct2.dSB_III = cmnString.stringToDouble(string2);
        }
        if (string.equals(_SBV) && cmnString.isNumeric(string2)) {
            ++this.stList._SB_V;
            brineStruct2.dSB_V = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_BI) || string.equals(_BIIII)) && cmnString.isNumeric(string2)) {
            ++this.stList._BI_III;
            brineStruct2.dBI_III = cmnString.stringToDouble(string2);
        }
        if (string.equals(_BIV) && cmnString.isNumeric(string2)) {
            ++this.stList._BI_V;
            brineStruct2.dBI_V = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_SN) || string.equals(_SNII)) && cmnString.isNumeric(string2)) {
            ++this.stList._SN_II;
            brineStruct2.dSN_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_SNIV) && cmnString.isNumeric(string2)) {
            ++this.stList._SN_IV;
            brineStruct2.dSN_IV = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_PB) || string.equals(_PBII)) && cmnString.isNumeric(string2)) {
            ++this.stList._PB_II;
            brineStruct2.dPB_II = cmnString.stringToDouble(string2);
        }
        if (string.equals(_PBIV) && cmnString.isNumeric(string2)) {
            ++this.stList._PB_IV;
            brineStruct2.dPB_IV = cmnString.stringToDouble(string2);
        }
        if (string.equals(_NH4) && cmnString.isNumeric(string2)) {
            ++this.stList._NH4;
            brineStruct2.dNH4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_F) && cmnString.isNumeric(string2)) {
            ++this.stList._F;
            brineStruct2.dF = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CL) && cmnString.isNumeric(string2)) {
            ++this.stList._CL;
            brineStruct2.dCL = cmnString.stringToDouble(string2);
        }
        if (string.equals(_BR) && cmnString.isNumeric(string2)) {
            ++this.stList._BR;
            brineStruct2.dBR = cmnString.stringToDouble(string2);
        }
        if (string.equals(_I) && cmnString.isNumeric(string2)) {
            ++this.stList._I;
            brineStruct2.dI = cmnString.stringToDouble(string2);
        }
        if (string.equals(_OH) && cmnString.isNumeric(string2)) {
            ++this.stList._OH;
            brineStruct2.dOH = cmnString.stringToDouble(string2);
        }
        if (string.equals(_BO3) && cmnString.isNumeric(string2)) {
            ++this.stList._BO3;
            brineStruct2.dBO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CO3) && cmnString.isNumeric(string2)) {
            ++this.stList._CO3;
            brineStruct2.dCO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_HCO3) && cmnString.isNumeric(string2)) {
            ++this.stList._HCO3;
            brineStruct2.dHCO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CLO) && cmnString.isNumeric(string2)) {
            ++this.stList._CLO;
            brineStruct2.dCLO = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CLO2) && cmnString.isNumeric(string2)) {
            ++this.stList._CLO2;
            brineStruct2.dCLO2 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CLO3) && cmnString.isNumeric(string2)) {
            ++this.stList._CLO3;
            brineStruct2.dCLO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CLO4) && cmnString.isNumeric(string2)) {
            ++this.stList._CLO4;
            brineStruct2.dCLO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CN) && cmnString.isNumeric(string2)) {
            ++this.stList._CN;
            brineStruct2.dCN = cmnString.stringToDouble(string2);
        }
        if (string.equals(_NCO) && cmnString.isNumeric(string2)) {
            ++this.stList._NCO;
            brineStruct2.dNCO = cmnString.stringToDouble(string2);
        }
        if (string.equals(_OCN) && cmnString.isNumeric(string2)) {
            ++this.stList._OCN;
            brineStruct2.dOCN = cmnString.stringToDouble(string2);
        }
        if (string.equals(_SCN) && cmnString.isNumeric(string2)) {
            ++this.stList._SCN;
            brineStruct2.dSCN = cmnString.stringToDouble(string2);
        }
        if (string.equals(_N) && cmnString.isNumeric(string2)) {
            ++this.stList._N;
            brineStruct2.dN = cmnString.stringToDouble(string2);
        }
        if (string.equals(_N3) && cmnString.isNumeric(string2)) {
            ++this.stList._N3;
            brineStruct2.dN3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_NO2) && cmnString.isNumeric(string2)) {
            ++this.stList._NO2;
            brineStruct2.dNO2 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_NO3) && cmnString.isNumeric(string2)) {
            ++this.stList._NO3;
            brineStruct2.dNO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CRO4) && cmnString.isNumeric(string2)) {
            ++this.stList._CRO4;
            brineStruct2.dCRO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_CR2O7) && cmnString.isNumeric(string2)) {
            ++this.stList._CR2O7;
            brineStruct2.dCR2O7 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_MNO4) && cmnString.isNumeric(string2)) {
            ++this.stList._MNO4;
            brineStruct2.dMNO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_P) && cmnString.isNumeric(string2)) {
            ++this.stList._P;
            brineStruct2.dP = cmnString.stringToDouble(string2);
        }
        if (string.equals(_PO3) && cmnString.isNumeric(string2)) {
            ++this.stList._PO3;
            brineStruct2.dPO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_PO4) && cmnString.isNumeric(string2)) {
            ++this.stList._PO4;
            brineStruct2.dPO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_HPO4) && cmnString.isNumeric(string2)) {
            ++this.stList._HPO4;
            brineStruct2.dHPO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_H2PO4) && cmnString.isNumeric(string2)) {
            ++this.stList._H2PO4;
            brineStruct2.dH2PO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_AS) && cmnString.isNumeric(string2)) {
            ++this.stList._AS;
            brineStruct2.dAS = cmnString.stringToDouble(string2);
        }
        if (string.equals(_SE) && cmnString.isNumeric(string2)) {
            ++this.stList._SE;
            brineStruct2.dSE = cmnString.stringToDouble(string2);
        }
        if (string.equals(_S) && cmnString.isNumeric(string2)) {
            ++this.stList._S;
            brineStruct2.dS = cmnString.stringToDouble(string2);
        }
        if (string.equals(_SO3) && cmnString.isNumeric(string2)) {
            ++this.stList._SO3;
            brineStruct2.dSO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_HSO3) && cmnString.isNumeric(string2)) {
            ++this.stList._HSO3;
            brineStruct2.dHSO3 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_S2O3) && cmnString.isNumeric(string2)) {
            ++this.stList._S2O3;
            brineStruct2.dS2O3 = cmnString.stringToDouble(string2);
        }
        if ((string.equals(_H2S) || string.equals(_HS)) && cmnString.isNumeric(string2)) {
            ++this.stList._HS;
            brineStruct2.dHS = cmnString.stringToDouble(string2);
        }
        if (string.equals(_SO4) && cmnString.isNumeric(string2)) {
            ++this.stList._SO4;
            brineStruct2.dSO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(_HSO4) && cmnString.isNumeric(string2)) {
            ++this.stList._HSO4;
            brineStruct2.dHSO4 = cmnString.stringToDouble(string2);
        }
        if (string.equals(SOLID) && cmnString.isNumeric(string2)) {
            ++this.stList._SOLID;
            brineStruct2.dSOLID = cmnString.stringToDouble(string2);
        }
        if (string.equals(TDS) && cmnString.isNumeric(string2)) {
            ++this.stList._TDS;
            brineStruct2.dTDS = cmnString.stringToDouble(string2);
        }
        if (string.equals(SPGR) && cmnString.isNumeric(string2)) {
            ++this.stList._SPGR;
            brineStruct2.dSPGR = cmnString.stringToDouble(string2);
        }
        if (string.equals(SIGMA) && cmnString.isNumeric(string2)) {
            ++this.stList._SIGMA;
            brineStruct2.dSIGMA = cmnString.stringToDouble(string2);
        }
        if (string.equals(PH) && cmnString.isNumeric(string2)) {
            ++this.stList._PH;
            brineStruct2.dPH = cmnString.stringToDouble(string2);
        }
        if (string.equals(DEG) && cmnString.isNumeric(string2)) {
            ++this.stList._DEG;
            brineStruct2.dDEG = cmnString.stringToDouble(string2);
        }
        if (string.equals(OHM) && cmnString.isNumeric(string2)) {
            ++this.stList._OHM;
            brineStruct2.dOHM = cmnString.stringToDouble(string2);
        }
        if (string.equals(OHM75) && cmnString.isNumeric(string2)) {
            ++this.stList._OHM75;
            brineStruct2.dOHM75 = cmnString.stringToDouble(string2);
        }
        if (string.equals(OHME) && cmnString.isNumeric(string2)) {
            ++this.stList._OHME;
            brineStruct2.dOHME = cmnString.stringToDouble(string2);
        }
        return brineStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

