/*
 * Decompiled with CFR 0.152.
 */
package brine.gui;

import brine.brineListStruct;
import brine.brineStandardTools;
import brine.gui.brineMapCSVFrameFocusAdapter;
import brine.io.brineCSVFile;
import cmn.cmnString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class brineMapCSVFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private String sReadMethod = null;
    private String sDirectory = null;
    private String sFilename = null;
    private String sLine1 = "";
    private String sLine2 = "";
    private int iRow = 3;
    private int[] iColumn = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private int[] iUnit = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    public static final String[][] CURVES = new String[][]{{"KEY", "Fluid Primary Key", "", "", ""}, {"FORM", "Formation", "", "", ""}, {"AGE", "Formation Age", "", "", ""}, {"TOP", "Depth Top", "", "", ""}, {"BASE", "Depth Base", "", "", ""}, {"SPGR", "Specific Gravity", "", "", ""}, {"SIGMA", "Specific Conductivity", "", "", ""}, {"PH", "PH", "", "", ""}, {"DEG", "Temperature (F)", "", "", ""}, {"OHM", "Resistivity (Rw)", "", "", ""}, {"OHM75", "Resistivity at 75 deg", "", "", ""}, {"OHME", "Estimated Rw", "", "", ""}, {"Li", "Lithium", "", "", ""}, {"Na", "Sodium", "", "", ""}, {"K", "Potassium", "", "", ""}, {"Rb", "Rubidium", "", "", ""}, {"Cs", "Cesium", "", "", ""}, {"Na_K", "Sodium Potassium", "", "", ""}, {"Be", "Beryllium", "", "", ""}, {"Mg", "Magnesium", "", "", ""}, {"Ca", "Calcium", "", "", ""}, {"Sr", "Strontium", "", "", ""}, {"Ba", "Barium", "", "", ""}, {"CrII", "Chromium(II)", "chromous", "Cr", ""}, {"CrIII", "Chromium(III)", "chromic", "", ""}, {"MnII", "Manganese(II)", "manganous", "Mn", ""}, {"MnIII", "Manganese(III)", "manganic", "", ""}, {"FeII", "Iron(II)", "ferrous", "Fe", ""}, {"FeIII", "Iron(III)", "ferric", "", ""}, {"CoII", "Cobalt(II)", "cobaltous", "Co", ""}, {"CoIII", "Cobalt(III)", "cobaltic", "", ""}, {"NiII", "Nickel(II)", "nickelous", "Ni", ""}, {"NiIII", "Nickel(III)", "nickelic", "", ""}, {"Cu", "Copper(I)", "cuprous", "", ""}, {"CuII", "Copper(II)", "cupric", "", ""}, {"Ag", "Silver", "", "", ""}, {"Au", "Gold", "aurous", "", ""}, {"AuIII", "Gold(III)", "auric", "", ""}, {"Zn", "Zinc", "", "", ""}, {"Cd", "Cadmium", "", "", ""}, {"Hg", "Mercury(I)", "mercurous", "", ""}, {"HgII", "Mercury(II)", "mercuric", "", ""}, {"Al", "Aluminum", "", "", ""}, {"SbIII", "Antimony(III)", "antimonous", "Sb", ""}, {"SbV", "Antimony(V)", "antimonic", "", ""}, {"BiIII", "Bismuth(III)", "bismuthous", "Bi", ""}, {"BiV", "Bismuth(V)", "bismuthic", "", ""}, {"SnII", "Tin(II)", "stannous", "Sn", ""}, {"SnIV", "Tin(IV)", "stannic", "", ""}, {"PbII", "Lead(II)", "plumbous", "Pb", ""}, {"PbIV", "Lead(IV)", "plumbic", "", ""}, {"NH4", "Ammonium", "", "", ""}, {"F", "Floride", "", "", ""}, {"Cl", "Chloride", "", "", ""}, {"Br", "Bromide", "", "", ""}, {"I", "Iodine", "", "", ""}, {"OH", "Hydroxide", "", "", ""}, {"BO3", "Borate", "", "", ""}, {"CO3", "Carbonate", "", "", ""}, {"HCO3", "Bicarbonate", "", "", ""}, {"ClO", "Hypochlorite", "", "", ""}, {"ClO2", "Chlorite", "", "", ""}, {"ClO3", "Chlorate", "", "", ""}, {"ClO4", "Per chlorate", "", "", ""}, {"CN", "Cyanide", "", "", ""}, {"NCO", "Cyanate", "", "", ""}, {"OCN", "Isocyanate", "", "", ""}, {"SCN", "Thicyanite", "", "", ""}, {"N", "Nitride", "", "", ""}, {"N3", "Azide", "", "", ""}, {"NO2", "Nitrite", "", "", ""}, {"NO3", "Nitrate", "", "", ""}, {"CrO4", "Chromate", "", "", ""}, {"Cr2O7", "Dichromate", "", "", ""}, {"MnO4", "Permanganate", "", "", ""}, {"P", "Phosphide", "", "", ""}, {"PO3", "Phosphite", "", "", ""}, {"PO4", "Phosphate", "", "", ""}, {"HPO4", "Monohydrogen Phosphate", "", "", ""}, {"H2PO4", "Dihydrogen Phosphate", "", "", ""}, {"As", "Arsinide", "", "", ""}, {"Se", "Selenide", "", "", ""}, {"S", "Sulfide", "", "", ""}, {"HS", "Hydrogen Sulfide", "", "", ""}, {"SO3", "Sulphite", "", "", ""}, {"HSO3", "Hydrogen Sulphite", "", "", ""}, {"S2O3", "Thiosulphate", "", "", ""}, {"SO4", "Sulfate", "", "", ""}, {"HSO4", "Bisulfate", "", "", ""}, {"SOLID", "Total Solids", "", "", ""}, {"TDS", "Total Solids Computed", "", "", ""}, {"NAME", "Well Name", "", "", ""}, {"API", "API-Number", "", "", ""}, {"FIELD", "Field", "", "", ""}, {"COUNTY", "County", "", "", ""}, {"STATE", "State", "", "", ""}, {"LOC", "Location", "", "", ""}, {"LAT", "Latitude", "", "", ""}, {"LONG", "Longitude", "", "", ""}, {"KB", "Kelly Bushing", "", "", ""}, {"GL", "Ground Level", "", "", ""}, {"DF", "Derrick Floor", "", "", ""}, {"TGT", "TGT", "", "", ""}, {"SRC", "source", "", "", ""}, {"DATE", "Recovery date", "", "", ""}};
    private brineCSVFile pFILE = new brineCSVFile();
    private brineListStruct stList = null;
    private JButton btnLoad = new JButton();
    private JButton btnCancel = new JButton();
    private JButton btnHelp = new JButton();
    private JTextField txtStart = new JTextField();
    private JPanel[] pnl = null;
    private JPanel[] pnl1a = null;
    private JPanel[] pnl2a = null;
    private JLabel[] lbl = null;
    private JTextField[] txt = null;
    private JRadioButton[][] rb = null;
    private ButtonGroup[] group = null;

    public brineMapCSVFrame(Observable observable, String string, String string2, String string3) {
        try {
            this.notifier = observable;
            this.sReadMethod = string;
            this.sDirectory = string2;
            this.sFilename = string3;
            this.jbInit();
            if (this.sLine1 != null) {
                this.mapColumns(this.sLine1);
            }
            if (this.sLine2 != null) {
                this.mapColumns(this.sLine2);
                this.mapUnits(this.sLine1);
                this.mapUnits(this.sLine2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        String string = "";
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        JPanel jPanel10 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        JTextArea jTextArea = new JTextArea();
        JTextArea jTextArea2 = new JTextArea();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        JScrollPane jScrollPane3 = new JScrollPane();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "1st Line of Comma Delimited File:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "2nd Line of Comma Delimited File:");
        TitledBorder titledBorder3 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Brine Data Columns:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        this.setTitle("Map File Column Number to Brine Data Column");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.btnLoad.setFont(new Font("Dialog", 1, 11));
        this.btnLoad.setPreferredSize(new Dimension(90, 25));
        this.btnLoad.setText("Load Data");
        this.btnLoad.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setPreferredSize(new Dimension(90, 25));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        this.btnHelp.setFont(new Font("Dialog", 1, 11));
        this.btnHelp.setPreferredSize(new Dimension(90, 25));
        this.btnHelp.setText("Help");
        this.btnHelp.addActionListener(this);
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel4.setBorder(titledBorder);
        jPanel4.setLayout(new BorderLayout());
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setText("");
        jTextArea.setRows(3);
        jTextArea.setWrapStyleWord(true);
        jPanel5.setBorder(titledBorder2);
        jPanel5.setLayout(new BorderLayout());
        jTextArea2.setEditable(false);
        jTextArea2.setLineWrap(true);
        jTextArea2.setText("");
        jTextArea2.setRows(3);
        jTextArea2.setWrapStyleWord(true);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBorder(titledBorder3);
        jPanel6.setLayout(new BorderLayout());
        jLabel.setFont(new Font("Dialog", 1, 11));
        jLabel.setText("Start Reading Data at Row");
        this.txtStart.setText("3");
        this.txtStart.setColumns(4);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new brineMapCSVFrameFocusAdapter(this));
        jLabel2.setFont(new Font("Dialog", 1, 11));
        jLabel2.setText("Assume Row & Column Count is 1,2,3 ...");
        jPanel7.setLayout(new BorderLayout());
        jPanel10.setLayout(new GridLayout(106, 1));
        jPanel9.setLayout(new BorderLayout());
        jLabel3.setFont(new Font("Dialog", 1, 11));
        jLabel3.setText("Brine Data Column Name");
        jLabel4.setFont(new Font("Dialog", 1, 11));
        jLabel4.setText("File Column Number");
        jPanel10.add((Component)jPanel9, null);
        jPanel9.add((Component)jLabel3, "West");
        jPanel9.add((Component)jLabel4, "East");
        this.pnl = new JPanel[105];
        this.pnl1a = new JPanel[105];
        this.pnl2a = new JPanel[105];
        this.lbl = new JLabel[105];
        this.txt = new JTextField[105];
        this.rb = new JRadioButton[105][2];
        this.group = new ButtonGroup[105];
        for (int i = 0; i < 105; ++i) {
            this.pnl[i] = new JPanel();
            this.pnl[i].setLayout(new BorderLayout());
            this.pnl[i].setBorder(BorderFactory.createEtchedBorder());
            this.pnl1a[i] = new JPanel();
            this.pnl1a[i].setLayout(new BorderLayout());
            this.pnl2a[i] = new JPanel();
            this.pnl2a[i].setLayout(new GridLayout());
            string = new String(brineStandardTools.CURVES[i][2]);
            if (i >= 12 && i <= 88) {
                string = new String(string + " ( " + brineStandardTools.CURVES[i][1] + " )");
            }
            this.lbl[i] = new JLabel();
            this.lbl[i].setFont(new Font("Dialog", 1, 11));
            this.lbl[i].setText("  " + string);
            this.txt[i] = new JTextField();
            this.txt[i].setText("0");
            this.txt[i].setColumns(4);
            this.txt[i].setHorizontalAlignment(11);
            this.txt[i].addFocusListener(new brineMapCSVFrameFocusAdapter(this));
            this.group[i] = new ButtonGroup();
            for (int j = 0; j < 2; ++j) {
                this.rb[i][j] = new JRadioButton();
                this.rb[i][j].setFont(new Font("Dialog", 1, 11));
                switch (j) {
                    case 0: {
                        this.rb[i][j].setSelected(true);
                        this.rb[i][j].setText("mg/l");
                        break;
                    }
                    case 1: {
                        this.rb[i][j].setSelected(false);
                        this.rb[i][j].setText("ug/l");
                    }
                }
                this.rb[i][j].addActionListener(this);
                this.group[i].add(this.rb[i][j]);
            }
            jPanel10.add((Component)this.pnl[i], null);
            this.pnl[i].add((Component)this.pnl1a[i], "Center");
            this.pnl1a[i].add((Component)this.lbl[i], "Center");
            if (i >= 12 && i < 91) {
                this.pnl1a[i].add((Component)this.pnl2a[i], "East");
            }
            this.pnl2a[i].add((Component)this.rb[i][0], null);
            this.pnl2a[i].add((Component)this.rb[i][1], null);
            this.pnl[i].add((Component)this.txt[i], "East");
        }
        this.pFILE.Open(1, this.sDirectory, this.sFilename);
        this.pFILE.get2Rows();
        this.pFILE.Close();
        this.sLine1 = new String(this.pFILE.getLine1());
        this.sLine2 = new String(this.pFILE.getLine2());
        jTextArea.setText(this.sLine1);
        jTextArea2.setText(this.sLine2);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)jPanel4, null);
        jPanel4.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)jTextArea, null);
        jPanel.add((Component)jPanel5, null);
        jPanel5.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)jTextArea2, null);
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel2.add((Component)this.btnLoad, null);
        jPanel2.add((Component)this.btnCancel, null);
        jPanel2.add((Component)this.btnHelp, null);
        this.getContentPane().add((Component)jPanel3, "Center");
        jPanel3.add((Component)jPanel6, "North");
        jPanel6.add((Component)jPanel8, "West");
        jPanel8.add((Component)jLabel, null);
        jPanel8.add((Component)this.txtStart, null);
        jPanel6.add((Component)jLabel2, "East");
        jPanel3.add((Component)jPanel7, "Center");
        jPanel7.add((Component)jScrollPane3, "Center");
        jScrollPane3.getViewport().add((Component)jPanel10, null);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(550, dimension.height - 50));
        this.setLocation((dimension.width - this.getSize().width) / 2, 5);
        this.setResizable(true);
        this.setVisible(true);
    }

    public brineListStruct getData() {
        return this.stList;
    }

    private void mapUnits(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        String string2 = "";
        String string3 = "";
        Object var11_8 = null;
        String[] stringArray = null;
        int n2 = 0;
        String string4 = new String("[,]+");
        string2 = new String(string.replace('\t', ' '));
        stringArray = string2.split(string4);
        n = 0;
        if (stringArray != null) {
            n = stringArray.length;
        }
        for (int i = 0; i < 105; ++i) {
            n2 = cmnString.stringToInt(this.txt[i].getText()) - 1;
            if (n2 <= 0 || n2 <= -1 || n2 >= n) continue;
            string2 = stringArray[n2];
            string2 = new String(string2.trim());
            string2 = brineMapCSVFrame.Mu_to_u(string2);
            string2 = new String(string2.toUpperCase());
            if ((string2 = new String(string2.trim())).length() > 4) {
                string2 = new String(string2.substring(0, 4));
            }
            if (!string2.equals("UG/L")) continue;
            this.iUnit[i] = 1;
            this.rb[i][1].setSelected(true);
        }
    }

    public static String Mu_to_u(String string) {
        String string2 = new String("");
        if (string != null) {
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                string2 = cArray[i] == '\u00b5' || cArray[i] == '\u03bc' ? new String(string2 + 'u') : new String(string2 + cArray[i]);
            }
        }
        return string2;
    }

    private void mapColumns(String string) {
        int n;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        String string3 = "";
        Object var11_8 = null;
        String[] stringArray = null;
        String string4 = new String("[,]+");
        string2 = new String(string.replace('\t', ' '));
        stringArray = string2.split(string4);
        n3 = 0;
        if (stringArray != null) {
            n3 = stringArray.length;
        }
        for (n = 0; n < n3; ++n) {
            string2 = stringArray[n];
            string2 = new String(string2.toUpperCase());
            string2 = new String(string2.trim());
            for (int i = 0; i < 105; ++i) {
                for (int j = 0; j < 5; ++j) {
                    string3 = new String(CURVES[i][j]);
                    string3 = new String(string3.toUpperCase());
                    if (string2.length() > 0 && string3.length() > 0 && string2.equals(string3)) {
                        n2 = n + 1;
                        this.txt[i].setText("" + n2);
                    }
                    if (i == 3 && this.txt[i].getText().equals("0") && (string2.equals("START") || string2.equals("BEGIN") || string2.equals("DEPTH") || string2.equals("STARTING DEPTH") || string2.equals("BEGIN DEPTH"))) {
                        n2 = n + 1;
                        this.txt[i].setText("" + n2);
                    }
                    if (i != 4 || !this.txt[i].getText().equals("0") || !string2.equals("END") && !string2.equals("ENDING DEPTH") && !string2.equals("END DEPTH")) continue;
                    n2 = n + 1;
                    this.txt[i].setText("" + n2);
                }
            }
        }
        for (n = 0; n < 105; ++n) {
            this.iColumn[n] = cmnString.stringToInt(this.txt[n].getText());
        }
    }

    private void load() {
        this.pFILE.Open(1, this.sDirectory, this.sFilename);
        this.pFILE.getData(this.iRow, this.iColumn, this.iUnit);
        this.pFILE.Close();
        this.stList = this.pFILE.getRock();
        this.notifier.notifyObservers(new String("Brine CSV File Loaded"));
    }

    public void close() {
        this.notifier = null;
        this.sReadMethod = null;
        this.sDirectory = null;
        this.sFilename = null;
        this.sLine1 = null;
        this.sLine2 = null;
        this.iColumn = null;
        this.iUnit = null;
        if (this.pFILE != null) {
            this.pFILE.delete();
        }
        this.pFILE = null;
        this.stList = null;
        this.btnLoad = null;
        this.btnCancel = null;
        this.btnHelp = null;
        this.txtStart = null;
        this.pnl = null;
        this.pnl1a = null;
        this.pnl2a = null;
        this.lbl = null;
        this.txt = null;
        this.rb = null;
        this.group = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnLoad) {
            this.load();
        }
        if (actionEvent.getSource() == this.btnHelp) {
            // empty if block
        }
        if (this.rb != null) {
            for (int i = 0; i < 105; ++i) {
                if (actionEvent.getSource() != this.rb[i][0] && actionEvent.getSource() != this.rb[i][1]) continue;
                if (this.rb[i][0].isSelected()) {
                    this.iUnit[i] = 0;
                    continue;
                }
                if (!this.rb[i][1].isSelected()) continue;
                this.iUnit[i] = 1;
            }
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        int n = 0;
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Starting Row Number is a Numeric Field");
        }
        for (n = 0; n < 105; ++n) {
            if (focusEvent.getSource() != this.txt[n]) continue;
            bl = true;
            string2 = this.txt[n].getText();
            string = new String("Column Number is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtStart) {
                    this.iRow = cmnString.stringToInt(this.txtStart.getText());
                }
                for (n = 0; n < 105; ++n) {
                    if (focusEvent.getSource() != this.txt[n]) continue;
                    this.iColumn[n] = cmnString.stringToInt(this.txt[n].getText());
                }
            }
        }
    }
}

