/*
 * Decompiled with CFR 0.152.
 */
package xml;

import cmn.cmnLASToolsListStruct;
import cmn.cmnLASToolsStruct;
import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadLASToolsXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private static final int NONE = -1;
    private static final int TOOL = 0;
    private static final int OTHER = 1;
    private int iType = 0;
    private int iXML = -1;
    private int iRows = 0;
    private int iCount = -1;
    private int iOtherRows = 0;
    private cmnLASToolsListStruct stList = new cmnLASToolsListStruct();

    public ReadLASToolsXMLFile() {
        this.iType = 0;
    }

    public ReadLASToolsXMLFile(int n) {
        this.iType = n;
    }

    public cmnLASToolsListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        this.stList.iCount = this.iCount + 1;
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals("log_curve")) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new cmnLASToolsStruct();
                this.stList.stItem[this.iCount].sKEY = new String("0");
                this.stList.stItem[this.iCount].sMnemonic = new String("");
                this.stList.stItem[this.iCount].sDesc = new String("");
                this.stList.stItem[this.iCount].sUnit = new String("");
                this.stList.stItem[this.iCount].sLogStand = new String("");
                this.stList.stItem[this.iCount].dMinimum = 0.0;
                this.stList.stItem[this.iCount].dMaximum = 0.0;
                this.stList.stItem[this.iCount].dTrack = 0.0;
                this.stList.stItem[this.iCount].iOther = 0;
                this.stList.stItem[this.iCount].sOther = new String[200];
            }
        }
        if (string4.equals("tool")) {
            this.iXML = 0;
        }
        if (string4.equals("other")) {
            this.iOtherRows = 0;
            this.iXML = 1;
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals("records")) {
                    if (this.iXML != 1) {
                        this.iRows = cmnString.stringToInt(string7.trim());
                        if (this.iRows > 0) {
                            this.stList.stItem = new cmnLASToolsStruct[this.iRows];
                        }
                    } else {
                        this.iOtherRows = cmnString.stringToInt(string7.trim());
                    }
                }
                if (this.iCount <= -1 || this.iCount >= this.iRows) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private cmnLASToolsStruct ParseData(String string, String string2, cmnLASToolsStruct cmnLASToolsStruct2) {
        if (string.equals("key")) {
            cmnLASToolsStruct2.sKEY = new String(string2);
        }
        if (string.equals("mnemonic")) {
            cmnLASToolsStruct2.sMnemonic = new String(string2);
        }
        if (string.equals("desc")) {
            cmnLASToolsStruct2.sDesc = new String(string2);
        }
        if (string.equals("unit")) {
            cmnLASToolsStruct2.sUnit = new String(string2);
        }
        if (string.equals("log_stand")) {
            cmnLASToolsStruct2.sLogStand = new String(string2);
        }
        if (string.equals("min")) {
            cmnLASToolsStruct2.dMinimum = 0.0;
            if (cmnString.isNumeric(string2)) {
                cmnLASToolsStruct2.dMinimum = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals("max")) {
            cmnLASToolsStruct2.dMaximum = 0.0;
            if (cmnString.isNumeric(string2)) {
                cmnLASToolsStruct2.dMaximum = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals("track")) {
            cmnLASToolsStruct2.dTrack = 0.0;
            if (cmnString.isNumeric(string2)) {
                cmnLASToolsStruct2.dTrack = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals("mn")) {
            cmnLASToolsStruct2.sOther[cmnLASToolsStruct2.iOther] = new String(string2);
            ++cmnLASToolsStruct2.iOther;
        }
        return cmnLASToolsStruct2;
    }
}

