/*
 * Decompiled with CFR 0.152.
 */
package util;

public class utilLatLongConversion {
    public static final int UTM_X = 0;
    public static final int UTM_Y = 1;
    private int iZone = 0;
    private double dAo = 6378206.4;
    private double dE2rd = 0.00676866;
    private double dKo = 0.9996;
    private double dMo = 0.0;
    private double dLatitude = 0.0;
    private double dLongitude = 0.0;
    private double dMedianLongitude = 0.0;
    private double dUTM_X = 0.0;
    private double dUTM_Y = 0.0;

    public utilLatLongConversion(double d, double d2) {
        this.dLatitude = this.convertDegreesToRadians(d);
        this.dLongitude = this.convertDegreesToRadians(d2);
        this.iZone = 1 + (int)((180.0 + d2) / 6.0);
        double d3 = -1.0 * (180.0 - (double)this.iZone * 6.0 + 3.0);
        this.dMedianLongitude = this.convertDegreesToRadians(d3);
        this.computeUTM();
    }

    public utilLatLongConversion(int n, double d, double d2) {
        this.dLatitude = this.convertDegreesToRadians(d);
        this.dLongitude = this.convertDegreesToRadians(d2);
        this.iZone = n;
        double d3 = -1.0 * (180.0 - (double)n * 6.0 + 3.0);
        this.dMedianLongitude = this.convertDegreesToRadians(d3);
        this.computeUTM();
    }

    public double convertDegreesToRadians(double d) {
        double d2 = 0.0;
        d2 = d * Math.PI / 180.0;
        return d2;
    }

    private double getEqn_8_12() {
        double d = 0.0;
        d = this.dE2rd / (1.0 - this.dE2rd);
        return d;
    }

    private double getEqn_4_20() {
        double d = 0.0;
        d = this.dAo / Math.sqrt(1.0 - this.dE2rd * Math.sin(this.dLatitude) * Math.sin(this.dLatitude));
        return d;
    }

    private double getEqn_8_13() {
        double d = 0.0;
        d = Math.tan(this.dLatitude) * Math.tan(this.dLatitude);
        return d;
    }

    private double getEqn_8_14() {
        double d = 0.0;
        double d2 = this.getEqn_8_12();
        d = d2 * Math.cos(this.dLatitude) * Math.cos(this.dLatitude);
        return d;
    }

    private double getEqn_8_15() {
        double d = 0.0;
        d = (this.dLongitude - this.dMedianLongitude) * Math.cos(this.dLatitude);
        return d;
    }

    private double getEqn_3_21() {
        double d = 0.0;
        d = 111132.0894 * this.dLatitude * 180.0 / Math.PI - 16216.94 * Math.sin(2.0 * this.dLatitude) + 17.21 * Math.sin(4.0 * this.dLatitude) - 0.02 * Math.sin(6.0 * this.dLatitude);
        return d;
    }

    private void computeUTM() {
        int n = 0;
        double d = 0.0;
        double d2 = this.getEqn_8_12();
        double d3 = this.getEqn_4_20();
        double d4 = this.getEqn_8_13();
        double d5 = this.getEqn_8_14();
        double d6 = this.getEqn_8_15();
        double d7 = this.getEqn_3_21();
        d = 500000.0;
        this.dUTM_X = d + this.dKo * d3 * (d6 + (1.0 - d4 + d5) * (Math.pow(d6, 3.0) / 6.0) + (5.0 - 18.0 * d4 + Math.pow(d4, 2.0) + 72.0 * d5 - 58.0 * d2) * Math.pow(d6, 5.0) / 120.0);
        n = (int)(this.dUTM_X * 100.0);
        this.dUTM_X = (double)n / 100.0;
        this.dUTM_Y = this.dKo * (d7 - this.dMo + d3 * Math.tan(this.dLatitude) * (Math.pow(d6, 2.0) / 2.0 + (5.0 - d4 + 9.0 * d5 + 4.0 * Math.pow(d5, 2.0)) * Math.pow(d6, 4.0) / 24.0 + (61.0 - 58.0 * d4 + Math.pow(d4, 2.0) + 600.0 * d5 - 330.0 * d2) * Math.pow(d6, 6.0) / 720.0));
        n = (int)(this.dUTM_Y * 100.0);
        this.dUTM_Y = (double)n / 100.0;
    }

    public int getZone() {
        return this.iZone;
    }

    public double getUTM(int n) {
        double d = 0.0;
        d = n == 0 ? this.dUTM_X : this.dUTM_Y;
        return d;
    }

    public void setUTM(int n, double d) {
        if (n == 0) {
            this.dUTM_X = d;
        } else {
            this.dUTM_Y = d;
        }
    }
}

