/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

public class utilImageIO {
    private BufferedImage image = null;
    private JFrame f = null;

    public utilImageIO(int n, int n2) {
        this.image = new BufferedImage(n, n2, 1);
    }

    public utilImageIO(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public utilImageIO(String string) {
        try {
            this.image = ImageIO.read(new File(string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Could not open file " + string);
        }
    }

    public utilImageIO(File file) {
        try {
            this.image = ImageIO.read(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Could not open file " + file);
        }
    }

    public utilImageIO(String string, String string2) {
        try {
            if (string2 == "URL") {
                URL uRL = new URL(string);
                this.image = ImageIO.read(uRL);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new RuntimeException("Could not open file " + string);
        }
    }

    public void close() {
        this.image = null;
        if (this.f != null) {
            this.f.dispose();
            this.f = null;
        }
    }

    public JLabel getJLabel() {
        if (this.image == null) {
            return null;
        }
        ImageIcon imageIcon = new ImageIcon(this.image);
        return new JLabel(imageIcon);
    }

    public void show(String string) {
        if (this.f == null) {
            this.f = new JFrame();
            this.f.setContentPane(this.getJLabel());
            this.f.setDefaultCloseOperation(2);
            if (string != null) {
                this.f.setTitle(string);
            }
            this.f.setResizable(false);
            this.f.pack();
            this.f.setVisible(true);
        }
        this.f.repaint();
    }

    public int height() {
        return this.image.getHeight(null);
    }

    public int width() {
        return this.image.getWidth(null);
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Color getColor(int n, int n2) {
        return new Color(this.image.getRGB(n, n2));
    }

    public int getGray(int n, int n2) {
        Color color = this.getColor(n, n2);
        int n3 = color.getRed();
        int n4 = color.getGreen();
        int n5 = color.getBlue();
        return (int)((double)(n3 + n4 + n5) / 3.0);
    }

    public void setGray(int n, int n2, int n3) {
        Color color = new Color(n3, n3, n3);
        this.setColor(n, n2, color);
    }

    public void setColor(int n, int n2, Color color) {
        this.image.setRGB(n, n2, color.getRGB());
    }

    public void save(String string) {
        this.save(new File(string));
    }

    public void save(File file) {
        String string = file.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        try {
            ImageIO.write((RenderedImage)this.image, string2, file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        utilImageIO utilImageIO2 = new utilImageIO(stringArray[0], "URL");
        utilImageIO2.show("Image IO Viewer");
        utilImageIO2.save("images/core.png");
    }
}

