/*
 * Decompiled with CFR 0.152.
 */
package rock.sedimentary.plot;

import cmn.cmnString;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.sedimentary.sedimentaryStruct;

public class sedimentaryPlotSymbol
extends Canvas
implements MouseListener {
    private Observable notifier = null;
    private maskSymbolsListStruct stSymbols = null;
    private static final int NO = 0;
    private static final int YES = 1;
    private maskPlotSymbol plot = null;
    private sedimentaryStruct st = null;
    private int[] iSelected = null;
    private int[] iRow = null;
    private int iWidth = 300;
    private int iHeight = 1000;
    private static final int TEXT = 18;
    private static final int ROW = 25;
    private static final int X_START = 10;
    private static final int X_IMAGE = 40;
    private static final int X_DESC = 75;
    private static final int X_ABBREV = 350;

    public sedimentaryPlotSymbol(Observable observable, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.notifier = observable;
        this.stSymbols = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.setBackground(Color.white);
        this.addMouseListener(this);
        this.iSelected = new int[maskSymbolsListStruct2.iCount];
        this.iRow = new int[maskSymbolsListStruct2.iCount];
        this.iHeight = (maskSymbolsListStruct2.iCount + 12) * 25;
        for (int i = 0; i < maskSymbolsListStruct2.iCount; ++i) {
            this.iSelected[i] = 0;
        }
    }

    public void close() {
        this.notifier = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.st = null;
        this.iSelected = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public sedimentaryStruct getData() {
        return this.st;
    }

    public void setData(sedimentaryStruct sedimentaryStruct2) {
        this.st = sedimentaryStruct2;
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            this.iSelected[i] = 0;
            if (!this.isSelected(i)) continue;
            this.iSelected[i] = 1;
        }
        this.repaint();
    }

    private boolean isSelected(int n) {
        boolean bl = false;
        if (n > -1 && this.st != null && this.st.iTotal > 0) {
            for (int i = 0; i < this.st.iTotal; ++i) {
                if (!this.st.sID[i].equals(this.stSymbols.stItem[n].sID)) continue;
                bl = true;
            }
        }
        return bl;
    }

    private void toggleStructure(int n) {
        this.iSelected[n] = this.iSelected[n] == 0 ? 1 : 0;
    }

    private void modifyStructureList() {
        int n = 0;
        int n2 = 0;
        if (this.st == null) {
            this.st = new sedimentaryStruct();
            this.st.sKEY = new String(cmnString.UniqueName());
        }
        for (n = 0; n < this.stSymbols.iCount; ++n) {
            if (this.iSelected[n] != 1) continue;
            ++n2;
        }
        if (n2 > 0) {
            this.st.iTotal = n2;
            this.st.sID = new String[n2];
            this.st.sText = new String[n2];
            n2 = 0;
            for (n = 0; n < this.stSymbols.iCount; ++n) {
                if (this.iSelected[n] != 1 || n2 >= this.st.iTotal) continue;
                this.st.sID[n2] = new String(this.stSymbols.stItem[n].sID);
                this.st.sText[n2] = new String(this.stSymbols.stItem[n].sName);
                ++n2;
            }
        } else {
            this.st.iTotal = 0;
            this.st.sID = null;
            this.st.sText = null;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (n2 < this.iRow[i] || n2 >= this.iRow[i] + 25) continue;
            this.toggleStructure(i);
            this.modifyStructureList();
            this.repaint();
            if (this.notifier == null) continue;
            this.notifier.notifyObservers(new String("Sed Structure Symbol Selected"));
        }
    }

    public int drawStructureGroup(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        String string = "";
        int n5 = 0;
        boolean bl = false;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 < this.stSymbols.iCount; ++n4) {
            if (this.stSymbols.stItem[n4].iGroup != n2) continue;
            if (!bl) {
                string = new String(this.stSymbols.stGroups.sGroups[n2][1]);
                n5 = string.length();
                graphics.setColor(Color.black);
                graphics.drawString(string, this.iWidth / 2 - 4 * n5, n);
                n3 += 18;
                bl = true;
            }
            this.iRow[n4] = n3;
            if (this.notifier != null) {
                if (this.isSelected(n4)) {
                    graphics.setColor(Color.red);
                    graphics.drawLine(10, n3, 20, n3 + 10);
                    graphics.drawLine(20, n3, 10, n3 + 10);
                }
                graphics.setColor(Color.black);
                graphics.drawRect(10, n3, 10, 10);
            }
            this.plot.drawSymbol(graphics, this.stSymbols.stItem[n4].iRows, 0, this.stSymbols.stItem[n4].symbol, 40, n3);
            graphics.setColor(Color.black);
            graphics.drawString(this.stSymbols.stItem[n4].sName, 75, n3 + 10);
            graphics.drawString(this.stSymbols.stItem[n4].sAbrev, 350, n3 + 10);
            n3 += 25;
        }
        return n3;
    }

    public void draw(Graphics graphics) {
        int n = 0;
        boolean bl = false;
        int n2 = 10;
        String string = "Sedimentary Structure Symbols";
        int n3 = 0;
        boolean bl2 = false;
        graphics.setFont(new Font("Serif", 1, 14));
        graphics.setColor(Color.black);
        graphics.drawString(string, 0, 14);
        n2 += 18;
        if (this.stSymbols != null && this.stSymbols.stGroups != null) {
            graphics.setFont(new Font("Serif", 1, 12));
            string = new String(this.stSymbols.stGroups.sGroups[0][1]);
            n3 = string.length();
            graphics.setColor(Color.black);
            graphics.drawString(string, this.iWidth / 2 - 4 * n3, n2 += 10);
            n2 += 18;
            for (n = 1; n < this.stSymbols.stGroups.iGroups; ++n) {
                n2 = this.drawStructureGroup(graphics, n2 + 10, n);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

