/*
 * Decompiled with CFR 0.152.
 */
package rock.plot;

import cmn.cmnString;
import iqstrat.iqstratStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import lith.lithology.plot.lithologyPlotTrack;
import lith.rock.plot.rockColumnPlotTrack;
import lith.rock.rockColumnListStruct;
import lith.texture.plot.texturePlotTrack;
import rock.color.plot.rockColorPlotTrack;
import rock.color.rockColorListStruct;
import rock.fossil.fossilListStruct;
import rock.fossil.plot.fossilPlotTrack;
import rock.phi.phiListStruct;
import rock.phi.plot.phiPlotTrack;
import rock.sedimentary.plot.sedimentaryPlotTrack;
import rock.sedimentary.sedimentaryListStruct;

public class rockObsEntryPlot
extends Canvas {
    public static final int _SOURCE = 1;
    public static final int _TYPE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _STATUS = 4;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int[] iSelected = null;
    private int iUnit = 0;
    private int iDataType = 0;
    private int[] iStart = null;
    private int[] iWide = null;
    private int iButtons = 0;
    private int iBio = 10;
    private int iSed = 20;
    private phiPlotTrack plotPhi = null;
    private rockColumnPlotTrack pRockColumn = null;
    private lithologyPlotTrack plotLithology = null;
    private texturePlotTrack plotTexture = null;
    private fossilPlotTrack plotFossils = null;
    private sedimentaryPlotTrack plotSedimentary = null;
    private rockColorPlotTrack plotRockColor = null;
    private int iWidth = 650;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    private double dIncrementDepth = 0.0;
    private int iStartDepthLabel = 10;
    public static final int PLOT_TITLES = 100;
    public static final int DEPTH_TRACK = 50;
    public static final int LABELSTART = 25;

    public rockObsEntryPlot(iqstratStruct iqstratStruct2, double d, double d2, int n, int[] nArray) {
        this.iUnit = iqstratStruct2.iUnit;
        this.setPlotWidth(nArray);
        this.setPlotHeight(n, d2, d);
        this.plotPhi = new phiPlotTrack(this.iDataType, d, d2, n, iqstratStruct2.stPorosity);
        this.pRockColumn = new rockColumnPlotTrack(this.iDataType, d, d2, n, iqstratStruct2.stParseRock);
        this.plotLithology = new lithologyPlotTrack(this.iDataType, d, d2, n, this.iUnit, iqstratStruct2.stSymbols);
        this.plotTexture = new texturePlotTrack(this.iDataType, d, d2, n, this.iUnit, iqstratStruct2.stSymbols);
        this.plotFossils = new fossilPlotTrack(this.iDataType, d, d2, n, iqstratStruct2.stFossils);
        this.plotSedimentary = new sedimentaryPlotTrack(this.iDataType, d, d2, n, iqstratStruct2.stSedStruct);
        this.plotRockColor = new rockColorPlotTrack(this.iDataType, d, d2, n);
        this.setBackground(Color.white);
    }

    public void close() {
        this.iSelected = null;
        this.iStart = null;
        this.iWide = null;
        if (this.plotPhi != null) {
            this.plotPhi.close();
        }
        this.plotPhi = null;
        if (this.pRockColumn != null) {
            this.pRockColumn.close();
        }
        this.pRockColumn = null;
        if (this.plotLithology != null) {
            this.plotLithology.close();
        }
        this.plotLithology = null;
        if (this.plotTexture != null) {
            this.plotTexture.close();
        }
        this.plotTexture = null;
        if (this.plotFossils != null) {
            this.plotFossils.close();
        }
        this.plotFossils = null;
        if (this.plotSedimentary != null) {
            this.plotSedimentary.close();
        }
        this.plotSedimentary = null;
        if (this.plotRockColor != null) {
            this.plotRockColor.close();
        }
        this.plotRockColor = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public void setSelected(int[] nArray) {
        this.setPlotWidth(nArray);
        this.repaint();
    }

    public void setPlotWidth(int[] nArray) {
        int n = 0;
        this.iWidth = 50;
        this.iSelected = nArray;
        if (nArray != null) {
            this.iButtons = nArray.length;
        }
        if (this.iButtons > 0) {
            this.iStart = new int[this.iButtons];
            this.iWide = new int[this.iButtons];
            for (int i = 0; i < this.iButtons; ++i) {
                n = 0;
                for (int j = 0; j < 19; ++j) {
                    if (nArray[i] == -1 || !iqstratTracksStruct.TRACK[nArray[i]][2].equals(iqstratTracksStruct.TYPE[j][0])) continue;
                    if (iqstratTracksStruct.TRACK[nArray[i]][2].equals("ICON")) {
                        if (nArray[i] == 80) {
                            n = this.iBio;
                        }
                        if (nArray[i] != 79) continue;
                        n = this.iSed;
                        continue;
                    }
                    n = cmnString.stringToInt(iqstratTracksStruct.TYPE[j][2]);
                }
                this.iStart[i] = this.iWidth;
                this.iWide[i] = n;
                this.iWidth += n;
            }
        }
    }

    public void setPlotWidth() {
        int n = 0;
        this.iWidth = 50;
        if (this.iButtons > 0) {
            this.iStart = new int[this.iButtons];
            this.iWide = new int[this.iButtons];
            for (int i = 0; i < this.iButtons; ++i) {
                n = 0;
                for (int j = 0; j < 19; ++j) {
                    if (this.iSelected[i] == -1 || !iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals(iqstratTracksStruct.TYPE[j][0])) continue;
                    if (iqstratTracksStruct.TRACK[this.iSelected[i]][2].equals("ICON")) {
                        if (this.iSelected[i] == 80) {
                            n = this.iBio;
                        }
                        if (this.iSelected[i] != 79) continue;
                        n = this.iSed;
                        continue;
                    }
                    n = cmnString.stringToInt(iqstratTracksStruct.TYPE[j][2]);
                }
                this.iStart[i] = this.iWidth;
                this.iWide[i] = n;
                this.iWidth += n;
            }
        }
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
        this.dIncrementDepth = iqstratTracksStruct.SCALE[n];
    }

    public void setScale(int n, double d, double d2) {
        this.setPlotHeight(n, d, d2);
        if (this.plotPhi != null) {
            this.plotPhi.setPlotHeight(n, d, d2);
        }
        if (this.pRockColumn != null) {
            this.pRockColumn.setPlotHeight(n, d, d2);
        }
        if (this.plotLithology != null) {
            this.plotLithology.setPlotHeight(n, d, d2);
        }
        if (this.plotTexture != null) {
            this.plotTexture.setPlotHeight(n, d, d2);
        }
        if (this.plotRockColor != null) {
            this.plotRockColor.setPlotHeight(n, d, d2);
        }
        if (this.plotSedimentary != null) {
            this.plotSedimentary.setPlotHeight(n, d, d2);
        }
        if (this.plotFossils != null) {
            this.plotFossils.setPlotHeight(n, d, d2);
        }
        if (this.plotRockColor != null) {
            this.plotRockColor.setPlotHeight(n, d, d2);
        }
        this.repaint();
    }

    public void modifyWidths(int n, int n2) {
        this.iBio = n;
        this.iSed = n2;
        this.setPlotWidth();
        this.repaint();
    }

    public void setPHI(phiListStruct phiListStruct2) {
        if (this.plotPhi != null) {
            this.plotPhi.setPHIData(phiListStruct2);
        }
    }

    public void setRockColumn(rockColumnListStruct rockColumnListStruct2) {
        if (this.pRockColumn != null) {
            this.pRockColumn.setRockColumn(rockColumnListStruct2);
        }
    }

    public void setStructures(sedimentaryListStruct sedimentaryListStruct2) {
        if (this.plotSedimentary != null) {
            this.plotSedimentary.setData(sedimentaryListStruct2);
        }
    }

    public void setFossils(fossilListStruct fossilListStruct2) {
        if (this.plotFossils != null) {
            this.plotFossils.setFossilData(fossilListStruct2);
        }
    }

    public void setRockColorData(rockColorListStruct rockColorListStruct2) {
        if (this.plotRockColor != null) {
            this.plotRockColor.setRockColorData(rockColorListStruct2);
        }
    }

    public void drawDepth(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 50;
        int n5 = 0;
        int n6 = 0;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n = 0; n <= this.iLogHeight; n += this.iIncrementY) {
            int n7 = (int)(this.depthStart + (double)n * this.dIncrementDepth / (double)this.iIncrementY);
            n5 = this.iDataType == 1 ? this.iHeight - n : n + 100;
            int n8 = this.iIncrementY / 5;
            for (n2 = 0; n2 < 5; ++n2) {
                n6 = this.iDataType == 1 ? this.iHeight - (n + n2 * n8) : n + n2 * n8 + 100;
                if (n6 < 100) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n3, n6, n3 + n4, n6);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n3, n5, n3 + n4, n5);
            graphics.drawString("" + n7, this.iStartDepthLabel, n5);
        }
        graphics.drawLine(n3, 100, n3 + n4, 100);
    }

    public void draw(Graphics graphics) {
        int n = 50;
        boolean bl = false;
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        for (int i = 0; i < this.iButtons; ++i) {
            if (this.iSelected[i] == -1) continue;
            this.plotPhi.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.pRockColumn.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotLithology.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotTexture.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotSedimentary.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotFossils.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
            this.plotRockColor.draw(graphics, this.iSelected[i], this.iStart[i], this.iWide[i]);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.draw(graphics);
    }
}

