/*
 * Decompiled with CFR 0.152.
 */
package rock.phi.plot;

import cmn.cmnString;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import mask.maskSymbolsListStruct;
import mask.plot.maskPlotSymbol;
import rock.phi.phiStruct;

public class phiPlotSymbol
extends Canvas
implements MouseListener {
    private Observable notifier = null;
    private maskSymbolsListStruct stSymbols = null;
    private maskPlotSymbol plot = null;
    private static final int NO = 0;
    private static final int YES = 1;
    private static final int _NONE = -1;
    private phiStruct st = null;
    private int[] iSelected = null;
    private int iWidth = 300;
    private int iHeight = 300;
    private static final int _START = 10;
    private static final int _FIRST = 10;
    private static final int _SECOND = 25;
    private static final int _IMAGE_START = 40;
    private static final int _DESC_START = 55;
    private static final int _DESCRIPTION = 63;
    private static final int _SEP = 15;

    public phiPlotSymbol(Observable observable, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.notifier = observable;
        this.stSymbols = maskSymbolsListStruct2;
        if (maskSymbolsListStruct2.iCount > 0) {
            this.iSelected = new int[maskSymbolsListStruct2.iCount];
            for (int i = 0; i < maskSymbolsListStruct2.iCount; ++i) {
                this.iSelected[i] = 0;
            }
        }
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public void close() {
        this.notifier = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.st = null;
        this.iSelected = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public phiStruct getData() {
        return this.st;
    }

    public void setData(phiStruct phiStruct2) {
        int n;
        this.st = phiStruct2;
        for (n = 0; n < this.stSymbols.iCount; ++n) {
            this.iSelected[n] = 0;
        }
        for (n = 0; n < this.stSymbols.iCount; ++n) {
            if (phiStruct2 == null) continue;
            for (int i = 0; i < phiStruct2.iTotal; ++i) {
                if (!phiStruct2.sID[i].equals(this.stSymbols.stItem[n].sID)) continue;
                this.iSelected[n] = 1;
            }
        }
        this.repaint();
    }

    private void togglePHI(int n) {
        this.iSelected[n] = this.iSelected[n] == 0 ? 1 : 0;
    }

    private void modifyPHIList() {
        int n = 0;
        int n2 = 0;
        if (this.st == null) {
            this.st = new phiStruct();
            this.st.sKEY = new String(cmnString.UniqueName());
        }
        for (n = 0; n < this.iSelected.length; ++n) {
            if (this.iSelected[n] != 1) continue;
            ++n2;
        }
        this.st.iTotal = 0;
        this.st.sID = null;
        this.st.sType = null;
        this.st.sText = null;
        if (n2 > 0) {
            this.st.iTotal = n2;
            this.st.sID = new String[n2];
            this.st.sType = new String[n2];
            this.st.sText = new String[n2];
            n2 = 0;
            for (n = 0; n < this.iSelected.length; ++n) {
                if (this.iSelected[n] != 1 || n2 >= this.st.iTotal) continue;
                this.st.sID[n2] = new String(this.stSymbols.stItem[n].sID);
                this.st.sText[n2] = new String(this.stSymbols.stItem[n].sName);
                this.st.sType[n2] = new String("");
                ++n2;
            }
        } else {
            this.st.iTotal = 0;
            this.st.sID = null;
            this.st.sType = null;
            this.st.sText = null;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (n2 < 10 + (i + 1) * 15 || n2 >= 10 + (i + 2) * 15) continue;
            this.togglePHI(i);
        }
        this.modifyPHIList();
        this.repaint();
        this.notifier.notifyObservers(new String("Rock Porosity Changed"));
    }

    public void draw(Graphics graphics) {
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (int i = 0; i < this.stSymbols.iCount; ++i) {
            if (this.notifier != null) {
                graphics.setColor(Color.red);
                if (this.iSelected[i] == 1) {
                    graphics.drawLine(10, 10 + (i + 1) * 15, 20, 10 + (i + 1) * 15 + 10);
                    graphics.drawLine(20, 10 + (i + 1) * 15, 10, 10 + (i + 1) * 15 + 10);
                }
                graphics.setColor(Color.black);
                graphics.drawRect(10, 10 + (i + 1) * 15, 10, 10);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(55, 10 + (i + 1) * 15 + 6, 60, 10 + (i + 1) * 15 + 6);
            graphics.drawString(this.stSymbols.stItem[i].sName, 63, 10 + (i + 1) * 15 + 8);
            this.plot.drawSymbol(graphics, this.stSymbols.stItem[i].iRows, 0, this.stSymbols.stItem[i].symbol, 40, 10 + (i + 1) * 15);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

