/*
 * Decompiled with CFR 0.152.
 */
package rock.phi.gui;

import cmn.cmnString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import mask.maskSymbolsListStruct;
import rock.phi.gui.phiPlotSymbolFrameFocusAdapter;
import rock.phi.gui.phiPlotSymbolPanel;
import rock.phi.phiStruct;

public class phiPlotSymbolFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private maskSymbolsListStruct stSymbols = null;
    private phiPlotSymbolPanel plot = null;
    private phiStruct stPHI = null;
    private String sKEY = "0";
    private double dStart = 0.0;
    private double dEnd = 0.0;
    private double dPHI = 0.0;
    private JTextField txtStart = new JTextField();
    private JTextField txtEnd = new JTextField();
    private JTextField txtPHI = new JTextField();
    private JButton btnAdd = new JButton();
    private JButton btnClear = new JButton();
    private JButton btnCancel = new JButton();
    private JMenuItem mExit = null;
    private int iXStart = 0;
    private int iYStart = 0;
    private int iWidth = 0;
    private int iHeight = 0;

    public phiPlotSymbolFrame(maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public phiPlotSymbolFrame(Observable observable, maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.notifier = observable;
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
            this.addWindowListener(new phiPlotSymbolFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public phiPlotSymbolFrame(Observable observable, int n, int n2, int n3, int n4, maskSymbolsListStruct maskSymbolsListStruct2) {
        try {
            this.notifier = observable;
            this.iXStart = n;
            this.iYStart = n2;
            this.iWidth = n3;
            this.iHeight = n4;
            this.stSymbols = maskSymbolsListStruct2;
            this.jbInit();
            this.addWindowListener(new phiPlotSymbolFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        JPanel jPanel9 = new JPanel();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Starting Depth:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Ending Depth:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Porosity (%)");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Close Dialog");
        this.mExit = new JMenuItem("Close");
        this.mExit.addActionListener(this);
        jMenu.add(this.mExit);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.setTitle("Porosity Symbols");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel2.setLayout(new BorderLayout());
        jPanel3.setLayout(new BorderLayout());
        jPanel5.setPreferredSize(new Dimension(100, 120));
        jPanel5.setLayout(new GridLayout(2, 1));
        jPanel6.setBorder(titledBorder);
        jPanel6.setLayout(new BorderLayout());
        this.txtStart.setText("0.0");
        this.txtStart.setEditable(false);
        this.txtStart.setHorizontalAlignment(11);
        this.txtStart.addFocusListener(new phiPlotSymbolFrameFocusAdapter(this));
        jPanel7.setBorder(titledBorder2);
        jPanel7.setLayout(new BorderLayout());
        this.txtEnd.setText("0.0");
        this.txtEnd.setEditable(false);
        this.txtEnd.setHorizontalAlignment(11);
        this.txtEnd.addFocusListener(new phiPlotSymbolFrameFocusAdapter(this));
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBorder(titledBorder3);
        this.txtPHI.setText("0.0");
        this.txtPHI.setHorizontalAlignment(11);
        this.txtPHI.addFocusListener(new phiPlotSymbolFrameFocusAdapter(this));
        jPanel8.setLayout(new GridLayout(2, 1));
        this.btnAdd.setFont(new Font("Dialog", 1, 11));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(this);
        jPanel9.setLayout(new GridLayout());
        this.btnClear.setFont(new Font("Dialog", 1, 11));
        this.btnClear.setText("Clear");
        this.btnClear.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        this.plot = new phiPlotSymbolPanel(this, this.notifier, this.stSymbols);
        this.getContentPane().add((Component)jPanel2, "West");
        jPanel2.add((Component)jPanel3, "North");
        jPanel3.add((Component)jPanel5, "North");
        jPanel5.add((Component)jPanel6, null);
        jPanel6.add((Component)this.txtStart, "Center");
        jPanel5.add((Component)jPanel7, null);
        jPanel7.add((Component)this.txtEnd, "Center");
        jPanel3.add((Component)jPanel4, "Center");
        jPanel4.add((Component)this.txtPHI, "Center");
        jPanel3.add((Component)jPanel8, "South");
        jPanel8.add((Component)this.btnAdd, null);
        jPanel8.add((Component)jPanel9, null);
        jPanel9.add((Component)this.btnClear, null);
        this.getContentPane().add((Component)this.plot, "Center");
        this.setSize(new Dimension(500, 550));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getSize().width) / 2;
        if (this.iWidth > 0) {
            n = this.iXStart + this.iWidth;
        }
        this.setLocation(n, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    public phiStruct getData() {
        if (this.stPHI == null) {
            this.stPHI = new phiStruct();
            this.sKEY = new String(cmnString.UniqueName());
        }
        if (this.plot != null) {
            this.stPHI = this.plot.getData();
        }
        this.stPHI.sKEY = new String(this.sKEY);
        this.stPHI.depthStart = this.dStart;
        this.stPHI.depthEnd = this.dEnd;
        if (this.dEnd == 0.0) {
            this.dEnd = this.dStart;
        }
        this.stPHI.dPHI = this.dPHI;
        return this.stPHI;
    }

    public void setData(phiStruct phiStruct2) {
        this.stPHI = phiStruct2;
        if (phiStruct2 != null) {
            this.sKEY = new String(phiStruct2.sKEY);
            this.dStart = phiStruct2.depthStart;
            this.dEnd = phiStruct2.depthEnd;
            this.txtStart.setText("" + this.dStart);
            this.txtEnd.setText("" + this.dEnd);
            this.dPHI = phiStruct2.dPHI;
            this.txtPHI.setText("" + phiStruct2.dPHI);
        }
        if (this.plot != null) {
            this.plot.setData(phiStruct2);
        }
        this.btnAdd.setText("Modify");
    }

    public void setDepthRange(double d, double d2) {
        this.dStart = d;
        this.txtStart.setText("" + this.dStart);
        this.dEnd = d2;
        this.txtEnd.setText("" + this.dEnd);
    }

    public void add() {
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("ADD or MODIFY Porosity Data"));
        }
    }

    public void cancel() {
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("Cancel Edit"));
        }
    }

    public void clear() {
        this.dPHI = 0.0;
        this.txtPHI.setText("0.0");
        if (this.stPHI != null) {
            this.stPHI.delete();
        }
        this.stPHI = null;
        if (this.plot != null) {
            this.plot.setData(this.stPHI);
        }
    }

    public void close() {
        this.notifier = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
        this.stPHI = null;
        this.sKEY = null;
        this.txtStart = null;
        this.txtEnd = null;
        this.txtPHI = null;
        this.btnAdd = null;
        this.btnClear = null;
        this.btnCancel = null;
        this.mExit = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnAdd) {
            this.add();
        }
        if (actionEvent.getSource() == this.btnClear) {
            this.clear();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.cancel();
        }
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtStart) {
            bl = true;
            string2 = this.txtStart.getText();
            string = new String("Start Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtEnd) {
            bl = true;
            string2 = this.txtEnd.getText();
            string = new String("End Depth Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtPHI) {
            bl = true;
            string2 = this.txtPHI.getText();
            string = new String("Porosity Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtStart) {
                    this.dStart = cmnString.stringToDouble(this.txtStart.getText());
                }
                if (focusEvent.getSource() == this.txtEnd) {
                    this.dEnd = cmnString.stringToDouble(this.txtEnd.getText());
                }
                if (focusEvent.getSource() == this.txtPHI) {
                    this.dPHI = cmnString.stringToDouble(this.txtPHI.getText());
                }
            }
        }
    }

    public class phiPlotSymbolFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (phiPlotSymbolFrame.this.notifier != null) {
                phiPlotSymbolFrame.this.notifier.notifyObservers(new String("Cancel Edit"));
            }
        }
    }
}

