/*
 * Decompiled with CFR 0.152.
 */
package rock.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import rock.rockImagesListStruct;
import rock.rockImagesStruct;

public class ReadRockImageXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    public static final String ROOTNAME = "image_files";
    public static final String RECORDS = "records";
    public static final String WELL = "well";
    public static final String KID = "kid";
    public static final String KEY = "key";
    public static final String TYPE = "type";
    public static final String API_NUMBER = "api";
    public static final String NAME = "name";
    public static final String WELL_STATUS = "status";
    public static final String ERROR_VAL = "error";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String DEPTH = "depth";
    public static final String GROUND_LEVEL = "gl";
    public static final String IMAGE = "image";
    public static final String LOCATION = "location";
    public static final String DIRECTORY = "dir";
    public static final String PATH = "path";
    public static final String FILENAME = "filename";
    public static final String FILENAME_P = "filenam_p";
    public static final String FORMAT = "format";
    public static final String IMAGE_TYPE = "type";
    public static final String START_DEPTH = "start";
    public static final String END_DEPTH = "end";
    public static final String AUTHORS = "authors";
    public static final String YEAR = "year";
    public static final String TITLE = "title";
    public static final String SOURCE = "source";
    public static final String DATE = "date";
    public static final String THUMBNAIL = "thumbnail";
    public static final String DESCRIPTION = "desc";
    public static final String COMMENTS = "comments";
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private static final int _NONE = 0;
    private static final int _WELL = 1;
    private static final int _DATA = 2;
    private int iData = 0;
    private int iDescription = 0;
    private int iComments = 0;
    private rockImagesListStruct stList = new rockImagesListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadRockImageXMLFile() {
        this.iType = 0;
    }

    public ReadRockImageXMLFile(int n) {
        this.iType = n;
    }

    public rockImagesListStruct Process(String string) {
        this.stList.iCount = 0;
        this.Read(string);
        this.stList.iCount = this.iCount + 1;
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(WELL)) {
            this.iData = 1;
        }
        if (string4.equals(IMAGE)) {
            this.iDescription = 0;
            this.iComments = 0;
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new rockImagesStruct();
            }
            this.iData = 2;
        }
        if (string4.equals(DESCRIPTION)) {
            this.iDescription = 1;
            this.iComments = 0;
        }
        if (string4.equals(COMMENTS)) {
            this.iDescription = 0;
            this.iComments = 1;
        }
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stList.stItem = new rockImagesStruct[this.iRows];
                    }
                }
                if (this.iData == 1) {
                    this.ParseData(string5, string7.trim());
                }
                if (this.iData != 2 || this.iCount <= -1 || this.iCount >= this.iRows) continue;
                this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.iDescription == 1) {
            this.stList.stItem[this.iCount].sDescription = new String(this.stList.stItem[this.iCount].sDescription + " " + string.trim());
        }
        if (this.iComments == 1) {
            this.stList.stItem[this.iCount].sComments = new String(this.stList.stItem[this.iCount].sComments + " " + string.trim());
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private rockImagesStruct ParseData(String string, String string2, rockImagesStruct rockImagesStruct2) {
        if (string.equals(KID)) {
            rockImagesStruct2.sKID = new String(string2);
        }
        if (string.equals(KEY)) {
            rockImagesStruct2.sKEY = new String(string2);
        }
        if (string.equals(LOCATION)) {
            rockImagesStruct2.sLocation = new String(string2);
        }
        if (string.equals(DIRECTORY)) {
            rockImagesStruct2.sDirectory = new String(string2);
        }
        if (string.equals(PATH)) {
            rockImagesStruct2.sURL = new String(string2);
        }
        if (string.equals(FILENAME)) {
            rockImagesStruct2.sFilename = new String(string2);
        }
        if (string.equals(FILENAME_P)) {
            rockImagesStruct2.sOriginal = new String(string2);
        }
        if (string.equals(FORMAT)) {
            rockImagesStruct2.sFormat = new String(string2);
        }
        if (string.equals("type")) {
            rockImagesStruct2.sType = new String(string2);
        }
        if (string.equals(START_DEPTH)) {
            rockImagesStruct2.depthStart = 0.0;
            if (cmnString.isNumeric(string2)) {
                rockImagesStruct2.depthStart = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals(END_DEPTH)) {
            rockImagesStruct2.depthEnd = 0.0;
            if (cmnString.isNumeric(string2)) {
                rockImagesStruct2.depthEnd = cmnString.stringToDouble(string2);
            }
        }
        if (string.equals(AUTHORS)) {
            rockImagesStruct2.sAuthors = new String(string2);
        }
        if (string.equals(YEAR)) {
            rockImagesStruct2.sYear = new String(string2);
        }
        if (string.equals(TITLE)) {
            rockImagesStruct2.sTitle = new String(string2);
        }
        if (string.equals(SOURCE)) {
            rockImagesStruct2.source = new String(string2);
            this.stList.sIMAGE_SRC = new String(string2);
        }
        if (string.equals(DATE)) {
            rockImagesStruct2.sDate = new String(string2);
            this.stList.sIMAGE_DATE = new String(string2);
        }
        if (string.equals(THUMBNAIL)) {
            rockImagesStruct2.sThumbnail = new String(string2);
        }
        return rockImagesStruct2;
    }

    private void ParseData(String string, String string2) {
        if (string.equals(KID)) {
            this.stList.sKID = new String(string2);
        }
        if (string.equals(KEY)) {
            this.stList.sKEY = new String(string2);
        }
        if (string.equals("type")) {
            if (string2.equals("WELL")) {
                this.stList.iType = 0;
            }
            if (string2.equals("OUTCROP")) {
                this.stList.iType = 1;
            }
        }
        if (string.equals(API_NUMBER)) {
            this.stList.sAPI = new String(string2);
        }
        if (string.equals(NAME)) {
            this.stList.sName = new String(string2);
        }
        if (string.equals(WELL_STATUS)) {
            this.stList.status = new String(string2);
        }
        if (string.equals(ERROR_VAL)) {
            this.iError = -1;
            this.sError = new String(string2);
        }
        if (string.equals(LATITUDE)) {
            this.stList.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONGITUDE)) {
            this.stList.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(DEPTH)) {
            this.stList.depth = cmnString.stringToDouble(string2);
        }
        if (string.equals(GROUND_LEVEL)) {
            this.stList.dGL = cmnString.stringToDouble(string2);
        }
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

