/*
 * Decompiled with CFR 0.152.
 */
package rock.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import rock.rockColumnsStruct;
import rock.rockDataListStruct;
import rock.rockDataStruct;
import rock.rockDataUtility;

public class ReadRockDataXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    private int iRows = 0;
    private int iCount = -1;
    private int iComments = 0;
    private static final int _NONE = 0;
    private static final int _WELL = 1;
    private static final int _COLUMNS = 2;
    private static final int _DATA = 3;
    public static final String ROOTNAME = "rock_data";
    public static final String RECORDS = "records";
    public static final String WELL = "well";
    public static final String KID = "kid";
    public static final String KEY = "key";
    public static final String TYPE = "type";
    public static final String API_NUMBER = "api";
    public static final String WELL_STATUS = "status";
    public static final String ERROR_VAL = "error";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String DEPTH = "depth";
    public static final String GROUND_LEVEL = "gl";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String MNEMONIC = "mnemonic";
    public static final String NAME = "name";
    public static final String UNIT = "unit";
    public static final String DATA = "data";
    public static final String ROW = "row";
    public static final String KID_R = "KID";
    public static final String KEY_R = "KEY";
    public static final String PUBLIC = "PUBLIC";
    public static final String TOP = "TOP";
    public static final String BASE = "BASE";
    public static final String CORRECTION = "CORR";
    public static final String STU = "STU";
    public static final String STN = "STN";
    public static final String ENV = "ENV";
    public static final String LITHO = "LITHO";
    public static final String PCORE = "PCORE";
    public static final String PPLUG = "PPLUG";
    public static final String P800 = "P800";
    public static final String PINSI = "PINSI";
    public static final String PEFF = "PEFF";
    public static final String KMAX = "KMAX";
    public static final String K90 = "K90";
    public static final String KVRT = "KVRT";
    public static final String KPLG = "KPLG";
    public static final String KKL = "KKL";
    public static final String KINSI = "KINSI";
    public static final String KKLIN = "KKLIN";
    public static final String KPVRT = "KPVRT";
    public static final String SOIL = "SOIL";
    public static final String SW = "SW";
    public static final String GMCC = "GMCC";
    public static final String RHOD = "RHOD";
    public static final String RHOW = "RHOW";
    public static final String MAMB = "MAMB";
    public static final String MINSI = "MINSI";
    public static final String NAMB = "NAMB";
    public static final String NINSI = "NINSI";
    public static final String GR = "GR";
    public static final String CGR = "CGR";
    public static final String THOR = "THOR";
    public static final String URAN = "URAN";
    public static final String POTA = "POTA";
    public static final String LTHCD = "LTHCD";
    public static final String FRACTURE = "FRACTURE";
    public static final String SOURCE = "source";
    public static final String DATE = "date";
    public static final String COMMENTS = "comments";
    private int iData = 0;
    private rockColumnsStruct stColumn = new rockColumnsStruct();
    private rockDataListStruct stList = new rockDataListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadRockDataXMLFile() {
        this.iType = 0;
    }

    public ReadRockDataXMLFile(int n) {
        this.iType = n;
    }

    public rockDataListStruct Process(String string) {
        this.Read(string);
        this.stList = rockDataUtility.computeDepthRange(this.stList);
        this.stList = rockDataUtility.computeBulkDensity(this.stList);
        this.stList = rockDataUtility.bubbleSort(this.stList);
        this.stList = rockDataUtility.addBaseDepth(this.stList);
        this.stList = rockDataUtility.addPorosity(this.stList);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadRockDataXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadRockDataXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(WELL)) {
            this.iData = 1;
            this.stList._TOP = -1;
            this.stList._BASE = -1;
            this.stList._CORR = -1;
            this.stList._STU = -1;
            this.stList._STN = -1;
            this.stList._ENV = -1;
            this.stList._LITHO = -1;
            this.stList._PCORE = -1;
            this.stList._PPLUG = -1;
            this.stList._P800 = -1;
            this.stList._PINSI = -1;
            this.stList._PEFF = -1;
            this.stList._KMAX = -1;
            this.stList._K90 = -1;
            this.stList._KVRT = -1;
            this.stList._KPLG = -1;
            this.stList._KKL = -1;
            this.stList._KINSI = -1;
            this.stList._KKLIN = -1;
            this.stList._KPVRT = -1;
            this.stList._SOIL = -1;
            this.stList._SW = -1;
            this.stList._GMCC = -1;
            this.stList._RHOD = -1;
            this.stList._RHOW = -1;
            this.stList._MAMB = -1;
            this.stList._MINSI = -1;
            this.stList._NAMB = -1;
            this.stList._NINSI = -1;
            this.stList._LTHCD = -1;
            this.stList._FRACTURE = -1;
            this.stList._GR = -1;
            this.stList._CGR = -1;
            this.stList._TH = -1;
            this.stList._U = -1;
            this.stList._K = -1;
        }
        if (string4.equals(COLUMNS)) {
            this.iRows = 0;
            this.iCount = -1;
            this.iData = 2;
        }
        if (string4.equals(COLUMN)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stColumns[this.iCount] = new rockColumnsStruct();
            }
        }
        if (string4.equals(DATA)) {
            this.iComments = 0;
            this.iRows = 0;
            this.iCount = -1;
            this.iData = 3;
        }
        if (string4.equals(ROW)) {
            ++this.iCount;
            if (this.iCount < this.iRows) {
                this.stList.stItem[this.iCount] = new rockDataStruct();
            }
        }
        if (string4.equals(COMMENTS)) {
            this.iComments = 1;
        }
        if (attributes != null) {
            block11: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    switch (this.iData) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stColumns = new rockColumnsStruct[this.iRows];
                            this.stList.iColumns = this.iRows;
                            break;
                        }
                        case 3: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem = new rockDataStruct[this.iRows];
                            this.stList.iCount = this.iRows;
                        }
                    }
                }
                if (this.iCount <= -1) continue;
                switch (this.iData) {
                    case 0: {
                        continue block11;
                    }
                    case 1: {
                        this.ParseData(string5, string7.trim());
                        continue block11;
                    }
                    case 2: {
                        if (this.iCount >= this.iRows) continue block11;
                        this.stList.stColumns[this.iCount] = this.ParseColumns(string5, string7.trim(), this.stList.stColumns[this.iCount]);
                        continue block11;
                    }
                    case 3: {
                        if (this.iCount >= this.iRows) continue block11;
                        this.stList.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iCount]);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        String string = new String(cArray, n, n2);
        if (this.iComments == 1) {
            this.stList.stItem[this.iCount].sComments = new String(this.stList.stItem[this.iCount].sComments + " " + string.trim());
        }
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private rockColumnsStruct ParseColumns(String string, String string2, rockColumnsStruct rockColumnsStruct2) {
        if (string.equals(MNEMONIC)) {
            rockColumnsStruct2.sMnemonic = new String(string2);
        }
        if (string.equals(NAME)) {
            rockColumnsStruct2.sName = new String(string2);
        }
        if (string.equals(UNIT)) {
            rockColumnsStruct2.sUnit = new String(string2);
        }
        if (string.equals(TYPE)) {
            rockColumnsStruct2.sKEY = new String(string2);
        }
        return rockColumnsStruct2;
    }

    private rockDataStruct ParseData(String string, String string2, rockDataStruct rockDataStruct2) {
        if (string.equals(KID_R)) {
            rockDataStruct2.sKID = new String(string2);
        }
        if (string.equals(KEY_R)) {
            rockDataStruct2.sKEY = new String(string2);
        }
        if (string.equals(PUBLIC)) {
            rockDataStruct2.sProprietary = new String(string2);
        }
        if (string.equals(TOP) && cmnString.isNumeric(string2)) {
            this.stList._TOP = 1;
            rockDataStruct2.dTOP = cmnString.stringToDouble(string2);
        }
        if (string.equals(BASE) && cmnString.isNumeric(string2)) {
            this.stList._BASE = 1;
            rockDataStruct2.dBASE = cmnString.stringToDouble(string2);
        }
        if (string.equals(CORRECTION) && cmnString.isNumeric(string2)) {
            this.stList._CORR = 1;
            rockDataStruct2.dCORR = cmnString.stringToDouble(string2);
        }
        if (string.equals(STU)) {
            this.stList._STU = 1;
            rockDataStruct2.sUNIT = new String(string2);
        }
        if (string.equals(STN)) {
            this.stList._STN = 1;
            rockDataStruct2.sNAME = new String(string2);
        }
        if (string.equals(ENV)) {
            this.stList._ENV = 1;
            rockDataStruct2.sENV = new String(string2);
        }
        if (string.equals(LITHO)) {
            this.stList._LITHO = 1;
            rockDataStruct2.sLITHO = new String(string2);
        }
        if (string.equals(PCORE) && cmnString.isNumeric(string2)) {
            this.stList._PCORE = 1;
            rockDataStruct2.dPCORE = cmnString.stringToDouble(string2);
        }
        if (string.equals(PPLUG) && cmnString.isNumeric(string2)) {
            this.stList._PPLUG = 1;
            rockDataStruct2.dPPLUG = cmnString.stringToDouble(string2);
        }
        if (string.equals(P800) && cmnString.isNumeric(string2)) {
            this.stList._P800 = 1;
            rockDataStruct2.dP800 = cmnString.stringToDouble(string2);
        }
        if (string.equals(PINSI) && cmnString.isNumeric(string2)) {
            this.stList._PINSI = 1;
            rockDataStruct2.dPINSI = cmnString.stringToDouble(string2);
        }
        if (string.equals(PEFF) && cmnString.isNumeric(string2)) {
            this.stList._PEFF = 1;
            rockDataStruct2.dPEFF = cmnString.stringToDouble(string2);
        }
        if (string.equals(KMAX) && cmnString.isNumeric(string2)) {
            this.stList._KMAX = 1;
            rockDataStruct2.dKMAX = cmnString.stringToDouble(string2);
        }
        if (string.equals(K90) && cmnString.isNumeric(string2)) {
            this.stList._K90 = 1;
            rockDataStruct2.dK90 = cmnString.stringToDouble(string2);
        }
        if (string.equals(KVRT) && cmnString.isNumeric(string2)) {
            this.stList._KVRT = 1;
            rockDataStruct2.dKVRT = cmnString.stringToDouble(string2);
        }
        if (string.equals(KPLG) && cmnString.isNumeric(string2)) {
            this.stList._KPLG = 1;
            rockDataStruct2.dKPLG = cmnString.stringToDouble(string2);
        }
        if (string.equals(KKL) && cmnString.isNumeric(string2)) {
            this.stList._KKL = 1;
            rockDataStruct2.dKKL = cmnString.stringToDouble(string2);
        }
        if (string.equals(KINSI) && cmnString.isNumeric(string2)) {
            this.stList._KINSI = 1;
            rockDataStruct2.dKINSI = cmnString.stringToDouble(string2);
        }
        if (string.equals(KKLIN) && cmnString.isNumeric(string2)) {
            this.stList._KKLIN = 1;
            rockDataStruct2.dKKLIN = cmnString.stringToDouble(string2);
        }
        if (string.equals(KPVRT) && cmnString.isNumeric(string2)) {
            this.stList._KPVRT = 1;
            rockDataStruct2.dKPVRT = cmnString.stringToDouble(string2);
        }
        if (string.equals(SOIL) && cmnString.isNumeric(string2)) {
            this.stList._SOIL = 1;
            rockDataStruct2.dSOIL = cmnString.stringToDouble(string2);
        }
        if (string.equals(SW) && cmnString.isNumeric(string2)) {
            this.stList._SW = 1;
            rockDataStruct2.dSW = cmnString.stringToDouble(string2);
        }
        if (string.equals(GMCC) && cmnString.isNumeric(string2)) {
            this.stList._GMCC = 1;
            rockDataStruct2.dGMCC = cmnString.stringToDouble(string2);
        }
        if (string.equals(RHOD) && cmnString.isNumeric(string2)) {
            this.stList._RHOD = 1;
            rockDataStruct2.dRHOD = cmnString.stringToDouble(string2);
        }
        if (string.equals(RHOW) && cmnString.isNumeric(string2)) {
            this.stList._RHOW = 1;
            rockDataStruct2.dRHOW = cmnString.stringToDouble(string2);
        }
        if (string.equals(MAMB) && cmnString.isNumeric(string2)) {
            this.stList._MAMB = 1;
            rockDataStruct2.dMAMB = cmnString.stringToDouble(string2);
        }
        if (string.equals(MINSI) && cmnString.isNumeric(string2)) {
            this.stList._MINSI = 1;
            rockDataStruct2.dMINSI = cmnString.stringToDouble(string2);
        }
        if (string.equals(NAMB) && cmnString.isNumeric(string2)) {
            this.stList._NAMB = 1;
            rockDataStruct2.dNAMB = cmnString.stringToDouble(string2);
        }
        if (string.equals(NINSI) && cmnString.isNumeric(string2)) {
            this.stList._NINSI = 1;
            rockDataStruct2.dNINSI = cmnString.stringToDouble(string2);
        }
        if (string.equals(GR) && cmnString.isNumeric(string2)) {
            this.stList._GR = 1;
            rockDataStruct2.dGR = cmnString.stringToDouble(string2);
        }
        if (string.equals(CGR) && cmnString.isNumeric(string2)) {
            this.stList._CGR = 1;
            rockDataStruct2.dCGR = cmnString.stringToDouble(string2);
        }
        if (string.equals(THOR) && cmnString.isNumeric(string2)) {
            this.stList._TH = 1;
            rockDataStruct2.dTh = cmnString.stringToDouble(string2);
        }
        if (string.equals(URAN) && cmnString.isNumeric(string2)) {
            this.stList._U = 1;
            rockDataStruct2.dU = cmnString.stringToDouble(string2);
        }
        if (string.equals(POTA) && cmnString.isNumeric(string2)) {
            this.stList._K = 1;
            rockDataStruct2.dK = cmnString.stringToDouble(string2);
        }
        if (string.equals(LTHCD) && cmnString.isNumeric(string2)) {
            this.stList._LTHCD = 1;
            rockDataStruct2.iLITH_CD = cmnString.stringToInt(string2);
        }
        if (string.equals(FRACTURE)) {
            this.stList._FRACTURE = 1;
            rockDataStruct2.sFracture = new String(string2);
        }
        if (string.equals(SOURCE)) {
            rockDataStruct2.source = new String(string2);
        }
        if (string.equals(DATE)) {
            rockDataStruct2.sDate = new String(string2);
        }
        return rockDataStruct2;
    }

    private void ParseData(String string, String string2) {
        if (string.equals(KID)) {
            this.stList.sKID = new String(string2);
        }
        if (string.equals(KEY)) {
            this.stList.sKEY = new String(string2);
        }
        if (string.equals(TYPE)) {
            if (string2.equals("WELL")) {
                this.stList.iType = 0;
            }
            if (string2.equals("OUTCROP")) {
                this.stList.iType = 1;
            }
        }
        if (string.equals(API_NUMBER)) {
            this.stList.sAPI = new String(string2);
        }
        if (string.equals(NAME)) {
            this.stList.sName = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(WELL_STATUS)) {
            this.stList.status = new String(string2.replaceAll("%20", " "));
        }
        if (string.equals(ERROR_VAL)) {
            this.iError = -1;
            this.sError = new String(string2);
        }
        if (string.equals(LATITUDE)) {
            this.stList.dLatitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(LONGITUDE)) {
            this.stList.dLongitude = cmnString.stringToDouble(string2);
        }
        if (string.equals(DEPTH)) {
            this.stList.depth = cmnString.stringToDouble(string2);
        }
        if (string.equals(GROUND_LEVEL)) {
            this.stList.dGL = cmnString.stringToDouble(string2);
        }
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

