/*
 * Decompiled with CFR 0.152.
 */
package rock.fossil.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import mask.maskSymbolsListStruct;
import mask.maskSymbolsUtility;
import mask.plot.maskPlotSymbol;
import rock.fossil.fossilListStruct;

public class fossilPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private fossilListStruct stFossil = null;
    private maskSymbolsListStruct stSymbols = null;
    private maskPlotSymbol plot = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public fossilPlotTrack(int n, double d, double d2, int n2, maskSymbolsListStruct maskSymbolsListStruct2) {
        this.iDataType = n;
        this.stSymbols = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stFossil = null;
        this.stSymbols = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public fossilListStruct getFossilData() {
        return this.stFossil;
    }

    private int getNextDepth(int n, double d) {
        int n2 = -1;
        int n3 = (int)d;
        d = n3;
        if (n > -1 && this.stFossil != null) {
            for (int i = n; i < this.stFossil.iCount; ++i) {
                if (n2 != -1 || !(this.stFossil.stItem[i].depthStart >= this.stFossil.stItem[n].depthEnd + d)) continue;
                n2 = i;
                break;
            }
        }
        return n2;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setFossilData(fossilListStruct fossilListStruct2) {
        this.stFossil = fossilListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = n + n2;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        n3 = n2 / 10;
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n7 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n6 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n8 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n6) : n4 + n5 * n6 + 100;
                if (n8 < 100 || n8 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n8, n9, n8);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n7, n9, n7);
        }
        graphics.setColor(Color.black);
        this.plot.drawSymbol(graphics, this.stSymbols.stItem[0].iRows, 0, this.stSymbols.stItem[0].symbol, n + 5 * (n3 - 1) + 1, 29);
        graphics.drawLine(n, 25, n9, 25);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Fossils", 45, -1 * (n + 5 * (n3 - 1) + 3));
        graphics2D.rotate(-1.5707963267948966);
    }

    public void drawFossils(Graphics graphics, int n, int n2) {
        int n3 = n;
        int n4 = n + n2;
        int n5 = -1;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = -1;
        int[] nArray = new int[]{255, 255, 255};
        int n12 = -1;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n13 = -1;
        double d5 = (double)iqstratTracksStruct.SCALE[this.iScale] / 10.0;
        if (this.stFossil != null) {
            for (int i = 0; i < this.stFossil.iCount; ++i) {
                d2 = this.stFossil.stItem[i].depthStart;
                d3 = this.stFossil.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d;
                }
                if (n6 == n7) {
                    n6 -= 5;
                    n7 -= 5;
                }
                if ((n9 = (n8 = Math.abs(n7 - n6)) / 10) == 0) {
                    n9 = 1;
                }
                n11 = maskSymbolsUtility.getColor(this.stFossil.stItem[i].sEnvironment, this.stSymbols.stBackground);
                nArray = maskSymbolsUtility.getRGB(n11, this.stSymbols.stBackground);
                if (n6 >= 100 && n7 > 100 && n6 < this.iHeight && n7 <= this.iHeight) {
                    for (int j = 0; j < n9; ++j) {
                        n10 = n;
                        n8 = n6 + j * 10;
                        for (int k = 0; k < this.stFossil.stItem[i].iTotal; ++k) {
                            n5 = maskSymbolsUtility.getSymbolID(this.stFossil.stItem[i].sID[k], 0, this.stSymbols);
                            if (n5 <= -1) continue;
                            if (this.stFossil.stItem[i].sMod[k].equals("Rare")) {
                                if (n11 > -1) {
                                    maskPlotSymbol.drawBackground(graphics, nArray[0], nArray[1], nArray[2], n10, n8, 3, 10);
                                }
                                if ((n12 = maskSymbolsUtility.getSymbolIDByName("few left", 1, this.stSymbols)) > -1) {
                                    this.plot.drawSymbol(graphics, this.stSymbols.stModifiers[n12].iRows, 0, this.stSymbols.stModifiers[n12].symbol, n10, n8);
                                }
                                n10 += 3;
                            }
                            if (n11 > -1) {
                                maskPlotSymbol.drawBackground(graphics, nArray[0], nArray[1], nArray[2], n10, n8, 10, 10);
                            }
                            this.plot.drawSymbol(graphics, this.stSymbols.stItem[n5].iRows, 0, this.stSymbols.stItem[n5].symbol, n10, n8);
                            if (this.stFossil.stItem[i].sMod[k].equals("Broken") && (n12 = maskSymbolsUtility.getSymbolIDByName("broken", 1, this.stSymbols)) > -1) {
                                this.plot.drawSymbol(graphics, this.stSymbols.stModifiers[n12].iRows, 0, this.stSymbols.stModifiers[n12].symbol, n10, n8);
                            }
                            if (this.stFossil.stItem[i].sMod[k].equals("Abundant") && (n12 = maskSymbolsUtility.getSymbolIDByName("rich", 1, this.stSymbols)) > -1) {
                                this.plot.drawSymbol(graphics, this.stSymbols.stModifiers[n12].iRows, 0, this.stSymbols.stModifiers[n12].symbol, n10, n8);
                            }
                            n10 += 10;
                            if (this.stFossil.stItem[i].sMod[k].equals("Rare")) {
                                if (n11 > -1) {
                                    maskPlotSymbol.drawBackground(graphics, nArray[0], nArray[1], nArray[2], n10, n8, 3, 10);
                                }
                                if ((n12 = maskSymbolsUtility.getSymbolIDByName("few right", 1, this.stSymbols)) > -1) {
                                    this.plot.drawSymbol(graphics, this.stSymbols.stModifiers[n12].iRows, 0, this.stSymbols.stModifiers[n12].symbol, n10, n8);
                                }
                                n10 += 3;
                            }
                            n10 += 2;
                        }
                    }
                }
                if ((n13 = this.getNextDepth(i, d5)) <= 0 || n13 - 1 <= i) continue;
                i = n13 - 1;
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 1;
        if (n == 80) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGrid(graphics, n2, n3);
            this.drawFossils(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

