/*
 * Decompiled with CFR 0.152.
 */
package rock.fossil.plot;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import mask.maskSymbolsListStruct;
import mask.maskSymbolsUtility;
import mask.plot.maskPlotSymbol;

public class fossilPlotLegend
extends Canvas {
    private int[] iSelected = null;
    private maskSymbolsListStruct stFossils = null;
    private maskPlotSymbol plot = null;
    private int iWidth = 250;
    private int iHeight = 950;
    private static final int _START = 10;
    private static final int _IMAGE_START = 10;
    private static final int _DESC_START = 25;
    private static final int _DESCRIPTION = 35;
    private static final int _SEP = 20;

    public fossilPlotLegend(int[] nArray, maskSymbolsListStruct maskSymbolsListStruct2) {
        int n = 0;
        this.iSelected = nArray;
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 0) continue;
                ++n;
            }
        }
        this.stFossils = maskSymbolsListStruct2;
        this.plot = new maskPlotSymbol(maskSymbolsListStruct2);
        this.iHeight = 100 + 20 * n;
    }

    public void close() {
        this.iSelected = null;
        this.stFossils = null;
        if (this.plot != null) {
            this.plot.close();
        }
        this.plot = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public int drawLegend(Graphics graphics, int n) {
        int n2 = -1;
        int[] nArray = new int[]{255, 255, 255};
        int n3 = 10;
        int n4 = this.iWidth;
        int n5 = n4 / 5;
        int n6 = n3 + n4;
        int n7 = -1;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        n2 = maskSymbolsUtility.getColor("Fresh Water", this.stFossils.stBackground);
        nArray = maskSymbolsUtility.getRGB(n2, this.stFossils.stBackground);
        maskPlotSymbol.drawBackground(graphics, nArray[0], nArray[1], nArray[2], n3 + 5, n, 10, 10);
        graphics.setColor(Color.black);
        graphics.drawString("Fresh Water", n3 + 20, n + 8);
        n2 = maskSymbolsUtility.getColor("Brackish Water", this.stFossils.stBackground);
        nArray = maskSymbolsUtility.getRGB(n2, this.stFossils.stBackground);
        maskPlotSymbol.drawBackground(graphics, nArray[0], nArray[1], nArray[2], n3 + 5, n + 15, 10, 10);
        graphics.setColor(Color.black);
        graphics.drawString("Brackish Water", n3 + 20, n + 23);
        n2 = maskSymbolsUtility.getColor("Marine", this.stFossils.stBackground);
        nArray = maskSymbolsUtility.getRGB(n2, this.stFossils.stBackground);
        maskPlotSymbol.drawBackground(graphics, nArray[0], nArray[1], nArray[2], n3 + 5, n + 30, 10, 10);
        graphics.setColor(Color.black);
        graphics.drawString("Marine", n3 + 20, n + 38);
        n7 = maskSymbolsUtility.getSymbolIDByName("few left", 1, this.stFossils);
        if (n7 > -1) {
            this.plot.drawSymbol(graphics, this.stFossils.stModifiers[n7].iRows, 0, this.stFossils.stModifiers[n7].symbol, n3 + n4 / 2 + 17, n);
        }
        this.plot.drawSymbol(graphics, this.stFossils.stItem[0].iRows, 0, this.stFossils.stItem[0].symbol, n3 + n4 / 2 + 20, n);
        n7 = maskSymbolsUtility.getSymbolIDByName("few right", 1, this.stFossils);
        if (n7 > -1) {
            this.plot.drawSymbol(graphics, this.stFossils.stModifiers[n7].iRows, 0, this.stFossils.stModifiers[n7].symbol, n3 + n4 / 2 + 30, n);
        }
        graphics.setColor(Color.black);
        graphics.drawString("Few", n3 + n4 / 2 + 35, n + 8);
        this.plot.drawSymbol(graphics, this.stFossils.stItem[0].iRows, 0, this.stFossils.stItem[0].symbol, n3 + n4 / 2 + 20, n + 15);
        n7 = maskSymbolsUtility.getSymbolIDByName("rich", 1, this.stFossils);
        if (n7 > -1) {
            this.plot.drawSymbol(graphics, this.stFossils.stModifiers[n7].iRows, 0, this.stFossils.stModifiers[n7].symbol, n3 + n4 / 2 + 20, n + 15);
        }
        graphics.setColor(Color.black);
        graphics.drawString("Many", n3 + n4 / 2 + 35, n + 23);
        this.plot.drawSymbol(graphics, this.stFossils.stItem[0].iRows, 0, this.stFossils.stItem[0].symbol, n3 + n4 / 2 + 20, n + 30);
        n7 = maskSymbolsUtility.getSymbolIDByName("broken", 1, this.stFossils);
        if (n7 > -1) {
            this.plot.drawSymbol(graphics, this.stFossils.stModifiers[n7].iRows, 0, this.stFossils.stModifiers[n7].symbol, n3 + n4 / 2 + 20, n + 30);
        }
        graphics.setColor(Color.black);
        graphics.drawString("Broken", n3 + n4 / 2 + 35, n + 38);
        return n + 50;
    }

    public void draw(Graphics graphics) {
        int n = 10;
        int n2 = 0;
        int n3 = 0;
        String string = "";
        Font font = new Font("Serif", 1, 14);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        string = new String("Fossils");
        n2 = string.length();
        graphics.setColor(Color.black);
        graphics.drawString(string, this.iWidth / 2 - 4 * n2, n);
        n = this.drawLegend(graphics, n + 20);
        font = new Font("Serif", 1, 12);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stFossils != null) {
            for (int i = 0; i < this.stFossils.iCount; ++i) {
                if (this.iSelected == null || this.iSelected[i] != 0) continue;
                graphics.drawLine(25, n + n3 * 20 + 6, 30, n + n3 * 20 + 6);
                graphics.drawString(this.stFossils.stItem[i].sName.trim(), 35, n + n3 * 20 + 8);
                this.plot.drawSymbol(graphics, this.stFossils.stItem[i].iRows, 0, this.stFossils.stItem[i].symbol, 10, n + n3 * 20);
                ++n3;
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
        this.draw(graphics);
    }
}

