/*
 * Decompiled with CFR 0.152.
 */
package rock.color.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import rock.color.rockColorListStruct;

public class rockColorPlotTrack
extends Canvas {
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private rockColorListStruct stColor = null;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public rockColorPlotTrack(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stColor = null;
    }

    public int getPlotWidth() {
        return this.iWidth;
    }

    public int getPlotHeight() {
        return this.iHeight;
    }

    public rockColorListStruct getRockColorData() {
        return this.stColor;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setRockColorData(rockColorListStruct rockColorListStruct2) {
        this.stColor = rockColorListStruct2;
    }

    public void drawGrid(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = true;
        double d = 0.0;
        double d2 = 0.0;
        int n6 = n2 / 6;
        int n7 = n + n2;
        int n8 = 0;
        int n9 = 0;
        graphics.setColor(Color.black);
        for (n3 = 0; n3 <= this.iLogHeight; n3 += this.iIncrementY) {
            n8 = this.iDataType == 1 ? this.iHeight - n3 : n3 + 100;
            n5 = this.iIncrementY / 5;
            for (n4 = 0; n4 < 5; ++n4) {
                n9 = this.iDataType == 1 ? this.iHeight - (n3 + n4 * n5) : n3 + n4 * n5 + 100;
                if (n9 < 100 || n9 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n9, n7, n9);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n8, n7, n8);
        }
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n7, 25);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void drawRockColorTrack(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n6 = n;
        int n7 = n + n2;
        int n8 = n2;
        int n9 = n;
        int n10 = n2;
        int n11 = n2 / 5;
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        if (this.stColor != null) {
            for (int i = 0; i < this.stColor.iCount; ++i) {
                if (this.stColor.stItem[i] == null) continue;
                d2 = this.stColor.stItem[i].depthStart;
                d3 = this.stColor.stItem[i].depthEnd;
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n3 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n3 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                n5 = Math.abs(n4 - n3);
                if (n3 < 100 || n4 <= 100 || n3 >= this.iHeight || n4 > this.iHeight) continue;
                for (int j = 0; j < 3; ++j) {
                    switch (j) {
                        case 0: {
                            n9 = n6;
                            n10 = n2;
                            break;
                        }
                        case 1: {
                            n9 = n6 + 3 * n2 / 5;
                            n10 = 2 * n2 / 5;
                            break;
                        }
                        case 2: {
                            n9 = n6 + 9 * n2 / 10;
                            n10 = n2 / 10;
                        }
                    }
                    for (int k = 0; k < 3; ++k) {
                        if (this.stColor.stItem[i].iRGB[j][k] <= 255) continue;
                        this.stColor.stItem[i].iRGB[j][k] = 255;
                    }
                    if (this.stColor.stItem[i].sMunsell[j].length() <= 0) continue;
                    graphics.setColor(new Color(this.stColor.stItem[i].iRGB[j][0], this.stColor.stItem[i].iRGB[j][1], this.stColor.stItem[i].iRGB[j][2]));
                    graphics.fillRect(n9, n3, n10, n5);
                }
            }
        }
        graphics.setColor(Color.black);
        graphics.drawString("Rock", n + n11, 39);
        graphics.drawString("Color", n + n11, 53);
        graphics.drawLine(n6, 25, n7, 25);
        graphics.drawLine(n6, 100, n7, 100);
        graphics.drawLine(n6, 25, n6, 100 + this.iLogHeight);
        graphics.drawLine(n7, 25, n7, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 1;
        if (n == 75) {
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawRockColorTrack(graphics, n2, n3);
            this.drawGrid(graphics, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

