/*
 * Decompiled with CFR 0.152.
 */
package rock.color.plot;

import iqstrat.iqstratStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Observable;
import rock.color.rockColorChartListStruct;
import rock.color.rockColorChartStruct;

public class rockColorChartPlot
extends Canvas
implements MouseListener {
    private Observable notifier = null;
    private iqstratStruct stStruct = null;
    private int iColor = -1;
    private String sMunsellCode = "";
    private String sColor = "";
    private String sHex = "";
    private int[] iRGB = new int[]{255, 255, 255};
    private rockColorChartStruct st = null;
    public static final int _R = 0;
    public static final int _YR = 1;
    public static final int _Y = 2;
    public static final int _GY = 3;
    public static final int _G = 4;
    public static final int _BG = 5;
    public static final int _B = 6;
    public static final int _PB = 7;
    public static final int _P = 8;
    public static final int _RP = 9;
    public static final int _N = 10;
    private int iHue = 0;
    public static final String[] _HUE = new String[]{"R", "YR", "Y", "GY", "G", "BG", "B", "PB", "P", "RP", "N"};
    public static final String[] HUE = new String[]{"Red", "Yellow Red", "Yellow", "Green Yellow", "Green", "Blue Green", "Blue", "Purple Blue", "Purple", "Red Purple"};
    public static final int _2p5 = 0;
    public static final int _5p0 = 1;
    public static final int _7p5 = 2;
    public static final int _10p = 3;
    public static final double[] HUE_NO = new double[]{2.5, 5.0, 7.5, 10.0};
    private int iHueNo = 1;
    public static final double[] CHROMA = new double[]{1.0, 2.0, 3.0, 4.0, 6.0, 8.0};
    public static final double[] ROCK_VALUE = new double[]{9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.0, 1.0};
    public static final double[] SOIL_VALUE = new double[]{8.0, 7.0, 6.0, 5.0, 4.0, 3.0, 2.5, 2.0};
    public static final int _ROCK_CATALOG = 0;
    public static final int _SOIL_CATALOG = 1;
    public int iCatalog = 0;
    private static final int WIDTH = 360;
    private static final int HEIGHT = 675;
    private static final int HUE_WIDTH = 300;
    private static final int HUE_START = 36;
    private static final int COL_START = 60;
    private static final int TEXT_LARGE = 12;
    private static final int TEXT = 10;
    private static final int ROW = 75;
    private static final int COLUMN = 50;
    private static final int COLOUR_WIDTH = 40;
    private static final int COLOUR_HEIGHT = 20;

    public rockColorChartPlot(Observable observable, iqstratStruct iqstratStruct2) {
        this.notifier = observable;
        this.stStruct = iqstratStruct2;
        this.setBackground(Color.white);
        this.addMouseListener(this);
    }

    public void close() {
        this.notifier = null;
        this.sMunsellCode = null;
        this.sColor = null;
        this.sHex = null;
        this.iRGB = null;
    }

    public int getPlotWidth() {
        return 360;
    }

    public int getPlotHeight() {
        return 675;
    }

    public int getColorID() {
        return this.iColor;
    }

    public String getMunsellCode() {
        return this.sMunsellCode;
    }

    public String getColorName() {
        return this.sColor;
    }

    public String getRGBHex() {
        return this.sHex;
    }

    public int[] getRGB() {
        return this.iRGB;
    }

    public void setCatalog(int n) {
        this.iCatalog = n;
        this.repaint();
    }

    public void setHue(int n) {
        this.iHue = n;
        this.repaint();
    }

    public void setHueNo(int n) {
        this.iHueNo = n;
        this.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = 0;
        int n4 = 0;
        rockColorChartListStruct rockColorChartListStruct2 = null;
        double[] dArray = null;
        switch (this.iCatalog) {
            case 0: {
                dArray = ROCK_VALUE;
                rockColorChartListStruct2 = this.stStruct.stRockColor;
                break;
            }
            case 1: {
                dArray = SOIL_VALUE;
                rockColorChartListStruct2 = this.stStruct.stSoilColor;
            }
        }
        if (rockColorChartListStruct2 != null) {
            for (int i = 0; i < rockColorChartListStruct2.iCount; ++i) {
                if (HUE_NO[this.iHueNo] != rockColorChartListStruct2.stItem[i].dHue || !_HUE[this.iHue].equals(rockColorChartListStruct2.stItem[i].sColor)) continue;
                for (int j = 0; j < dArray.length; ++j) {
                    if (dArray[j] != rockColorChartListStruct2.stItem[i].dValue) continue;
                    for (int k = 0; k < CHROMA.length; ++k) {
                        if (CHROMA[k] != rockColorChartListStruct2.stItem[i].dChroma) continue;
                        n4 = 36 + j * 75;
                        n3 = 60 + k * 50;
                        if (n <= n3 || n >= n3 + 40 || n2 <= n4 || n2 >= n4 + 20) continue;
                        this.iColor = i;
                        this.sMunsellCode = new String(rockColorChartListStruct2.stItem[i].sMunsell);
                        this.sColor = new String(rockColorChartListStruct2.stItem[i].sName);
                        this.sHex = new String(rockColorChartListStruct2.stItem[i].sHex);
                        for (int i2 = 0; i2 < 3; ++i2) {
                            this.iRGB[i2] = rockColorChartListStruct2.stItem[i].iRGB[i2];
                        }
                        if (this.notifier == null) continue;
                        this.notifier.notifyObservers(new String("Color Selected"));
                    }
                }
            }
        }
    }

    public void drawBlock(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        graphics.setColor(new Color(n, n2, n3));
        graphics.fillRect(n4, n5, n6, n7);
    }

    public void draw(Graphics graphics) {
        int n;
        rockColorChartListStruct rockColorChartListStruct2 = null;
        double[] dArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "[ ]+";
        String[] stringArray = null;
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        switch (this.iCatalog) {
            case 0: {
                dArray = ROCK_VALUE;
                rockColorChartListStruct2 = this.stStruct.stRockColor;
                break;
            }
            case 1: {
                dArray = SOIL_VALUE;
                rockColorChartListStruct2 = this.stStruct.stSoilColor;
            }
        }
        string = "Hue: " + HUE_NO[this.iHueNo] + " " + HUE[this.iHue];
        n4 = 6 * string.length();
        graphics.drawString(string, (300 - n4) / 2, 12);
        graphics.drawString("Chroma (Saturation)", 110, 24);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Value (Lightness)", 200, -20);
        graphics2D.rotate(-1.5707963267948966);
        font = new Font("Serif", 0, 11);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n = 0; n < CHROMA.length; ++n) {
            graphics.drawString("" + CHROMA[n], 60 + n * 50 + 20, 34);
        }
        for (n = 0; n < dArray.length; ++n) {
            graphics.drawString("" + dArray[n], 40, 48 + n * 75);
        }
        font = new Font("Serif", 0, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        if (rockColorChartListStruct2 != null) {
            for (n = 0; n < rockColorChartListStruct2.iCount; ++n) {
                if (HUE_NO[this.iHueNo] != rockColorChartListStruct2.stItem[n].dHue || !_HUE[this.iHue].equals(rockColorChartListStruct2.stItem[n].sColor)) continue;
                for (int i = 0; i < dArray.length; ++i) {
                    if (dArray[i] != rockColorChartListStruct2.stItem[n].dValue) continue;
                    for (int j = 0; j < CHROMA.length; ++j) {
                        if (CHROMA[j] != rockColorChartListStruct2.stItem[n].dChroma) continue;
                        n3 = 36 + i * 75;
                        n2 = 60 + j * 50;
                        this.drawBlock(graphics, rockColorChartListStruct2.stItem[n].iRGB[0], rockColorChartListStruct2.stItem[n].iRGB[1], rockColorChartListStruct2.stItem[n].iRGB[2], n2, n3, 40, 20);
                        string2 = rockColorChartListStruct2.stItem[n].sMunsell;
                        string3 = rockColorChartListStruct2.stItem[n].sName;
                        stringArray = string3.split(string4);
                        graphics.setColor(Color.black);
                        n4 = stringArray.length;
                        for (int k = 0; k < n4; ++k) {
                            graphics.drawString(stringArray[k], n2, 20 + n3 + (k + 1) * 10);
                        }
                        graphics.drawString(string2, n2, 20 + n3 + (n4 + 1) * 10);
                    }
                }
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 360, 675);
        this.draw(graphics);
    }
}

