/*
 * Decompiled with CFR 0.152.
 */
package rock.color.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import rock.color.rockColorChartListStruct;
import rock.color.rockColorChartStruct;
import rock.color.rockColorChartUtility;

public class ReadColorChartXML
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    private static final int _NONE = 0;
    private static final int _COLOR = 1;
    private int iData = 0;
    public static final String ROOTNAME = "colors";
    public static final String RECORDS = "records";
    public static final String REFERENCE = "ref";
    public static final String COLOR = "color";
    public static final String COLOR_NAME = "name";
    public static final String HUE = "H";
    public static final String HUE_NUMBER = "Hn";
    public static final String HUE_COLOR = "Hc";
    public static final String MUNSELL_VALUE = "V";
    public static final String MUNSELL_CHROMA = "C";
    public static final String MUNSELL_CODE = "munsell";
    public static final String COLOR_x = "x";
    public static final String COLOR_y = "y";
    public static final String COLOR_Yo = "Yo";
    public static final String RGB_RED = "r";
    public static final String RGB_GREEN = "g";
    public static final String RGB_BLUE = "b";
    private int iRows = 0;
    private int iCount = -1;
    private rockColorChartListStruct stChart = new rockColorChartListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadColorChartXML() {
        this.iType = 0;
    }

    public ReadColorChartXML(int n) {
        this.iType = n;
    }

    public rockColorChartListStruct Process(String string) {
        this.Read(string);
        this.stChart.iCount = this.iCount + 1;
        return this.stChart;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadColorChartXML.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadColorChartXML.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(COLOR)) {
            ++this.iCount;
            this.stChart.stItem[this.iCount] = new rockColorChartStruct();
            this.iData = 1;
        }
        if (attributes != null) {
            block4: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    this.iRows = cmnString.stringToInt(string7.trim());
                    if (this.iRows > 0) {
                        this.stChart.stItem = new rockColorChartStruct[this.iRows];
                    }
                }
                if (this.iCount <= -1) continue;
                switch (this.iData) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        if (this.iCount >= this.iRows) continue block4;
                        this.stChart.stItem[this.iCount] = this.ParseData(string5, string7.trim(), this.stChart.stItem[this.iCount]);
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private rockColorChartStruct ParseData(String string, String string2, rockColorChartStruct rockColorChartStruct2) {
        if (string.equals(COLOR_NAME)) {
            rockColorChartStruct2.sName = new String(string2);
        }
        if (string.equals(MUNSELL_CODE)) {
            rockColorChartStruct2.sMunsell = new String(string2);
        }
        if (string.equals(HUE)) {
            rockColorChartStruct2.sHue = new String(string2);
        }
        if (string.equals(HUE_NUMBER)) {
            rockColorChartStruct2.dHue = cmnString.stringToDouble(string2);
        }
        if (string.equals(HUE_COLOR)) {
            rockColorChartStruct2.sColor = new String(string2);
        }
        if (string.equals(MUNSELL_VALUE)) {
            rockColorChartStruct2.dValue = cmnString.stringToDouble(string2);
        }
        if (string.equals(MUNSELL_CHROMA)) {
            rockColorChartStruct2.dChroma = cmnString.stringToDouble(string2);
        }
        if (string.equals(COLOR_x)) {
            rockColorChartStruct2.x = cmnString.stringToDouble(string2);
        }
        if (string.equals(COLOR_y)) {
            rockColorChartStruct2.y = cmnString.stringToDouble(string2);
        }
        if (string.equals(COLOR_Yo)) {
            rockColorChartStruct2.Yo = cmnString.stringToDouble(string2);
        }
        if (string.equals(RGB_RED)) {
            rockColorChartStruct2.iRGB[0] = cmnString.stringToInt(string2);
        }
        if (string.equals(RGB_GREEN)) {
            rockColorChartStruct2.iRGB[1] = cmnString.stringToInt(string2);
        }
        if (string.equals(RGB_BLUE)) {
            rockColorChartStruct2.iRGB[2] = cmnString.stringToInt(string2);
            rockColorChartStruct2.sHex = new String(rockColorChartUtility.getHEX(rockColorChartStruct2.iRGB[0], rockColorChartStruct2.iRGB[1], rockColorChartStruct2.iRGB[2]));
        }
        return rockColorChartStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

