/*
 * Decompiled with CFR 0.152.
 */
package rock.color.gui;

import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import rock.color.gui.rockColorChartPlotFrameObservable;
import rock.color.gui.rockColorChartPlotPanel;
import rock.color.gui.rockColorDataEntryPanel;
import rock.color.plot.rockColorChartPlot;
import rock.color.rockColorChartListStruct;
import rock.color.rockColorStruct;

public class rockColorChartPlotFrame
extends JFrame
implements ActionListener,
Observer {
    private Observable pNotifier = null;
    private iqstratStruct stStruct = null;
    private Observable notifier = null;
    private rockColorChartPlotPanel plot = null;
    private rockColorDataEntryPanel pColor = null;
    private int iCatalog = 0;
    private int iHueNo = 1;
    private int iHue = 0;
    private static final int[][] RGB = new int[][]{{255, 0, 0}, {255, 128, 0}, {255, 255, 0}, {64, 255, 0}, {0, 220, 0}, {80, 180, 180}, {0, 0, 220}, {180, 180, 255}, {220, 0, 220}, {255, 0, 128}};
    private JRadioButton rbRock = new JRadioButton();
    private JRadioButton rbSoil = new JRadioButton();
    private JRadioButton rb2p5 = new JRadioButton();
    private JRadioButton rb5p0 = new JRadioButton();
    private JRadioButton rb7p5 = new JRadioButton();
    private JRadioButton rb10p = new JRadioButton();
    private JButton btnN9 = new JButton();
    private JButton btnN8 = new JButton();
    private JButton btnN7 = new JButton();
    private JButton btnN6 = new JButton();
    private JButton btnN5 = new JButton();
    private JButton btnN4 = new JButton();
    private JButton btnN3 = new JButton();
    private JButton btnN2 = new JButton();
    private JButton btnN1 = new JButton();
    private JButton btnR = new JButton();
    private JButton btnYR = new JButton();
    private JButton btnY = new JButton();
    private JButton btnGY = new JButton();
    private JButton btnG = new JButton();
    private JButton btnBG = new JButton();
    private JButton btnB = new JButton();
    private JButton btnRP = new JButton();
    private JButton btnPB = new JButton();
    private JButton btnP = new JButton();
    private JMenuItem mExit = null;
    private int iXStart = 0;
    private int iYStart = 0;
    private int iWidth = 0;
    private int iHeight = 0;

    public rockColorChartPlotFrame(iqstratStruct iqstratStruct2) {
        try {
            this.stStruct = iqstratStruct2;
            this.jbInit();
            this.addWindowListener(new rockColorChartPlotFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public rockColorChartPlotFrame(Observable observable, iqstratStruct iqstratStruct2) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public rockColorChartPlotFrame(Observable observable, iqstratStruct iqstratStruct2, int n, int n2, int n3, int n4) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.iXStart = n;
            this.iYStart = n2;
            this.iWidth = n3;
            this.iHeight = n4;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Color");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Hue #:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Hue:");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Gray:");
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Close Dialog");
        this.mExit = new JMenuItem("Close");
        this.mExit.addActionListener(this);
        jMenu.add(this.mExit);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.notifier = new rockColorChartPlotFrameObservable();
        this.notifier.addObserver(this);
        this.setTitle("Rock Color Chart");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel2.setBorder(titledBorder4);
        jPanel2.setLayout(new GridLayout(9, 1));
        jPanel2.setPreferredSize(new Dimension(61, 450));
        this.btnN9.setBackground(new Color(228, 228, 228));
        this.btnN9.setPreferredSize(new Dimension(50, 30));
        this.btnN9.setText("N9");
        this.btnN9.addActionListener(this);
        this.btnN8.setBackground(new Color(202, 202, 202));
        this.btnN8.setPreferredSize(new Dimension(50, 30));
        this.btnN8.setText("N8");
        this.btnN8.addActionListener(this);
        this.btnN7.setBackground(new Color(175, 175, 175));
        this.btnN7.setPreferredSize(new Dimension(50, 30));
        this.btnN7.setText("N7");
        this.btnN7.addActionListener(this);
        this.btnN6.setBackground(new Color(158, 158, 158));
        this.btnN6.setPreferredSize(new Dimension(50, 30));
        this.btnN6.setText("N6");
        this.btnN6.addActionListener(this);
        this.btnN5.setBackground(new Color(123, 123, 123));
        this.btnN5.setForeground(Color.white);
        this.btnN5.setPreferredSize(new Dimension(50, 30));
        this.btnN5.setText("N5");
        this.btnN5.addActionListener(this);
        this.btnN4.setBackground(new Color(97, 97, 97));
        this.btnN4.setForeground(Color.white);
        this.btnN4.setPreferredSize(new Dimension(50, 30));
        this.btnN4.setText("N4");
        this.btnN4.addActionListener(this);
        this.btnN3.setBackground(new Color(72, 72, 72));
        this.btnN3.setForeground(Color.white);
        this.btnN3.setPreferredSize(new Dimension(50, 30));
        this.btnN3.setText("N3");
        this.btnN3.addActionListener(this);
        this.btnN2.setBackground(new Color(49, 49, 49));
        this.btnN2.setForeground(Color.white);
        this.btnN2.setPreferredSize(new Dimension(50, 30));
        this.btnN2.setText("N2");
        this.btnN2.addActionListener(this);
        this.btnN1.setBackground(new Color(29, 29, 29));
        this.btnN1.setForeground(Color.white);
        this.btnN1.setPreferredSize(new Dimension(50, 30));
        this.btnN1.setText("N1");
        this.btnN1.addActionListener(this);
        jPanel3.setLayout(new BorderLayout());
        jPanel4.setBorder(titledBorder);
        jPanel4.setLayout(new GridLayout(2, 1));
        this.rbRock.setFont(new Font("Dialog", 1, 11));
        this.rbRock.setSelected(true);
        this.rbRock.setText("Rock");
        this.rbRock.addActionListener(this);
        this.rbSoil.setFont(new Font("Dialog", 1, 11));
        this.rbSoil.setText("Soil");
        this.rbSoil.addActionListener(this);
        jPanel5.setBorder(titledBorder3);
        jPanel5.setLayout(new GridLayout(4, 1));
        this.rb2p5.setFont(new Font("Dialog", 1, 11));
        this.rb2p5.setText("2.5");
        this.rb2p5.addActionListener(this);
        this.rb5p0.setFont(new Font("Dialog", 1, 11));
        this.rb5p0.setSelected(true);
        this.rb5p0.setText("5.0");
        this.rb5p0.addActionListener(this);
        this.rb7p5.setFont(new Font("Dialog", 1, 11));
        this.rb7p5.setText("7.5");
        this.rb7p5.addActionListener(this);
        this.rb10p.setFont(new Font("Dialog", 1, 11));
        this.rb10p.setText("10.0");
        this.rb10p.addActionListener(this);
        jPanel6.setBorder(titledBorder3);
        jPanel6.setLayout(new GridLayout(10, 1));
        jPanel6.setPreferredSize(new Dimension(61, 450));
        this.btnR.setBackground(new Color(RGB[0][0], RGB[0][1], RGB[0][2]));
        this.btnR.setFont(new Font("Dialog", 1, 11));
        this.btnR.setText("R");
        this.btnR.addActionListener(this);
        this.btnYR.setBackground(new Color(RGB[1][0], RGB[1][1], RGB[1][2]));
        this.btnYR.setFont(new Font("Dialog", 1, 11));
        this.btnYR.setText("YR");
        this.btnYR.addActionListener(this);
        this.btnY.setBackground(new Color(RGB[2][0], RGB[2][1], RGB[2][2]));
        this.btnY.setFont(new Font("Dialog", 1, 11));
        this.btnY.setText("Y");
        this.btnY.addActionListener(this);
        this.btnGY.setBackground(new Color(RGB[3][0], RGB[3][1], RGB[3][2]));
        this.btnGY.setFont(new Font("Dialog", 1, 11));
        this.btnGY.setText("GY");
        this.btnGY.addActionListener(this);
        this.btnG.setBackground(new Color(RGB[4][0], RGB[4][1], RGB[4][2]));
        this.btnG.setFont(new Font("Dialog", 1, 11));
        this.btnG.setText("G");
        this.btnG.addActionListener(this);
        this.btnBG.setBackground(new Color(RGB[5][0], RGB[5][1], RGB[5][2]));
        this.btnBG.setFont(new Font("Dialog", 1, 11));
        this.btnBG.setText("BG");
        this.btnBG.addActionListener(this);
        this.btnB.setBackground(new Color(RGB[6][0], RGB[6][1], RGB[6][2]));
        this.btnB.setFont(new Font("Dialog", 1, 11));
        this.btnB.setText("B");
        this.btnB.addActionListener(this);
        this.btnPB.setBackground(new Color(RGB[7][0], RGB[7][1], RGB[7][2]));
        this.btnPB.setFont(new Font("Dialog", 1, 11));
        this.btnPB.setText("PB");
        this.btnPB.addActionListener(this);
        this.btnP.setBackground(new Color(RGB[8][0], RGB[8][1], RGB[8][2]));
        this.btnP.setFont(new Font("Dialog", 1, 11));
        this.btnP.setText("P");
        this.btnP.addActionListener(this);
        this.btnRP.setBackground(new Color(RGB[9][0], RGB[9][1], RGB[9][2]));
        this.btnRP.setFont(new Font("Dialog", 1, 11));
        this.btnRP.setText("RP");
        this.btnRP.addActionListener(this);
        this.setButtons();
        this.plot = new rockColorChartPlotPanel(this, this.notifier, this.stStruct);
        jPanel7.setLayout(new BorderLayout());
        this.pColor = new rockColorDataEntryPanel(this.pNotifier, this.stStruct);
        this.getContentPane().add((Component)jPanel, "East");
        jPanel.add((Component)jPanel2, "South");
        jPanel2.add((Component)this.btnN1, null);
        jPanel2.add((Component)this.btnN2, null);
        jPanel2.add((Component)this.btnN3, null);
        jPanel2.add((Component)this.btnN4, null);
        jPanel2.add((Component)this.btnN5, null);
        jPanel2.add((Component)this.btnN6, null);
        jPanel2.add((Component)this.btnN7, null);
        jPanel2.add((Component)this.btnN8, null);
        jPanel2.add((Component)this.btnN9, null);
        this.getContentPane().add((Component)jPanel3, "West");
        jPanel3.add((Component)jPanel5, "Center");
        jPanel3.add((Component)jPanel6, "South");
        jPanel6.add((Component)this.btnR, null);
        jPanel6.add((Component)this.btnYR, null);
        jPanel6.add((Component)this.btnY, null);
        jPanel6.add((Component)this.btnGY, null);
        jPanel6.add((Component)this.btnG, null);
        jPanel6.add((Component)this.btnBG, null);
        jPanel6.add((Component)this.btnB, null);
        jPanel6.add((Component)this.btnPB, null);
        jPanel6.add((Component)this.btnP, null);
        jPanel6.add((Component)this.btnRP, null);
        jPanel3.add((Component)jPanel4, "North");
        jPanel4.add((Component)this.rbRock, null);
        jPanel4.add((Component)this.rbSoil, null);
        buttonGroup2.add(this.rbRock);
        buttonGroup2.add(this.rbSoil);
        this.getContentPane().add((Component)this.plot, "Center");
        jPanel5.add((Component)this.rb2p5, null);
        jPanel5.add((Component)this.rb5p0, null);
        jPanel5.add((Component)this.rb7p5, null);
        jPanel5.add((Component)this.rb10p, null);
        buttonGroup.add(this.rb2p5);
        buttonGroup.add(this.rb5p0);
        buttonGroup.add(this.rb7p5);
        buttonGroup.add(this.rb10p);
        this.getContentPane().add((Component)jPanel7, "South");
        jPanel7.add((Component)this.pColor, "Center");
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setSize(new Dimension(550, 850));
        int n = (dimension.width - this.getSize().width) / 2;
        if (this.iWidth > 0) {
            n = this.iXStart + this.iWidth;
        }
        if (this.getSize().width > dimension.width - n) {
            n = dimension.width - this.getSize().width;
        }
        this.setLocation(n, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    public int getColorID() {
        return this.plot.getColorID();
    }

    public String getMunsellCode() {
        return this.plot.getMunsellCode();
    }

    public String getColorName() {
        return this.plot.getColorName();
    }

    public String getRGBHex() {
        return this.plot.getRGBHex();
    }

    public int[] getRGB() {
        return this.plot.getRGB();
    }

    public rockColorStruct getData() {
        return this.pColor.getData();
    }

    public void clear() {
        if (this.pColor != null) {
            this.pColor.clear();
        }
    }

    private void setButtons() {
        rockColorChartListStruct rockColorChartListStruct2 = null;
        int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        int[] nArray2 = new int[]{-1, -1, -1, -1};
        switch (this.iCatalog) {
            case 0: {
                this.setTitle("Rock Color Chart");
                rockColorChartListStruct2 = this.stStruct.stRockColor;
                break;
            }
            case 1: {
                this.setTitle("Munsell Soil Color Chart");
                rockColorChartListStruct2 = this.stStruct.stSoilColor;
            }
        }
        if (rockColorChartListStruct2 != null) {
            int n;
            this.rb2p5.setEnabled(false);
            this.rb5p0.setEnabled(false);
            this.rb7p5.setEnabled(false);
            this.rb10p.setEnabled(false);
            this.btnR.setEnabled(false);
            this.btnYR.setEnabled(false);
            this.btnY.setEnabled(false);
            this.btnGY.setEnabled(false);
            this.btnG.setEnabled(false);
            this.btnBG.setEnabled(false);
            this.btnB.setEnabled(false);
            this.btnPB.setEnabled(false);
            this.btnP.setEnabled(false);
            this.btnRP.setEnabled(false);
            for (n = 0; n < rockColorChartListStruct2.iCount; ++n) {
                int n2;
                for (n2 = 0; n2 < rockColorChartPlot.HUE_NO.length; ++n2) {
                    if (rockColorChartListStruct2.stItem[n].dHue != rockColorChartPlot.HUE_NO[n2]) continue;
                    nArray2[n2] = 1;
                }
                for (n2 = 0; n2 < rockColorChartPlot._HUE.length; ++n2) {
                    if (rockColorChartListStruct2.stItem[n].dHue != rockColorChartPlot.HUE_NO[this.iHueNo] || !rockColorChartListStruct2.stItem[n].sColor.equals(rockColorChartPlot._HUE[n2])) continue;
                    nArray[n2] = 1;
                }
            }
            block25: for (n = 0; n < rockColorChartPlot._HUE.length; ++n) {
                switch (n) {
                    case 0: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnR.setEnabled(true);
                        continue block25;
                    }
                    case 1: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnYR.setEnabled(true);
                        continue block25;
                    }
                    case 2: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnY.setEnabled(true);
                        continue block25;
                    }
                    case 3: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnGY.setEnabled(true);
                        continue block25;
                    }
                    case 4: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnG.setEnabled(true);
                        continue block25;
                    }
                    case 5: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnBG.setEnabled(true);
                        continue block25;
                    }
                    case 6: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnB.setEnabled(true);
                        continue block25;
                    }
                    case 7: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnPB.setEnabled(true);
                        continue block25;
                    }
                    case 8: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnP.setEnabled(true);
                        continue block25;
                    }
                    case 9: {
                        if (nArray[n] <= -1) continue block25;
                        this.btnRP.setEnabled(true);
                    }
                }
            }
            block26: for (n = 0; n < rockColorChartPlot.HUE_NO.length; ++n) {
                switch (n) {
                    case 0: {
                        if (nArray2[n] <= -1) continue block26;
                        this.rb2p5.setEnabled(true);
                        continue block26;
                    }
                    case 1: {
                        if (nArray2[n] <= -1) continue block26;
                        this.rb5p0.setEnabled(true);
                        continue block26;
                    }
                    case 2: {
                        if (nArray2[n] <= -1) continue block26;
                        this.rb7p5.setEnabled(true);
                        continue block26;
                    }
                    case 3: {
                        if (nArray2[n] <= -1) continue block26;
                        this.rb10p.setEnabled(true);
                    }
                }
            }
        }
    }

    public void setCatalog(int n) {
        this.iCatalog = n;
        this.plot.setCatalog(n);
    }

    public void setHue(int n) {
        this.iHue = n;
        this.plot.setHue(n);
    }

    public void setHueNo(int n) {
        this.iHueNo = n;
        this.plot.setHueNo(n);
    }

    public void setDepthRange(double d, double d2) {
        if (this.pColor != null) {
            this.pColor.setDepthRange(d, d2);
        }
    }

    public void setData(rockColorStruct rockColorStruct2) {
        if (this.pColor != null) {
            this.pColor.setData(rockColorStruct2);
        }
    }

    public void setNeutralColor(int n) {
        this.pColor.setNeutralColor(n);
    }

    public void close() {
        this.pNotifier = null;
        this.notifier = null;
        if (this.pColor != null) {
            this.pColor.close();
        }
        this.pColor = null;
        this.rbRock = null;
        this.rbSoil = null;
        this.rb2p5 = null;
        this.rb5p0 = null;
        this.rb7p5 = null;
        this.rb10p = null;
        this.btnR = null;
        this.btnYR = null;
        this.btnY = null;
        this.btnGY = null;
        this.btnG = null;
        this.btnBG = null;
        this.btnB = null;
        this.btnRP = null;
        this.btnPB = null;
        this.btnP = null;
        this.mExit = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbRock) {
            this.setCatalog(0);
        }
        if (actionEvent.getSource() == this.rbSoil) {
            this.setCatalog(1);
        }
        if (actionEvent.getSource() == this.rb2p5) {
            this.setHueNo(0);
        }
        if (actionEvent.getSource() == this.rb5p0) {
            this.setHueNo(1);
        }
        if (actionEvent.getSource() == this.rb7p5) {
            this.setHueNo(2);
        }
        if (actionEvent.getSource() == this.rb10p) {
            this.setHueNo(3);
        }
        if (actionEvent.getSource() == this.btnR) {
            this.setHue(0);
        }
        if (actionEvent.getSource() == this.btnYR) {
            this.setHue(1);
        }
        if (actionEvent.getSource() == this.btnY) {
            this.setHue(2);
        }
        if (actionEvent.getSource() == this.btnGY) {
            this.setHue(3);
        }
        if (actionEvent.getSource() == this.btnG) {
            this.setHue(4);
        }
        if (actionEvent.getSource() == this.btnBG) {
            this.setHue(5);
        }
        if (actionEvent.getSource() == this.btnB) {
            this.setHue(6);
        }
        if (actionEvent.getSource() == this.btnPB) {
            this.setHue(7);
        }
        if (actionEvent.getSource() == this.btnP) {
            this.setHue(8);
        }
        if (actionEvent.getSource() == this.btnRP) {
            this.setHue(9);
        }
        if (actionEvent.getSource() == this.btnN9) {
            this.setNeutralColor(8);
        }
        if (actionEvent.getSource() == this.btnN8) {
            this.setNeutralColor(7);
        }
        if (actionEvent.getSource() == this.btnN7) {
            this.setNeutralColor(6);
        }
        if (actionEvent.getSource() == this.btnN6) {
            this.setNeutralColor(5);
        }
        if (actionEvent.getSource() == this.btnN5) {
            this.setNeutralColor(4);
        }
        if (actionEvent.getSource() == this.btnN4) {
            this.setNeutralColor(3);
        }
        if (actionEvent.getSource() == this.btnN3) {
            this.setNeutralColor(2);
        }
        if (actionEvent.getSource() == this.btnN2) {
            this.setNeutralColor(1);
        }
        if (actionEvent.getSource() == this.btnN1) {
            this.setNeutralColor(0);
        }
        this.setButtons();
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        int n = -1;
        int[] nArray = new int[]{255, 255, 255};
        if (string.equals("Color Selected")) {
            this.pColor.getColor(this.plot.getColorID(), this.plot.getRGB(), this.plot.getMunsellCode(), this.plot.getColorName(), this.plot.getRGBHex());
        }
    }

    public class rockColorChartPlotFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (rockColorChartPlotFrame.this.notifier != null) {
                rockColorChartPlotFrame.this.notifier.notifyObservers(new String("Cancel Edit"));
            }
        }
    }
}

