/*
 * Decompiled with CFR 0.152.
 */
package parse;

import cmn.cmnString;
import iqstrat.iqstratRemarkListStruct;
import lith.lithology.lithologyColorsStruct;
import lith.lithology.lithologyGroupsStruct;
import lith.rock.rockColumnListStruct;
import lith.rock.rockColumnStruct;
import lith.rock.rockColumnUtility;
import parse.parseGrainsTextureListStruct;
import parse.parseGrainsTextureUtility;
import parse.parseRockColumnSymbolsListStruct;
import parse.parseRockColumnSymbolsStruct;

public class parseRockColumnSymbolsUtility {
    public static final int _NONE = -1;
    public static final int _TRACE = 0;
    public static final int _SLIGHTLY = 1;
    public static final int _NORMAL = 2;
    public static final int _MANY = 3;
    public static final int _VERY = 4;
    public static final String[] AMOUNT = rockColumnStruct.AMOUNT;

    public static int getColor(char c, lithologyColorsStruct lithologyColorsStruct2) {
        int n = -1;
        if (lithologyColorsStruct2 != null && lithologyColorsStruct2.colors != null) {
            for (int i = 0; i < lithologyColorsStruct2.colors.length; ++i) {
                if (c != lithologyColorsStruct2.colors[i]) continue;
                n = i;
            }
        }
        return n;
    }

    public static int getColor(String string, lithologyColorsStruct lithologyColorsStruct2) {
        int n = -1;
        if (lithologyColorsStruct2 != null && lithologyColorsStruct2.sColors != null) {
            for (int i = 1; i < lithologyColorsStruct2.sColors.length; ++i) {
                if (!string.equals(lithologyColorsStruct2.sColors[i])) continue;
                n = i;
            }
        }
        return n;
    }

    public static int[] getRGB(int n, lithologyColorsStruct lithologyColorsStruct2) {
        int[] nArray = new int[]{255, 255, 255};
        if (n != -1 && lithologyColorsStruct2 != null && lithologyColorsStruct2.iRGB != null && n < lithologyColorsStruct2.iRGB.length) {
            for (int i = 0; i < 3; ++i) {
                nArray[i] = lithologyColorsStruct2.iRGB[n][i];
            }
        }
        return nArray;
    }

    public static int getGroupID(int n, String string, lithologyGroupsStruct lithologyGroupsStruct2) {
        int n2 = -1;
        if (lithologyGroupsStruct2 != null) {
            for (int i = 0; i < lithologyGroupsStruct2.iGroups; ++i) {
                if (!lithologyGroupsStruct2.sGroups[i][n].equals(string)) continue;
                n2 = i;
            }
        }
        return n2;
    }

    public static String getGroup(int n, int n2, lithologyGroupsStruct lithologyGroupsStruct2) {
        String string = "";
        if (lithologyGroupsStruct2 != null && n2 > -1) {
            string = new String(lithologyGroupsStruct2.sGroups[n2][n]);
        }
        return string;
    }

    public static int[] getColor(int n, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        int[] nArray = new int[]{255, 255, 255};
        if (parseRockColumnSymbolsListStruct2 != null && n > -1) {
            for (int i = 0; i < 3; ++i) {
                nArray[i] = parseRockColumnSymbolsListStruct2.stItem[n].iRGB[i];
            }
        }
        return nArray;
    }

    public static int[] getColor(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        int[] nArray = new int[]{255, 255, 255};
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
                if (!string.equals(parseRockColumnSymbolsListStruct2.stItem[i].sID)) continue;
                for (int j = 0; j < 3; ++j) {
                    nArray[j] = parseRockColumnSymbolsListStruct2.stItem[i].iRGB[j];
                }
            }
        }
        return nArray;
    }

    public static String getAbbrevWord(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        String string2 = "";
        string = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iAbbrev; ++i) {
                if (!string.equals(parseRockColumnSymbolsListStruct2.sAbbrev[i][0].toLowerCase())) continue;
                string2 = new String(parseRockColumnSymbolsListStruct2.sAbbrev[i][1]);
            }
        }
        return string2;
    }

    public static String[] getKeyword(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        String[] stringArray = new String[]{"", ""};
        String string2 = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iKeywords; ++i) {
                if (!string2.equals(parseRockColumnSymbolsListStruct2.sKeywords[i][0].toLowerCase())) continue;
                stringArray[0] = new String(parseRockColumnSymbolsListStruct2.sKeywords[i][0]);
                stringArray[1] = new String(parseRockColumnSymbolsListStruct2.sKeywords[i][1]);
            }
        }
        return stringArray;
    }

    public static String[][] getSymbol(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        int n = -1;
        String[][] stringArray = null;
        if (parseRockColumnSymbolsListStruct2 != null) {
            int n2;
            for (n2 = 0; n2 < parseRockColumnSymbolsListStruct2.iCount; ++n2) {
                if (!string.equals(parseRockColumnSymbolsListStruct2.stItem[n2].sID)) continue;
                n = n2;
            }
            if (n > -1 && parseRockColumnSymbolsListStruct2.stItem[n].symbol != null) {
                stringArray = new String[parseRockColumnSymbolsListStruct2.stItem[n].symbol.length][2];
                for (n2 = 0; n2 < parseRockColumnSymbolsListStruct2.stItem[n].symbol.length; ++n2) {
                    for (int i = 0; i < 2; ++i) {
                        stringArray[n2][i] = parseRockColumnSymbolsListStruct2.stItem[n].symbol[n2][i];
                    }
                }
            }
        }
        return stringArray;
    }

    public static String[][] getCaps(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        int n = -1;
        String[][] stringArray = null;
        if (parseRockColumnSymbolsListStruct2 != null) {
            int n2;
            for (n2 = 0; n2 < parseRockColumnSymbolsListStruct2.iCount; ++n2) {
                if (!string.equals(parseRockColumnSymbolsListStruct2.stItem[n2].sID)) continue;
                n = n2;
            }
            if (n > -1 && parseRockColumnSymbolsListStruct2.stItem[n].caps != null) {
                int n3;
                stringArray = new String[parseRockColumnSymbolsListStruct2.stItem[n].caps.length][3];
                for (n2 = 0; n2 < parseRockColumnSymbolsListStruct2.stItem[n].caps.length; ++n2) {
                    for (n3 = 0; n3 < parseRockColumnSymbolsListStruct2.stItem[n].iCaps; ++n3) {
                        stringArray[n2][n3] = "";
                    }
                }
                for (n2 = 0; n2 < parseRockColumnSymbolsListStruct2.stItem[n].caps.length; ++n2) {
                    for (n3 = 0; n3 < parseRockColumnSymbolsListStruct2.stItem[n].iCaps; ++n3) {
                        stringArray[n2][n3] = parseRockColumnSymbolsListStruct2.stItem[n].caps[n2][n3];
                    }
                }
            }
        }
        return stringArray;
    }

    public static int[] getCapType(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        int n = -1;
        int[] nArray = null;
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
                if (!string.equals(parseRockColumnSymbolsListStruct2.stItem[i].sID)) continue;
                n = i;
            }
            if (n > -1 && parseRockColumnSymbolsListStruct2.stItem[n].iCaps > 0) {
                int n2;
                nArray = new int[3];
                for (n2 = 0; n2 < 3; ++n2) {
                    nArray[n2] = -1;
                }
                for (n2 = 0; n2 < parseRockColumnSymbolsListStruct2.stItem[n].iCaps; ++n2) {
                    nArray[n2] = parseRockColumnSymbolsListStruct2.stItem[n].iTypes[n2];
                }
            }
        }
        return nArray;
    }

    public static String getLithology(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        String string2 = "";
        String string3 = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
                for (int j = 0; j < parseRockColumnSymbolsListStruct2.stItem[i].iThesaurus; ++j) {
                    if (!string3.equals(parseRockColumnSymbolsListStruct2.stItem[i].sThesaurus[j].toLowerCase())) continue;
                    string2 = new String(parseRockColumnSymbolsListStruct2.stItem[i].sID);
                }
            }
        }
        return string2;
    }

    public static String getLithology(String string, String string2, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        String string3 = "";
        String string4 = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
                for (int j = 0; j < parseRockColumnSymbolsListStruct2.stItem[i].iThesaurus; ++j) {
                    if (!string4.equals(parseRockColumnSymbolsListStruct2.stItem[i].sThesaurus[j].toLowerCase()) || !string2.equals(parseRockColumnSymbolsListStruct2.stItem[i].sType.toLowerCase())) continue;
                    string3 = new String(parseRockColumnSymbolsListStruct2.stItem[i].sID);
                }
            }
        }
        return string3;
    }

    public static int getID(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        int n = -1;
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
                if (!string.equals(parseRockColumnSymbolsListStruct2.stItem[i].sID)) continue;
                n = i;
            }
        }
        return n;
    }

    public static rockColumnListStruct parse(iqstratRemarkListStruct iqstratRemarkListStruct2, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        rockColumnListStruct rockColumnListStruct2 = null;
        String string = cmnString.UniqueName();
        String string2 = "";
        String[] stringArray = null;
        String string3 = new String("[ /,;:.=-]+");
        rockColumnStruct rockColumnStruct2 = null;
        double d = 1000.0;
        double d2 = 0.0;
        boolean bl = true;
        String[] stringArray2 = null;
        if (iqstratRemarkListStruct2 != null) {
            int n;
            rockColumnListStruct2 = new rockColumnListStruct();
            for (n = 0; n < iqstratRemarkListStruct2.iCount; ++n) {
                if (!(iqstratRemarkListStruct2.stItem[n].depthEnd > iqstratRemarkListStruct2.stItem[n].depthStart)) continue;
                bl = false;
            }
            if (bl) {
                for (n = 0; n < iqstratRemarkListStruct2.iCount - 1; ++n) {
                    d2 = iqstratRemarkListStruct2.stItem[n + 1].depthStart - iqstratRemarkListStruct2.stItem[n].depthStart;
                    if (!(d2 < d) || !(d2 > 0.0)) continue;
                    d = d2;
                }
                for (n = 0; n < iqstratRemarkListStruct2.iCount - 1; ++n) {
                    d2 = iqstratRemarkListStruct2.stItem[n + 1].depthStart - iqstratRemarkListStruct2.stItem[n].depthStart;
                    iqstratRemarkListStruct2.stItem[n].depthEnd = d2 > d ? iqstratRemarkListStruct2.stItem[n].depthStart + d : iqstratRemarkListStruct2.stItem[n].depthStart + d2;
                }
                iqstratRemarkListStruct2.stItem[iqstratRemarkListStruct2.iCount - 1].depthEnd = iqstratRemarkListStruct2.stItem[iqstratRemarkListStruct2.iCount - 1].depthStart + d;
            }
            for (n = 0; n < iqstratRemarkListStruct2.iCount; ++n) {
                string2 = new String(iqstratRemarkListStruct2.stItem[n].sText.replace('\t', ' '));
                stringArray = (string2 = new String(string2.replace('\n', ' '))).split(string3);
                if (stringArray != null && stringArray.length > 0) {
                    stringArray2 = new String[stringArray.length];
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray2[i] = new String(stringArray[i]);
                    }
                }
                if ((rockColumnStruct2 = parseRockColumnSymbolsUtility.parseColumn(iqstratRemarkListStruct2.stItem[n].depthStart, iqstratRemarkListStruct2.stItem[n].depthEnd, stringArray, parseRockColumnSymbolsListStruct2)) != null) {
                    rockColumnStruct2.sKEY = new String(string + "_" + n);
                    rockColumnListStruct2 = rockColumnUtility.add(rockColumnStruct2, rockColumnListStruct2);
                }
                stringArray = null;
                stringArray2 = null;
                if (rockColumnStruct2 != null) {
                    rockColumnStruct2.delete();
                }
                rockColumnStruct2 = null;
            }
            iqstratRemarkListStruct2.delete();
            iqstratRemarkListStruct2 = null;
        }
        return rockColumnListStruct2;
    }

    public static rockColumnListStruct parse(iqstratRemarkListStruct iqstratRemarkListStruct2, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2, parseGrainsTextureListStruct parseGrainsTextureListStruct2) {
        rockColumnListStruct rockColumnListStruct2 = null;
        String string = cmnString.UniqueName();
        String string2 = "";
        String[] stringArray = null;
        String string3 = new String("[ /,;:.=-]+");
        rockColumnStruct rockColumnStruct2 = null;
        double d = 1000.0;
        double d2 = 0.0;
        boolean bl = true;
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        if (iqstratRemarkListStruct2 != null) {
            int n;
            rockColumnListStruct2 = new rockColumnListStruct();
            for (n = 0; n < iqstratRemarkListStruct2.iCount; ++n) {
                if (!(iqstratRemarkListStruct2.stItem[n].depthEnd > iqstratRemarkListStruct2.stItem[n].depthStart)) continue;
                bl = false;
            }
            if (bl) {
                for (n = 0; n < iqstratRemarkListStruct2.iCount - 1; ++n) {
                    d2 = iqstratRemarkListStruct2.stItem[n + 1].depthStart - iqstratRemarkListStruct2.stItem[n].depthStart;
                    if (!(d2 < d) || !(d2 > 0.0)) continue;
                    d = d2;
                }
                for (n = 0; n < iqstratRemarkListStruct2.iCount - 1; ++n) {
                    d2 = iqstratRemarkListStruct2.stItem[n + 1].depthStart - iqstratRemarkListStruct2.stItem[n].depthStart;
                    iqstratRemarkListStruct2.stItem[n].depthEnd = d2 > d ? iqstratRemarkListStruct2.stItem[n].depthStart + d : iqstratRemarkListStruct2.stItem[n].depthStart + d2;
                }
                iqstratRemarkListStruct2.stItem[iqstratRemarkListStruct2.iCount - 1].depthEnd = iqstratRemarkListStruct2.stItem[iqstratRemarkListStruct2.iCount - 1].depthStart + d;
            }
            for (n = 0; n < iqstratRemarkListStruct2.iCount; ++n) {
                int n2;
                string2 = new String(iqstratRemarkListStruct2.stItem[n].sText.replace('\t', ' '));
                stringArray = (string2 = new String(string2.replace('\n', ' '))).split(string3);
                if (stringArray != null && stringArray.length > 0) {
                    stringArray2 = new String[stringArray.length];
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        stringArray2[n2] = new String(stringArray[n2]);
                    }
                }
                if (stringArray != null && stringArray.length > 0) {
                    stringArray3 = new String[stringArray.length];
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        stringArray3[n2] = new String(stringArray[n2]);
                    }
                }
                rockColumnStruct2 = parseRockColumnSymbolsUtility.parseColumn(iqstratRemarkListStruct2.stItem[n].depthStart, iqstratRemarkListStruct2.stItem[n].depthEnd, stringArray, parseRockColumnSymbolsListStruct2);
                rockColumnStruct2 = parseGrainsTextureUtility.parseColumn(rockColumnStruct2, stringArray2, parseGrainsTextureListStruct2);
                if ((rockColumnStruct2 = parseGrainsTextureUtility.getTexture(rockColumnStruct2, stringArray3, parseGrainsTextureListStruct2)) != null) {
                    rockColumnStruct2.sKEY = new String(string + "_" + n);
                    rockColumnListStruct2 = rockColumnUtility.add(rockColumnStruct2, rockColumnListStruct2);
                }
                stringArray = null;
                stringArray2 = null;
                if (rockColumnStruct2 != null) {
                    rockColumnStruct2.delete();
                }
                rockColumnStruct2 = null;
            }
            iqstratRemarkListStruct2.delete();
            iqstratRemarkListStruct2 = null;
        }
        return rockColumnListStruct2;
    }

    public static rockColumnStruct parseColumn(double d, double d2, String[] stringArray, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        int n;
        int n2;
        int n3;
        parseRockColumnSymbolsStruct parseRockColumnSymbolsStruct2 = null;
        rockColumnStruct rockColumnStruct2 = null;
        boolean bl = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 30;
        String[][] stringArrayArray = new String[][]{{"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}, {"", ""}};
        int[] nArray = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        String[] stringArray2 = new String[]{"", ""};
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        int n7 = 0;
        int[] nArray2 = null;
        String[] stringArray3 = null;
        String string5 = "";
        int n8 = 0;
        if (parseRockColumnSymbolsStruct2 != null) {
            parseRockColumnSymbolsStruct2.delete();
        }
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            for (n2 = 0; n2 < parseRockColumnSymbolsListStruct2.iAbbrev; ++n2) {
                if (!stringArray[n3].toLowerCase().equals(parseRockColumnSymbolsListStruct2.sAbbrev[n2][0].toLowerCase())) continue;
                stringArray[n3] = new String(parseRockColumnSymbolsListStruct2.sAbbrev[n2][1]);
            }
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            if (!parseRockColumnSymbolsUtility.isKeyword(stringArray[n2], parseRockColumnSymbolsListStruct2) || n5 >= n6) continue;
            stringArray2 = parseRockColumnSymbolsUtility.getKeyword(stringArray[n2], parseRockColumnSymbolsListStruct2);
            stringArrayArray[n5][0] = new String(stringArray2[0]);
            stringArrayArray[n5][1] = new String(stringArray2[1]);
            nArray[n5] = n2;
            ++n5;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            int n9;
            if (!stringArrayArray[n3][1].equals("B") && !stringArrayArray[n3][1].equals("L") || (n9 = n3 + 1) >= n5 || !parseRockColumnSymbolsUtility.isModified(stringArrayArray[n3][0], stringArrayArray[n9][0], parseRockColumnSymbolsListStruct2)) continue;
            stringArrayArray[n3][0] = new String(stringArrayArray[n3][0] + " " + stringArrayArray[n9][0]);
            stringArrayArray[n3][1] = new String("L");
            stringArrayArray[n9][0] = new String("");
            stringArrayArray[n9][1] = new String("");
        }
        n7 = 0;
        nArray2 = new int[5];
        stringArray3 = new String[5];
        for (n3 = 0; n3 < 5; ++n3) {
            nArray2[n3] = 0;
            stringArray3[n3] = "";
        }
        for (n3 = 0; n3 < n5; ++n3) {
            n4 = 0;
            if (!stringArrayArray[n3][1].equals("L") && !stringArrayArray[n3][1].equals("B")) continue;
            if (string2.length() == 0) {
                if (parseRockColumnSymbolsUtility.isThesarus(stringArrayArray[n3][0], "1st", parseRockColumnSymbolsListStruct2)) {
                    string2 = new String(parseRockColumnSymbolsUtility.getLithology(stringArrayArray[n3][0], "1st", parseRockColumnSymbolsListStruct2));
                    bl = true;
                } else if (parseRockColumnSymbolsUtility.isThesarus(stringArrayArray[n3][0], "both", parseRockColumnSymbolsListStruct2)) {
                    string2 = new String(parseRockColumnSymbolsUtility.getLithology(stringArrayArray[n3][0], "both", parseRockColumnSymbolsListStruct2));
                    bl = true;
                }
                if (!bl || (n8 = parseRockColumnSymbolsUtility.getID(string2, parseRockColumnSymbolsListStruct2)) <= 0) continue;
                string3 = new String(parseRockColumnSymbolsListStruct2.stItem[n8].sCycle);
                continue;
            }
            if (!string3.equals("sed")) continue;
            if (parseRockColumnSymbolsUtility.isThesarus(stringArrayArray[n3][0], "2nd", parseRockColumnSymbolsListStruct2)) {
                string5 = new String(parseRockColumnSymbolsUtility.getLithology(stringArrayArray[n3][0], "2nd", parseRockColumnSymbolsListStruct2));
            } else if (parseRockColumnSymbolsUtility.isThesarus(stringArrayArray[n3][0], "both", parseRockColumnSymbolsListStruct2)) {
                string5 = new String(parseRockColumnSymbolsUtility.getLithology(stringArrayArray[n3][0], "both", parseRockColumnSymbolsListStruct2));
            }
            if (string5.length() > 2) {
                n8 = parseRockColumnSymbolsUtility.getID(string5, parseRockColumnSymbolsListStruct2);
                if (n8 > 0) {
                    string4 = new String(parseRockColumnSymbolsListStruct2.stItem[n8].sCycle);
                }
                if (string4.equals("sed")) {
                    if (string2.length() > 2) {
                        if (string2.substring(0, 3).equals(string5.substring(0, 3))) {
                            ++n4;
                        } else if (string2.equals("CO3-LS_DOL") && string2.substring(7, 10).equals(string5.substring(0, 3))) {
                            ++n4;
                        }
                    }
                    if (n7 > 0) {
                        for (n = 0; n < n7; ++n) {
                            if (stringArray3[n].substring(0, 3).equals(string5.substring(0, 3))) {
                                ++n4;
                                continue;
                            }
                            if (!string2.equals("CO3-LS_DOL") || !string2.substring(7, 10).equals(string5.substring(0, 3))) continue;
                            ++n4;
                        }
                    }
                }
                if (n4 == 0 && n7 < 4) {
                    n8 = parseRockColumnSymbolsUtility.getID(string5, parseRockColumnSymbolsListStruct2);
                    if (n8 > 0) {
                        nArray2[n7] = parseRockColumnSymbolsListStruct2.stItem[n8].iOrder;
                    }
                    stringArray3[n7] = new String(string5);
                    ++n7;
                }
            }
            string5 = new String("");
        }
        if (bl && string3.equals("sed")) {
            for (n3 = 0; n3 < n5; ++n3) {
                n4 = 0;
                if (!stringArrayArray[n3][1].equals("D")) continue;
                if (parseRockColumnSymbolsUtility.isThesarus(stringArrayArray[n3][0], "2nd", parseRockColumnSymbolsListStruct2)) {
                    string5 = new String(parseRockColumnSymbolsUtility.getLithology(stringArrayArray[n3][0], "2nd", parseRockColumnSymbolsListStruct2));
                } else if (parseRockColumnSymbolsUtility.isThesarus(stringArrayArray[n3][0], "both", parseRockColumnSymbolsListStruct2)) {
                    string5 = new String(parseRockColumnSymbolsUtility.getLithology(stringArrayArray[n3][0], "both", parseRockColumnSymbolsListStruct2));
                }
                if (string5.length() > 2) {
                    n8 = parseRockColumnSymbolsUtility.getID(string5, parseRockColumnSymbolsListStruct2);
                    if (n8 > 0) {
                        string4 = new String(parseRockColumnSymbolsListStruct2.stItem[n8].sCycle);
                    }
                    if (string4.equals("sed")) {
                        if (string2.length() > 2 && string2.substring(0, 3).equals(string5.substring(0, 3))) {
                            ++n4;
                        }
                        if (n7 > 0) {
                            for (n = 0; n < n7; ++n) {
                                if (!stringArray3[n].substring(0, 3).equals(string5.substring(0, 3))) continue;
                                ++n4;
                            }
                        }
                    }
                    if (n4 == 0 && n7 < 4) {
                        n8 = parseRockColumnSymbolsUtility.getID(string5, parseRockColumnSymbolsListStruct2);
                        if (n8 > 0) {
                            nArray2[n7] = parseRockColumnSymbolsListStruct2.stItem[n8].iOrder;
                        }
                        stringArray3[n7] = new String(string5);
                        ++n7;
                    }
                }
                string5 = new String("");
            }
        }
        if (bl) {
            rockColumnStruct2 = new rockColumnStruct();
            rockColumnStruct2.sKEY = new String(cmnString.UniqueName() + (int)d);
            rockColumnStruct2.depthStart = d;
            rockColumnStruct2.depthEnd = d2;
            rockColumnStruct2.iRGB = parseRockColumnSymbolsUtility.getColor(string2, parseRockColumnSymbolsListStruct2);
            rockColumnStruct2.sPrimary = new String(string2);
            rockColumnStruct2.iSecondary = n7;
            if (rockColumnStruct2.iSecondary > 0) {
                rockColumnStruct2.iAmount = new int[rockColumnStruct2.iSecondary];
                rockColumnStruct2.secondary = new String[rockColumnStruct2.iSecondary];
                stringArray3 = parseRockColumnSymbolsUtility.bubbleSort(n7, nArray2, stringArray3);
                for (n3 = 0; n3 < rockColumnStruct2.iSecondary; ++n3) {
                    rockColumnStruct2.secondary[n3] = new String(stringArray3[n3]);
                }
            }
        }
        return rockColumnStruct2;
    }

    public static String[] bubbleSort(int n, int[] nArray, String[] stringArray) {
        boolean bl = true;
        int n2 = 0;
        String string = "";
        if (stringArray != null && n > 1) {
            while (bl) {
                bl = false;
                for (int i = 0; i < n - 1; ++i) {
                    if (nArray[i] <= nArray[i + 1]) continue;
                    bl = true;
                    string = new String(stringArray[i]);
                    n2 = nArray[i];
                    stringArray[i] = new String(stringArray[i + 1]);
                    nArray[i] = nArray[i + 1];
                    stringArray[i + 1] = new String(string);
                    nArray[i + 1] = n2;
                }
            }
        }
        return stringArray;
    }

    public static boolean isThesarus(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        boolean bl = false;
        String string2 = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
                for (int j = 0; j < parseRockColumnSymbolsListStruct2.stItem[i].iThesaurus; ++j) {
                    if (!string2.equals(parseRockColumnSymbolsListStruct2.stItem[i].sThesaurus[j].toLowerCase())) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean isThesarus(String string, String string2, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        boolean bl = false;
        String string3 = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
                for (int j = 0; j < parseRockColumnSymbolsListStruct2.stItem[i].iThesaurus; ++j) {
                    if (!string3.equals(parseRockColumnSymbolsListStruct2.stItem[i].sThesaurus[j].toLowerCase()) || !string2.equals(parseRockColumnSymbolsListStruct2.stItem[i].sType.toLowerCase())) continue;
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static boolean isKeyword(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        boolean bl = false;
        String string2 = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iKeywords; ++i) {
                if (!string2.equals(parseRockColumnSymbolsListStruct2.sKeywords[i][0].toLowerCase())) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isModified(String string, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        boolean bl = false;
        String string2 = new String(string.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iModifiers; ++i) {
                if (!string2.equals(parseRockColumnSymbolsListStruct2.sModifier[i][1].toLowerCase())) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static boolean isModified(String string, String string2, parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        boolean bl = false;
        String string3 = new String(string.toLowerCase());
        String string4 = new String(string2.toLowerCase());
        if (parseRockColumnSymbolsListStruct2 != null) {
            for (int i = 0; i < parseRockColumnSymbolsListStruct2.iModifiers; ++i) {
                if (!string3.equals(parseRockColumnSymbolsListStruct2.sModifier[i][0].toLowerCase()) || !string4.equals(parseRockColumnSymbolsListStruct2.sModifier[i][1].toLowerCase())) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static parseRockColumnSymbolsListStruct copyList(parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct3 = null;
        int n = 0;
        int n2 = 0;
        if (parseRockColumnSymbolsListStruct2 != null) {
            parseRockColumnSymbolsListStruct3 = new parseRockColumnSymbolsListStruct();
            parseRockColumnSymbolsListStruct3.stForeground = parseRockColumnSymbolsUtility.copyColor(parseRockColumnSymbolsListStruct2.stForeground);
            parseRockColumnSymbolsListStruct3.stBackground = parseRockColumnSymbolsUtility.copyColor(parseRockColumnSymbolsListStruct2.stBackground);
            parseRockColumnSymbolsListStruct3.stGroups = parseRockColumnSymbolsUtility.copyGroup(parseRockColumnSymbolsListStruct2.stGroups);
            parseRockColumnSymbolsListStruct3.iAbbrev = parseRockColumnSymbolsListStruct2.iAbbrev;
            parseRockColumnSymbolsListStruct3.sAbbrev = new String[parseRockColumnSymbolsListStruct3.iAbbrev][2];
            for (n = 0; n < parseRockColumnSymbolsListStruct3.iAbbrev; ++n) {
                for (n2 = 0; n2 < 2; ++n2) {
                    parseRockColumnSymbolsListStruct3.sAbbrev[n][n2] = new String(parseRockColumnSymbolsListStruct2.sAbbrev[n][n2]);
                }
            }
            parseRockColumnSymbolsListStruct3.iModifiers = parseRockColumnSymbolsListStruct2.iModifiers;
            parseRockColumnSymbolsListStruct3.sModifier = new String[parseRockColumnSymbolsListStruct3.iModifiers][3];
            for (n = 0; n < parseRockColumnSymbolsListStruct3.iModifiers; ++n) {
                for (n2 = 0; n2 < 3; ++n2) {
                    parseRockColumnSymbolsListStruct3.sModifier[n][n2] = new String(parseRockColumnSymbolsListStruct2.sModifier[n][n2]);
                }
            }
            parseRockColumnSymbolsListStruct3.iKeywords = 0;
            parseRockColumnSymbolsListStruct3.sKeywords = new String[parseRockColumnSymbolsListStruct3.iKeywords][2];
            for (n = 0; n < parseRockColumnSymbolsListStruct3.iKeywords; ++n) {
                for (n2 = 0; n2 < 2; ++n2) {
                    parseRockColumnSymbolsListStruct3.sKeywords[n][n2] = new String(parseRockColumnSymbolsListStruct2.sKeywords[n][n2]);
                }
            }
            parseRockColumnSymbolsListStruct3.iCount = parseRockColumnSymbolsListStruct2.iCount;
            parseRockColumnSymbolsListStruct3.stItem = new parseRockColumnSymbolsStruct[parseRockColumnSymbolsListStruct2.iCount];
            for (n = 0; n < parseRockColumnSymbolsListStruct2.iCount; ++n) {
                parseRockColumnSymbolsListStruct3.stItem[n] = parseRockColumnSymbolsUtility.copy(parseRockColumnSymbolsListStruct2.stItem[n]);
            }
        }
        return parseRockColumnSymbolsListStruct3;
    }

    public static parseRockColumnSymbolsStruct copy(parseRockColumnSymbolsStruct parseRockColumnSymbolsStruct2) {
        parseRockColumnSymbolsStruct parseRockColumnSymbolsStruct3 = new parseRockColumnSymbolsStruct();
        int n = 0;
        int n2 = 0;
        parseRockColumnSymbolsStruct3.sID = new String(parseRockColumnSymbolsStruct2.sID);
        parseRockColumnSymbolsStruct3.iGroup = parseRockColumnSymbolsStruct2.iGroup;
        parseRockColumnSymbolsStruct3.sGroup = new String(parseRockColumnSymbolsStruct2.sGroup);
        parseRockColumnSymbolsStruct3.sName = new String(parseRockColumnSymbolsStruct2.sName);
        parseRockColumnSymbolsStruct3.sAbrev = new String(parseRockColumnSymbolsStruct2.sAbrev);
        parseRockColumnSymbolsStruct3.sType = new String(parseRockColumnSymbolsStruct2.sType);
        parseRockColumnSymbolsStruct3.sCycle = new String(parseRockColumnSymbolsStruct2.sCycle);
        parseRockColumnSymbolsStruct3.iOrder = parseRockColumnSymbolsStruct2.iOrder;
        parseRockColumnSymbolsStruct3.iWeather = parseRockColumnSymbolsStruct2.iWeather;
        for (n = 0; n < 3; ++n) {
            parseRockColumnSymbolsStruct3.iRGB[n] = parseRockColumnSymbolsStruct2.iRGB[n];
        }
        parseRockColumnSymbolsStruct3.iRows = parseRockColumnSymbolsStruct2.iRows;
        parseRockColumnSymbolsStruct3.iColumns = parseRockColumnSymbolsStruct2.iColumns;
        if (parseRockColumnSymbolsStruct3.iRows > 0) {
            parseRockColumnSymbolsStruct3.symbol = new String[parseRockColumnSymbolsStruct3.iRows][2];
            for (n = 0; n < parseRockColumnSymbolsStruct3.iRows; ++n) {
                for (n2 = 0; n2 < 2; ++n2) {
                    parseRockColumnSymbolsStruct3.symbol[n][n2] = new String(parseRockColumnSymbolsStruct2.symbol[n][n2]);
                }
            }
        }
        parseRockColumnSymbolsStruct3.iCapRows = parseRockColumnSymbolsStruct2.iCapRows;
        parseRockColumnSymbolsStruct3.iCaps = parseRockColumnSymbolsStruct2.iCaps;
        if (parseRockColumnSymbolsStruct3.iCapRows > 0) {
            parseRockColumnSymbolsStruct3.iTypes = new int[3];
            for (n2 = 0; n2 < 3; ++n2) {
                parseRockColumnSymbolsStruct3.iTypes[n2] = parseRockColumnSymbolsStruct2.iTypes[n2];
            }
            parseRockColumnSymbolsStruct3.caps = new String[parseRockColumnSymbolsStruct3.iRows][3];
            for (n = 0; n < parseRockColumnSymbolsStruct3.iCapRows; ++n) {
                for (n2 = 0; n2 < 3; ++n2) {
                    parseRockColumnSymbolsStruct3.caps[n][n2] = new String(parseRockColumnSymbolsStruct2.caps[n][n2]);
                }
            }
        }
        parseRockColumnSymbolsStruct3.iThesaurus = parseRockColumnSymbolsStruct2.iThesaurus;
        if (parseRockColumnSymbolsStruct3.iThesaurus > 0) {
            parseRockColumnSymbolsStruct3.sThesaurus = new String[parseRockColumnSymbolsStruct3.iThesaurus];
            parseRockColumnSymbolsStruct3.iType = new int[parseRockColumnSymbolsStruct3.iThesaurus];
            for (n = 0; n < parseRockColumnSymbolsStruct3.iThesaurus; ++n) {
                parseRockColumnSymbolsStruct3.sThesaurus[n] = new String(parseRockColumnSymbolsStruct2.sThesaurus[n]);
                parseRockColumnSymbolsStruct3.iType[n] = parseRockColumnSymbolsStruct2.iType[n];
            }
        }
        return parseRockColumnSymbolsStruct3;
    }

    public static lithologyGroupsStruct copyGroup(lithologyGroupsStruct lithologyGroupsStruct2) {
        lithologyGroupsStruct lithologyGroupsStruct3 = new lithologyGroupsStruct();
        if (lithologyGroupsStruct2 != null) {
            lithologyGroupsStruct3.iGroups = lithologyGroupsStruct2.iGroups;
            lithologyGroupsStruct3.sGroups = new String[lithologyGroupsStruct3.iGroups][2];
            for (int i = 0; i < lithologyGroupsStruct3.iGroups; ++i) {
                for (int j = 0; j < 2; ++j) {
                    lithologyGroupsStruct3.sGroups[i][j] = new String(lithologyGroupsStruct2.sGroups[i][j]);
                }
            }
        }
        return lithologyGroupsStruct3;
    }

    public static lithologyColorsStruct copyColor(lithologyColorsStruct lithologyColorsStruct2) {
        lithologyColorsStruct lithologyColorsStruct3 = new lithologyColorsStruct();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (lithologyColorsStruct2 != null) {
            lithologyColorsStruct3.iColors = lithologyColorsStruct2.iColors;
            if (lithologyColorsStruct2.colors != null) {
                n = lithologyColorsStruct2.colors.length;
                lithologyColorsStruct3.colors = new char[n];
                for (n2 = 0; n2 < n; ++n2) {
                    lithologyColorsStruct3.colors[n2] = lithologyColorsStruct2.colors[n2];
                }
            }
            if (lithologyColorsStruct2.sColors != null) {
                n = lithologyColorsStruct2.sColors.length;
                lithologyColorsStruct3.sColors = new String[n];
                for (n2 = 0; n2 < n; ++n2) {
                    lithologyColorsStruct3.sColors[n2] = new String(lithologyColorsStruct2.sColors[n2]);
                }
            }
            if (lithologyColorsStruct2.iRGB != null) {
                lithologyColorsStruct3.iRGB = new int[n][3];
                for (n2 = 0; n2 < n; ++n2) {
                    for (n3 = 0; n3 < 3; ++n3) {
                        lithologyColorsStruct3.iRGB[n2][n3] = lithologyColorsStruct2.iRGB[n2][n3];
                    }
                }
            }
        }
        return lithologyColorsStruct3;
    }

    public static void print(parseRockColumnSymbolsListStruct parseRockColumnSymbolsListStruct2) {
        System.out.println(" ------------ Foreground Colors ------------- \n");
        parseRockColumnSymbolsUtility.print(parseRockColumnSymbolsListStruct2.stForeground);
        System.out.println("\n ------------ Background Colors ------------- \n");
        parseRockColumnSymbolsUtility.print(parseRockColumnSymbolsListStruct2.stBackground);
        System.out.println("\n ------------ Lithology Groups ------------- \n");
        parseRockColumnSymbolsUtility.print(parseRockColumnSymbolsListStruct2.stGroups);
        System.out.println("\n ------------ Lithologies ------------- \n");
        for (int i = 0; i < parseRockColumnSymbolsListStruct2.iCount; ++i) {
            parseRockColumnSymbolsUtility.print(parseRockColumnSymbolsListStruct2.stItem[i]);
        }
    }

    public static void print(lithologyColorsStruct lithologyColorsStruct2) {
        block2: {
            int n;
            block3: {
                n = 0;
                if (lithologyColorsStruct2 == null || lithologyColorsStruct2.iColors <= 0) break block2;
                if (lithologyColorsStruct2.colors == null) break block3;
                for (n = 0; n < lithologyColorsStruct2.iColors; ++n) {
                    System.out.println(lithologyColorsStruct2.colors[n] + " " + lithologyColorsStruct2.iRGB[n][0] + " " + lithologyColorsStruct2.iRGB[n][1] + " " + lithologyColorsStruct2.iRGB[n][2]);
                }
                break block2;
            }
            if (lithologyColorsStruct2.sColors == null) break block2;
            for (n = 0; n < lithologyColorsStruct2.iColors; ++n) {
                System.out.println(lithologyColorsStruct2.sColors[n] + " " + lithologyColorsStruct2.iRGB[n][0] + " " + lithologyColorsStruct2.iRGB[n][1] + " " + lithologyColorsStruct2.iRGB[n][2]);
            }
        }
    }

    public static void print(lithologyGroupsStruct lithologyGroupsStruct2) {
        if (lithologyGroupsStruct2 != null && lithologyGroupsStruct2.iGroups > 0) {
            for (int i = 0; i < lithologyGroupsStruct2.iGroups; ++i) {
                System.out.println(i + " " + lithologyGroupsStruct2.sGroups[i][0] + " <-> " + lithologyGroupsStruct2.sGroups[i][1]);
            }
        }
    }

    public static void print(parseRockColumnSymbolsStruct parseRockColumnSymbolsStruct2) {
        int n = 0;
        if (parseRockColumnSymbolsStruct2 != null) {
            System.out.println(parseRockColumnSymbolsStruct2.sID + " " + parseRockColumnSymbolsStruct2.iGroup + " " + parseRockColumnSymbolsStruct2.sGroup + " " + parseRockColumnSymbolsStruct2.sName + " " + parseRockColumnSymbolsStruct2.sAbrev + " " + parseRockColumnSymbolsStruct2.sType + " " + parseRockColumnSymbolsStruct2.iWeather);
            System.out.println("Color " + parseRockColumnSymbolsStruct2.iRGB[0] + " " + parseRockColumnSymbolsStruct2.iRGB[1] + " " + parseRockColumnSymbolsStruct2.iRGB[2]);
            if (parseRockColumnSymbolsStruct2.symbol != null) {
                for (n = 0; n < parseRockColumnSymbolsStruct2.iRows; ++n) {
                    System.out.println(parseRockColumnSymbolsStruct2.symbol[n][0] + " " + parseRockColumnSymbolsStruct2.symbol[n][1]);
                }
            }
            if (parseRockColumnSymbolsStruct2.iThesaurus > 0) {
                for (n = 0; n < parseRockColumnSymbolsStruct2.iThesaurus; ++n) {
                    System.out.print(parseRockColumnSymbolsStruct2.sThesaurus[n] + " ");
                }
                System.out.println("\n");
            }
        }
    }
}

