/*
 * Decompiled with CFR 0.152.
 */
package mask.io;

import cmn.cmnString;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import mask.maskColorsStruct;
import mask.maskGroupsStruct;
import mask.maskSymbolsListStruct;
import mask.maskSymbolsStruct;
import mask.maskSymbolsUtility;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ReadMaskSymbolsXMLFile
extends DefaultHandler {
    public static final int FILE = 0;
    public static final int URL = 1;
    public static final int SERVER = 2;
    public static final int SERVER_ZIP = 3;
    private int iType = 0;
    public static final String ROOTNAME = "symbol_data";
    public static final String RECORDS = "records";
    public static final String BACKGROUND = "background";
    public static final String FOREGROUND = "foreground";
    public static final String COLOR = "color";
    public static final String SYMBOL = "symbol";
    public static final String RED = "r";
    public static final String GREEN = "g";
    public static final String BLUE = "b";
    public static final String GROUPS = "groups";
    public static final String GROUP = "group";
    public static final String MNEMONIC = "mnemonic";
    public static final String DESCRIPTION = "desc";
    public static final String MODIFIERS = "modifiers";
    public static final String MASKS = "masks";
    public static final String TYPE = "type";
    public static final String ROWS = "rows";
    public static final String WORDS = "words";
    public static final String DATA = "data";
    public static final String COLUMNS = "columns";
    public static final String COLUMN = "column";
    public static final String ID = "id";
    public static final String SID = "sid";
    public static final String SHOW = "show";
    public static final String ORDER = "order";
    public static final String SIZE = "size";
    public static final String MINIMUM = "min";
    public static final String MAXIMUM = "max";
    public static final String ABREV = "abrv";
    public static final String NAME = "name";
    public static final String SYMBOLS = "symbols";
    public static final String ROW = "row";
    public static final String LEFT = "l";
    public static final String RIGHT = "r";
    public static final String CENTER = "c";
    public static final String THESAURUS = "thesaurus";
    public static final String KEYWORDS = "keywords";
    public static final String WORD = "word";
    public static final String PHRASE = "phrase";
    public static final String LITHOLOGY = "lith";
    public static final String _1 = "o1";
    public static final String _2 = "o2";
    public static final String _3 = "o3";
    public static final String _4 = "o4";
    public static final String _5 = "o5";
    public static final String _6 = "o6";
    public static final String _7 = "o7";
    public static final String _8 = "o8";
    public static final String _9 = "o9";
    public static final String _10 = "o10";
    private static final int _NONE = 0;
    private static final int _BACKGROUND = 1;
    private static final int _FOREGROUND = 2;
    private static final int _COLOR = 3;
    private static final int _GROUPS = 4;
    private static final int _GROUP = 5;
    private static final int _MASKS = 6;
    private static final int _DATA = 7;
    private static final int _COLUMN = 8;
    private static final int _SYMBOLS = 9;
    private static final int _SYMBOL = 10;
    private static final int _THESAURUS = 11;
    private static final int _WORD = 12;
    private static final int _LITHOLOGY = 13;
    private static final int _MODIFIERS = 14;
    private static final int _KEYWORDS = 15;
    private int iRows = 0;
    private int iLines = 0;
    private int iColumns = 0;
    private int iCount = -1;
    private int iRow = 0;
    private int iData = 0;
    private int iColor = 0;
    private int iSymbol = 0;
    private int iWord = 0;
    private maskSymbolsListStruct stList = new maskSymbolsListStruct();
    private int iError = 0;
    private String sError = "";

    public ReadMaskSymbolsXMLFile() {
        this.iType = 0;
    }

    public ReadMaskSymbolsXMLFile(int n) {
        this.iType = n;
    }

    public maskSymbolsListStruct Process(String string) {
        this.Read(string);
        return this.stList;
    }

    public void Read(String string) {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (this.iType == 0) {
                sAXParser.parse(new File(string), (DefaultHandler)this);
            } else if (this.iType == 1) {
                try {
                    InputSource inputSource = new InputSource(string);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                }
                catch (Exception exception) {
                    System.err.println("ReadMaskSymbolsXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else if (this.iType == 2) {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    InputStream inputStream = httpURLConnection.getInputStream();
                    InputSource inputSource = new InputSource(inputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    inputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println("ReadMaskSymbolsXMLFile.Read() " + exception);
                    exception.printStackTrace();
                }
            } else {
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setRequestMethod("POST");
                    GZIPInputStream gZIPInputStream = new GZIPInputStream(httpURLConnection.getInputStream());
                    InputSource inputSource = new InputSource(gZIPInputStream);
                    sAXParser.parse(inputSource, (DefaultHandler)this);
                    gZIPInputStream.close();
                    httpURLConnection.disconnect();
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        int n = 0;
        int n2 = 0;
        if ("".equals(string4)) {
            string4 = string3;
        }
        if (string4.equals(BACKGROUND)) {
            this.iRow = -1;
            this.iData = 1;
            this.iColor = 1;
            this.stList.stBackground = new maskColorsStruct();
        }
        if (string4.equals(FOREGROUND)) {
            this.iRow = -1;
            this.iData = 2;
            this.iColor = 2;
            this.stList.stForeground = new maskColorsStruct();
        }
        if (string4.equals(COLOR)) {
            this.iData = 3;
            ++this.iRow;
        }
        if (string4.equals(GROUPS)) {
            this.iRow = -1;
            this.iColor = 0;
            this.iData = 4;
            this.stList.stGroups = new maskGroupsStruct();
        }
        if (string4.equals(GROUP)) {
            this.iData = 5;
            ++this.iRow;
        }
        if (string4.equals(MASKS)) {
            this.iRow = -1;
            this.iSymbol = 6;
            this.iData = 6;
            this.iWord = 6;
        }
        if (string4.equals(MODIFIERS)) {
            this.iRow = -1;
            this.iSymbol = 14;
            this.iData = 14;
            this.iWord = 14;
        }
        if (string4.equals(DATA)) {
            this.iData = 7;
            ++this.iRow;
            switch (this.iSymbol) {
                case 6: {
                    this.stList.stItem[this.iRow] = new maskSymbolsStruct();
                    break;
                }
                case 14: {
                    this.stList.stModifiers[this.iRow] = new maskSymbolsStruct();
                    break;
                }
            }
        }
        if (string4.equals(COLUMN)) {
            this.iData = 8;
        }
        if (string4.equals(SYMBOLS)) {
            this.iData = 9;
            this.iCount = -1;
        }
        if (string4.equals(SYMBOL)) {
            this.iData = 10;
        }
        if (string4.equals(THESAURUS)) {
            this.iData = 11;
            this.iCount = -1;
        }
        if (string4.equals(WORD)) {
            this.iData = 12;
            ++this.iCount;
        }
        if (string4.equals(LITHOLOGY)) {
            this.iData = 13;
        }
        if (string4.equals(KEYWORDS)) {
            this.iRow = -1;
            this.iData = 15;
            this.iWord = 15;
        }
        if (attributes != null) {
            block53: for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                String string6 = new String(attributes.getValue(i));
                String string7 = this.removeExcess(string6);
                if (string5.equals(RECORDS)) {
                    block4 : switch (this.iData) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.stList.stBackground.iColors = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stBackground.sColors = new String[this.iRows];
                            this.stList.stBackground.iRGB = new int[this.iRows][3];
                            for (n = 0; n < this.iRows; ++n) {
                                this.stList.stBackground.sColors[n] = new String("");
                                for (n2 = 0; n2 < 3; ++n2) {
                                    this.stList.stBackground.iRGB[n][n2] = 255;
                                }
                            }
                            break;
                        }
                        case 2: {
                            this.stList.stForeground.iColors = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stForeground.colors = new char[this.iRows];
                            this.stList.stForeground.iRGB = new int[this.iRows][3];
                            for (n = 0; n < this.iRows; ++n) {
                                this.stList.stForeground.colors[n] = 32;
                                for (n2 = 0; n2 < 3; ++n2) {
                                    this.stList.stForeground.iRGB[n][n2] = 255;
                                }
                            }
                            break;
                        }
                        case 4: {
                            this.stList.stGroups.iGroups = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stGroups.sGroups = new String[this.iRows][2];
                            for (n = 0; n < this.iRows; ++n) {
                                for (n2 = 0; n2 < 2; ++n2) {
                                    this.stList.stGroups.sGroups[n][n2] = new String("");
                                }
                            }
                            break;
                        }
                        case 6: {
                            this.stList.iCount = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stItem = new maskSymbolsStruct[this.iRows];
                            break;
                        }
                        case 14: {
                            this.stList.iModifiers = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.stModifiers = new maskSymbolsStruct[this.iRows];
                            break;
                        }
                        case 9: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            switch (this.iSymbol) {
                                case 6: {
                                    this.stList.stItem[this.iRow].symbol = new String[this.iRows][2];
                                    for (n = 0; n < this.iRows; ++n) {
                                        for (n2 = 0; n2 < 2; ++n2) {
                                            this.stList.stItem[this.iRow].symbol[n][n2] = new String("..........");
                                        }
                                    }
                                    break block4;
                                }
                                case 14: {
                                    this.stList.stModifiers[this.iRow].symbol = new String[this.iRows][2];
                                    for (n = 0; n < this.iRows; ++n) {
                                        for (n2 = 0; n2 < 2; ++n2) {
                                            this.stList.stModifiers[this.iRow].symbol[n][n2] = new String("..........");
                                        }
                                    }
                                    break block4;
                                }
                            }
                            break;
                        }
                        case 11: {
                            this.iRows = cmnString.stringToInt(string7.trim());
                            switch (this.iSymbol) {
                                case 6: {
                                    this.stList.stItem[this.iRow].iThesaurus = this.iRows;
                                    this.stList.stItem[this.iRow].sThesaurus = new String[this.iRows];
                                    for (n = 0; n < this.iRows; ++n) {
                                        this.stList.stItem[this.iRow].sThesaurus[n] = new String("");
                                    }
                                    break block4;
                                }
                                case 14: {
                                    this.stList.stModifiers[this.iRow].iThesaurus = this.iRows;
                                    this.stList.stModifiers[this.iRow].sThesaurus = new String[this.iRows];
                                    for (n = 0; n < this.iRows; ++n) {
                                        this.stList.stModifiers[this.iRow].sThesaurus[n] = new String("");
                                    }
                                    break block4;
                                }
                            }
                            break;
                        }
                        case 15: {
                            this.stList.iKeywords = this.iRows = cmnString.stringToInt(string7.trim());
                            this.stList.sKeywords = new String[this.iRows];
                            break;
                        }
                    }
                }
                switch (this.iData) {
                    case 3: {
                        switch (this.iColor) {
                            case 2: {
                                this.stList.stForeground = this.ParseData(string5, string7.trim(), this.stList.stForeground);
                                break;
                            }
                            case 1: {
                                this.stList.stBackground = this.ParseData(string5, string7.trim(), this.stList.stBackground);
                                break;
                            }
                        }
                        continue block53;
                    }
                    case 5: {
                        this.stList.stGroups = this.ParseData(string5, string7.trim(), this.stList.stGroups);
                        continue block53;
                    }
                    case 6: 
                    case 14: {
                        if (string5.equals(ROWS) && cmnString.isNumeric(string7.trim())) {
                            this.iLines = cmnString.stringToInt(string7.trim());
                        }
                        if (!string5.equals(COLUMNS) || !cmnString.isNumeric(string7.trim())) continue block53;
                        this.iColumns = cmnString.stringToInt(string7.trim());
                        continue block53;
                    }
                    case 8: {
                        switch (this.iSymbol) {
                            case 6: {
                                this.stList.stItem[this.iRow] = this.ParseData(string5, string7.trim(), this.stList.stItem[this.iRow]);
                                break;
                            }
                            case 14: {
                                this.stList.stModifiers[this.iRow] = this.ParseData(string5, string7.trim(), this.stList.stModifiers[this.iRow]);
                                break;
                            }
                        }
                        continue block53;
                    }
                    case 10: {
                        switch (this.iSymbol) {
                            case 6: {
                                this.stList.stItem[this.iRow] = this.ParseSymbol(string5, string7.trim(), this.stList.stItem[this.iRow]);
                                break;
                            }
                            case 14: {
                                this.stList.stModifiers[this.iRow] = this.ParseSymbol(string5, string7.trim(), this.stList.stModifiers[this.iRow]);
                                break;
                            }
                        }
                        continue block53;
                    }
                    case 13: {
                        switch (this.iSymbol) {
                            case 6: {
                                this.stList.stItem[this.iRow] = this.parseLithology(string5, string7.trim(), this.stList.stItem[this.iRow]);
                                break;
                            }
                            case 14: {
                                this.stList.stModifiers[this.iRow] = this.parseLithology(string5, string7.trim(), this.stList.stModifiers[this.iRow]);
                                break;
                            }
                        }
                        continue block53;
                    }
                    case 12: {
                        switch (this.iWord) {
                            case 6: {
                                if (!string5.equals(PHRASE)) break;
                                this.stList.stItem[this.iRow].sThesaurus[this.iCount] = new String(string7.trim());
                                break;
                            }
                            case 14: {
                                if (!string5.equals(PHRASE)) break;
                                this.stList.stModifiers[this.iRow].sThesaurus[this.iCount] = new String(string7.trim());
                                break;
                            }
                            case 15: {
                                if (!string5.equals(PHRASE)) break;
                                ++this.iRow;
                                this.stList.sKeywords[this.iRow] = new String(string7.trim());
                            }
                        }
                        continue block53;
                    }
                }
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXParseException {
        throw sAXParseException;
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXParseException {
        System.out.println("** Warning, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
        System.out.println("   " + sAXParseException.getMessage());
    }

    private String removeExcess(String string) {
        String string2 = new String("");
        int n = 32;
        char[] cArray = string.toCharArray();
        for (int i = 0; i < cArray.length; ++i) {
            if (i == 0) {
                n = cArray[i];
            }
            if (n != 32) {
                string2 = new String(string2 + cArray[i]);
            } else if (n == 32 && cArray[i] != ' ') {
                string2 = new String(string2 + cArray[i]);
            }
            n = cArray[i];
        }
        return string2;
    }

    private maskColorsStruct ParseData(String string, String string2, maskColorsStruct maskColorsStruct2) {
        char[] cArray = null;
        if (string.equals(SYMBOL)) {
            switch (this.iColor) {
                case 1: {
                    maskColorsStruct2.sColors[this.iRow] = new String(string2);
                    break;
                }
                case 2: {
                    cArray = string2.toCharArray();
                    if (cArray.length <= 0) break;
                    maskColorsStruct2.colors[this.iRow] = cArray[0];
                }
            }
        }
        if (string.equals("r") && this.iRow > -1 && cmnString.isNumeric(string2)) {
            maskColorsStruct2.iRGB[this.iRow][0] = cmnString.stringToInt(string2);
        }
        if (string.equals(GREEN) && this.iRow > -1 && cmnString.isNumeric(string2)) {
            maskColorsStruct2.iRGB[this.iRow][1] = cmnString.stringToInt(string2);
        }
        if (string.equals(BLUE) && this.iRow > -1 && cmnString.isNumeric(string2)) {
            maskColorsStruct2.iRGB[this.iRow][2] = cmnString.stringToInt(string2);
        }
        return maskColorsStruct2;
    }

    private maskGroupsStruct ParseData(String string, String string2, maskGroupsStruct maskGroupsStruct2) {
        if (string.equals(MNEMONIC)) {
            maskGroupsStruct2.sGroups[this.iRow][0] = new String(string2);
        }
        if (string.equals(DESCRIPTION)) {
            maskGroupsStruct2.sGroups[this.iRow][1] = new String(string2);
        }
        return maskGroupsStruct2;
    }

    private maskSymbolsStruct ParseData(String string, String string2, maskSymbolsStruct maskSymbolsStruct2) {
        String string3 = "";
        int n = -1;
        if (string.equals(ID) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.id = cmnString.stringToInt(string2);
        }
        if (string.equals(SID)) {
            maskSymbolsStruct2.sID = new String(string2);
            if (maskSymbolsStruct2.id == 0) {
                maskSymbolsStruct2.id = this.iRow;
            }
        }
        if (string.equals(ROWS) && cmnString.isNumeric(string2)) {
            this.iLines = cmnString.stringToInt(string2);
        }
        if (string.equals(COLUMNS) && cmnString.isNumeric(string2)) {
            this.iColumns = cmnString.stringToInt(string2);
        }
        if (string.equals(SHOW) && string2.equals("yes")) {
            maskSymbolsStruct2.iShow = 1;
            maskSymbolsStruct2.iExtend = 1;
        }
        if (string.equals(ORDER) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iOrder = cmnString.stringToInt(string2);
        }
        if (string.equals(GROUP) && this.stList.stGroups != null) {
            maskSymbolsStruct2.iGroup = maskSymbolsUtility.getGroupID(0, string2, this.stList.stGroups);
            maskSymbolsStruct2.sGroup = new String(maskSymbolsUtility.getGroup(1, maskSymbolsStruct2.iGroup, this.stList.stGroups));
        }
        if (string.equals(COLOR)) {
            n = maskSymbolsUtility.getColor(string2, this.stList.stBackground);
            maskSymbolsStruct2.iRGB = maskSymbolsUtility.getRGB(n, this.stList.stBackground);
        }
        if (string.equals(TYPE)) {
            maskSymbolsStruct2.sType = new String(string2);
        }
        if (string.equals(SIZE)) {
            maskSymbolsStruct2.size = new String(string2);
        }
        if (string.equals(MINIMUM) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.dMinimum = cmnString.stringToDouble(string2);
        }
        if (string.equals(MAXIMUM) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.dMaximum = cmnString.stringToDouble(string2);
        }
        if (string.equals(MNEMONIC)) {
            maskSymbolsStruct2.sMnemonic = new String(string2);
        }
        if (string.equals(ABREV)) {
            maskSymbolsStruct2.sAbrev = new String(string2);
        }
        if (string.equals(NAME)) {
            maskSymbolsStruct2.sName = new String(string2);
        }
        return maskSymbolsStruct2;
    }

    private maskSymbolsStruct ParseSymbol(String string, String string2, maskSymbolsStruct maskSymbolsStruct2) {
        if (string.equals(ROW)) {
            maskSymbolsStruct2.iRows = this.iLines;
            maskSymbolsStruct2.iColumns = this.iColumns;
            if (cmnString.isNumeric(string2)) {
                this.iCount = cmnString.stringToInt(string2);
            }
        }
        if (string.equals(CENTER)) {
            maskSymbolsStruct2.symbol[this.iCount][0] = new String(string2);
        }
        if (string.equals(LEFT)) {
            maskSymbolsStruct2.symbol[this.iCount][0] = new String(string2);
        }
        if (string.equals("r")) {
            maskSymbolsStruct2.symbol[this.iCount][1] = new String(string2);
        }
        return maskSymbolsStruct2;
    }

    private maskSymbolsStruct parseLithology(String string, String string2, maskSymbolsStruct maskSymbolsStruct2) {
        if (string.equals(_1) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[0] = cmnString.stringToInt(string2);
        }
        if (string.equals(_2) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[1] = cmnString.stringToInt(string2);
        }
        if (string.equals(_3) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[2] = cmnString.stringToInt(string2);
        }
        if (string.equals(_4) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[3] = cmnString.stringToInt(string2);
        }
        if (string.equals(_5) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[4] = cmnString.stringToInt(string2);
        }
        if (string.equals(_6) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[5] = cmnString.stringToInt(string2);
        }
        if (string.equals(_7) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[6] = cmnString.stringToInt(string2);
        }
        if (string.equals(_8) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[7] = cmnString.stringToInt(string2);
        }
        if (string.equals(_9) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[8] = cmnString.stringToInt(string2);
        }
        if (string.equals(_10) && cmnString.isNumeric(string2)) {
            maskSymbolsStruct2.iLithology[9] = cmnString.stringToInt(string2);
        }
        return maskSymbolsStruct2;
    }

    public int GetErrorID() {
        return this.iError;
    }

    public String GetError() {
        return this.sError;
    }
}

