/*
 * Decompiled with CFR 0.152.
 */
package lith.texture.plot;

import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import las.lasFileDataStruct;
import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.lithologySymbolsUtility;
import lith.lithology.plot.lithologyPlotSymbol;
import lith.texture.textureConstants;
import lith.texture.textureListStruct;
import lith.texture.textureUtility;

public class texturePlotTrack
extends Canvas {
    private int iUnits = 0;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    public static final double GAMMA_MAX = 150.0;
    public static final double GAMMA_MIN = 0.0;
    public static final double CLEAN = 60.0;
    private lasFileDataStruct stLASFileData = null;
    private double dStart = 0.0;
    private double dEnd = 0.0;
    private textureListStruct stLASTexture = null;
    private lithologySymbolsListStruct stLithology = null;
    private lithologyPlotSymbol plotLith = null;
    private int iFocus = 0;
    private int iLASTexture = 36;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public texturePlotTrack(int n, double d, double d2, int n2, int n3, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        this.iDataType = n;
        this.iUnits = n3;
        this.stLithology = lithologySymbolsListStruct2;
        this.plotLith = new lithologyPlotSymbol(lithologySymbolsListStruct2);
        this.setPlotHeight(n2, d2, d);
        this.builidDataStructure();
        this.setBackground(Color.white);
    }

    public void close() {
        this.stLASFileData = null;
        this.stLithology = null;
        if (this.plotLith != null) {
            this.plotLith.close();
        }
        this.plotLith = null;
        if (this.stLASTexture != null) {
            this.stLASTexture.delete();
        }
        this.stLASTexture = null;
    }

    public textureListStruct getTexture() {
        return this.stLASTexture;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        this.builidDataStructure();
        this.stLASFileData = lasFileDataStruct2;
        this.stLASTexture = textureUtility.computeLASPlotTexture(lasFileDataStruct2, this.stLASTexture, this.stLithology);
        this.stLASTexture = textureUtility.fillEmptySpaces(this.stLASTexture);
    }

    private void builidDataStructure() {
        if (this.stLASTexture != null) {
            this.stLASTexture.delete();
        }
        this.stLASTexture = null;
        this.stLASTexture = textureUtility.buildNew(0, this.depthStart, this.depthEnd);
    }

    public void drawTextureGrid(Graphics graphics, int n, int n2) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = n2 / 14;
        int n12 = n + n2;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int[] nArray = new int[]{255, 255, 255};
        int n17 = -1;
        String[][] stringArray = null;
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        for (n4 = 0; n4 <= this.iLogHeight; n4 += this.iIncrementY) {
            n8 = this.iDataType == 1 ? this.iHeight - n4 : n4 + 100;
            n10 = this.iIncrementY / 5;
            for (n5 = 0; n5 < 5; ++n5) {
                n9 = this.iDataType == 1 ? this.iHeight - (n4 + n5 * n10) : n4 + n5 * n10 + 100;
                if (n9 < 100 || n9 >= this.iHeight) continue;
                graphics.setColor(Color.lightGray);
                graphics.drawLine(n, n9, n12, n9);
            }
            graphics.setColor(Color.gray);
            graphics.drawLine(n, n8, n12, n8);
        }
        graphics.setColor(Color.lightGray);
        graphics.drawLine(n12, 25, n12, 100 + this.iLogHeight);
        for (n4 = 0; n4 <= n2; n4 += n11) {
            if (n4 == 0 || n4 == n2) {
                graphics.drawLine(n4 + n, 25, n4 + n, 100 + this.iLogHeight);
                continue;
            }
            graphics.drawLine(n4 + n, 100, n4 + n, 100 + this.iLogHeight);
        }
        graphics.setColor(Color.black);
        if (this.iFocus == 0) {
            graphics.drawString("Rock Texture by LAS", n + n11, 35);
        } else {
            graphics.drawString("Rock Texture", n + 3 * n11, 35);
        }
        graphics.setColor(new Color(0, 229, 229));
        graphics.fillRect(n, 35, n2, 10);
        n15 = 5;
        n16 = 10;
        n13 = 19;
        for (n3 = 0; n3 < this.stLithology.iCount; ++n3) {
            if (n13 != this.stLithology.stItem[n3].id) continue;
            n17 = n3;
        }
        nArray = this.stLithology.stItem[n17].iRGB;
        stringArray = lithologySymbolsUtility.getSymbol(n17, this.stLithology);
        for (n5 = 0; n5 < 14; ++n5) {
            n3 = n2 / 12;
            this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n5 * n3, 35, n16, n15);
            this.plotLith.drawLithologySymbolMask(graphics, n15, this.plotLith.getOrder(0), stringArray, n + n5 * n3, 35);
            this.plotLith.drawLithologySymbolMask(graphics, n15, this.plotLith.getOrder(1), stringArray, n + n5 * n3, 40);
        }
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString("Carbonate", n + 4 * n11, 45);
        for (n6 = 6; n6 > -1; --n6) {
            n15 = 5;
            n16 = 10;
            n14 = textureConstants.CaCO3_CELLS[n6];
            nArray = textureConstants.LIMESTONE_COLOR[n14 - 1];
            for (n7 = 0; n7 < n14; ++n7) {
                this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n7 * 10, 56, n11, 11);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n + n14 * 10, 56, n + n14 * 10, 67);
        }
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawLine(n + 50, 45, n + 50, 67);
        graphics.drawLine(n + 90, 45, n + 90, 67);
        graphics.drawLine(n + 120, 45, n + 120, 67);
        graphics.drawString("Mud", n + 2 * n11, 56);
        graphics.drawString("Grain", n + 6 * n11, 56);
        graphics.drawString("M", n + n11, 67);
        graphics.drawString("W", n + 4 * n11, 67);
        graphics.drawString("P", n + 6 * n11, 67);
        graphics.drawString("G", n + 8 * n11, 67);
        graphics.drawString("B", n + 10 * n11, 67);
        graphics.drawString("C", n + 12 * n11, 67);
        graphics.setColor(new Color(255, 255, 0));
        graphics.fillRect(n, 68, n2, 10);
        n15 = 5;
        n16 = 10;
        n13 = 7;
        for (n3 = 0; n3 < this.stLithology.iCount; ++n3) {
            if (n13 != this.stLithology.stItem[n3].id) continue;
            n17 = n3;
        }
        nArray = this.stLithology.stItem[n17].iRGB;
        stringArray = lithologySymbolsUtility.getSymbol(n17, this.stLithology);
        for (n5 = 0; n5 < 13; ++n5) {
            n3 = n2 / 12;
            this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n5 * n3, 73, n16, n15);
            this.plotLith.drawLithologySymbolMask(graphics, n15, this.plotLith.getOrder(0), stringArray, n + n5 * n3, 68);
            this.plotLith.drawLithologySymbolMask(graphics, n15, this.plotLith.getOrder(1), stringArray, n + n5 * n3, 73);
        }
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawString("Siliciclastic", n + 4 * n11, 78);
        for (n6 = 9; n6 > -1; --n6) {
            n15 = 5;
            n16 = 10;
            n14 = textureConstants.SiO2_CELLS[n6];
            nArray = textureConstants.SIO2_COLOR[n14 - 1];
            for (n7 = 0; n7 < n14; ++n7) {
                this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n7 * 10, 89, n11, 11);
            }
            graphics.setColor(Color.black);
            graphics.drawLine(n + n14 * 10, 89, n + n14 * 10, 100);
        }
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics.setColor(Color.black);
        graphics.drawLine(n + 40, 78, n + 40, 100);
        graphics.drawLine(n + 90, 78, n + 90, 100);
        graphics.drawString("Mud", n + n11, 89);
        graphics.drawString("Sand", n + 5 * n11 + 2, 89);
        graphics.drawString("Gravel", n + 10 * n11 + 2, 89);
        graphics.drawString("Clay", n, 100);
        graphics.drawString("Silt", n + 2 * n11 + 2, 100);
        graphics.drawString("v", n + 4 * n11 + 2, 100);
        graphics.drawString("f", n + 5 * n11 + 3, 100);
        graphics.drawString("m", n + 6 * n11 + 2, 100);
        graphics.drawString("c", n + 7 * n11 + 3, 100);
        graphics.drawString("C", n + 8 * n11 + 1, 100);
        graphics.drawString("g", n + 9 * n11 + 2, 100);
        graphics.drawString("peb", n + 10 * n11 + 2, 100);
        graphics.drawString("cob", n + 12 * n11 + 2, 100);
        graphics.setColor(Color.black);
        graphics.drawLine(n, 25, n12, 25);
        graphics.drawLine(n, 100, n12, 100);
        graphics.drawLine(n, 25, n, 100 + this.iLogHeight);
    }

    public void drawTexture(Graphics graphics, int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int[] nArray = new int[]{255, 255, 255};
        int n14 = -1;
        String[][] stringArray = null;
        textureListStruct textureListStruct2 = null;
        boolean bl = false;
        int n15 = 0;
        textureListStruct2 = this.stLASTexture;
        if (textureListStruct2 != null && textureListStruct2.iCount > 0 && textureListStruct2.stItem[0] != null) {
            d2 = textureListStruct2.stItem[0].depthEnd;
            d = textureListStruct2.stItem[0].depthStart;
            d3 = d2 - d;
            n5 = (int)(5.0 / d3 * ((double)iqstratTracksStruct.SCALE[this.iScale] / 100.0));
            if (n5 < 1) {
                n5 = 1;
            }
            n6 = -1;
            for (n3 = 0; n3 < textureListStruct2.iCount; ++n3) {
                int n16;
                if (textureListStruct2.stItem[n3] == null) continue;
                d = textureListStruct2.stItem[n3].depthStart;
                d2 = d + d3 * (double)n5;
                for (n16 = 1; n16 < n5; ++n16) {
                    if (n3 >= textureListStruct2.iCount - 1) continue;
                    ++n3;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d4;
                }
                d4 = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n8 = 100 + (int)d4;
                if (this.iDataType == 1) {
                    n8 = this.iHeight - (int)d4;
                }
                n9 = Math.abs(n8 - n7);
                if (!bl) {
                    n15 = n9;
                    bl = true;
                }
                if (n9 > n15) {
                    n15 = n9;
                }
                if (n9 < n15) {
                    n9 = n15;
                    n8 = n7 + n15;
                }
                if (n7 < 100 || n8 <= 100 || n7 >= this.iHeight || n8 >= this.iHeight) continue;
                if (this.iDataType == 1) {
                    n7 = n8;
                }
                if ((n10 = n9 / 5) == 0) {
                    n10 = 1;
                }
                n12 = 5;
                n13 = 10;
                nArray = textureListStruct2.stItem[n3].iRGB;
                n11 = textureListStruct2.stItem[n3].iEnergy;
                stringArray = lithologySymbolsUtility.getSymbol(textureListStruct2.stItem[n3].iSymbol, this.stLithology);
                if (textureListStruct2.stItem[n3].iSymbol <= -1) continue;
                for (n4 = 0; n4 < n10; ++n4) {
                    ++n6;
                    for (n16 = 0; n16 < n11; ++n16) {
                        this.plotLith.drawBlock(graphics, nArray[0], nArray[1], nArray[2], n + n16 * n13, n7 + n4 * 5, n13, n12);
                        this.plotLith.drawLithologySymbolMask(graphics, n12, this.plotLith.getOrder(n6), stringArray, n + n16 * n13, n7 + n4 * 5);
                    }
                }
            }
        }
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = -1;
        switch (n) {
            case 36: {
                n4 = 0;
                graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
                graphics.fillRect(n2, 25, n3, 20);
                this.iFocus = 0;
                this.drawTextureGrid(graphics, n2, n3);
                this.drawTexture(graphics, n2, n3);
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

