/*
 * Decompiled with CFR 0.152.
 */
package lith.plot;

import iqstrat.iqstratShaleListStruct;
import iqstrat.iqstratTracksStruct;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import las.lasFileDataStruct;
import las.lasStandardTools;
import rock.rockFileDataStruct;

public class lithPlotColorlith
extends Canvas {
    private boolean bSonic = false;
    private int iDataType = -1;
    private double depthStart = 0.0;
    private double depthEnd = 0.0;
    private int iScale = -1;
    private int iColorlith = 0;
    private lasFileDataStruct stLASFileData = null;
    private rockFileDataStruct stRockFileData = null;
    public static final double RHO_MAX = 3.0;
    public static final double RHO_MIN = 2.0;
    public static final double UMAA_MAX = 13.8;
    public static final double UMAA_MIN = 4.3;
    public static final double RHOMAA_MAX = 2.87;
    public static final double RHOMAA_MIN = 2.6;
    public static final double DTMAA_MAX = 65.0;
    public static final double DTMAA_MIN = 35.0;
    public static final double PHI_MAX = 0.5;
    public static final double PHI_MIN = 0.0;
    public static final double DPHI_MAX = 0.08;
    public static final double DPHI_MIN = -0.08;
    public static final double THU_MAX = 24.5;
    public static final double THU_MIN = 0.57;
    public static final double THK_MAX = 41.14;
    public static final double THK_MIN = 1.02;
    public static final double U_MAX = 30.0;
    public static final double U_MIN = 0.0;
    public static final double TH_MAX = 20.0;
    public static final double TH_MIN = 0.0;
    public static final double K_MAX = 5.0;
    public static final double K_MIN = 0.0;
    private static final int _RT = 0;
    private static final int _PHIT = 1;
    private int iRt = -1;
    private double dRtMax = 2000.0;
    private double dRtMin = 0.0;
    private double[][] dataRt = null;
    private static final int _MMHOS_M = 16;
    private static final int[][] MMHOS_M = iqstratTracksStruct.MMHOS_M;
    private int iPhit = -1;
    private double dPhitMax = 0.3;
    private double dPhitMin = 0.0;
    private double[][] dataPhit = null;
    private double[][] dataPhi = null;
    private static final int _PU = 16;
    private static final int[][] PU = iqstratTracksStruct.PU;
    private int iWidth = 100;
    private int iHeight = 100;
    private int iLogHeight = 100;
    private int iIncrementY = 100;
    public static final int PLOT_TITLES = 100;
    public static final int LABELSTART = 25;

    public lithPlotColorlith(int n, double d, double d2, int n2) {
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public lithPlotColorlith(boolean bl, int n, double d, double d2, int n2) {
        this.bSonic = bl;
        this.iDataType = n;
        this.setPlotHeight(n2, d2, d);
        this.setBackground(Color.white);
    }

    public void close() {
        this.stLASFileData = null;
        this.stRockFileData = null;
        this.dataRt = null;
        this.dataPhit = null;
        this.dataPhi = null;
    }

    public void setPlotHeight(int n, double d, double d2) {
        this.depthStart = d2;
        this.depthEnd = d;
        this.iScale = n;
        this.iLogHeight = (int)(100.0 * Math.abs(d - d2) / (double)iqstratTracksStruct.SCALE[n]);
        this.iHeight = 100 + this.iLogHeight;
    }

    public void setLASFileData(lasFileDataStruct lasFileDataStruct2) {
        this.stLASFileData = lasFileDataStruct2;
    }

    public void setRockFileData(rockFileDataStruct rockFileDataStruct2) {
        this.stRockFileData = rockFileDataStruct2;
    }

    public void setColorlith(int n) {
        this.iColorlith = n;
    }

    public void setOHM(int n, double d, double d2) {
        this.iRt = n;
        this.dRtMax = d;
        this.dRtMin = d2;
    }

    public void setPHI(int n, double d, double d2) {
        this.iPhit = n;
        this.dPhitMax = d;
        this.dPhitMin = d2;
    }

    public void setImageData(double[][] dArray, double[][] dArray2, double[][] dArray3) {
        this.dataRt = dArray;
        this.dataPhit = dArray2;
        this.dataPhi = dArray3;
    }

    public void drawGammaTrack(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n9 = n2 + n3;
        double d5 = 0.0;
        double d6 = 150.0;
        int n10 = 0;
        double[] dArray = null;
        double[] dArray2 = null;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        int n11 = 255;
        int n12 = 255;
        int n13 = 255;
        double d7 = 60.0;
        double d8 = 70.0;
        double d9 = 0.0;
        boolean bl = false;
        graphics.setColor(new Color(255, 255, 255));
        if (n == 0 && this.stLASFileData != null) {
            n10 = this.stLASFileData.iRows;
            dArray = this.bSonic ? this.stLASFileData.dTime : this.stLASFileData.depths;
            dArray2 = this.stLASFileData.dGR;
            iqstratShaleListStruct2 = this.stLASFileData.stList;
        }
        if (n10 > 0) {
            for (int i = 0; i < n10 - 1; ++i) {
                d3 = dArray[i];
                d4 = dArray[i + 1];
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n4 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n4 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d4) / (this.depthStart - this.depthEnd);
                n5 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n5 = this.iHeight - (int)d;
                }
                n6 = Math.abs(n5 - n4);
                d2 = dArray2[i];
                if (iqstratShaleListStruct2 != null) {
                    for (int j = 0; j < iqstratShaleListStruct2.iCount; ++j) {
                        if (!(dArray[i] >= iqstratShaleListStruct2.stItem[j].depthStart) || !(dArray[i] <= iqstratShaleListStruct2.stItem[j].depthEnd)) continue;
                        d5 = iqstratShaleListStruct2.stItem[j].dGammaMin;
                        d7 = iqstratShaleListStruct2.stItem[j].dShaly;
                        d8 = iqstratShaleListStruct2.stItem[j].dShale;
                        d6 = iqstratShaleListStruct2.stItem[j].dGammaMax;
                    }
                }
                if (d2 < d5) {
                    d2 = d5;
                }
                if (d2 > d6) {
                    d2 = d6;
                }
                bl = true;
                if (d2 < 0.1) {
                    d9 = 0.1 - d5;
                    n11 = 255;
                    n12 = 255;
                    n13 = 255;
                    bl = false;
                } else if (d2 < d8) {
                    d9 = d8 - d5;
                    n11 = 255;
                    n12 = (int)(255.0 * (d8 - d2) / d9);
                    n13 = 0;
                } else {
                    d9 = d6 - d8;
                    n11 = (int)(255.0 * (d6 - d2) / d9);
                    n12 = 0;
                    n13 = 0;
                }
                graphics.setColor(new Color(n11, n12, n13));
                n7 = (int)(255.0 * (1.0 - (d2 - d5) / (d6 - d5)));
                if (!bl || n4 <= 100 || n5 <= 100 || n4 >= this.iHeight || n5 >= this.iHeight) continue;
                n8 = n3 * (256 - n7) / 255;
                n8 = n3 - n8 / 2;
                graphics.fillRect(n9 - n8, n4, n8, n6);
            }
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Lithology", 39, -1 * (n2 + 2 * n3 / 3));
        graphics2D.drawString("Gamma Ray", 32, -1 * (n2 + 5));
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n2, 25, n9, 25);
        graphics.drawLine(n2, 100, n9, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n9, 25, n9, 100 + this.iLogHeight);
    }

    public void drawImageTrack(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = null;
        double[] dArray2 = null;
        double d3 = 0.0;
        double d4 = 0.0;
        int n10 = n3 + n4;
        int n11 = -1;
        double d5 = 0.0;
        double d6 = 0.0;
        int n12 = 0;
        boolean bl = false;
        double d7 = 0.0;
        switch (n2) {
            case 0: {
                n11 = this.iRt;
                d6 = this.dRtMax;
                d5 = this.dRtMin;
                break;
            }
            case 1: {
                n11 = this.iPhit;
                d6 = this.dPhitMax;
                d5 = this.dPhitMin;
            }
        }
        if ((n == 11 || n == 2) && this.stLASFileData != null) {
            n12 = this.stLASFileData.iRows;
            dArray = this.bSonic ? this.stLASFileData.dTime : this.stLASFileData.depths;
            dArray2 = this.stLASFileData.getData(n11);
            d7 = this.stLASFileData.dNull;
            if (this.stLASFileData.checkData(n11)) {
                bl = true;
            }
        }
        graphics.setColor(new Color(255, 255, 255));
        if (n11 > -1 && bl) {
            for (n5 = 0; n5 < n12 - 1; ++n5) {
                d3 = dArray[n5];
                d4 = dArray[n5 + 1];
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n6 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d4) / (this.depthStart - this.depthEnd);
                n7 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n7 = this.iHeight - (int)d;
                }
                n8 = Math.abs(n7 - n6);
                d2 = dArray2[n5];
                if (n2 == 0) {
                    d2 = d2 > d7 ? 1000.0 / d2 : d7;
                }
                if (d2 < d5) {
                    d2 = d5;
                }
                if (d2 > d6) {
                    d2 = d6;
                }
                switch (n2) {
                    case 0: {
                        n9 = (int)(15.0 * (d2 - d5) / (d6 - d5));
                        graphics.setColor(new Color(MMHOS_M[n9][0], MMHOS_M[n9][1], MMHOS_M[n9][2]));
                        break;
                    }
                    case 1: {
                        n9 = (int)(15.0 * (d2 - d5) / (d6 - d5));
                        graphics.setColor(new Color(PU[n9][0], PU[n9][1], PU[n9][2]));
                    }
                }
                if (n6 <= 100 || n7 <= 100 || n6 >= this.iHeight || n7 >= this.iHeight || !(d2 > d7)) continue;
                graphics.fillRect(n3, n6, n4, n8);
            }
        }
        for (n5 = 0; n5 < n4; ++n5) {
            switch (n2) {
                case 0: {
                    n9 = 15 * n5 / n4;
                    graphics.setColor(new Color(MMHOS_M[n9][0], MMHOS_M[n9][1], MMHOS_M[n9][2]));
                    break;
                }
                case 1: {
                    n9 = 15 * n5 / n4;
                    graphics.setColor(new Color(PU[n9][0], PU[n9][1], PU[n9][2]));
                }
            }
            graphics.fillRect(n3 + n5, 94, 1, 6);
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Linear", 39, -1 * (n3 + 3 * n4 / 4));
        font = new Font("Serif", 1, 11);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics2D.drawString("color scheme", 26, -1 * (n3 + n4 / 2));
        String string = "";
        if (n11 > -1) {
            graphics2D.drawString(lasStandardTools.LAS_TOOLS[n11][1] + string, 39, -1 * n3);
        }
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n3, 25, n10, 25);
        graphics.drawLine(n3, 100, n10, 100);
        graphics.drawLine(n3, 25, n3, 100 + this.iLogHeight);
        graphics.drawLine(n10, 25, n10, 100 + this.iLogHeight);
    }

    public void drawNonLinearImageTrack(Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        int n7 = -1;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n11 = n3 + n4;
        int n12 = 0;
        double d4 = 0.0;
        double d5 = 0.0;
        double[][] dArray = null;
        double d6 = 0.0;
        boolean bl = false;
        switch (n2) {
            case 0: {
                n7 = this.iRt;
                d5 = this.dRtMax;
                d4 = this.dRtMin;
                dArray = this.dataRt;
                break;
            }
            case 1: {
                n7 = this.iPhit;
                d5 = this.dPhitMax;
                d4 = this.dPhitMin;
                dArray = this.dataPhit;
            }
        }
        if (this.stLASFileData != null && this.stLASFileData.checkData(n7)) {
            bl = true;
        }
        graphics.setColor(new Color(255, 255, 255));
        if (n7 > -1 && bl && dArray != null) {
            n12 = dArray.length;
            for (n5 = 0; n5 < n12 - 1; ++n5) {
                d2 = dArray[n5][0];
                d3 = dArray[n5 + 1][0];
                d = (double)this.iLogHeight * (this.depthStart - d2) / (this.depthStart - this.depthEnd);
                n8 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n8 = this.iHeight - (int)d;
                }
                d = (double)this.iLogHeight * (this.depthStart - d3) / (this.depthStart - this.depthEnd);
                n9 = 100 + (int)d;
                if (this.iDataType == 1) {
                    n9 = this.iHeight - (int)d;
                }
                n10 = Math.abs(n9 - n8);
                d6 = dArray[n5][1];
                if (d6 < d4) {
                    d6 = d4;
                }
                if (d6 > d5) {
                    d6 = d5;
                }
                n6 = (int)dArray[n5][2];
                switch (n2) {
                    case 0: {
                        graphics.setColor(new Color(MMHOS_M[n6][0], MMHOS_M[n6][1], MMHOS_M[n6][2]));
                        break;
                    }
                    case 1: {
                        graphics.setColor(new Color(PU[n6][0], PU[n6][1], PU[n6][2]));
                    }
                }
                if (n8 <= 100 || n9 <= 100 || n8 >= this.iHeight || n9 >= this.iHeight || !(d6 > this.stLASFileData.dNull)) continue;
                graphics.fillRect(n3, n8, n4, n10);
            }
        }
        for (n5 = 0; n5 < n4; ++n5) {
            switch (n2) {
                case 0: {
                    n6 = 15 * n5 / n4;
                    graphics.setColor(new Color(MMHOS_M[n6][0], MMHOS_M[n6][1], MMHOS_M[n6][2]));
                    break;
                }
                case 1: {
                    n6 = 15 * n5 / n4;
                    graphics.setColor(new Color(PU[n6][0], PU[n6][1], PU[n6][2]));
                }
            }
            graphics.fillRect(n3 + n5, 94, 1, 6);
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 10);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString("Non-linear", 39, -1 * (n3 + 3 * n4 / 4));
        font = new Font("Serif", 1, 11);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics2D.drawString("color scheme", 26, -1 * (n3 + n4 / 2));
        String string = "";
        if (n7 > -1) {
            graphics2D.drawString(lasStandardTools.LAS_TOOLS[n7][1] + string, 39, -1 * n3);
        }
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n3, 25, n11, 25);
        graphics.drawLine(n3, 100, n11, 100);
        graphics.drawLine(n3, 25, n3, 100 + this.iLogHeight);
        graphics.drawLine(n11, 25, n11, 100 + this.iLogHeight);
    }

    public void drawLithologyTrack(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        boolean bl = false;
        int n11 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n12 = n2 + n3;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        String string = "";
        String string2 = "";
        switch (n) {
            case 29: {
                if (this.stLASFileData != null) {
                    n4 = this.stLASFileData.iRows;
                    d9 = this.stLASFileData.dNull;
                    dArray = this.bSonic ? this.stLASFileData.dTime : this.stLASFileData.depths;
                    iqstratShaleListStruct2 = this.stLASFileData.stList;
                    dArray2 = this.stLASFileData.dRhomaa;
                    d3 = 2.87;
                    d4 = 2.6;
                    dArray3 = this.stLASFileData.dUmaa;
                    d5 = 13.8;
                    d6 = 4.3;
                    dArray4 = this.stLASFileData.dGR;
                    d7 = 150.0;
                    d8 = 0.0;
                }
                string = "Colorlith";
                string2 = "Rhomaa-Umaa";
                break;
            }
            case 30: {
                if (this.stLASFileData != null) {
                    n4 = this.stLASFileData.iRows;
                    d9 = this.stLASFileData.dNull;
                    dArray = this.bSonic ? this.stLASFileData.dTime : this.stLASFileData.depths;
                    iqstratShaleListStruct2 = this.stLASFileData.stList;
                    dArray2 = this.stLASFileData.dRhomaa;
                    d3 = 2.87;
                    d4 = 2.6;
                    dArray3 = this.stLASFileData.dNPHI;
                    d5 = 0.5;
                    d6 = 0.0;
                    dArray4 = this.stLASFileData.dGR;
                    d7 = 150.0;
                    d8 = 0.0;
                }
                string = "Colorlith";
                string2 = "Rhomaa-NPHI";
                break;
            }
            case 31: {
                if (this.stLASFileData != null) {
                    n4 = this.stLASFileData.iRows;
                    d9 = this.stLASFileData.dNull;
                    dArray = this.bSonic ? this.stLASFileData.dTime : this.stLASFileData.depths;
                    iqstratShaleListStruct2 = this.stLASFileData.stList;
                    dArray2 = this.stLASFileData.dRhomaa;
                    d3 = 2.87;
                    d4 = 2.6;
                    dArray3 = this.stLASFileData.dDTmaa;
                    d5 = 65.0;
                    d6 = 35.0;
                    dArray4 = this.stLASFileData.dGR;
                    d7 = 150.0;
                    d8 = 0.0;
                }
                string = "Colorlith";
                string2 = "Rhomaa-DTmaa";
                break;
            }
            case 18: {
                if (this.stLASFileData != null) {
                    n4 = this.stLASFileData.iRows;
                    d9 = this.stLASFileData.dNull;
                    dArray = this.bSonic ? this.stLASFileData.dTime : this.stLASFileData.depths;
                    iqstratShaleListStruct2 = this.stLASFileData.stList;
                    dArray2 = this.stLASFileData.dThU;
                    d3 = Math.log(24.5) / Math.log(10.0);
                    d4 = Math.log(0.57) / Math.log(10.0);
                    dArray3 = this.stLASFileData.dThK;
                    d5 = Math.log(41.14) / Math.log(10.0);
                    d6 = Math.log(1.02) / Math.log(10.0);
                    dArray4 = this.stLASFileData.dGR;
                    d7 = 150.0;
                    d8 = 0.0;
                }
                string = "Colorlith";
                string2 = "Th/U-Th/K";
                break;
            }
            case 19: {
                if (this.stLASFileData != null) {
                    n4 = this.stLASFileData.iRows;
                    d9 = this.stLASFileData.dNull;
                    dArray = this.bSonic ? this.stLASFileData.dTime : this.stLASFileData.depths;
                    dArray2 = this.stLASFileData.dK;
                    d3 = 5.0;
                    d4 = 0.0;
                    dArray3 = this.stLASFileData.dTh;
                    d5 = 20.0;
                    d6 = 0.0;
                    dArray4 = this.stLASFileData.dU;
                    d7 = 30.0;
                    d8 = 0.0;
                }
                string = "Colorlith";
                string2 = "K-Th-U Hall";
            }
        }
        graphics.setColor(new Color(255, 255, 255));
        if (n4 > 0) {
            for (int i = 0; i < n4 - 1; ++i) {
                if (!(dArray2[i] > d9) || !(dArray3[i] > d9)) continue;
                d2 = (double)this.iLogHeight * (dArray[i] - this.depthStart) / (this.depthEnd - this.depthStart);
                n5 = 100 + (int)d2;
                if (this.iDataType == 1) {
                    n5 = this.iHeight - (int)d2;
                }
                d2 = (double)this.iLogHeight * (dArray[i + 1] - this.depthStart) / (this.depthEnd - this.depthStart);
                n6 = 100 + (int)d2;
                if (this.iDataType == 1) {
                    n6 = this.iHeight - (int)d2;
                }
                n7 = Math.abs(n6 - n5);
                d = dArray4[i];
                if (n != 19 && iqstratShaleListStruct2 != null) {
                    for (int j = 0; j < iqstratShaleListStruct2.iCount; ++j) {
                        if (!(dArray[i] >= iqstratShaleListStruct2.stItem[j].depthStart) || !(dArray[i] <= iqstratShaleListStruct2.stItem[j].depthEnd)) continue;
                        d8 = iqstratShaleListStruct2.stItem[j].dGammaMin;
                        d7 = iqstratShaleListStruct2.stItem[j].dGammaMax;
                    }
                }
                if (d < d8) {
                    d = d8;
                }
                if (d > d7) {
                    d = d7;
                }
                n10 = (int)(255.0 * (d - d8) / (d7 - d8));
                switch (n) {
                    case 19: 
                    case 29: 
                    case 30: 
                    case 31: {
                        d = dArray2[i];
                        break;
                    }
                    case 18: {
                        d = Math.log(dArray2[i]) / Math.log(10.0);
                    }
                }
                if (d > d3) {
                    d = d3;
                }
                if (d < d4) {
                    d = d4;
                }
                switch (n) {
                    case 29: 
                    case 30: 
                    case 31: {
                        n8 = (int)(255.0 * (1.0 - (d - d4) / (d3 - d4)));
                        break;
                    }
                    case 18: 
                    case 19: {
                        n8 = (int)(255.0 * ((d - d4) / (d3 - d4)));
                    }
                }
                if (n8 > 255) {
                    n8 = 255;
                }
                if (n8 < 0) {
                    n8 = 0;
                }
                switch (n) {
                    case 19: 
                    case 29: 
                    case 30: 
                    case 31: {
                        d = dArray3[i];
                        break;
                    }
                    case 18: {
                        d = Math.log(dArray3[i]) / Math.log(10.0);
                    }
                }
                if (d > d5) {
                    d = d5;
                }
                if (d < d6) {
                    d = d6;
                }
                switch (n) {
                    case 18: 
                    case 19: 
                    case 29: {
                        n9 = (int)(255.0 * (d - d6) / (d5 - d6));
                        break;
                    }
                    case 30: 
                    case 31: {
                        n9 = (int)(255.0 * (1.0 - (d - d6) / (d5 - d6)));
                    }
                }
                if (n9 > 255) {
                    n9 = 255;
                }
                if (n9 < 0) {
                    n9 = 0;
                }
                switch (n) {
                    case 19: 
                    case 29: 
                    case 30: 
                    case 31: {
                        graphics.setColor(new Color(n8, n9, n10));
                        break;
                    }
                    case 18: {
                        graphics.setColor(new Color(n8, n9, 0));
                    }
                }
                if (n5 <= 100 || n6 <= 100 || n5 >= this.iHeight || n6 >= this.iHeight) continue;
                if (n == 19) {
                    if (dArray2[i] == d9 || dArray3[i] == d9) {
                        graphics.setColor(Color.white);
                    }
                    graphics.fillRect(n2, n5, n3, n7);
                    continue;
                }
                n11 = n3 * n10 / 255;
                n11 = n3 - n11 / 2;
                if (dArray2[i] == d9 || dArray3[i] == d9 || dArray4[i] == d9) {
                    graphics.setColor(Color.white);
                }
                graphics.fillRect(n12 - n11, n5, n11, n7);
            }
        }
        graphics.setColor(Color.black);
        Font font = new Font("Serif", 1, 12);
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString(string, 39, -1 * (n2 + 2 * n3 / 3));
        font = new Font("Serif", 1, 10);
        fontMetrics = graphics.getFontMetrics(font);
        graphics.setFont(font);
        graphics2D.drawString(string2, 31, -1 * (n2 + 5));
        graphics2D.rotate(-1.5707963267948966);
        graphics.drawLine(n2, 25, n12, 25);
        graphics.drawLine(n2, 100, n12, 100);
        graphics.drawLine(n2, 25, n2, 100 + this.iLogHeight);
        graphics.drawLine(n12, 25, n12, 100 + this.iLogHeight);
    }

    public void draw(Graphics graphics, int n, int n2, int n3) {
        int n4 = 0;
        if (n == 0) {
            switch (n) {
                case 0: {
                    n4 = 0;
                }
            }
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawGammaTrack(graphics, n, n2, n3);
        }
        if (n == 11 || n == 2 || n == 12 || n == 3) {
            switch (n) {
                case 2: 
                case 3: 
                case 11: 
                case 12: {
                    n4 = 0;
                }
            }
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            if (n == 11) {
                this.drawImageTrack(graphics, n, 1, n2, n3);
            }
            if (n == 12) {
                this.drawNonLinearImageTrack(graphics, n, 1, n2, n3);
            }
            if (n == 2) {
                this.drawImageTrack(graphics, n, 0, n2, n3);
            }
            if (n == 3) {
                this.drawNonLinearImageTrack(graphics, n, 0, n2, n3);
            }
        }
        if (n == 29 || n == 30 || n == 31 || n == 18 || n == 19) {
            switch (n) {
                case 18: 
                case 19: 
                case 29: 
                case 30: 
                case 31: {
                    n4 = 0;
                }
            }
            graphics.setColor(new Color(iqstratTracksStruct.COLORS[n4][0], iqstratTracksStruct.COLORS[n4][1], iqstratTracksStruct.COLORS[n4][2]));
            graphics.fillRect(n2, 25, n3, 20);
            this.drawLithologyTrack(graphics, n, n2, n3);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.iWidth, this.iHeight);
    }
}

