/*
 * Decompiled with CFR 0.152.
 */
package lith.math;

import lith.math.lithMath;
import math.mathLAS;

public class lithMathRules {
    public static final double PHI_N4 = -0.04;
    public static final double PHI_N2 = -0.02;
    public static final double PHI_0 = 0.0;
    public static final double PHI_2 = 0.02;
    public static final double PHI_4 = 0.04;
    public static final double PHI_5 = 0.05;
    public static final double PHI_6 = 0.06;
    public static final double PHI_7 = 0.07;
    public static final double PHI_8 = 0.08;
    public static final double PHI_9 = 0.09;
    public static final double PHI_10 = 0.1;
    public static final double PHI_11 = 0.11;
    public static final double PHI_15 = 0.15;
    public static final double PHI_20 = 0.2;
    public static final double PHI_25 = 0.25;
    public static final double PHI_30 = 0.3;
    public static final double PHI_35 = 0.35;
    public static final double PHI_45 = 0.45;
    public static final double RHO_COAL = 1.8;
    public static final double RHO_SALT = 2.03;
    public static final double RHO_GYPSUM = 2.34;
    public static final double RHO_CLAY = 2.4;
    public static final double RHO_DOLOMITE = 2.84;
    public static final double RHO_ANHYDRITE = 2.9;
    public static final double RHO_IGNEOUS = 2.91;
    public static final double PE_ANHYDRITE = 4.5;
    public static final double PE_IRONSTONE = 9.0;
    public static final double PE_IGNEOUS = 6.0;

    public static int getLithology(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        int n2 = 0;
        if (d5 > d9) {
            n2 = lithMathRules.getLithology(n, d, d2, d3, d4, d5, d6, d7, d9);
        } else if (d8 > d9) {
            n2 = lithMathRules.getLithology(n, d, d2, d3, d4, d6, d8, d9);
        }
        return n2;
    }

    public static int getLithology(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        int n2 = 0;
        double d9 = 0.0;
        double d10 = 0.0;
        d9 = mathLAS.computePHI(d6, 0, 1, 0);
        d10 = d5 - d9;
        if (d4 >= d3) {
            n2 = 12;
            if (d10 <= 0.02 && Math.abs(d5) < 0.02) {
                n2 = 60;
            }
        } else if (d4 >= d2 && d4 < d3) {
            n2 = 12;
            if (d10 >= -0.04 && d10 <= 0.04 && Math.abs(d5) >= 0.1 && Math.abs(d5) <= 0.3) {
                n2 = 15;
            }
            if (d10 < 0.0 && Math.abs(d5) < 0.02) {
                n2 = 18;
            }
        } else if (d10 < -0.04) {
            n2 = 7;
            if (d4 >= d && d4 < d2) {
                n2 = 15;
            }
            if (d6 <= 2.03 && Math.abs(d5) <= 0.05) {
                n2 = 34;
            }
            if (d6 < 1.8 && d5 > 0.35) {
                n2 = 44;
            }
        } else if (d10 >= -0.04 && d10 <= 0.04) {
            n2 = 19;
            if (d4 >= d && d4 < d2) {
                n2 = 21;
            }
        } else if (d10 > 0.04) {
            n2 = 22;
            if (d4 >= d && d4 < d2) {
                n2 = 21;
            }
            if (d6 <= lithMath._MINERAL[4][0]) {
                n2 = 31;
            }
            if (d6 > 2.4 && d5 > 0.45) {
                n2 = 90;
            }
            if (d6 > 2.84) {
                n2 = 22;
                if (d4 >= d && d4 < d2) {
                    n2 = 21;
                }
            }
            if ((d6 > 2.9 || d7 > 4.5) && Math.abs(d5) <= 0.05) {
                n2 = 32;
            }
            if ((d6 > 2.9 || d7 > 9.0) && d5 > 0.15) {
                n2 = 55;
            }
            if ((d6 > 2.91 || d7 > 6.0) && d5 > 0.1) {
                n2 = 58;
            }
        }
        return n2;
    }

    public static int getLithology(int n, double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        int n2 = 0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        d8 = mathLAS.computePHI(d5, 0, 1, 0);
        d9 = mathLAS.computePHI(d6, 1, 1, 0);
        d10 = Math.sqrt(d9 * d9 + d8 * d8);
        if (d4 >= d3) {
            n2 = 12;
            if (Math.abs(d10) < 0.02) {
                n2 = 60;
            }
        } else if (d4 >= d2 && d4 < d3) {
            n2 = 12;
            if (Math.abs(d10) < 0.02) {
                n2 = 18;
            }
        } else if (d4 >= d && d4 < d2) {
            n2 = 21;
            if (d6 >= 51.3 && d6 <= 55.6) {
                n2 = 15;
            }
            if (d6 >= 38.5 && d6 <= 47.6) {
                n2 = 21;
            }
        } else {
            n2 = 19;
            if (d6 >= 51.3 && d6 <= 55.6) {
                n2 = 7;
            }
            if (d6 >= 43.5 && d6 <= 47.6) {
                n2 = 19;
            }
            if (d6 >= 38.5 && d6 < 43.5) {
                n2 = 22;
            }
            if (d5 > 2.9 && d6 >= 49.5 && d6 <= 50.5 && Math.abs(d10) <= 0.05) {
                n2 = 32;
            }
            if (d5 <= lithMath._MINERAL[4][0] && d6 >= 51.5 && d6 <= 52.5 && Math.abs(d10) > 0.3) {
                n2 = 31;
            }
            if (d5 <= 2.03 && d6 >= 66.5 && d6 <= 67.5 && Math.abs(d10) <= 0.05) {
                n2 = 34;
            }
            if (d5 < 1.8 && d6 >= 90.0 && d6 <= 180.0 && d10 > 0.35) {
                n2 = 44;
            }
            if (d5 > 2.91 && d6 >= 39.5 && d6 <= 49.5 && d10 > 0.05) {
                n2 = 58;
            }
        }
        return n2;
    }
}

