/*
 * Decompiled with CFR 0.152.
 */
package lith.lithology;

import iqstrat.iqstratHeadersStruct;
import iqstrat.iqstratShaleListStruct;
import iqstrat.iqstratTracksStruct;
import las.lasFileDataStruct;
import lith.lithology.lithologyListStruct;
import lith.lithology.lithologyStruct;
import lith.lithology.lithologySymbolsListStruct;
import lith.math.lithMath;
import lith.math.lithMathRules;
import rock.rockFileDataStruct;
import rock.rockFileDataUtility;

public class lithologyUtility {
    public static lithologyListStruct buildNew(int n, double d, double d2) {
        lithologyListStruct lithologyListStruct2 = null;
        int n2 = 0;
        int n3 = 0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        boolean bl = false;
        n3 = 1 + (int)(iqstratTracksStruct._SCALE_FACTOR[n] * Math.abs(d2 - d));
        d5 = iqstratTracksStruct._SCALE[n];
        lithologyListStruct2 = new lithologyListStruct();
        lithologyListStruct2.iCount = n3;
        lithologyListStruct2.iUnit = n;
        lithologyListStruct2.depthStart = d;
        lithologyListStruct2.depthEnd = d2;
        lithologyListStruct2.stItem = new lithologyStruct[n3];
        for (int i = 0; i < n3; ++i) {
            if (n2 >= n3) continue;
            d3 = d + (double)i * d5;
            d4 = d + (double)(i + 1) * d5;
            lithologyListStruct2.stItem[n2] = new lithologyStruct();
            lithologyListStruct2.stItem[n2].depthStart = lithologyUtility.getDepth(n, d3);
            lithologyListStruct2.stItem[n2].depthEnd = lithologyUtility.getDepth(n, d4);
            lithologyListStruct2.stItem[n2].iLithology = new int[10];
            for (int j = 0; j < 10; ++j) {
                lithologyListStruct2.stItem[n2].iLithology[j] = 0;
            }
            lithologyListStruct2.stItem[n2].sAbbreviation = new String("");
            lithologyListStruct2.stItem[n2].iStreaks = 0;
            ++n2;
        }
        lithologyListStruct2.iCount = n2;
        return lithologyListStruct2;
    }

    public static lithologyListStruct computeDepthRange(lithologyListStruct lithologyListStruct2) {
        double d = 0.0;
        double d2 = 0.0;
        if (lithologyListStruct2 != null) {
            for (int i = 0; i < lithologyListStruct2.iCount; ++i) {
                d = lithologyListStruct2.stItem[i].depthStart;
                d2 = lithologyListStruct2.stItem[i].depthEnd;
                if (i == 0) {
                    lithologyListStruct2.depthStart = d;
                    lithologyListStruct2.depthEnd = d2;
                }
                if (lithologyListStruct2.depthStart > d) {
                    lithologyListStruct2.depthStart = d;
                }
                if (!(lithologyListStruct2.depthEnd < d2)) continue;
                lithologyListStruct2.depthEnd = d2;
            }
        }
        return lithologyListStruct2;
    }

    public static int getUnit(double d) {
        int n = 1;
        if (d <= 0.5) {
            n = 0;
        }
        if (d <= 0.16667) {
            n = 8;
        }
        if (d <= 0.08333) {
            n = 7;
        }
        if (d <= 0.04167) {
            n = 6;
        }
        if (d <= 0.25) {
            n = 9;
        }
        if (d <= 0.1) {
            n = 10;
        }
        return n;
    }

    public static int getUnit(int n, double d) {
        int n2;
        int n3 = n2 = (int)d;
        double d2 = 0.0;
        double d3 = Math.abs(d - (double)n2);
        if (d3 == 0.0) {
            d3 = 0.5;
        }
        if (d3 <= 0.5) {
            n = 0;
        }
        if (d3 <= 0.16667) {
            n = 8;
        }
        if (d3 <= 0.1) {
            n = 10;
        }
        return n;
    }

    public static double getDepth(int n, double d) {
        int n2;
        int n3 = n2 = (int)d;
        double d2 = 0.0;
        double d3 = Math.abs(d - (double)n2);
        int n4 = 1;
        if (d < 0.0) {
            n3 = (int)Math.abs(d);
            if (n3 == 0) {
                n3 = 1;
            }
            n4 = n2 / n3;
        }
        switch (n) {
            case 6: {
                if (d3 <= 0.020835) {
                    d2 = 0.0;
                }
                if (d3 > 0.020835 && d3 <= 0.0625) {
                    d2 = 0.04167;
                }
                if (d3 > 0.0625 && d3 <= 0.104165) {
                    d2 = 0.08333;
                }
                if (d3 > 0.104165 && d3 <= 0.145835) {
                    d2 = 0.125;
                }
                if (d3 > 0.145835 && d3 <= 0.1875) {
                    d2 = 0.16667;
                }
                if (d3 > 0.1875 && d3 <= 0.229165) {
                    d2 = 0.20833;
                }
                if (d3 > 0.229165 && d3 <= 0.270835) {
                    d2 = 0.25;
                }
                if (d3 > 0.270835 && d3 <= 0.3125) {
                    d2 = 0.29167;
                }
                if (d3 > 0.3125 && d3 <= 0.354165) {
                    d2 = 0.33333;
                }
                if (d3 > 0.354165 && d3 <= 0.395835) {
                    d2 = 0.375;
                }
                if (d3 > 0.395835 && d3 <= 0.4375) {
                    d2 = 0.41667;
                }
                if (d3 > 0.4375 && d3 <= 0.479165) {
                    d2 = 0.45833;
                }
                if (d3 > 0.479165 && d3 <= 0.520835) {
                    d2 = 0.5;
                }
                if (d3 > 0.520835 && d3 <= 0.5625) {
                    d2 = 0.54167;
                }
                if (d3 > 0.5625 && d3 <= 0.604165) {
                    d2 = 0.58333;
                }
                if (d3 > 0.604165 && d3 <= 0.645835) {
                    d2 = 0.625;
                }
                if (d3 > 0.645835 && d3 <= 0.6875) {
                    d2 = 0.66667;
                }
                if (d3 > 0.6875 && d3 <= 0.729165) {
                    d2 = 0.70833;
                }
                if (d3 > 0.729165 && d3 <= 0.790835) {
                    d2 = 0.75;
                }
                if (d3 > 0.790835 && d3 <= 0.8125) {
                    d2 = 0.79167;
                }
                if (d3 > 0.8125 && d3 <= 0.854165) {
                    d2 = 0.83333;
                }
                if (d3 > 0.854165 && d3 <= 0.915835) {
                    d2 = 0.875;
                }
                if (d3 > 0.915835 && d3 <= 0.9375) {
                    d2 = 0.91667;
                }
                if (d3 > 0.9375 && d3 <= 0.979165) {
                    d2 = 0.95833;
                }
                if (!(d3 > 0.979165)) break;
                d2 = 1.0;
                break;
            }
            case 7: {
                if (d3 <= 0.04167) {
                    d2 = 0.0;
                }
                if (d3 > 0.04167 && d3 <= 0.125) {
                    d2 = 0.08333;
                }
                if (d3 > 0.125 && d3 <= 0.20833) {
                    d2 = 0.16667;
                }
                if (d3 > 0.20833 && d3 <= 0.29167) {
                    d2 = 0.25;
                }
                if (d3 > 0.29167 && d3 <= 0.375) {
                    d2 = 0.33333;
                }
                if (d3 > 0.375 && d3 <= 0.45833) {
                    d2 = 0.41667;
                }
                if (d3 > 0.45833 && d3 <= 0.54167) {
                    d2 = 0.5;
                }
                if (d3 > 0.54167 && d3 <= 0.625) {
                    d2 = 0.58333;
                }
                if (d3 > 0.625 && d3 <= 0.70833) {
                    d2 = 0.66667;
                }
                if (d3 > 0.70833 && d3 <= 0.79167) {
                    d2 = 0.75;
                }
                if (d3 > 0.79167 && d3 <= 0.875) {
                    d2 = 0.83333;
                }
                if (d3 > 0.875 && d3 <= 0.95833) {
                    d2 = 0.91667;
                }
                if (!(d3 > 0.95833)) break;
                d2 = 1.0;
                break;
            }
            case 8: {
                if (d3 <= 0.08333) {
                    d2 = 0.0;
                }
                if (d3 > 0.08333 && d3 <= 0.25) {
                    d2 = 0.16667;
                }
                if (d3 > 0.25 && d3 <= 0.41667) {
                    d2 = 0.33333;
                }
                if (d3 > 0.41667 && d3 <= 0.58333) {
                    d2 = 0.5;
                }
                if (d3 > 0.58333 && d3 <= 0.75) {
                    d2 = 0.66667;
                }
                if (d3 > 0.75 && d3 <= 0.91667) {
                    d2 = 0.83333;
                }
                if (!(d3 > 0.91667)) break;
                d2 = 1.0;
                break;
            }
            case 10: {
                if (d3 <= 0.05) {
                    d2 = 0.0;
                }
                if (d3 > 0.05 && d3 <= 0.105) {
                    d2 = 0.1;
                }
                if (d3 > 0.105 && d3 <= 0.205) {
                    d2 = 0.2;
                }
                if (d3 > 0.205 && d3 <= 0.305) {
                    d2 = 0.3;
                }
                if (d3 > 0.305 && d3 <= 0.405) {
                    d2 = 0.4;
                }
                if (d3 > 0.405 && d3 <= 0.505) {
                    d2 = 0.5;
                }
                if (d3 > 0.505 && d3 <= 0.605) {
                    d2 = 0.6;
                }
                if (d3 > 0.605 && d3 <= 0.705) {
                    d2 = 0.7;
                }
                if (d3 > 0.705 && d3 <= 0.805) {
                    d2 = 0.8;
                }
                if (d3 > 0.805 && d3 <= 0.905) {
                    d2 = 0.9;
                }
                if (!(d3 > 0.905)) break;
                d2 = 1.0;
                break;
            }
            case 9: {
                if (d3 <= 0.125) {
                    d2 = 0.0;
                }
                if (d3 > 0.125 && d3 <= 0.375) {
                    d2 = 0.25;
                }
                if (d3 > 0.375 && d3 <= 0.625) {
                    d2 = 0.5;
                }
                if (d3 > 0.625 && d3 <= 0.875) {
                    d2 = 0.75;
                }
                if (!(d3 > 0.75)) break;
                d2 = 1.0;
                break;
            }
            case 0: {
                if (d3 <= 0.25) {
                    d2 = 0.0;
                }
                if (d3 > 0.25 && d3 <= 0.75) {
                    d2 = 0.5;
                }
                if (!(d3 > 0.75)) break;
                d2 = 1.0;
                break;
            }
            case 1: {
                if (d3 <= 0.5) {
                    d2 = 0.0;
                }
                if (!(d3 > 0.5)) break;
                d2 = 1.0;
            }
        }
        d = (double)n4 * ((double)n3 + d2);
        return d;
    }

    public static lithologyListStruct fillEmptySpaces(lithologyListStruct lithologyListStruct2) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (lithologyListStruct2 != null) {
            for (n = 0; n < lithologyListStruct2.iCount - 2; ++n) {
                bl = false;
                for (n2 = 0; n2 < 10; ++n2) {
                    if (lithologyListStruct2.stItem[n].iLithology[n2] == 0) continue;
                    bl = true;
                }
                bl2 = false;
                bl3 = false;
                if (!bl) continue;
                for (n2 = 0; n2 < 10; ++n2) {
                    if (lithologyListStruct2.stItem[n + 1].iLithology[n2] == 0) continue;
                    bl2 = true;
                }
                for (n2 = 0; n2 < 10; ++n2) {
                    if (lithologyListStruct2.stItem[n + 2].iLithology[n2] == 0) continue;
                    bl3 = true;
                }
                if (bl2 || !bl3) continue;
                for (n2 = 0; n2 < 10; ++n2) {
                    lithologyListStruct2.stItem[n + 1].iLithology[n2] = lithologyListStruct2.stItem[n].iLithology[n2];
                }
                lithologyListStruct2.stItem[n + 1].sAbbreviation = new String(lithologyListStruct2.stItem[n].sAbbreviation);
                lithologyListStruct2.stItem[n + 1].iStreaks = lithologyListStruct2.stItem[n].iStreaks;
            }
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct addHeaderData(iqstratHeadersStruct iqstratHeadersStruct2, lithologyListStruct lithologyListStruct2) {
        if (iqstratHeadersStruct2 != null && lithologyListStruct2 != null) {
            lithologyListStruct2.sKID = new String(iqstratHeadersStruct2.sKID);
            lithologyListStruct2.sKEY = new String(iqstratHeadersStruct2.sKEY);
            lithologyListStruct2.iType = iqstratHeadersStruct2.iType;
            lithologyListStruct2.sAPI = new String(iqstratHeadersStruct2.sAPI);
            lithologyListStruct2.sName = new String(iqstratHeadersStruct2.sName);
            lithologyListStruct2.status = new String(iqstratHeadersStruct2.status);
            lithologyListStruct2.dLatitude = iqstratHeadersStruct2.dLatitude;
            lithologyListStruct2.dLongitude = iqstratHeadersStruct2.dLongitude;
            lithologyListStruct2.depth = iqstratHeadersStruct2.depth;
            lithologyListStruct2.dGL = iqstratHeadersStruct2.dGL;
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct addRecord(lithologyStruct lithologyStruct2, lithologyListStruct lithologyListStruct2) {
        double d = lithologyStruct2.depthStart;
        double d2 = lithologyStruct2.depthEnd;
        if (lithologyStruct2 != null && lithologyListStruct2 != null) {
            for (int i = 0; i < lithologyListStruct2.iCount; ++i) {
                if (d >= lithologyListStruct2.stItem[i].depthStart && d < lithologyListStruct2.stItem[i].depthEnd) {
                    lithologyStruct2.depthStart = lithologyListStruct2.stItem[i].depthStart;
                    lithologyStruct2.depthEnd = lithologyListStruct2.stItem[i].depthEnd;
                    lithologyListStruct2.stItem[i] = lithologyUtility.copy(lithologyStruct2);
                    continue;
                }
                if (d2 > lithologyListStruct2.stItem[i].depthStart && d2 <= lithologyListStruct2.stItem[i].depthEnd) {
                    lithologyStruct2.depthStart = lithologyListStruct2.stItem[i].depthStart;
                    lithologyStruct2.depthEnd = lithologyListStruct2.stItem[i].depthEnd;
                    lithologyListStruct2.stItem[i] = lithologyUtility.copy(lithologyStruct2);
                    continue;
                }
                if (!(lithologyListStruct2.stItem[i].depthStart >= d) || !(lithologyListStruct2.stItem[i].depthEnd <= d2)) continue;
                lithologyStruct2.depthStart = lithologyListStruct2.stItem[i].depthStart;
                lithologyStruct2.depthEnd = lithologyListStruct2.stItem[i].depthEnd;
                lithologyListStruct2.stItem[i] = lithologyUtility.copy(lithologyStruct2);
            }
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct add(lithologyStruct lithologyStruct2, lithologyListStruct lithologyListStruct2) {
        int n = 0;
        int n2 = 0;
        lithologyListStruct lithologyListStruct3 = new lithologyListStruct();
        String string = "YES";
        String string2 = "";
        String string3 = "";
        lithologyListStruct3.stItem = new lithologyStruct[1];
        if (lithologyListStruct2 != null) {
            string = new String(lithologyListStruct2.sKGS);
            string2 = new String(lithologyListStruct2.source);
            string3 = new String(lithologyListStruct2.sCreated);
            lithologyListStruct3.depthStart = lithologyListStruct2.depthStart;
            lithologyListStruct3.depthEnd = lithologyListStruct2.depthEnd;
            lithologyListStruct3.iUnit = lithologyListStruct2.iUnit;
            if (lithologyListStruct2.iCount > 0) {
                lithologyListStruct3.stItem = new lithologyStruct[lithologyListStruct2.iCount + 1];
            }
            for (n = 0; n < lithologyListStruct2.iCount; ++n) {
                lithologyListStruct3.stItem[n2] = new lithologyStruct();
                lithologyListStruct3.stItem[n2] = lithologyUtility.copy(lithologyListStruct2.stItem[n]);
                ++n2;
            }
            lithologyListStruct2.delete();
            lithologyListStruct2 = null;
        }
        if (lithologyStruct2 != null) {
            lithologyListStruct3.stItem[n2] = new lithologyStruct();
            lithologyListStruct3.stItem[n2] = lithologyUtility.copy(lithologyStruct2);
            ++n2;
        }
        lithologyListStruct2 = new lithologyListStruct();
        lithologyListStruct2.iCount = n2;
        lithologyListStruct2.stItem = new lithologyStruct[lithologyListStruct2.iCount];
        lithologyListStruct2.depthStart = lithologyListStruct3.depthStart;
        lithologyListStruct2.depthEnd = lithologyListStruct3.depthEnd;
        lithologyListStruct2.iUnit = lithologyListStruct3.iUnit;
        lithologyListStruct2.sKGS = new String(string);
        lithologyListStruct2.source = new String(string2);
        lithologyListStruct2.sCreated = new String(string3);
        for (n = 0; n < lithologyListStruct2.iCount; ++n) {
            lithologyListStruct2.stItem[n] = new lithologyStruct();
            lithologyListStruct2.stItem[n] = lithologyUtility.copy(lithologyListStruct3.stItem[n]);
        }
        lithologyListStruct3.delete();
        lithologyListStruct3 = null;
        return lithologyListStruct2;
    }

    public static lithologyListStruct modify(lithologyStruct lithologyStruct2, lithologyListStruct lithologyListStruct2) {
        int n = 0;
        int n2 = 0;
        lithologyListStruct lithologyListStruct3 = new lithologyListStruct();
        String string = "YES";
        String string2 = "";
        String string3 = "";
        lithologyListStruct3.stItem = new lithologyStruct[1];
        if (lithologyListStruct2 != null) {
            string = new String(lithologyListStruct2.sKGS);
            string2 = new String(lithologyListStruct2.source);
            string3 = new String(lithologyListStruct2.sCreated);
            lithologyListStruct3.depthStart = lithologyListStruct2.depthStart;
            lithologyListStruct3.depthEnd = lithologyListStruct2.depthEnd;
            lithologyListStruct3.iUnit = lithologyListStruct2.iUnit;
            if (lithologyListStruct2.iCount > 0) {
                lithologyListStruct3.stItem = new lithologyStruct[lithologyListStruct2.iCount];
            }
            for (n = 0; n < lithologyListStruct2.iCount; ++n) {
                if (lithologyListStruct2.stItem[n].sKEY.equals(lithologyStruct2.sKEY)) {
                    lithologyListStruct3.stItem[n2] = new lithologyStruct();
                    lithologyListStruct3.stItem[n2] = lithologyUtility.copy(lithologyStruct2);
                    ++n2;
                    continue;
                }
                lithologyListStruct3.stItem[n2] = new lithologyStruct();
                lithologyListStruct3.stItem[n2] = lithologyUtility.copy(lithologyListStruct2.stItem[n]);
                ++n2;
            }
            lithologyListStruct2.delete();
            lithologyListStruct2 = null;
            lithologyListStruct2 = new lithologyListStruct();
            lithologyListStruct2.iCount = n2;
            lithologyListStruct2.stItem = new lithologyStruct[lithologyListStruct2.iCount];
            lithologyListStruct2.depthStart = lithologyListStruct3.depthStart;
            lithologyListStruct2.depthEnd = lithologyListStruct3.depthEnd;
            lithologyListStruct2.iUnit = lithologyListStruct3.iUnit;
            lithologyListStruct2.sKGS = new String(string);
            lithologyListStruct2.source = new String(string2);
            lithologyListStruct2.sCreated = new String(string3);
            for (n = 0; n < lithologyListStruct2.iCount; ++n) {
                lithologyListStruct2.stItem[n] = new lithologyStruct();
                lithologyListStruct2.stItem[n] = lithologyUtility.copy(lithologyListStruct3.stItem[n]);
            }
            lithologyListStruct3.delete();
            lithologyListStruct3 = null;
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct remove(String string, lithologyListStruct lithologyListStruct2) {
        int n = 0;
        int n2 = 0;
        lithologyListStruct lithologyListStruct3 = null;
        String string2 = "YES";
        String string3 = "";
        String string4 = "";
        if (lithologyListStruct2 != null) {
            string2 = new String(lithologyListStruct2.sKGS);
            string3 = new String(lithologyListStruct2.source);
            string4 = new String(lithologyListStruct2.sCreated);
            if (lithologyListStruct2.iCount < 2) {
                lithologyListStruct2.iCount = 0;
                lithologyListStruct2.delete();
                lithologyListStruct2 = null;
            } else {
                lithologyListStruct3 = new lithologyListStruct();
                lithologyListStruct3.stItem = new lithologyStruct[lithologyListStruct2.iCount - 1];
                lithologyListStruct3.depthStart = lithologyListStruct2.depthStart;
                lithologyListStruct3.depthEnd = lithologyListStruct2.depthEnd;
                lithologyListStruct3.iUnit = lithologyListStruct2.iUnit;
                for (n = 0; n < lithologyListStruct2.iCount; ++n) {
                    if (lithologyListStruct2.stItem[n] == null || lithologyListStruct2.stItem[n].sKEY.equals(string)) continue;
                    lithologyListStruct3.stItem[n2] = new lithologyStruct();
                    lithologyListStruct3.stItem[n2] = lithologyUtility.copy(lithologyListStruct2.stItem[n]);
                    ++n2;
                }
                lithologyListStruct2.delete();
                lithologyListStruct2 = null;
                lithologyListStruct2 = new lithologyListStruct();
                lithologyListStruct2.iCount = n2;
                lithologyListStruct2.stItem = new lithologyStruct[lithologyListStruct2.iCount];
                lithologyListStruct2.depthStart = lithologyListStruct3.depthStart;
                lithologyListStruct2.depthEnd = lithologyListStruct3.depthEnd;
                lithologyListStruct2.iUnit = lithologyListStruct3.iUnit;
                lithologyListStruct2.sKGS = new String(string2);
                lithologyListStruct2.source = new String(string3);
                lithologyListStruct2.sCreated = new String(string4);
                for (n = 0; n < lithologyListStruct2.iCount; ++n) {
                    lithologyListStruct2.stItem[n] = new lithologyStruct();
                    lithologyListStruct2.stItem[n] = lithologyUtility.copy(lithologyListStruct3.stItem[n]);
                }
                if (lithologyListStruct3 != null) {
                    lithologyListStruct3.delete();
                }
                lithologyListStruct3 = null;
            }
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct copyList(lithologyListStruct lithologyListStruct2) {
        lithologyListStruct lithologyListStruct3 = null;
        if (lithologyListStruct2 != null) {
            lithologyListStruct3 = new lithologyListStruct();
            lithologyListStruct3.depthStart = lithologyListStruct2.depthStart;
            lithologyListStruct3.depthEnd = lithologyListStruct2.depthEnd;
            lithologyListStruct3.iUnit = lithologyListStruct2.iUnit;
            lithologyListStruct3.sKGS = new String(lithologyListStruct2.sKGS);
            lithologyListStruct3.source = new String(lithologyListStruct2.source);
            lithologyListStruct3.sCreated = new String(lithologyListStruct2.sCreated);
            lithologyListStruct3.iCount = lithologyListStruct2.iCount;
            lithologyListStruct3.stItem = new lithologyStruct[lithologyListStruct2.iCount];
            for (int i = 0; i < lithologyListStruct2.iCount; ++i) {
                lithologyListStruct3.stItem[i] = lithologyUtility.copy(lithologyListStruct2.stItem[i]);
            }
        }
        return lithologyListStruct3;
    }

    public static lithologyStruct copy(lithologyStruct lithologyStruct2) {
        lithologyStruct lithologyStruct3 = new lithologyStruct();
        lithologyStruct3.sKEY = new String(lithologyStruct2.sKEY);
        lithologyStruct3.depthStart = lithologyStruct2.depthStart;
        lithologyStruct3.depthEnd = lithologyStruct2.depthEnd;
        lithologyStruct3.dRhomaa = lithologyStruct2.dRhomaa;
        lithologyStruct3.dUmaa = lithologyStruct2.dUmaa;
        lithologyStruct3.dGR = lithologyStruct2.dGR;
        for (int i = 0; i < 10; ++i) {
            lithologyStruct3.iLithology[i] = lithologyStruct2.iLithology[i];
        }
        lithologyStruct3.sAbbreviation = new String(lithologyStruct2.sAbbreviation);
        lithologyStruct3.iStreaks = lithologyStruct2.iStreaks;
        return lithologyStruct3;
    }

    public static lithologyListStruct computeLithology(lasFileDataStruct lasFileDataStruct2, rockFileDataStruct rockFileDataStruct2, lithologySymbolsListStruct lithologySymbolsListStruct2, lithologyListStruct lithologyListStruct2) {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -999.95;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = null;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        if (lasFileDataStruct2 != null) {
            n = lasFileDataStruct2.iRows;
            d = lasFileDataStruct2.depthStart;
            d2 = lasFileDataStruct2.depthEnd;
            d3 = lasFileDataStruct2.depthStep;
            d4 = lasFileDataStruct2.dNull;
            if (lasFileDataStruct2.iPE == -1) {
                n2 = 1;
            }
            dArray = lasFileDataStruct2.depths;
            dArray2 = lasFileDataStruct2.dGR;
            dArray4 = lasFileDataStruct2.dNPHI;
            dArray3 = lasFileDataStruct2.dRHOB;
            dArray5 = lasFileDataStruct2.dPE;
            dArray6 = lasFileDataStruct2.dTh;
            dArray8 = lasFileDataStruct2.dU;
            dArray7 = lasFileDataStruct2.dK;
            dArray9 = lasFileDataStruct2.dDT;
            iqstratShaleListStruct2 = lasFileDataStruct2.stList;
        }
        if (rockFileDataStruct2 != null) {
            n = rockFileDataStruct2.iRows;
            d = rockFileDataStruct2.depthStart;
            d2 = rockFileDataStruct2.depthEnd;
            d3 = rockFileDataStruct2.depthStep;
            d4 = rockFileDataStruct2.dNull;
            n2 = 1;
            dArray = rockFileDataStruct2.depths;
            dArray2 = rockFileDataStruct2.dGRL;
            dArray4 = rockFileDataStruct2.dPHI;
            dArray3 = rockFileDataUtility.computeBulkDensity(rockFileDataStruct2);
            dArray6 = rockFileDataStruct2.dTh;
            dArray8 = rockFileDataStruct2.dU;
            dArray7 = rockFileDataStruct2.dK;
            dArray5 = new double[n];
            dArray9 = new double[n];
            for (int i = 0; i < n - 1; ++i) {
                dArray5[i] = d4;
                dArray9[i] = d4;
            }
        }
        lithologyListStruct2 = lithologyUtility.computeLithology(n2, d, d2, d3, d4, n, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, iqstratShaleListStruct2, lithologySymbolsListStruct2, lithologyListStruct2);
        return lithologyListStruct2;
    }

    public static lithologyListStruct computeLithology(lasFileDataStruct lasFileDataStruct2, lithologySymbolsListStruct lithologySymbolsListStruct2, lithologyListStruct lithologyListStruct2) {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -999.95;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = null;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        if (lasFileDataStruct2 != null) {
            n = lasFileDataStruct2.iRows;
            d = lasFileDataStruct2.depthStart;
            d2 = lasFileDataStruct2.depthEnd;
            d3 = lasFileDataStruct2.depthStep;
            d4 = lasFileDataStruct2.dNull;
            if (lasFileDataStruct2.iPE == -1) {
                n2 = 1;
            }
            dArray = lasFileDataStruct2.depths;
            dArray2 = lasFileDataStruct2.dGR;
            dArray4 = lasFileDataStruct2.dNPHI;
            dArray3 = lasFileDataStruct2.dRHOB;
            dArray5 = lasFileDataStruct2.dPE;
            dArray6 = lasFileDataStruct2.dTh;
            dArray8 = lasFileDataStruct2.dU;
            dArray7 = lasFileDataStruct2.dK;
            dArray9 = lasFileDataStruct2.dDT;
            iqstratShaleListStruct2 = lasFileDataStruct2.stList;
            lithologyListStruct2 = lithologyUtility.computeLithology(n2, d, d2, d3, d4, n, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, iqstratShaleListStruct2, lithologySymbolsListStruct2, lithologyListStruct2);
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct computeLithology(int n, lasFileDataStruct lasFileDataStruct2, lithologySymbolsListStruct lithologySymbolsListStruct2, lithologyListStruct lithologyListStruct2) {
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -999.95;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = null;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        if (lasFileDataStruct2 != null) {
            n2 = lasFileDataStruct2.iRows;
            d = lasFileDataStruct2.depthStart;
            d2 = lasFileDataStruct2.depthEnd;
            d3 = lasFileDataStruct2.depthStep;
            d4 = lasFileDataStruct2.dNull;
            if (n == 0 && lasFileDataStruct2.iPE == -1) {
                n = 1;
            }
            dArray = lasFileDataStruct2.depths;
            dArray2 = lasFileDataStruct2.dGR;
            dArray4 = lasFileDataStruct2.dNPHI;
            dArray3 = lasFileDataStruct2.dRHOB;
            dArray5 = lasFileDataStruct2.dPE;
            dArray6 = lasFileDataStruct2.dTh;
            dArray8 = lasFileDataStruct2.dU;
            dArray7 = lasFileDataStruct2.dK;
            dArray9 = lasFileDataStruct2.dDT;
            iqstratShaleListStruct2 = lasFileDataStruct2.stList;
            lithologyListStruct2 = lithologyUtility.computeLithology(n, d, d2, d3, d4, n2, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, iqstratShaleListStruct2, lithologySymbolsListStruct2, lithologyListStruct2);
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct computeLithology(rockFileDataStruct rockFileDataStruct2, lithologySymbolsListStruct lithologySymbolsListStruct2, lithologyListStruct lithologyListStruct2) {
        int n = 0;
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = -999.95;
        double[] dArray = null;
        double[] dArray2 = null;
        double[] dArray3 = null;
        double[] dArray4 = null;
        double[] dArray5 = null;
        double[] dArray6 = null;
        double[] dArray7 = null;
        double[] dArray8 = null;
        double[] dArray9 = null;
        iqstratShaleListStruct iqstratShaleListStruct2 = null;
        if (rockFileDataStruct2 != null) {
            n = rockFileDataStruct2.iRows;
            d = rockFileDataStruct2.depthStart;
            d2 = rockFileDataStruct2.depthEnd;
            d3 = rockFileDataStruct2.depthStep;
            d4 = rockFileDataStruct2.dNull;
            n2 = 1;
            dArray = rockFileDataStruct2.depths;
            dArray2 = rockFileDataStruct2.dGRL;
            dArray4 = rockFileDataStruct2.dPHI;
            dArray3 = rockFileDataUtility.computeBulkDensity(rockFileDataStruct2);
            dArray6 = rockFileDataStruct2.dTh;
            dArray8 = rockFileDataStruct2.dU;
            dArray7 = rockFileDataStruct2.dK;
            dArray5 = new double[n];
            dArray9 = new double[n];
            for (int i = 0; i < n - 1; ++i) {
                dArray5[i] = d4;
                dArray9[i] = d4;
            }
            lithologyListStruct2 = lithologyUtility.computeLithology(n2, d, d2, d3, d4, n, dArray, dArray2, dArray3, dArray4, dArray5, dArray6, dArray7, dArray8, dArray9, iqstratShaleListStruct2, lithologySymbolsListStruct2, lithologyListStruct2);
        }
        return lithologyListStruct2;
    }

    public static lithologyListStruct computeLithology(int n, double d, double d2, double d3, double d4, int n2, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, double[] dArray5, double[] dArray6, double[] dArray7, double[] dArray8, double[] dArray9, iqstratShaleListStruct iqstratShaleListStruct2, lithologySymbolsListStruct lithologySymbolsListStruct2, lithologyListStruct lithologyListStruct2) {
        int n3 = 0;
        double d5 = 0.0;
        double d6 = 0.0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 60.0;
        double d10 = 70.0;
        double d11 = 100.0;
        int n7 = 0;
        int n8 = 0;
        boolean bl6 = false;
        int n9 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        double[] dArray10 = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double[] dArray11 = null;
        double[][] dArray12 = null;
        if (n2 > 0) {
            lithologyListStruct2 = d3 == 2.0 ? lithologyUtility.buildNew(2, d, d2) : (d3 == 1.0 ? lithologyUtility.buildNew(1, d, d2) : lithologyUtility.buildNew(0, d, d2));
            for (int i = 0; i < n2 - 1; ++i) {
                int n10;
                int n11;
                bl6 = false;
                if (n == 0 || n == 1) {
                    if (dArray4[i] > d4 && dArray3[i] > d4) {
                        bl6 = true;
                    }
                } else if (n == 6 && dArray9[i] > d4 && dArray3[i] > d4) {
                    bl6 = true;
                }
                if (!bl6) continue;
                d7 = dArray[i];
                d8 = dArray[i + 1];
                if (lithologyListStruct2 != null) {
                    for (n11 = 0; n11 < lithologyListStruct2.iCount; ++n11) {
                        if (lithologyListStruct2.stItem[n11].depthStart == d7) {
                            n6 = n11;
                            continue;
                        }
                        if (!(lithologyListStruct2.stItem[n11].depthStart > d7) || !(lithologyListStruct2.stItem[n11].depthStart < d8)) continue;
                        n6 = n11;
                    }
                }
                d9 = 60.0;
                d10 = 70.0;
                d11 = 100.0;
                if (iqstratShaleListStruct2 != null) {
                    for (int j = 0; j < iqstratShaleListStruct2.iCount; ++j) {
                        if (!(d7 >= iqstratShaleListStruct2.stItem[j].depthStart) || !(d7 <= iqstratShaleListStruct2.stItem[j].depthEnd)) continue;
                        d9 = iqstratShaleListStruct2.stItem[j].dShaly;
                        d10 = iqstratShaleListStruct2.stItem[j].dShale;
                        d11 = iqstratShaleListStruct2.stItem[j].dHotShale;
                    }
                }
                n7 = lithMathRules.getLithology(0, d9, d10, d11, dArray2[i], dArray4[i], dArray3[i], dArray5[i], dArray9[i], d4);
                for (n10 = 0; n10 < 10; ++n10) {
                    lithologyListStruct2.stItem[n6].iLithology[n10] = n7;
                }
                bl6 = false;
                block0 : switch (n) {
                    case 0: {
                        switch (n7) {
                            case 7: 
                            case 15: 
                            case 19: 
                            case 21: 
                            case 22: 
                            case 24: {
                                nArray = lithMath._RU;
                                nArray2 = lithMath._RU_LITH;
                                nArray3 = lithMath._RU_COL;
                                dArray11 = lithMath.getRU(1, 0, dArray3[i], dArray5[i], dArray4[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 18: {
                                nArray = lithMath._ARKOSE;
                                nArray2 = lithMath._ARKOSE_LITH;
                                nArray3 = lithMath._RUGR_COL;
                                dArray11 = lithMath.getRUGR(1, 0, dArray3[i], dArray5[i], dArray4[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 60: {
                                nArray = lithMath._GRANITE;
                                nArray2 = lithMath._GRANITE_LITH;
                                nArray3 = lithMath._RUGR_COL;
                                dArray11 = lithMath.getRUGR(1, 0, dArray3[i], dArray5[i], dArray4[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 58: {
                                nArray = lithMath._IGNEOUS;
                                nArray2 = lithMath._IGNEOUS_LITH;
                                nArray3 = lithMath._RUGR_COL;
                                dArray11 = lithMath.getRUGR(1, 0, dArray3[i], dArray5[i], dArray4[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 32: {
                                nArray = lithMath._ANHY;
                                nArray2 = lithMath._ANHY_LITH;
                                nArray3 = lithMath._RU_COL;
                                dArray11 = lithMath.getRU(1, 0, dArray3[i], dArray5[i], dArray4[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 31: {
                                nArray = lithMath._GYP;
                                nArray2 = lithMath._GYP_LITH;
                                nArray3 = lithMath._RU_COL;
                                dArray11 = lithMath.getRU(1, 0, dArray3[i], dArray5[i], dArray4[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 34: 
                            case 44: {
                                break;
                            }
                            case 12: {
                                nArray = lithMath._RUGR;
                                nArray2 = lithMath._RUGR_LITH;
                                nArray3 = lithMath._RUGR_COL;
                                dArray11 = lithMath.getRUGR(1, 0, dArray3[i], dArray5[i], dArray4[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (n7) {
                            case 7: 
                            case 15: 
                            case 19: 
                            case 21: 
                            case 22: 
                            case 24: {
                                nArray = lithMath._RU;
                                nArray2 = lithMath._RU_LITH;
                                nArray3 = lithMath._PD_COL;
                                dArray11 = lithMath.getPD(1, 0, dArray3[i], dArray4[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 18: {
                                nArray = lithMath._ARKOSE;
                                nArray2 = lithMath._ARKOSE_LITH;
                                nArray3 = lithMath._PDGR_COL;
                                dArray11 = lithMath.getPDGR(1, 0, dArray3[i], dArray4[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 55: {
                                break;
                            }
                            case 32: {
                                nArray = lithMath._ANHY;
                                nArray2 = lithMath._ANHY_LITH;
                                nArray3 = lithMath._PD_COL;
                                dArray11 = lithMath.getPD(1, 0, dArray3[i], dArray4[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 31: {
                                nArray = lithMath._GYP;
                                nArray2 = lithMath._GYP_LITH;
                                nArray3 = lithMath._PD_COL;
                                dArray11 = lithMath.getPD(1, 0, dArray3[i], dArray4[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break;
                            }
                            case 34: 
                            case 44: {
                                break;
                            }
                            case 12: {
                                nArray = lithMath._RUGR;
                                nArray2 = lithMath._RUGR_LITH;
                                nArray3 = lithMath._PDGR_COL;
                                dArray11 = lithMath.getPDGR(1, 0, dArray3[i], dArray4[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                            }
                        }
                        break;
                    }
                    case 6: {
                        switch (n7) {
                            case 7: 
                            case 15: 
                            case 19: 
                            case 21: 
                            case 22: 
                            case 24: {
                                nArray = lithMath._RU;
                                nArray2 = lithMath._RU_LITH;
                                nArray3 = lithMath._RT_COL;
                                dArray11 = dArray4[i] > d4 ? lithMath.getRT(1, 0, dArray3[i], dArray9[i], dArray4[i]) : lithMath.getRT(1, 0, dArray3[i], dArray9[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break block0;
                            }
                            case 18: {
                                break block0;
                            }
                            case 60: {
                                break block0;
                            }
                            case 58: {
                                nArray = lithMath._IGNEOUS;
                                nArray2 = lithMath._IGNEOUS_LITH;
                                nArray3 = lithMath._RTGR_COL;
                                dArray11 = dArray4[i] > d4 ? lithMath.getRTGR(1, 0, dArray3[i], dArray9[i], dArray4[i], dArray2[i]) : lithMath.getRTGR(1, 0, dArray3[i], dArray9[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break block0;
                            }
                            case 32: {
                                nArray = lithMath._ANHY;
                                nArray2 = lithMath._ANHY_LITH;
                                nArray3 = lithMath._RT_COL;
                                dArray11 = dArray4[i] > d4 ? lithMath.getRT(1, 0, dArray3[i], dArray9[i], dArray4[i]) : lithMath.getRT(1, 0, dArray3[i], dArray9[i]);
                                n9 = nArray.length;
                                bl6 = true;
                                break block0;
                            }
                            case 31: {
                                break block0;
                            }
                            case 34: 
                            case 44: {
                                break block0;
                            }
                            case 12: {
                                nArray = lithMath._RUGR;
                                nArray2 = lithMath._RUGR_LITH;
                                nArray3 = lithMath._RTGR_COL;
                                dArray11 = dArray4[i] > d4 ? lithMath.getRTGR(1, 0, dArray3[i], dArray9[i], dArray4[i], dArray2[i]) : lithMath.getRTGR(1, 0, dArray3[i], dArray9[i], dArray2[i]);
                                n9 = nArray.length;
                                bl6 = true;
                            }
                        }
                    }
                }
                if (!bl6) continue;
                dArray12 = lithMath.getMatrix(nArray, nArray3);
                dArray10 = lithMath.composition(dArray11, dArray12);
                d5 = 0.0;
                for (n10 = 0; n10 < n9; ++n10) {
                    if (dArray10[n10] < 0.0) {
                        dArray10[n10] = 0.0;
                    }
                    d5 += dArray10[n10];
                }
                for (n10 = 0; n10 < n9; ++n10) {
                    if (n10 == 0) {
                        n4 = 0;
                    }
                    d6 = 10.0 * dArray10[n10] / d5;
                    n3 = (int)d6;
                    d6 -= (double)n3;
                    n5 = n4 + (int)(10.0 * dArray10[n10] / d5);
                    if (d6 > 0.5) {
                        ++n5;
                    }
                    if (n5 > 10) {
                        n5 = 10;
                    }
                    if (n10 == n9 - 1 && n5 == 9) {
                        n5 = 10;
                    }
                    n8 = nArray2[n10];
                    switch (n8) {
                        case 22: {
                            switch (n7) {
                                case 12: 
                                case 15: 
                                case 21: {
                                    n8 = 24;
                                }
                            }
                            break;
                        }
                        case 19: {
                            switch (n7) {
                                case 12: 
                                case 15: 
                                case 21: {
                                    n8 = 21;
                                }
                            }
                            break;
                        }
                        case 7: {
                            switch (n7) {
                                case 12: 
                                case 15: 
                                case 21: {
                                    n8 = 15;
                                }
                            }
                        }
                    }
                    for (n11 = n4; n11 < n5; ++n11) {
                        lithologyListStruct2.stItem[n6].iLithology[n11] = n8;
                    }
                    n4 = n5;
                }
            }
        }
        return lithologyListStruct2;
    }

    public static int[] setLegend(int[] nArray, lithologyListStruct lithologyListStruct2) {
        if (lithologyListStruct2 != null) {
            for (int i = 0; i < lithologyListStruct2.iCount; ++i) {
                for (int j = 0; j < 10; ++j) {
                    if (lithologyListStruct2.stItem[i].iLithology[j] <= 0) continue;
                    nArray[lithologyListStruct2.stItem[i].iLithology[j]] = 0;
                }
            }
        }
        return nArray;
    }

    public static lithologyListStruct bubbleSort(lithologyListStruct lithologyListStruct2) {
        boolean bl = true;
        lithologyStruct lithologyStruct2 = null;
        if (lithologyListStruct2 != null && lithologyListStruct2.iCount > 1) {
            while (bl) {
                bl = false;
                for (int i = 0; i < lithologyListStruct2.iCount - 1; ++i) {
                    if (!(lithologyListStruct2.stItem[i].depthStart > lithologyListStruct2.stItem[i + 1].depthStart)) continue;
                    bl = true;
                    lithologyStruct2 = lithologyUtility.copy(lithologyListStruct2.stItem[i]);
                    lithologyListStruct2.stItem[i] = lithologyUtility.copy(lithologyListStruct2.stItem[i + 1]);
                    lithologyListStruct2.stItem[i + 1] = lithologyUtility.copy(lithologyStruct2);
                }
            }
        }
        return lithologyListStruct2;
    }

    public static void print(lithologyListStruct lithologyListStruct2) {
        System.out.println("-------------------------------------------------");
        if (lithologyListStruct2 != null) {
            for (int i = 0; i < lithologyListStruct2.iCount; ++i) {
                System.out.print(i + " " + lithologyListStruct2.stItem[i].sKEY + " " + lithologyListStruct2.stItem[i].depthStart + " " + lithologyListStruct2.stItem[i].depthEnd);
                System.out.print(" Abrev:   " + lithologyListStruct2.stItem[i].sAbbreviation);
                System.out.print(" Streaks: " + lithologyListStruct2.stItem[i].iStreaks);
                System.out.print(" Lithology: ");
                for (int j = 0; j < 10; ++j) {
                    System.out.print(", " + lithologyListStruct2.stItem[i].iLithology[j]);
                }
                System.out.println("");
            }
        }
        System.out.println("-------------------------------------------------");
    }
}

