/*
 * Decompiled with CFR 0.152.
 */
package lith.gui;

import iqstrat.iqstratRemarkListStruct;
import iqstrat.iqstratRemarkStruct;
import iqstrat.iqstratRemarkUtility;
import iqstrat.iqstratStruct;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import lith.gui.lithIgneousPanel;
import lith.gui.lithMetamorphPanel;
import lith.gui.lithSedimentPanel;
import lith.gui.lithologyEntryFrameObservable;
import lith.lithology.lithologyListStruct;
import lith.lithology.lithologyStruct;
import lith.lithology.lithologyUtility;
import parse.parseMineralsUtility;

public class lithologyEntryFrame
extends JFrame
implements ActionListener,
Observer {
    private Observable pNotifier = null;
    private iqstratStruct stStruct = null;
    private Observable notifier = null;
    private String sRock = "";
    private String second = "";
    private int iTexture = -1;
    private String sTexture = "";
    private lithologyStruct stLithology = null;
    private lithSedimentPanel pSediment = null;
    private lithMetamorphPanel pMetamorph = null;
    private lithIgneousPanel pIgneous = null;
    private static final int _SEDIMENTARY = 0;
    private static final int _METAMORPHIC = 1;
    private static final int _IGNEOUS = 2;
    private static final String[] PANEL = new String[]{"Sedimentary Rock Lithology", "Metamorphic Rock Lithology", "Igneous Rock Lithology"};
    private int iPanel = 0;
    private JButton btnAdd = new JButton();
    private JPanel pnlData = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private TitledBorder titledBorderEntry = null;
    private JRadioButton rbSedimentary = new JRadioButton();
    private JRadioButton rbMetamorphic = new JRadioButton();
    private JRadioButton rbIgneous = new JRadioButton();
    private JTextArea txt = new JTextArea();
    private JMenuItem mExit = null;
    private int iXStart = 0;
    private int iYStart = 0;
    private int iWidth = 0;
    private int iHeight = 0;

    public lithologyEntryFrame(Observable observable, iqstratStruct iqstratStruct2) {
        try {
            this.pNotifier = observable;
            this.stStruct = iqstratStruct2;
            this.jbInit();
            this.addWindowListener(new lithologyEntryFrame_WindowListener());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.titledBorderEntry = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Sedimentary Rock Lithology");
        this.titledBorderEntry.setTitleFont(new Font("Dialog", 1, 11));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Close Dialog");
        this.mExit = new JMenuItem("Close");
        this.mExit.addActionListener(this);
        jMenu.add(this.mExit);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.notifier = new lithologyEntryFrameObservable();
        this.notifier.addObserver(this);
        this.setTitle("Lithology/Texture");
        this.getContentPane().setLayout(new BorderLayout());
        jPanel.setLayout(new GridLayout());
        jPanel.setBackground(Color.white);
        this.rbSedimentary.setFont(new Font("Monospaced", 1, 11));
        this.rbSedimentary.setBackground(Color.white);
        this.rbSedimentary.setHorizontalAlignment(0);
        this.rbSedimentary.setSelected(true);
        this.rbSedimentary.setText("Sedimentary Rocks");
        this.rbSedimentary.addActionListener(this);
        this.rbMetamorphic.setFont(new Font("Monospaced", 1, 11));
        this.rbMetamorphic.setBackground(Color.white);
        this.rbMetamorphic.setHorizontalAlignment(0);
        this.rbMetamorphic.setText("Metamorphic Rocks");
        this.rbMetamorphic.addActionListener(this);
        this.rbIgneous.setFont(new Font("Monospaced", 1, 11));
        this.rbIgneous.setBackground(Color.white);
        this.rbIgneous.setHorizontalAlignment(0);
        this.rbIgneous.setText("Igneous Rocks");
        this.rbIgneous.addActionListener(this);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(Color.white);
        this.pnlData.setLayout(this.cardLayout);
        this.pnlData.setBorder(this.titledBorderEntry);
        this.pnlData.setBackground(Color.white);
        this.pSediment = new lithSedimentPanel(this.notifier);
        this.pMetamorph = new lithMetamorphPanel(this.notifier);
        this.pIgneous = new lithIgneousPanel(this.notifier);
        jPanel3.setLayout(new BorderLayout());
        this.txt.setText("");
        this.txt.setRows(3);
        this.txt.setFont(new Font("Dialog", 0, 14));
        this.txt.setLineWrap(true);
        this.txt.setWrapStyleWord(true);
        jPanel4.setLayout(new GridLayout(2, 1));
        this.btnAdd.setFont(new Font("Dialog", 1, 11));
        this.btnAdd.setText("Add");
        this.btnAdd.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.add((Component)this.rbSedimentary, null);
        jPanel.add((Component)this.rbMetamorphic, null);
        jPanel.add((Component)this.rbIgneous, null);
        buttonGroup.add(this.rbSedimentary);
        buttonGroup.add(this.rbMetamorphic);
        buttonGroup.add(this.rbIgneous);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)this.pnlData, "Center");
        this.pnlData.add((Component)this.pSediment, "SEDIMENTARY");
        this.pnlData.add((Component)this.pMetamorph, "METAMORPHIC");
        this.pnlData.add((Component)this.pIgneous, "IGNEOUS");
        this.getContentPane().add((Component)jPanel3, "South");
        jPanel3.add((Component)jScrollPane, "Center");
        jScrollPane.getViewport().add((Component)this.txt, null);
        jPanel3.add((Component)jPanel4, "East");
        jPanel4.add((Component)this.btnAdd, null);
        this.setSize(new Dimension(770, 750));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (dimension.width - this.getSize().width) / 2;
        if (this.iWidth > 0) {
            n = this.iXStart + this.iWidth;
        }
        this.setLocation(n, (dimension.height - this.getSize().height) / 2);
        this.setVisible(true);
    }

    public lithologyStruct getData() {
        lithologyListStruct lithologyListStruct2 = null;
        iqstratRemarkStruct iqstratRemarkStruct2 = new iqstratRemarkStruct();
        iqstratRemarkListStruct iqstratRemarkListStruct2 = null;
        if (this.stLithology != null) {
            this.stLithology.delete();
        }
        this.stLithology = null;
        iqstratRemarkStruct2.depthStart = 0.0;
        iqstratRemarkStruct2.depthEnd = 20.0;
        iqstratRemarkStruct2.sText = new String(this.txt.getText());
        lithologyListStruct2 = parseMineralsUtility.parse(iqstratRemarkListStruct2 = iqstratRemarkUtility.add(iqstratRemarkStruct2, iqstratRemarkListStruct2), this.stStruct.stSymbols, this.stStruct.stParseTexture, this.stStruct.stMinerals);
        if (lithologyListStruct2 != null && lithologyListStruct2.iCount > 0) {
            this.stLithology = lithologyUtility.copy(lithologyListStruct2.stItem[0]);
        }
        return this.stLithology;
    }

    public String getText() {
        return this.txt.getText();
    }

    private void setPanel(int n) {
        this.iPanel = n;
        switch (n) {
            case 0: {
                this.cardLayout.show(this.pnlData, "SEDIMENTARY");
                break;
            }
            case 1: {
                this.cardLayout.show(this.pnlData, "METAMORPHIC");
                break;
            }
            case 2: {
                this.cardLayout.show(this.pnlData, "IGNEOUS");
            }
        }
        this.titledBorderEntry.setTitle(PANEL[n]);
        this.pnlData.updateUI();
    }

    public void add() {
        if (this.pNotifier != null) {
            this.pNotifier.notifyObservers(new String("ADD or MODIFY Lithology Data"));
        }
    }

    public void close() {
        this.pNotifier = null;
        this.stStruct = null;
        this.notifier = null;
        this.sRock = null;
        this.second = null;
        this.sTexture = null;
        if (this.stLithology != null) {
            this.stLithology.delete();
        }
        this.stLithology = null;
        if (this.pSediment != null) {
            this.pSediment.close();
        }
        this.pSediment = null;
        if (this.pMetamorph != null) {
            this.pMetamorph.close();
        }
        this.pMetamorph = null;
        if (this.pIgneous != null) {
            this.pIgneous.close();
        }
        this.pIgneous = null;
        this.btnAdd = null;
        this.pnlData = null;
        this.cardLayout = null;
        this.titledBorderEntry = null;
        this.rbSedimentary = null;
        this.rbMetamorphic = null;
        this.rbIgneous = null;
        this.txt = null;
        this.mExit = null;
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbSedimentary) {
            this.setPanel(0);
        }
        if (actionEvent.getSource() == this.rbMetamorphic) {
            this.setPanel(1);
        }
        if (actionEvent.getSource() == this.rbIgneous) {
            this.setPanel(2);
        }
        if (actionEvent.getSource() == this.btnAdd) {
            this.add();
        }
        if (actionEvent.getSource() == this.mExit) {
            this.close();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        if (string.equals("Sedimentary Lithology Selected")) {
            this.sRock = new String(this.pSediment.getLithology());
            this.second = new String(this.pSediment.getSecondary());
            this.iTexture = this.pSediment.getTexture();
            this.sTexture = new String(this.pSediment.getTextureDesc());
            if (this.second.length() == 0) {
                this.txt.setText(this.sRock + ": " + this.sTexture + " ( Level: " + this.iTexture + " )");
            } else {
                this.txt.setText(this.sRock + ": " + this.sTexture + " ( Level: " + this.iTexture + " ), " + this.second);
            }
        }
        if (string.equals("Metamorphic Lithology Selected")) {
            this.sRock = new String(this.pMetamorph.getLithology());
            this.iTexture = this.pMetamorph.getTexture();
            this.sTexture = new String(this.pMetamorph.getTextureDesc());
            this.txt.setText(this.sRock + ": " + this.sTexture + " ( Level: " + this.iTexture + " )");
        }
        if (string.equals("Igneous Lithology Selected")) {
            this.sRock = new String(this.pIgneous.getLithology());
            this.iTexture = this.pIgneous.getTexture();
            this.sTexture = new String(this.pIgneous.getTextureDesc());
            this.txt.setText(this.sRock + ": " + this.sTexture + " ( Level: " + this.iTexture + " ), ");
        }
    }

    public class lithologyEntryFrame_WindowListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent windowEvent) {
            lithologyEntryFrame.this.close();
        }
    }
}

