/*
 * Decompiled with CFR 0.152.
 */
package lith.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import lith.lithConstants;

public class lithSedimentsTexturePanel
extends JPanel
implements ActionListener {
    private Observable notifier = null;
    public static final String[] DEFAULT = lithConstants.DEFAULT;
    public static final int[][] DEFAULT_COLOR = lithConstants.DEFAULT_COLOR;
    public static final String[] SIO2 = lithConstants.SIO2;
    public static final int[][] SIO2_COLOR = lithConstants.SIO2_COLOR;
    public static final String[] CO3 = lithConstants.CO3;
    public static final int[][] CO3_COLOR = lithConstants.CO3_COLOR;
    public static final String[] PYRO = lithConstants.PYRO;
    public static final int[][] PYRO_COLOR = lithConstants.PYRO_COLOR;
    public static final int[][] PRIMARY_SIZE = lithConstants.PRIMARY_SIZE;
    private static final int _SAND = 0;
    private static final int _CALC = 1;
    private static final int _DOLO = 2;
    private static final int _PYRO = 3;
    private int iPanel = 0;
    private int iRock = -1;
    private int iTexture = -1;
    private String sTexture = "";
    private JPanel pnlData = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private TitledBorder titledBorderMain = null;
    private JRadioButton rbSand = new JRadioButton();
    private JRadioButton rbCalc = new JRadioButton();
    private JRadioButton rbDolo = new JRadioButton();
    private JRadioButton rbPyro = new JRadioButton();
    private JRadioButton[] rb = null;
    private JRadioButton[] rbP = null;

    public lithSedimentsTexturePanel(Observable observable) {
        try {
            this.notifier = observable;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n;
        int n2 = 0;
        String string = "";
        int[][] nArray = null;
        String[] stringArray = null;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup buttonGroup2 = new ButtonGroup();
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.titledBorderMain = new TitledBorder(new EtchedBorder(0, Color.white, new Color(165, 163, 151)), "Sediments");
        this.titledBorderMain.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        this.setBackground(Color.white);
        this.setBorder(this.titledBorderMain);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(300, 10));
        jPanel.setLayout(new GridLayout(2, 2));
        jPanel.setBackground(new Color(255, 255, 255));
        jPanel.setBorder(titledBorder);
        this.rbSand.setFont(new Font("Monospaced", 1, 11));
        this.rbSand.setHorizontalAlignment(0);
        this.rbSand.setBackground(new Color(255, 255, 255));
        this.rbSand.setText("Rock Fragments ");
        this.rbSand.setSelected(true);
        this.rbSand.addActionListener(this);
        this.rbCalc.setFont(new Font("Monospaced", 1, 11));
        this.rbCalc.setHorizontalAlignment(0);
        this.rbCalc.setBackground(new Color(255, 255, 255));
        this.rbCalc.setText("> 50% Carbonate");
        this.rbCalc.addActionListener(this);
        this.rbDolo.setFont(new Font("Monospaced", 1, 11));
        this.rbDolo.setHorizontalAlignment(0);
        this.rbDolo.setBackground(new Color(255, 255, 255));
        this.rbDolo.setText("> 50% Dolomite ");
        this.rbDolo.addActionListener(this);
        this.rbPyro.setFont(new Font("Monospaced", 1, 11));
        this.rbPyro.setHorizontalAlignment(0);
        this.rbPyro.setBackground(new Color(255, 255, 255));
        this.rbPyro.setText("Pyroclastic    ");
        this.rbPyro.addActionListener(this);
        jPanel7.setLayout(new GridLayout(14, 1));
        jPanel7.setBackground(new Color(255, 255, 255));
        this.rb = new JRadioButton[14];
        nArray = DEFAULT_COLOR;
        stringArray = DEFAULT;
        for (n = 13; n > -1; --n) {
            n2 = n + 1;
            string = new String("(" + n2 + ") ");
            if (n2 < 10) {
                string = new String("( " + n2 + ") ");
            }
            this.rb[n] = new JRadioButton();
            this.rb[n].setFont(new Font("Monospaced", 1, 11));
            this.rb[n].setHorizontalAlignment(2);
            this.rb[n].setBackground(new Color(nArray[n][0], nArray[n][1], nArray[n][2]));
            this.rb[n].setText(stringArray[n]);
            if (stringArray[n].length() == 0) {
                this.rb[n].setEnabled(false);
            }
            this.rb[n].addActionListener(this);
            jPanel7.add((Component)this.rb[n], null);
            buttonGroup.add(this.rb[n]);
        }
        this.rbP = new JRadioButton[85];
        for (n = 0; n < 85; ++n) {
            this.rbP[n] = new JRadioButton();
            this.rbP[n].setFont(new Font("Monospaced", 1, 11));
            this.rbP[n].setHorizontalAlignment(2);
            this.rbP[n].setBackground(new Color(255, 255, 255));
            this.rbP[n].setText(lithConstants.PRIMARY[n][0]);
            this.rbP[n].addActionListener(this);
            buttonGroup3.add(this.rbP[n]);
        }
        jPanel6.setLayout(new BorderLayout());
        this.pnlData.setLayout(this.cardLayout);
        jPanel2 = this.buildSAND();
        jPanel3 = this.buildCALC();
        jPanel4 = this.buildDOLO();
        jPanel5 = this.buildPYRO();
        this.add((Component)jPanel, "North");
        jPanel.add((Component)this.rbSand, null);
        jPanel.add((Component)this.rbCalc, null);
        jPanel.add((Component)this.rbDolo, null);
        jPanel.add((Component)this.rbPyro, null);
        buttonGroup2.add(this.rbSand);
        buttonGroup2.add(this.rbCalc);
        buttonGroup2.add(this.rbDolo);
        buttonGroup2.add(this.rbPyro);
        this.add((Component)jPanel7, "West");
        this.add((Component)jPanel6, "Center");
        jPanel6.add((Component)this.pnlData, "Center");
        this.pnlData.add((Component)jPanel2, "SAND");
        this.pnlData.add((Component)jPanel3, "CALC");
        this.pnlData.add((Component)jPanel4, "DOLO");
        this.pnlData.add((Component)jPanel5, "PYRO");
        this.setPanel(0);
    }

    private JPanel buildSAND() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel[] jPanelArray = null;
        JPanel jPanel4 = new JPanel();
        JPanel[] jPanelArray2 = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Rudaceous");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Arenaceous");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Argillaceous");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setBorder(titledBorder);
        jPanel2.setPreferredSize(new Dimension(10, 160));
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new GridLayout(3, 1));
        jPanel2.add((Component)this.rbP[18], null);
        jPanel2.add((Component)this.rbP[19], null);
        jPanel2.add((Component)this.rbP[17], null);
        jPanel3.setBorder(titledBorder2);
        jPanel3.setBackground(Color.white);
        jPanel3.setLayout(new GridLayout(4, 1));
        jPanelArray = new JPanel[2];
        jPanelArray[1] = new JPanel();
        jPanelArray[1].setLayout(new GridLayout());
        jPanelArray[1].add((Component)this.rbP[3], null);
        jPanelArray[1].add((Component)this.rbP[1], null);
        jPanel3.add((Component)jPanelArray[1], null);
        jPanelArray[0] = new JPanel();
        jPanelArray[0].setLayout(new GridLayout());
        jPanelArray[0].add((Component)this.rbP[15], null);
        jPanelArray[0].add((Component)this.rbP[16], null);
        jPanel3.add((Component)jPanelArray[0], null);
        jPanel3.add((Component)this.rbP[47], null);
        jPanel3.add((Component)this.rbP[2], null);
        jPanel4.setBorder(titledBorder3);
        jPanel4.setPreferredSize(new Dimension(10, 150));
        jPanel4.setBackground(Color.white);
        jPanel4.setLayout(new GridLayout(5, 1));
        jPanelArray2 = new JPanel[4];
        jPanelArray2[0] = new JPanel();
        jPanelArray2[0].setLayout(new GridLayout());
        jPanelArray2[0].add((Component)this.rbP[13], null);
        jPanelArray2[0].add((Component)this.rbP[14], null);
        jPanel4.add((Component)jPanelArray2[0], null);
        jPanelArray2[1] = new JPanel();
        jPanelArray2[1].setLayout(new GridLayout());
        jPanelArray2[1].add((Component)this.rbP[6], null);
        jPanelArray2[1].add((Component)this.rbP[7], null);
        jPanel4.add((Component)jPanelArray2[1], null);
        jPanelArray2[2] = new JPanel();
        jPanelArray2[2].setLayout(new GridLayout());
        jPanelArray2[2].add((Component)this.rbP[8], null);
        jPanelArray2[2].add((Component)this.rbP[9], null);
        jPanel4.add((Component)jPanelArray2[2], null);
        jPanelArray2[3] = new JPanel();
        jPanelArray2[3].setLayout(new GridLayout());
        jPanelArray2[3].add((Component)this.rbP[21], null);
        jPanelArray2[3].add((Component)this.rbP[22], null);
        jPanel4.add((Component)jPanelArray2[3], null);
        jPanel4.add((Component)this.rbP[10], null);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private JPanel buildCALC() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Rudaceous");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Arenaceous");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Argillaceous");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setBorder(titledBorder);
        jPanel2.setPreferredSize(new Dimension(10, 160));
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new GridLayout());
        jPanel2.add((Component)this.rbP[48], null);
        jPanel3.setBorder(titledBorder2);
        jPanel3.setBackground(Color.white);
        jPanel3.setLayout(new GridLayout());
        jPanel3.add((Component)this.rbP[49], null);
        jPanel4.setBorder(titledBorder3);
        jPanel4.setPreferredSize(new Dimension(10, 150));
        jPanel4.setBackground(Color.white);
        jPanel4.setLayout(new GridLayout());
        jPanel4.add((Component)this.rbP[50], null);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private JPanel buildDOLO() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Rudaceous");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Arenaceous");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Argillaceous");
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setBorder(titledBorder);
        jPanel2.setPreferredSize(new Dimension(10, 160));
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new GridLayout());
        jPanel2.add((Component)this.rbP[51], null);
        jPanel3.setBorder(titledBorder2);
        jPanel3.setBackground(Color.white);
        jPanel3.setLayout(new GridLayout());
        jPanel3.add((Component)this.rbP[52], null);
        jPanel4.setBorder(titledBorder3);
        jPanel4.setPreferredSize(new Dimension(10, 150));
        jPanel4.setBackground(Color.white);
        jPanel4.setLayout(new GridLayout());
        jPanel4.add((Component)this.rbP[53], null);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private JPanel buildPYRO() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Rudaceous");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Arenaceous");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        jPanel.setLayout(new BorderLayout());
        jPanel2.setBorder(titledBorder);
        jPanel2.setPreferredSize(new Dimension(10, 160));
        jPanel2.setBackground(Color.white);
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel2.add((Component)this.rbP[54], null);
        jPanel2.add((Component)this.rbP[55], null);
        jPanel3.setBorder(titledBorder2);
        jPanel3.setBackground(Color.white);
        jPanel3.setLayout(new GridLayout());
        jPanel3.add((Component)this.rbP[56], null);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "Center");
        return jPanel;
    }

    public int getLithology() {
        return this.iRock;
    }

    public int getTexture() {
        return this.iTexture;
    }

    public String getTextureDesc() {
        return this.sTexture;
    }

    private void setPanel(int n) {
        int[][] nArray = null;
        String[] stringArray = null;
        String string = "";
        this.iPanel = n;
        switch (n) {
            case 0: {
                this.cardLayout.show(this.pnlData, "SAND");
                string = new String("Sediments: Quartz, Feldspar, Rock Fragments");
                nArray = SIO2_COLOR;
                stringArray = SIO2;
                break;
            }
            case 1: {
                this.cardLayout.show(this.pnlData, "CALC");
                string = new String("Sediments: > 50 % Carbonate-Limestone");
                nArray = CO3_COLOR;
                stringArray = CO3;
                break;
            }
            case 2: {
                this.cardLayout.show(this.pnlData, "DOLO");
                string = new String("Sediments: > 50 % Carbonate-Dolomite");
                nArray = CO3_COLOR;
                stringArray = CO3;
                break;
            }
            case 3: {
                this.cardLayout.show(this.pnlData, "PYRO");
                string = new String("Sediments: > 50 % Volcanic Material");
                nArray = PYRO_COLOR;
                stringArray = PYRO;
                break;
            }
            default: {
                string = new String("Sediments:");
                nArray = DEFAULT_COLOR;
                stringArray = DEFAULT;
            }
        }
        for (int i = 13; i > -1; --i) {
            this.rb[i].setBackground(new Color(nArray[i][0], nArray[i][1], nArray[i][2]));
            this.rb[i].setText(stringArray[i]);
            if (stringArray[i].length() != 0) continue;
            if (i + 1 < 14) {
                this.rb[i].setBackground(new Color(nArray[i + 1][0], nArray[i + 1][1], nArray[i + 1][2]));
            }
            this.rb[i].setEnabled(false);
        }
        this.titledBorderMain.setTitle(string);
        this.updateUI();
    }

    private void setTextureBTNS(int n) {
        int[][] nArray = null;
        String[] stringArray = null;
        this.iRock = n;
        switch (this.iPanel) {
            case 0: {
                nArray = SIO2_COLOR;
                stringArray = SIO2;
                break;
            }
            case 1: {
                nArray = CO3_COLOR;
                stringArray = CO3;
                break;
            }
            case 2: {
                nArray = CO3_COLOR;
                stringArray = CO3;
                break;
            }
            case 3: {
                nArray = PYRO_COLOR;
                stringArray = PYRO;
                break;
            }
            default: {
                nArray = DEFAULT_COLOR;
                stringArray = DEFAULT;
            }
        }
        if (n > -1) {
            int n2;
            for (n2 = 13; n2 > -1; --n2) {
                this.rb[n2].setBackground(new Color(255, 255, 255));
            }
            for (n2 = 13; n2 > -1; --n2) {
                if (PRIMARY_SIZE[n][n2] != 1 && PRIMARY_SIZE[n][n2] != 2) continue;
                this.rb[n2].setBackground(new Color(nArray[n2][0], nArray[n2][1], nArray[n2][2]));
                this.rb[n2].setText(stringArray[n2]);
                if (stringArray[n2].length() != 0) continue;
                if (n2 + 1 < 14) {
                    this.rb[n2].setBackground(new Color(nArray[n2 + 1][0], nArray[n2 + 1][1], nArray[n2 + 1][2]));
                }
                this.rb[n2].setEnabled(false);
            }
            for (n2 = 0; n2 < 14; ++n2) {
                this.rb[n2].setEnabled(false);
                if (PRIMARY_SIZE[n][n2] != 1 && PRIMARY_SIZE[n][n2] != 2) continue;
                if (stringArray[n2].length() > 0) {
                    this.rb[n2].setEnabled(true);
                }
                if (PRIMARY_SIZE[n][n2] != 2) continue;
                this.rb[n2].setSelected(true);
                this.setTexture(n2);
            }
        }
    }

    private void setTexture(int n) {
        String[] stringArray = null;
        switch (this.iPanel) {
            case 0: {
                stringArray = SIO2;
                break;
            }
            case 1: {
                stringArray = CO3;
                break;
            }
            case 2: {
                stringArray = CO3;
                break;
            }
            case 3: {
                stringArray = PYRO;
                break;
            }
            default: {
                stringArray = DEFAULT;
            }
        }
        switch (this.iRock) {
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 21: 
            case 22: {
                this.sTexture = new String("");
                break;
            }
            default: {
                this.sTexture = new String(stringArray[n]);
            }
        }
        this.iTexture = n + 1;
    }

    public void close() {
        int n = 0;
        this.notifier = null;
        this.sTexture = null;
        this.pnlData = null;
        this.cardLayout = null;
        this.titledBorderMain = null;
        this.rbSand = null;
        this.rbCalc = null;
        this.rbDolo = null;
        this.rbPyro = null;
        for (n = 0; n < 14; ++n) {
            this.rb[n] = null;
        }
        for (n = 0; n < 85; ++n) {
            this.rbP[n] = null;
        }
        this.rb = null;
        this.rbP = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = 0;
        if (actionEvent.getSource() == this.rbSand) {
            this.setPanel(0);
        }
        if (actionEvent.getSource() == this.rbCalc) {
            this.setPanel(1);
        }
        if (actionEvent.getSource() == this.rbDolo) {
            this.setPanel(2);
        }
        if (actionEvent.getSource() == this.rbPyro) {
            this.setPanel(3);
        }
        for (n = 0; n < 14; ++n) {
            if (actionEvent.getSource() != this.rb[n]) continue;
            this.setTexture(n);
        }
        for (n = 0; n < 85; ++n) {
            if (actionEvent.getSource() != this.rbP[n]) continue;
            this.setTextureBTNS(n);
        }
        if (this.notifier != null) {
            this.notifier.notifyObservers(new String("Primary Sediments Selected"));
        }
    }
}

