/*
 * Decompiled with CFR 0.152.
 */
package lith.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import lith.gui.lithCarbonateTexturePanel;
import lith.gui.lithChemicalTexturePanel;
import lith.gui.lithOrganicTexturePanel;
import lith.gui.lithSedimentPanelObservable;
import lith.gui.lithSedimentsTexturePanel;
import lith.lithConstants;

public class lithSedimentPanel
extends Panel
implements ActionListener,
Observer {
    private Observable pNotifier = null;
    private Observable notifier = null;
    private int iPrimary = 0;
    private int iRock = -1;
    private String sRock = "";
    private int iTexture = -1;
    private String sTexture = "";
    private String second = "";
    private lithSedimentsTexturePanel pSediments = null;
    private lithCarbonateTexturePanel pCarbonate = null;
    private lithChemicalTexturePanel pChemical = null;
    private lithOrganicTexturePanel pOrganic = null;
    private static final int _SEDIMENTS = 0;
    private static final int _CARBONATE = 1;
    private static final int _CHEMICAL = 2;
    private static final int _ORGANIC = 3;
    private int iPanel = 0;
    private JPanel pnlData = new JPanel();
    private CardLayout cardLayout = new CardLayout();
    private TitledBorder titledBorderEntry = null;
    private JRadioButton rbSediments = new JRadioButton();
    private JRadioButton rbCarbonate = new JRadioButton();
    private JRadioButton rbChemical = new JRadioButton();
    private JRadioButton rbOrganic = new JRadioButton();
    private JRadioButton[][] rbS = null;
    private JLabel[] lblS = null;

    public lithSedimentPanel(Observable observable) {
        try {
            this.pNotifier = observable;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        boolean bl = false;
        String string = "";
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel[] jPanelArray = null;
        JPanel[] jPanelArray2 = null;
        JPanel[] jPanelArray3 = null;
        JLabel jLabel = new JLabel();
        JScrollPane jScrollPane = new JScrollPane();
        JScrollPane jScrollPane2 = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        ButtonGroup[] buttonGroupArray = null;
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Primary:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Secondary Lithologies:");
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        this.notifier = new lithSedimentPanelObservable();
        this.notifier.addObserver(this);
        this.setLayout(new BorderLayout());
        jPanel.setLayout(new GridLayout());
        jPanel.setBackground(Color.white);
        this.rbSediments.setFont(new Font("Monospaced", 1, 11));
        this.rbSediments.setBackground(Color.white);
        this.rbSediments.setHorizontalAlignment(0);
        this.rbSediments.setSelected(true);
        this.rbSediments.setText("Detrital Sediments");
        this.rbSediments.addActionListener(this);
        this.rbCarbonate.setFont(new Font("Monospaced", 1, 11));
        this.rbCarbonate.setBackground(Color.white);
        this.rbCarbonate.setHorizontalAlignment(0);
        this.rbCarbonate.setText("Carbonate Rocks");
        this.rbCarbonate.addActionListener(this);
        this.rbChemical.setFont(new Font("Monospaced", 1, 11));
        this.rbChemical.setBackground(Color.white);
        this.rbChemical.setHorizontalAlignment(0);
        this.rbChemical.setText("Chemical Rocks");
        this.rbChemical.addActionListener(this);
        this.rbOrganic.setFont(new Font("Monospaced", 1, 11));
        this.rbOrganic.setBackground(Color.white);
        this.rbOrganic.setHorizontalAlignment(0);
        this.rbOrganic.setText("Organic Rocks");
        this.rbOrganic.addActionListener(this);
        jPanel2.setLayout(new BorderLayout());
        jPanel2.setBackground(Color.white);
        this.pnlData.setLayout(this.cardLayout);
        this.pnlData.setBackground(Color.white);
        this.pSediments = new lithSedimentsTexturePanel(this.notifier);
        this.pCarbonate = new lithCarbonateTexturePanel(this.notifier);
        this.pChemical = new lithChemicalTexturePanel(this.notifier);
        this.pOrganic = new lithOrganicTexturePanel(this.notifier);
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setBackground(Color.white);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.setBackground(Color.white);
        jPanel4.setBorder(titledBorder2);
        jLabel.setFont(new Font("Monospaced", 2, 11));
        jLabel.setBackground(Color.white);
        jLabel.setForeground(Color.red);
        jLabel.setHorizontalAlignment(0);
        jLabel.setText("sli=slightly; med=medium; vry=very; ex=extremely");
        n = 24;
        jPanel6.setLayout(new GridLayout(n, 1));
        jPanel6.setBackground(Color.white);
        jPanel6.setPreferredSize(new Dimension(10, n * 25));
        jPanelArray = new JPanel[24];
        jPanelArray2 = new JPanel[24];
        jPanelArray3 = new JPanel[24];
        this.lblS = new JLabel[24];
        this.rbS = new JRadioButton[24][5];
        buttonGroupArray = new ButtonGroup[24];
        for (int i = 0; i < 24; ++i) {
            jPanelArray[i] = new JPanel();
            jPanelArray[i].setLayout(new BorderLayout());
            jPanelArray[i].setBackground(Color.white);
            jPanelArray[i].setBorder(BorderFactory.createEtchedBorder());
            jPanelArray2[i] = new JPanel();
            jPanelArray2[i].setBackground(Color.white);
            jPanelArray2[i].setPreferredSize(new Dimension(100, 10));
            jPanelArray3[i] = new JPanel();
            jPanelArray3[i].setBackground(Color.white);
            jPanelArray3[i].setLayout(new GridLayout());
            buttonGroupArray[i] = new ButtonGroup();
            this.lblS[i] = new JLabel();
            this.lblS[i].setFont(new Font("Monospaced", 1, 11));
            this.lblS[i].setBackground(Color.white);
            this.lblS[i].setHorizontalAlignment(2);
            this.lblS[i].setText(lithConstants.SECONDARY[i]);
            for (int j = 0; j < 5; ++j) {
                this.rbS[i][j] = new JRadioButton();
                this.rbS[i][j].setBackground(Color.white);
                this.rbS[i][j].setFont(new Font("Monospaced", 1, 11));
                this.rbS[i][j].setHorizontalAlignment(2);
                if (j == 0) {
                    this.rbS[i][j].setSelected(true);
                }
                if (j == 0) {
                    this.rbS[i][j].setText("");
                }
                if (j == 1) {
                    this.rbS[i][j].setText("sli");
                }
                if (j == 2) {
                    this.rbS[i][j].setText("med");
                }
                if (j == 3) {
                    this.rbS[i][j].setText("vry");
                }
                if (j == 4) {
                    this.rbS[i][j].setText("ex");
                }
                this.rbS[i][j].addActionListener(this);
                jPanelArray3[i].add((Component)this.rbS[i][j], null);
                buttonGroupArray[i].add(this.rbS[i][j]);
            }
            jPanel6.add((Component)jPanelArray[i], null);
            jPanelArray[i].add((Component)jPanelArray2[i], "East");
            jPanelArray2[i].add((Component)this.lblS[i], null);
            jPanelArray[i].add((Component)jPanelArray3[i], "Center");
        }
        this.setPrimary(this.iPrimary);
        this.add((Component)jPanel, "North");
        jPanel.add((Component)this.rbSediments, null);
        jPanel.add((Component)this.rbCarbonate, null);
        jPanel.add((Component)this.rbChemical, null);
        jPanel.add((Component)this.rbOrganic, null);
        buttonGroup.add(this.rbSediments);
        buttonGroup.add(this.rbCarbonate);
        buttonGroup.add(this.rbChemical);
        buttonGroup.add(this.rbOrganic);
        this.add((Component)jPanel2, "West");
        jPanel2.add((Component)this.pnlData, "Center");
        this.pnlData.add((Component)this.pSediments, "SEDIMENTS");
        this.pnlData.add((Component)this.pCarbonate, "CARBONATE");
        this.pnlData.add((Component)this.pChemical, "CHEMICAL");
        this.pnlData.add((Component)this.pOrganic, "ORGANIC");
        this.add((Component)jPanel3, "Center");
        jPanel3.add((Component)jPanel4, "Center");
        jPanel4.add((Component)jPanel5, "North");
        jPanel5.add((Component)jLabel, null);
        jPanel4.add((Component)jScrollPane2, "Center");
        jScrollPane2.getViewport().add((Component)jPanel6, null);
    }

    public String getLithology() {
        return this.sRock;
    }

    public String getSecondary() {
        return this.second;
    }

    public int getTexture() {
        return this.iTexture;
    }

    public String getTextureDesc() {
        return this.sTexture;
    }

    private void setPanel(int n) {
        this.iPanel = n;
        switch (n) {
            case 0: {
                this.cardLayout.show(this.pnlData, "SEDIMENTS");
                break;
            }
            case 1: {
                this.cardLayout.show(this.pnlData, "CARBONATE");
                break;
            }
            case 2: {
                this.cardLayout.show(this.pnlData, "CHEMICAL");
                break;
            }
            case 3: {
                this.cardLayout.show(this.pnlData, "ORGANIC");
            }
        }
        this.pnlData.updateUI();
    }

    private void setPrimary(int n) {
        this.iPrimary = n;
        if (n > -1) {
            for (int i = 0; i < 24; ++i) {
                this.rbS[i][0].setSelected(true);
                for (int j = 0; j < 5; ++j) {
                    this.rbS[i][j].setEnabled(false);
                    this.rbS[i][j].setForeground(Color.lightGray);
                    this.rbS[i][j].setBackground(Color.white);
                    this.lblS[i].setForeground(Color.lightGray);
                    this.lblS[i].setBackground(Color.white);
                    if (lithConstants.ACTION[n][i] != 1) continue;
                    this.rbS[i][j].setEnabled(true);
                    this.rbS[i][j].setForeground(Color.black);
                    this.rbS[i][j].setBackground(Color.white);
                    this.lblS[i].setForeground(Color.black);
                    this.lblS[i].setBackground(Color.white);
                }
            }
        }
    }

    private void setSecondary() {
        int n;
        int n2;
        String string = "";
        int n3 = 0;
        int[] nArray = null;
        String[] stringArray = null;
        int n4 = -1;
        String string2 = "";
        boolean bl = true;
        for (n2 = 0; n2 < 24; ++n2) {
            for (n = 1; n < 5; ++n) {
                if (!this.rbS[n2][n].isSelected()) continue;
                ++n3;
            }
        }
        if (n3 > 0) {
            nArray = new int[n3];
            stringArray = new String[n3];
            n3 = 0;
            for (n2 = 0; n2 < 24; ++n2) {
                for (n = 1; n < 5; ++n) {
                    if (!this.rbS[n2][n].isSelected()) continue;
                    nArray[n3] = n;
                    stringArray[n3] = new String(lithConstants.SECONDARY[n2]);
                    ++n3;
                }
            }
        }
        while (bl) {
            bl = false;
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                if (nArray[n2] >= nArray[n2 + 1]) continue;
                bl = true;
                n4 = nArray[n2];
                string2 = new String(stringArray[n2]);
                nArray[n2] = nArray[n2 + 1];
                stringArray[n2] = new String(stringArray[n2 + 1]);
                nArray[n2 + 1] = n4;
                stringArray[n2 + 1] = new String(string2);
            }
        }
        this.second = new String("");
        for (n2 = 0; n2 < n3; ++n2) {
            switch (nArray[n2]) {
                case 1: {
                    string = new String("slightly " + stringArray[n2]);
                    break;
                }
                case 2: {
                    string = new String(stringArray[n2]);
                    break;
                }
                case 3: {
                    string = new String("very " + stringArray[n2]);
                    break;
                }
                case 4: {
                    string = new String("extremely " + stringArray[n2]);
                }
            }
            if (string.length() <= 0) continue;
            this.second = this.second.length() > 0 ? new String(this.second + ", " + string) : new String(string);
        }
        if (this.pNotifier != null) {
            this.pNotifier.notifyObservers(new String("Sedimentary Lithology Selected"));
        }
    }

    public void close() {
        this.pNotifier = null;
        this.notifier = null;
        this.sRock = null;
        this.sTexture = null;
        this.second = null;
        if (this.pSediments != null) {
            this.pSediments.close();
        }
        this.pSediments = null;
        if (this.pCarbonate != null) {
            this.pCarbonate.close();
        }
        this.pCarbonate = null;
        if (this.pChemical != null) {
            this.pChemical.close();
        }
        this.pChemical = null;
        if (this.pOrganic != null) {
            this.pOrganic.close();
        }
        this.pOrganic = null;
        this.pnlData = null;
        this.cardLayout = null;
        this.titledBorderEntry = null;
        this.rbSediments = null;
        this.rbCarbonate = null;
        this.rbChemical = null;
        this.rbOrganic = null;
        for (int i = 0; i < 24; ++i) {
            this.lblS[i] = null;
            for (int j = 0; j < 5; ++j) {
                this.rbS[i][j] = null;
            }
        }
        this.rbS = null;
        this.lblS = null;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.rbSediments) {
            this.setPanel(0);
        }
        if (actionEvent.getSource() == this.rbCarbonate) {
            this.setPanel(1);
        }
        if (actionEvent.getSource() == this.rbChemical) {
            this.setPanel(2);
        }
        if (actionEvent.getSource() == this.rbOrganic) {
            this.setPanel(3);
        }
        for (int i = 0; i < 24; ++i) {
            for (int j = 0; j < 5; ++j) {
                this.setSecondary();
            }
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        String string = new String((String)object);
        if (string.equals("Primary Sediments Selected")) {
            this.iRock = this.pSediments.getLithology();
            if (this.iRock > -1) {
                this.sRock = new String(lithConstants.PRIMARY[this.iRock][0]);
            }
            this.iTexture = this.pSediments.getTexture();
            this.sTexture = new String(this.pSediments.getTextureDesc());
            this.setPrimary(this.iRock);
            this.setSecondary();
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Sedimentary Lithology Selected"));
            }
        }
        if (string.equals("Primary Carbonates Selected")) {
            this.iRock = this.pCarbonate.getLithology();
            if (this.iRock > -1) {
                this.sRock = new String(lithConstants.PRIMARY[this.iRock][0]);
            }
            this.iTexture = this.pCarbonate.getTexture();
            this.sTexture = new String(this.pCarbonate.getTextureDesc());
            this.setPrimary(this.iRock);
            this.setSecondary();
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Sedimentary Lithology Selected"));
            }
        }
        if (string.equals("Primary Chemical Selected")) {
            this.iRock = this.pChemical.getLithology();
            if (this.iRock > -1) {
                this.sRock = new String(lithConstants.PRIMARY[this.iRock][0]);
            }
            this.iTexture = this.pChemical.getTexture();
            this.sTexture = new String(this.pChemical.getTextureDesc());
            this.setPrimary(this.iRock);
            this.setSecondary();
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Sedimentary Lithology Selected"));
            }
        }
        if (string.equals("Primary Organic Selected")) {
            this.iRock = this.pOrganic.getLithology();
            if (this.iRock > -1) {
                this.sRock = new String(lithConstants.PRIMARY[this.iRock][0]);
            }
            this.iTexture = this.pOrganic.getTexture();
            this.sTexture = new String(this.pOrganic.getTextureDesc());
            this.setPrimary(this.iRock);
            this.setSecondary();
            if (this.pNotifier != null) {
                this.pNotifier.notifyObservers(new String("Sedimentary Lithology Selected"));
            }
        }
    }
}

