/*
 * Decompiled with CFR 0.152.
 */
package lith.gui;

import cmn.cmnString;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import las.lasFileDataStruct;
import las.lasStandardTools;
import lith.gui.lithImageTrackFrameFocusAdapter;

public class lithImageTrackFrame
extends JFrame
implements ActionListener {
    private Observable notifier = null;
    private lasFileDataStruct stLAS = null;
    private int iTool = 0;
    private double dMinimum = 0.0;
    private double dMaximum = 150.0;
    public static final int _RT = 0;
    public static final int _PHIT = 1;
    private int iTrack = 0;
    private int iRt = 18;
    private double dRtMax = 2000.0;
    private double dRtMin = 0.0;
    private int iPhit = 8;
    private double dPhitMax = 0.3;
    private double dPhitMin = 0.0;
    private JButton btnOk = new JButton();
    private JButton btnCurves = new JButton();
    private JButton btnCancel = new JButton();
    private JTextField txtDescription = new JTextField();
    private JTextField txtMnemonic = new JTextField();
    private JTextField txtMinimum = new JTextField();
    private JTextField txtMaximum = new JTextField();
    private JFrame frame = null;
    private int iTotal = 0;
    private JRadioButton[] rb = null;
    private JButton btnClose = null;

    public lithImageTrackFrame(Observable observable, lasFileDataStruct lasFileDataStruct2) {
        try {
            this.notifier = observable;
            this.stLAS = lasFileDataStruct2;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        JPanel jPanel8 = new JPanel();
        TitledBorder titledBorder = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Mnemonic:");
        TitledBorder titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Description:");
        TitledBorder titledBorder3 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Minimum:");
        TitledBorder titledBorder4 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(165, 163, 151)), "Maximum:");
        titledBorder.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder2.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder3.setTitleFont(new Font("Dialog", 1, 11));
        titledBorder4.setTitleFont(new Font("Dialog", 1, 11));
        this.getContentPane().setLayout(new BorderLayout());
        this.setTitle("Resistivity & Porosity Image Track");
        this.rb = new JRadioButton[81];
        for (int i = 0; i < 81; ++i) {
            this.rb[i] = new JRadioButton();
            this.rb[i].setEnabled(false);
            this.rb[i].setFont(new Font("Dialog", 0, 11));
            this.rb[i].setText(lasStandardTools.LAS_TOOLS[i][1] + " - " + lasStandardTools.LAS_TOOLS[i][2]);
            this.rb[i].addActionListener(this);
        }
        jPanel2.setLayout(new GridLayout(2, 1));
        jPanel3.setLayout(new BorderLayout());
        jPanel3.setPreferredSize(new Dimension(110, 50));
        jPanel4.setBorder(titledBorder);
        jPanel4.setPreferredSize(new Dimension(100, 10));
        jPanel4.setLayout(new BorderLayout());
        this.txtMnemonic.setEditable(false);
        this.txtMnemonic.setText(lasStandardTools.LAS_TOOLS[0][1]);
        jPanel5.setBorder(titledBorder2);
        jPanel5.setLayout(new BorderLayout());
        this.txtDescription.setEditable(false);
        this.txtDescription.setText(lasStandardTools.LAS_TOOLS[0][2]);
        jPanel6.setLayout(new GridLayout());
        jPanel7.setBorder(titledBorder3);
        jPanel7.setLayout(new BorderLayout());
        this.txtMinimum.setText("" + this.dMinimum);
        this.txtMinimum.setHorizontalAlignment(11);
        this.txtMinimum.addFocusListener(new lithImageTrackFrameFocusAdapter(this));
        jPanel8.setBorder(titledBorder4);
        jPanel8.setLayout(new BorderLayout());
        this.txtMaximum.setText("" + this.dMaximum);
        this.txtMaximum.setHorizontalAlignment(11);
        this.txtMaximum.addFocusListener(new lithImageTrackFrameFocusAdapter(this));
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        this.btnOk.setFont(new Font("Dialog", 1, 11));
        this.btnOk.setPreferredSize(new Dimension(75, 25));
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(this);
        this.btnCurves.setFont(new Font("Dialog", 1, 11));
        this.btnCurves.setText("Select Log Curve");
        this.btnCurves.addActionListener(this);
        this.btnCancel.setFont(new Font("Dialog", 1, 11));
        this.btnCancel.setPreferredSize(new Dimension(75, 25));
        this.btnCancel.setText("Cancel");
        this.btnCancel.addActionListener(this);
        this.getContentPane().add((Component)jPanel, "South");
        jPanel.add((Component)this.btnOk, null);
        jPanel.add((Component)this.btnCurves, null);
        jPanel.add((Component)this.btnCancel, null);
        this.getContentPane().add((Component)jPanel2, "Center");
        jPanel2.add((Component)jPanel3, null);
        jPanel3.add((Component)jPanel4, "West");
        jPanel4.add((Component)this.txtMnemonic, "Center");
        jPanel3.add((Component)jPanel5, "Center");
        jPanel5.add((Component)this.txtDescription, "Center");
        jPanel2.add((Component)jPanel6, null);
        jPanel6.add((Component)jPanel7, null);
        jPanel7.add((Component)this.txtMinimum, "Center");
        jPanel6.add((Component)jPanel8, null);
        jPanel8.add((Component)this.txtMaximum, "Center");
        this.setSize(new Dimension(450, 200));
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dimension.width - this.getSize().width) / 2, (dimension.height - this.getSize().height) / 2);
        this.setResizable(false);
        this.setVisible(false);
    }

    private JPanel panelLogCurves() {
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        ButtonGroup buttonGroup = new ButtonGroup();
        JPanel[] jPanelArray = null;
        switch (this.iTrack) {
            case 0: {
                n = 14;
                n2 = 34;
                this.iTotal = 20;
                break;
            }
            case 1: {
                n = 7;
                n2 = 10;
                this.iTotal = 3;
            }
        }
        jPanel.setPreferredSize(new Dimension(10, 180));
        jPanel.setLayout(new BorderLayout());
        if (this.iTotal > 0) {
            jPanel2.setLayout(new GridLayout(this.iTotal, 1));
            jPanel2.setSize(100, this.iTotal * 20);
            jPanelArray = new JPanel[81];
            for (int i = 0; i < 81; ++i) {
                jPanelArray[i] = new JPanel();
                jPanelArray[i].setLayout(new BorderLayout());
                if (i == this.iTool) {
                    this.rb[i].setSelected(true);
                }
                this.rb[i].setEnabled(false);
                if (this.stLAS.checkData(i)) {
                    this.rb[i].setEnabled(true);
                }
                if (!(i >= n & i < n2)) continue;
                jPanelArray[i].add((Component)this.rb[i], "West");
                jPanel2.add((Component)jPanelArray[i], null);
                buttonGroup.add(this.rb[i]);
            }
            this.btnClose = new JButton();
            this.btnClose.setFont(new Font("Dialog", 1, 11));
            this.btnClose.setPreferredSize(new Dimension(75, 25));
            this.btnClose.setText("Close");
            this.btnClose.addActionListener(this);
            jPanel.add((Component)jScrollPane, "Center");
            jScrollPane.getViewport().add((Component)jPanel2, null);
            jPanel.add((Component)jPanel3, "South");
            jPanel3.add((Component)this.btnClose, null);
        }
        return jPanel;
    }

    private void displayCurves() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
        this.frame = new JFrame();
        switch (this.iTrack) {
            case 0: {
                this.frame.setTitle("Change Resistivity Curve");
                break;
            }
            case 1: {
                this.frame.setTitle("Change Porosity Curve");
            }
        }
        JPanel jPanel = this.panelLogCurves();
        this.frame.getContentPane().add((Component)jPanel, null);
        this.frame.setSize(200, 250);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.frame.setLocation((dimension.width - this.frame.getSize().width) / 2, (dimension.height - this.frame.getSize().height) / 2);
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    public int getTrack() {
        return this.iTrack;
    }

    public int getTool() {
        return this.iTool;
    }

    public double getMinimum() {
        return this.dMinimum;
    }

    public double getMaximum() {
        return this.dMaximum;
    }

    public void setTrack(int n) {
        this.iTrack = n;
        switch (n) {
            case 0: {
                this.iTool = this.iRt;
                this.dMinimum = this.dRtMin;
                this.dMaximum = this.dRtMax;
                break;
            }
            case 1: {
                this.iTool = this.iPhit;
                this.dMinimum = this.dPhitMin;
                this.dMaximum = this.dPhitMax;
            }
        }
        this.txtMnemonic.setText(lasStandardTools.LAS_TOOLS[this.iTool][1]);
        this.txtDescription.setText(lasStandardTools.LAS_TOOLS[this.iTool][2]);
        this.txtMinimum.setText("" + this.dMinimum);
        this.txtMaximum.setText("" + this.dMaximum);
    }

    public void setOHM(int n, double d, double d2) {
        this.iRt = n;
        this.dRtMax = d;
        this.dRtMin = d2;
    }

    public void setPHI(int n, double d, double d2) {
        this.iPhit = n;
        this.dPhitMax = d;
        this.dPhitMin = d2;
    }

    private void ok() {
        switch (this.iTrack) {
            case 0: {
                this.setOHM(this.iTool, this.dMaximum, this.dMinimum);
                break;
            }
            case 1: {
                this.setPHI(this.iTool, this.dMaximum, this.dMinimum);
            }
        }
        this.notifier.notifyObservers(new String("Image Track Changed"));
    }

    public void close() {
        this.notifier = null;
        this.stLAS = null;
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
        for (int i = 0; i < 81; ++i) {
            this.rb[i] = null;
        }
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        for (int i = 0; i < 81; ++i) {
            if (actionEvent.getSource() != this.rb[i]) continue;
            this.iTool = i;
            this.txtMnemonic.setText(lasStandardTools.LAS_TOOLS[this.iTool][1]);
            this.txtDescription.setText(lasStandardTools.LAS_TOOLS[this.iTool][2]);
        }
        if (actionEvent.getSource() == this.btnCurves) {
            this.displayCurves();
        }
        if (actionEvent.getSource() == this.btnOk) {
            this.ok();
        }
        if (actionEvent.getSource() == this.btnCancel) {
            this.setVisible(false);
        }
        if (actionEvent.getSource() == this.btnClose) {
            this.btnClose = null;
            this.frame.dispose();
        }
    }

    protected void focusLost(FocusEvent focusEvent) {
        boolean bl = false;
        String string = new String("");
        String string2 = new String("");
        if (focusEvent.getSource() == this.txtMinimum) {
            bl = true;
            string2 = this.txtMinimum.getText();
            string = new String("Minimum Value is a Numeric Field");
        }
        if (focusEvent.getSource() == this.txtMaximum) {
            bl = true;
            string2 = this.txtMaximum.getText();
            string = new String("Maximum Value is a Numeric Field");
        }
        if (bl) {
            if (!cmnString.isNumeric(string2)) {
                JOptionPane.showMessageDialog(null, string, "ERROR", 0);
            } else {
                if (focusEvent.getSource() == this.txtMinimum) {
                    this.dMinimum = cmnString.stringToDouble(this.txtMinimum.getText());
                }
                if (focusEvent.getSource() == this.txtMaximum) {
                    this.dMaximum = cmnString.stringToDouble(this.txtMaximum.getText());
                }
            }
        }
    }
}

