/*
 * Decompiled with CFR 0.152.
 */
package las3;

import cmn.cmnString;
import iqstrat.iqstratHeadersStruct;
import las.lasFileDataStruct;
import las3.las3ListStruct;
import las3.las3Struct;
import las3.las3Utility;

public class las3LoadWellHeader {
    public static final int _NONE = -1;
    public static final int _COMPANY = 0;
    public static final int _WELL = 1;
    public static final int _FIELD = 2;
    public static final int _SECTION = 3;
    public static final int _TOWNSHIP = 4;
    public static final int _RANGE = 5;
    public static final int _LOCATION = 6;
    public static final int _LOCATION_1 = 7;
    public static final int _LOCATION_2 = 8;
    public static final int _STATE = 9;
    public static final int _PROVINCE = 10;
    public static final int _COUNTRY = 11;
    public static final int _COUNTY = 12;
    public static final int _API = 13;
    public static final int _UWI = 14;
    public static final int _LICENSE = 15;
    public static final int _SERVICE = 16;
    public static final int _DATE = 17;
    public static final int _X = 18;
    public static final int _Y = 19;
    public static final int _LATI = 20;
    public static final int _LONG = 21;
    public static final int _GDAT = 22;
    public static final int _HZCS = 23;
    public static final int _UTM = 24;
    public static final int _STATUS = 25;
    public static final int _WELL_ROWS = 26;
    public static final int _WELL_COLS = 5;
    public static final String[][] WELL = new String[][]{{"COMP", "Company", "CN", "CN2", "COMPANY"}, {"WELL", "Well", "LEAS", "WN", "WELL"}, {"FLD", "Field", "FLD", "", "FIELD"}, {"SECT", "Section", "SECT2", "SEC", "SECTION"}, {"TOWN", "Township", "TOWN2", "", "TOWNSHIP"}, {"RANG", "Range", "RANG2", "", "RANGE"}, {"LOC", "Location", "LOC", "", "LOCATION"}, {"LOC1", "Location 1", "LOC1", "", "LOCATION 1"}, {"LOC2", "Location 2", "LOC2", "", "LOCATION 2"}, {"STAT", "State", "STAT2", "", "STATE"}, {"PROV", "Province", "PROV", "", "PROVINCE"}, {"CTRY", "Country", "NATI", "", "COUNTRY"}, {"CNTY", "County", "COUN", "", "COUNTY"}, {"API", "API-Number", "API", "API-NUMBER", "API NUMBER"}, {"UWI", "UNIQUE Well ID", "UWI", "", "UNIQUE WELL ID"}, {"LIC", "License Number", "LIC", "LICENSE", "LICENSE NUMBER"}, {"SRVC", "Service Company", "SRVC", "SERVICE", "SERVICE COMPANY"}, {"DATE", "Service Data", "DATE2", "", "SERVICE DATE"}, {"X", "X or East-West coordinate", "UTMX", "", ""}, {"Y", "Y or North South coordinate", "UTMY", "", ""}, {"LATI", "Latitude", "LAT", "LAT", "LATITUDE"}, {"LONG", "Longitude", "LNG", "LON", "LONGITUDE"}, {"GDAT", "Geodetic Datum", "", "GEODETIC", "GEODETIC DATUM"}, {"HZCS", "Horizontal Co-ordinate System", "", "", ""}, {"UTM", "UTM LOCATION", "", "", ""}, {"STUS", "Well Status", "", "", ""}};
    public static final int _GL = 0;
    public static final int _KB = 1;
    public static final int _DF = 2;
    public static final int _RT = 3;
    public static final int _DEPTHS_ROWS = 4;
    public static final int _DEPTHS_COLS = 6;
    public static final String[][] DEPTHS = new String[][]{{"GL", "Ground Level", "EGL", "EGL2", "G.L.", "GROUND LEVEL"}, {"KB", "Kelly Bushing", "EKB", "EKB2", "K.B.", "KELLY BUSHING"}, {"EDF", "Drilling Rig Floor", "EDF2", "DFE", "D.F.", "DRILLING RIG FLOOR"}, {"RT", "Rotary Table", "ERT", "R.T.", "ROTARY TABLE", ""}};
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;

    public static iqstratHeadersStruct getData(las3ListStruct las3ListStruct2) {
        iqstratHeadersStruct iqstratHeadersStruct2 = new iqstratHeadersStruct();
        las3Struct las3Struct2 = null;
        las3Struct las3Struct3 = null;
        int n = -1;
        int n2 = -1;
        if (las3ListStruct2 != null) {
            int n3;
            int n4;
            int n5;
            for (n5 = 0; n5 < las3ListStruct2.iCount; ++n5) {
                iqstratHeadersStruct2.iLAS = 1;
                if (las3Utility.isData(1, 0, las3ListStruct2)) {
                    las3Struct2 = las3Utility.getData(1, 0, las3ListStruct2);
                }
                if (las3Utility.isData(2, 0, las3ListStruct2)) {
                    las3Struct3 = las3Utility.getData(2, 0, las3ListStruct2);
                }
                if (las3Utility.isData(3, 0, las3ListStruct2)) {
                    iqstratHeadersStruct2.iCore = 1;
                }
                if (!las3Utility.isData(6, 0, las3ListStruct2)) continue;
                iqstratHeadersStruct2.iTops = 1;
            }
            if (las3Struct2 != null) {
                for (n5 = 0; n5 < las3Struct2.iParamRows; ++n5) {
                    n = -1;
                    for (n4 = 0; n4 < 26; ++n4) {
                        block49: for (n3 = 0; n3 < 5; ++n3) {
                            if (!las3Struct2.sParams[n5][0].toUpperCase().equals(WELL[n4][n3])) continue;
                            n = n4;
                            switch (n) {
                                case -1: {
                                    continue block49;
                                }
                                case 0: {
                                    iqstratHeadersStruct2.sOperator = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 1: {
                                    iqstratHeadersStruct2.sName = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 2: {
                                    iqstratHeadersStruct2.sField = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 6: {
                                    iqstratHeadersStruct2.sLocation = new String(las3Struct2.sParams[n5][2]);
                                    if (iqstratHeadersStruct2.iSection != 0) continue block49;
                                    iqstratHeadersStruct2 = las3LoadWellHeader.parseSTR(las3Struct2.sParams[n5][2], iqstratHeadersStruct2);
                                    continue block49;
                                }
                                case 7: {
                                    iqstratHeadersStruct2.sLocation1 = new String(las3Struct2.sParams[n5][2]);
                                    if (iqstratHeadersStruct2.iSection != 0) continue block49;
                                    iqstratHeadersStruct2 = las3LoadWellHeader.parseSTR(las3Struct2.sParams[n5][2], iqstratHeadersStruct2);
                                    continue block49;
                                }
                                case 8: {
                                    iqstratHeadersStruct2.sLocation2 = new String(las3Struct2.sParams[n5][2]);
                                    if (iqstratHeadersStruct2.iSection != 0) continue block49;
                                    iqstratHeadersStruct2 = las3LoadWellHeader.parseSTR(las3Struct2.sParams[n5][2], iqstratHeadersStruct2);
                                    continue block49;
                                }
                                case 3: {
                                    iqstratHeadersStruct2 = las3LoadWellHeader.parseSection(las3Struct2.sParams[n5][2], iqstratHeadersStruct2);
                                    continue block49;
                                }
                                case 4: {
                                    iqstratHeadersStruct2 = las3LoadWellHeader.parseTownship(las3Struct2.sParams[n5][2], iqstratHeadersStruct2);
                                    continue block49;
                                }
                                case 5: {
                                    iqstratHeadersStruct2 = las3LoadWellHeader.parseRange(las3Struct2.sParams[n5][2], iqstratHeadersStruct2);
                                    continue block49;
                                }
                                case 9: {
                                    iqstratHeadersStruct2.state = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 10: {
                                    iqstratHeadersStruct2.sProvince = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 11: {
                                    iqstratHeadersStruct2.sCountry = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 12: {
                                    iqstratHeadersStruct2.sCounty = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 13: {
                                    iqstratHeadersStruct2.sAPI = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 14: {
                                    iqstratHeadersStruct2.sUWI = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 15: {
                                    iqstratHeadersStruct2.sLicense = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 16: {
                                    iqstratHeadersStruct2.service = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 17: {
                                    iqstratHeadersStruct2.sDate = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 18: {
                                    if (!cmnString.isNumeric(las3Struct2.sParams[n5][2])) continue block49;
                                    iqstratHeadersStruct2.dUTMx = cmnString.stringToDouble(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 19: {
                                    if (!cmnString.isNumeric(las3Struct2.sParams[n5][2])) continue block49;
                                    iqstratHeadersStruct2.dUTMy = cmnString.stringToDouble(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 20: {
                                    iqstratHeadersStruct2.dLatitude = las3LoadWellHeader.parseDegrees(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 21: {
                                    iqstratHeadersStruct2.dLongitude = las3LoadWellHeader.parseDegrees(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 22: {
                                    iqstratHeadersStruct2.sGDAT = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 23: {
                                    iqstratHeadersStruct2.sHZCS = new String(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 24: {
                                    if (!cmnString.isNumeric(las3Struct2.sParams[n5][2])) continue block49;
                                    iqstratHeadersStruct2.dZone = cmnString.stringToDouble(las3Struct2.sParams[n5][2]);
                                    continue block49;
                                }
                                case 25: {
                                    iqstratHeadersStruct2.status = new String(las3Struct2.sParams[n5][2]);
                                }
                            }
                        }
                    }
                }
            }
            if (las3Struct3 != null) {
                for (n5 = 0; n5 < las3Struct3.iParamRows; ++n5) {
                    n = -1;
                    for (n4 = 0; n4 < 26; ++n4) {
                        block52: for (n3 = 0; n3 < 5; ++n3) {
                            if (!las3Struct3.sParams[n5][0].toUpperCase().equals(WELL[n4][n3])) continue;
                            n = n4;
                            switch (n) {
                                case -1: {
                                    continue block52;
                                }
                                case 18: {
                                    if (!cmnString.isNumeric(las3Struct3.sParams[n5][2])) continue block52;
                                    iqstratHeadersStruct2.dUTMx = cmnString.stringToDouble(las3Struct3.sParams[n5][2]);
                                    continue block52;
                                }
                                case 19: {
                                    if (!cmnString.isNumeric(las3Struct3.sParams[n5][2])) continue block52;
                                    iqstratHeadersStruct2.dUTMy = cmnString.stringToDouble(las3Struct3.sParams[n5][2]);
                                    continue block52;
                                }
                                case 20: {
                                    iqstratHeadersStruct2.dLatitude = las3LoadWellHeader.parseDegrees(las3Struct3.sParams[n5][2]);
                                    continue block52;
                                }
                                case 21: {
                                    iqstratHeadersStruct2.dLongitude = las3LoadWellHeader.parseDegrees(las3Struct3.sParams[n5][2]);
                                    continue block52;
                                }
                                case 22: {
                                    iqstratHeadersStruct2.sGDAT = new String(las3Struct3.sParams[n5][2]);
                                    continue block52;
                                }
                                case 23: {
                                    iqstratHeadersStruct2.sHZCS = new String(las3Struct3.sParams[n5][2]);
                                    continue block52;
                                }
                                case 24: {
                                    if (!cmnString.isNumeric(las3Struct3.sParams[n5][2])) continue block52;
                                    iqstratHeadersStruct2.dZone = cmnString.stringToDouble(las3Struct3.sParams[n5][2]);
                                }
                            }
                        }
                    }
                }
                for (n5 = 0; n5 < las3Struct3.iParamRows; ++n5) {
                    n2 = -1;
                    for (n4 = 0; n4 < 4; ++n4) {
                        block55: for (n3 = 0; n3 < 6; ++n3) {
                            if (!las3Struct3.sParams[n5][0].toUpperCase().equals(DEPTHS[n4][n3])) continue;
                            n2 = n4;
                            switch (n2) {
                                case -1: {
                                    continue block55;
                                }
                                case 0: {
                                    iqstratHeadersStruct2.dGL = las3LoadWellHeader.convertMtoF(las3Struct3.sParams[n5][2], las3Struct3.sParams[n5][1]);
                                    continue block55;
                                }
                                case 1: {
                                    iqstratHeadersStruct2.dKB = las3LoadWellHeader.convertMtoF(las3Struct3.sParams[n5][2], las3Struct3.sParams[n5][1]);
                                    continue block55;
                                }
                                case 2: {
                                    iqstratHeadersStruct2.dDF = las3LoadWellHeader.convertMtoF(las3Struct3.sParams[n5][2], las3Struct3.sParams[n5][1]);
                                    continue block55;
                                }
                                case 3: {
                                    iqstratHeadersStruct2.dRT = las3LoadWellHeader.convertMtoF(las3Struct3.sParams[n5][2], las3Struct3.sParams[n5][1]);
                                }
                            }
                        }
                    }
                }
            }
        }
        return iqstratHeadersStruct2;
    }

    public static iqstratHeadersStruct parseSTR(String string, iqstratHeadersStruct iqstratHeadersStruct2) {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String[] stringArray = null;
        String string5 = new String("[ ]+");
        if (string != null && iqstratHeadersStruct2 != null && string.length() > 0 && (stringArray = (string2 = new String(string.replace('-', ' '))).split(string5)).length == 3) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (cmnString.isNumeric(stringArray[i])) {
                    iqstratHeadersStruct2.iSection = cmnString.stringToInt(stringArray[i].trim());
                }
                string2 = new String(stringArray[i].trim());
                string3 = new String(string2.substring(0, string2.length() - 1));
                string4 = new String(string2.substring(string2.length() - 1, string2.length()));
                if (cmnString.isNumeric(string3) && (string4.equals("S") || string4.equals("N"))) {
                    iqstratHeadersStruct2.iTownship = cmnString.stringToInt(string3);
                    iqstratHeadersStruct2.sTownship = new String(string4);
                }
                if (!cmnString.isNumeric(string3) || !string4.equals("E") && !string4.equals("W")) continue;
                iqstratHeadersStruct2.iRange = cmnString.stringToInt(string3);
                iqstratHeadersStruct2.sRange = new String(string4);
            }
        }
        return iqstratHeadersStruct2;
    }

    public static iqstratHeadersStruct parseSection(String string, iqstratHeadersStruct iqstratHeadersStruct2) {
        if (string != null && iqstratHeadersStruct2 != null && string.length() > 0) {
            iqstratHeadersStruct2.iSection = cmnString.stringToInt(string);
        }
        return iqstratHeadersStruct2;
    }

    public static iqstratHeadersStruct parseTownship(String string, iqstratHeadersStruct iqstratHeadersStruct2) {
        String string2 = "";
        String string3 = "";
        if (string != null && iqstratHeadersStruct2 != null && string.length() > 0) {
            string2 = new String(string.substring(0, string.length() - 1));
            string3 = new String(string.substring(string.length() - 1, string.length()));
            if (cmnString.isNumeric(string2) && (string3.equals("S") || string3.equals("N"))) {
                iqstratHeadersStruct2.iTownship = cmnString.stringToInt(string2);
                iqstratHeadersStruct2.sTownship = new String(string3);
            }
        }
        return iqstratHeadersStruct2;
    }

    public static iqstratHeadersStruct parseRange(String string, iqstratHeadersStruct iqstratHeadersStruct2) {
        String string2 = "";
        String string3 = "";
        if (string != null && iqstratHeadersStruct2 != null && string.length() > 0) {
            string2 = new String(string.substring(0, string.length() - 1));
            string3 = new String(string.substring(string.length() - 1, string.length()));
            if (cmnString.isNumeric(string2) && (string3.equals("E") || string3.equals("W"))) {
                iqstratHeadersStruct2.iRange = cmnString.stringToInt(string2);
                iqstratHeadersStruct2.sRange = new String(string3);
            }
        }
        return iqstratHeadersStruct2;
    }

    public static double parseDegrees(String string) {
        String string2 = "";
        String string3 = "";
        double d = 0.0;
        int n = 0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        String[] stringArray = null;
        String string4 = new String("[ ]+");
        if (string.length() > 0) {
            stringArray = string.trim().split(string4);
            if (stringArray.length == 3) {
                string2 = new String(stringArray[0].trim());
                string3 = new String(string2.substring(0, string2.length() - 1));
                if (cmnString.isNumeric(string3)) {
                    d2 = cmnString.stringToDouble(string3.trim());
                }
                if (cmnString.isNumeric(string3 = new String((string2 = new String(stringArray[1].trim())).substring(0, string2.length() - 1)))) {
                    d3 = cmnString.stringToDouble(string3.trim());
                }
                if (cmnString.isNumeric(string3 = new String((string2 = new String(stringArray[2].trim())).substring(0, string2.length() - 1)))) {
                    d4 = cmnString.stringToDouble(string3.trim());
                }
                d = d2 + d3 / 60.0 + d4 / 3600.0;
            } else if (cmnString.isNumeric(string.trim())) {
                d = cmnString.stringToDouble(string.trim());
            }
            n = (int)(d * 10000.0);
            d = (double)n / 10000.0;
        }
        return d;
    }

    public static double convertMtoF(String string, String string2) {
        double d = 0.0;
        double d2 = 3.281;
        int n = 0;
        if (string.length() > 0 && cmnString.isNumeric(string.trim())) {
            d = cmnString.stringToDouble(string.trim());
            if (string2.equals("M")) {
                d = d2 * d;
            }
            n = (int)(d * 1000.0);
            d = (double)n / 1000.0;
        }
        return d;
    }

    public static String removeChar(String string, char c) {
        String string2 = new String("");
        char[] cArray = null;
        if (string != null) {
            cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == c) continue;
                string2 = new String(string2 + cArray[i]);
            }
        }
        return string2;
    }

    public static iqstratHeadersStruct normalizeDepth(iqstratHeadersStruct iqstratHeadersStruct2, lasFileDataStruct lasFileDataStruct2) {
        double d = 15.0;
        if (iqstratHeadersStruct2 != null && lasFileDataStruct2 != null) {
            if (lasFileDataStruct2.sPDAT.length() == 0) {
                if (iqstratHeadersStruct2.dGL > 0.0 && iqstratHeadersStruct2.dKB == 0.0) {
                    iqstratHeadersStruct2.dKB = iqstratHeadersStruct2.dGL + d;
                } else if (iqstratHeadersStruct2.dGL == 0.0 && iqstratHeadersStruct2.dKB > 0.0) {
                    iqstratHeadersStruct2.dGL = iqstratHeadersStruct2.dKB - d;
                } else if (iqstratHeadersStruct2.dGL == 0.0 && iqstratHeadersStruct2.dDF > 0.0) {
                    iqstratHeadersStruct2.dGL = iqstratHeadersStruct2.dDF - d;
                }
            } else if (iqstratHeadersStruct2.dGL == 0.0 && iqstratHeadersStruct2.dKB == 0.0 && iqstratHeadersStruct2.dDF == 0.0) {
                if (lasFileDataStruct2.sDREF.equals("KB") && lasFileDataStruct2.sPDAT.equals("GL")) {
                    iqstratHeadersStruct2.dGL = lasFileDataStruct2.dElevation - lasFileDataStruct2.dAPD;
                    iqstratHeadersStruct2.dKB = lasFileDataStruct2.dElevation;
                } else if (lasFileDataStruct2.sDREF.equals("DF") && lasFileDataStruct2.sPDAT.equals("GL")) {
                    iqstratHeadersStruct2.dGL = lasFileDataStruct2.dElevation - lasFileDataStruct2.dAPD;
                    iqstratHeadersStruct2.dDF = lasFileDataStruct2.dElevation;
                } else if (lasFileDataStruct2.sDREF.equals("GL")) {
                    iqstratHeadersStruct2.dGL = lasFileDataStruct2.dElevation;
                } else if (lasFileDataStruct2.sDREF.equals("KB")) {
                    iqstratHeadersStruct2.dGL = lasFileDataStruct2.dElevation - lasFileDataStruct2.dAPD;
                    iqstratHeadersStruct2.dKB = lasFileDataStruct2.dElevation;
                } else if (lasFileDataStruct2.sDREF.equals("DF")) {
                    iqstratHeadersStruct2.dGL = lasFileDataStruct2.dElevation - lasFileDataStruct2.dAPD;
                    iqstratHeadersStruct2.dDF = lasFileDataStruct2.dElevation;
                }
            }
            if (lasFileDataStruct2.dTDD > 0.0) {
                iqstratHeadersStruct2.depth = lasFileDataStruct2.dTDD;
            } else if (lasFileDataStruct2.dTLD > 0.0) {
                iqstratHeadersStruct2.depth = lasFileDataStruct2.dTLD;
            }
        }
        return iqstratHeadersStruct2;
    }
}

