/*
 * Decompiled with CFR 0.152.
 */
package las3;

import cmn.cmnLASCurveListStruct;
import cmn.cmnString;
import las.lasFileDataStruct;
import las.lasFileDataUtility;
import las.lasStandardTools;
import las3.las3Constants;
import las3.las3Struct;
import lith.lithology.lithologySymbolsListStruct;
import lith.lithology.lithologySymbolsUtility;
import pfeffer.math.pfefferMath;
import pfeffer.math.pfefferSwModels;
import pfeffer.pfefferDataListStruct;
import pfeffer.pfefferDataStruct;
import pfeffer.pfefferDataUtility;
import pfeffer.pfefferStandardTools;

public class las3LoadPfefferData {
    public static final int _NONE = -1;
    public static final int _IQ_KGS = 0;
    public static final int _PF_SRC = 1;
    public static final int _PF_NEW = 2;
    public static final int _PF_SAVE = 3;
    public static final int _PARAM_ROWS = 4;
    public static final int _PARAM_COLS = 5;
    public static final String[][] PARAM = new String[][]{{"IQKGS", "Profile Web App Saved Data Indicator", "", ""}, {"PF_SRC", "PfEFFER Source (Owner, Group, etc.)", "", "S"}, {"PF_NEW", "Date Created", "DATE", "D"}, {"PF_SAVE", "Date Last Saved", "DATE", "D"}};
    public static final int _MNEMONIC = 0;
    public static final int _UNIT = 1;
    public static final int _VALUE = 2;
    public static final int _DESCRIPTION = 3;
    public static final int _FORMAT = 4;
    public static final int _ASSOCIATION = 5;

    public static pfefferDataListStruct getData(las3Struct las3Struct2) {
        pfefferDataListStruct pfefferDataListStruct2 = new pfefferDataListStruct();
        int n = -1;
        if (las3Struct2 != null) {
            for (int i = 0; i < las3Struct2.iParamRows; ++i) {
                n = -1;
                block8: for (int j = 0; j < 4; ++j) {
                    if (!las3Struct2.sParams[i][0].toUpperCase().equals(PARAM[j][0])) continue;
                    n = j;
                    switch (n) {
                        case -1: {
                            continue block8;
                        }
                        case 0: {
                            pfefferDataListStruct2.sKGS = new String("YES");
                            continue block8;
                        }
                        case 1: {
                            pfefferDataListStruct2.source = new String(las3Struct2.sParams[i][2]);
                            continue block8;
                        }
                        case 2: {
                            pfefferDataListStruct2.sCreated = new String(las3Struct2.sParams[i][2]);
                            continue block8;
                        }
                        case 3: {
                            pfefferDataListStruct2.savedLast = new String(las3Struct2.sParams[i][2]);
                        }
                    }
                }
            }
        }
        return pfefferDataListStruct2;
    }

    public static pfefferDataListStruct loadData(double d, las3Struct las3Struct2, cmnLASCurveListStruct cmnLASCurveListStruct2, lasFileDataStruct lasFileDataStruct2, lithologySymbolsListStruct lithologySymbolsListStruct2, pfefferDataListStruct pfefferDataListStruct2) {
        pfefferDataListStruct pfefferDataListStruct3 = null;
        String string = "0";
        int n = -1;
        if (las3Struct2 != null && pfefferDataListStruct2 != null && lasFileDataStruct2 != null && cmnLASCurveListStruct2 != null) {
            pfefferDataListStruct3 = pfefferDataUtility.copyList(pfefferDataListStruct2);
            pfefferDataListStruct2.delete();
            pfefferDataListStruct2 = null;
            if (pfefferDataListStruct3 == null) {
                pfefferDataListStruct3 = new pfefferDataListStruct();
            }
            if (las3Struct2.iRows > 0) {
                pfefferDataListStruct3.stItem = new pfefferDataStruct[las3Struct2.iRows];
                pfefferDataListStruct3.iCount = las3Struct2.iRows;
                for (int i = 0; i < las3Struct2.iRows; ++i) {
                    pfefferDataListStruct3.stItem[i] = new pfefferDataStruct();
                    for (int j = 0; j < las3Struct2.iColumns; ++j) {
                        n = -1;
                        for (int k = 0; k < cmnLASCurveListStruct2.iCount; ++k) {
                            if (!las3Struct2.sCurves[j][0].equals(cmnLASCurveListStruct2.stItem[k].sMnemonic)) continue;
                            n = k;
                        }
                        if (n <= -1) continue;
                        pfefferDataListStruct3.stItem[i] = las3LoadPfefferData.addFlowData(d, cmnLASCurveListStruct2.stItem[n].sMnemonic, las3Struct2.sData[i][j], lithologySymbolsListStruct2, pfefferDataListStruct3.stItem[i]);
                    }
                }
            }
        }
        return pfefferDataListStruct3;
    }

    public static pfefferDataStruct addFlowData(double d, String string, String string2, lithologySymbolsListStruct lithologySymbolsListStruct2, pfefferDataStruct pfefferDataStruct2) {
        int n = 0;
        int n2 = pfefferStandardTools.getPRow(1, string);
        String string3 = "";
        String string4 = new String("" + d);
        int n3 = -1;
        if (pfefferDataStruct2 != null) {
            switch (n2) {
                case 0: {
                    pfefferDataStruct2.sKEY = new String(string2);
                    break;
                }
                case 1: {
                    if (string2.equals(string4)) break;
                    pfefferDataStruct2.sZone = new String(string2);
                    break;
                }
                case 2: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.depthStart = cmnString.stringToDouble(string2);
                    break;
                }
                case 3: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.depthEnd = cmnString.stringToDouble(string2);
                    break;
                }
                case 4: {
                    n3 = lithologySymbolsUtility.getLithology(string2, lithologySymbolsListStruct2);
                    for (int i = 0; i < lithologySymbolsListStruct2.iCount; ++i) {
                        if (n3 != lithologySymbolsListStruct2.stItem[i].id) continue;
                        pfefferDataStruct2.iLithology = i;
                    }
                    break;
                }
                case 5: {
                    for (n = 0; n < 3; ++n) {
                        if (!string2.equals(pfefferSwModels.WATER_MODEL[n])) continue;
                        pfefferDataStruct2.iWaterModel = n;
                        pfefferDataStruct2.sWaterModel = new String(string2);
                    }
                    break;
                }
                case 6: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.A = cmnString.stringToDouble(string2);
                    break;
                }
                case 7: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.M = cmnString.stringToDouble(string2);
                    break;
                }
                case 8: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.N = cmnString.stringToDouble(string2);
                    break;
                }
                case 9: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.Rw = cmnString.stringToDouble(string2);
                    break;
                }
                case 10: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.Rsh = cmnString.stringToDouble(string2);
                    break;
                }
                case 11: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.Phish = cmnString.stringToDouble(string2);
                    break;
                }
                case 12: {
                    for (n = 0; n < 71; ++n) {
                        if (!string2.equals(lasStandardTools.LAS_TOOLS[n][1])) continue;
                        pfefferDataStruct2.iRt = n;
                    }
                    break;
                }
                case 13: {
                    for (n = 0; n < 71; ++n) {
                        if (!string2.equals(lasStandardTools.LAS_TOOLS[n][1])) continue;
                        pfefferDataStruct2.iRxo = n;
                    }
                    break;
                }
                case 14: {
                    for (n = 0; n < 71; ++n) {
                        if (!string2.equals(lasStandardTools.LAS_TOOLS[n][1])) continue;
                        pfefferDataStruct2.iVsh = n;
                    }
                    break;
                }
                case 15: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dClean = cmnString.stringToDouble(string2);
                    break;
                }
                case 16: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dShale = cmnString.stringToDouble(string2);
                    break;
                }
                case 17: {
                    for (n = 0; n < 4; ++n) {
                        if (!string2.equals(pfefferMath.PHI_TYPE[n])) continue;
                        pfefferDataStruct2.iPHIt = n;
                    }
                    break;
                }
                case 18: {
                    for (n = 0; n < 71; ++n) {
                        if (!string2.equals(lasStandardTools.LAS_TOOLS[n][1])) continue;
                        pfefferDataStruct2.iPHI1 = n;
                    }
                    break;
                }
                case 19: {
                    for (n = 0; n < 71; ++n) {
                        if (!string2.equals(lasStandardTools.LAS_TOOLS[n][1])) continue;
                        pfefferDataStruct2.iPHI2 = n;
                    }
                    break;
                }
                case 20: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dGrain = cmnString.stringToDouble(string2);
                    break;
                }
                case 21: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dFluid = cmnString.stringToDouble(string2);
                    break;
                }
                case 22: {
                    pfefferDataStruct2.iPHIVsh = 0;
                    if (!string2.equals("YES")) break;
                    pfefferDataStruct2.iPHIVsh = 1;
                    break;
                }
                case 23: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dPHIShale1 = cmnString.stringToDouble(string2);
                    break;
                }
                case 24: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dPHIShale2 = cmnString.stringToDouble(string2);
                    break;
                }
                case 25: {
                    for (n = 0; n < 71; ++n) {
                        if (!string2.equals(lasStandardTools.LAS_TOOLS[n][1])) continue;
                        pfefferDataStruct2.iPHI2nd = n;
                    }
                    break;
                }
                case 26: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dtGrain = cmnString.stringToDouble(string2);
                    break;
                }
                case 27: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dtFluid = cmnString.stringToDouble(string2);
                    break;
                }
                case 28: {
                    pfefferDataStruct2.iPHI2ndVsh = 0;
                    if (!string2.equals("YES")) break;
                    pfefferDataStruct2.iPHI2ndVsh = 1;
                    break;
                }
                case 29: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dPHI2ndShale = cmnString.stringToDouble(string2);
                    break;
                }
                case 30: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dPhiCut = cmnString.stringToDouble(string2);
                    break;
                }
                case 31: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dSwCut = cmnString.stringToDouble(string2);
                    break;
                }
                case 32: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dVshCut = cmnString.stringToDouble(string2);
                    break;
                }
                case 33: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dBvwCut = cmnString.stringToDouble(string2);
                    break;
                }
                case 34: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.P = cmnString.stringToDouble(string2);
                    break;
                }
                case 35: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.Q = cmnString.stringToDouble(string2);
                    break;
                }
                case 36: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.R = cmnString.stringToDouble(string2);
                    break;
                }
                case 37: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dThickness = cmnString.stringToDouble(string2);
                    break;
                }
                case 38: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dHydroCarbon = cmnString.stringToDouble(string2);
                    break;
                }
                case 39: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dPay = cmnString.stringToDouble(string2);
                    break;
                }
                case 40: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dPorosity = cmnString.stringToDouble(string2);
                    break;
                }
                case 41: {
                    if (string2.equals(string4) || !cmnString.isNumeric(string2)) break;
                    pfefferDataStruct2.dSaturation = cmnString.stringToDouble(string2);
                }
            }
        }
        return pfefferDataStruct2;
    }

    public static pfefferDataStruct getDepths(lasFileDataStruct lasFileDataStruct2, pfefferDataStruct pfefferDataStruct2) {
        boolean bl = false;
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null && pfefferDataStruct2 != null) {
            lasFileDataStruct3 = lasFileDataUtility.copy(lasFileDataStruct2);
            if (pfefferDataStruct2.depthEnd > 0.0 && lasFileDataStruct3 != null) {
                if (lasFileDataStruct3.iRows > 0) {
                    pfefferDataStruct2.iRows = pfefferMath.getRowCount(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep);
                    pfefferDataStruct2.depth = pfefferMath.getDepth(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep, lasFileDataStruct3);
                    pfefferDataStruct2.thick = pfefferMath.getThickness(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep);
                }
                lasFileDataStruct3.delete();
                lasFileDataStruct3 = null;
            }
        }
        return pfefferDataStruct2;
    }

    public static pfefferDataStruct getRt(lasFileDataStruct lasFileDataStruct2, pfefferDataStruct pfefferDataStruct2) {
        int n = 0;
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null && pfefferDataStruct2 != null) {
            n = pfefferDataStruct2.iRows;
            lasFileDataStruct3 = lasFileDataUtility.copy(lasFileDataStruct2);
            if (pfefferDataStruct2.iRt != -1 && pfefferDataStruct2.depthEnd > 0.0 && lasFileDataStruct3 != null) {
                if (lasFileDataStruct3.iRows > 0) {
                    pfefferDataStruct2.Rt = pfefferMath.getRt(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep, pfefferDataStruct2.iRt, lasFileDataStruct3);
                    pfefferDataStruct2.Rtc = pfefferMath.getRt(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep, pfefferDataStruct2.iRt, lasFileDataStruct3);
                }
                lasFileDataStruct3.delete();
                lasFileDataStruct3 = null;
            }
        }
        return pfefferDataStruct2;
    }

    public static pfefferDataStruct getRxo(lasFileDataStruct lasFileDataStruct2, pfefferDataStruct pfefferDataStruct2) {
        int n = 0;
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null && pfefferDataStruct2 != null) {
            n = pfefferDataStruct2.iRows;
            lasFileDataStruct3 = lasFileDataUtility.copy(lasFileDataStruct2);
            if (pfefferDataStruct2.iRt != -1 && pfefferDataStruct2.depthEnd > 0.0 && lasFileDataStruct3 != null) {
                if (lasFileDataStruct3.iRows > 0) {
                    pfefferDataStruct2.Rxo = pfefferMath.getRt(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep, pfefferDataStruct2.iRxo, lasFileDataStruct3);
                }
                lasFileDataStruct3.delete();
                lasFileDataStruct3 = null;
            }
        }
        return pfefferDataStruct2;
    }

    public static pfefferDataStruct getVsh(lasFileDataStruct lasFileDataStruct2, pfefferDataStruct pfefferDataStruct2) {
        int n = 0;
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null && pfefferDataStruct2 != null) {
            n = pfefferDataStruct2.iRows;
            lasFileDataStruct3 = lasFileDataUtility.copy(lasFileDataStruct2);
            if (pfefferDataStruct2.iVsh != -1 && pfefferDataStruct2.depthEnd > 0.0 && lasFileDataStruct3 != null) {
                if (lasFileDataStruct3.iRows > 0) {
                    pfefferDataStruct2.Vsh = pfefferMath.getVsh(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep, pfefferDataStruct2.iVsh, pfefferDataStruct2.dClean, pfefferDataStruct2.dShale, lasFileDataStruct3);
                }
                lasFileDataStruct3.delete();
                lasFileDataStruct3 = null;
            }
        }
        return pfefferDataStruct2;
    }

    public static pfefferDataStruct getPHIt(lasFileDataStruct lasFileDataStruct2, pfefferDataStruct pfefferDataStruct2) {
        int n = 0;
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null && pfefferDataStruct2 != null) {
            n = pfefferDataStruct2.iRows;
            lasFileDataStruct3 = lasFileDataUtility.copy(lasFileDataStruct2);
            if (pfefferDataStruct2.iPHIt != -1 && pfefferDataStruct2.depthEnd > 0.0 && lasFileDataStruct3 != null) {
                if (lasFileDataStruct3.iRows > 0) {
                    pfefferDataStruct2.PHIt = pfefferMath.getPHIt(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep, pfefferDataStruct2.iPHIt, pfefferDataStruct2.iPHI1, pfefferDataStruct2.iPHI2, pfefferDataStruct2.dGrain, pfefferDataStruct2.dFluid, pfefferDataStruct2.dPHIShale1, pfefferDataStruct2.dPHIShale2, pfefferDataStruct2.iPHIVsh, pfefferDataStruct2.Vsh, lasFileDataStruct3);
                    pfefferDataStruct2.PHI1st = new double[lasFileDataStruct3.iRows];
                    pfefferDataStruct2.PHI2nd = new double[lasFileDataStruct3.iRows];
                    for (int i = 0; i < lasFileDataStruct3.iRows; ++i) {
                        pfefferDataStruct2.PHI1st[i] = 0.0;
                        pfefferDataStruct2.PHI2nd[i] = 0.0;
                    }
                }
                lasFileDataStruct3.delete();
                lasFileDataStruct3 = null;
            }
        }
        pfefferDataStruct2 = las3LoadPfefferData.get2ndPHI(lasFileDataStruct2, pfefferDataStruct2);
        return pfefferDataStruct2;
    }

    public static pfefferDataStruct get2ndPHI(lasFileDataStruct lasFileDataStruct2, pfefferDataStruct pfefferDataStruct2) {
        int n = 0;
        Object var3_3 = null;
        Object var4_4 = null;
        Object var5_5 = null;
        Object var6_6 = null;
        lasFileDataStruct lasFileDataStruct3 = null;
        if (lasFileDataStruct2 != null && pfefferDataStruct2 != null) {
            n = pfefferDataStruct2.iRows;
            lasFileDataStruct3 = lasFileDataUtility.copy(lasFileDataStruct2);
            if (pfefferDataStruct2.iPHI2nd != -1 && pfefferDataStruct2.depthEnd > 0.0 && lasFileDataStruct3 != null) {
                if (lasFileDataStruct3.iRows > 0) {
                    pfefferDataStruct2.PHI1st = pfefferMath.getPHIt(pfefferDataStruct2.depthStart, pfefferDataStruct2.depthEnd, lasFileDataStruct3.depthStep, 3, pfefferDataStruct2.iPHI2nd, -1, pfefferDataStruct2.dtGrain, pfefferDataStruct2.dtFluid, pfefferDataStruct2.dPHI2ndShale, 0.0, pfefferDataStruct2.iPHI2ndVsh, pfefferDataStruct2.Vsh, lasFileDataStruct3);
                    pfefferDataStruct2.PHI2nd = pfefferMath.get2ndPHI(pfefferDataStruct2.iRows, pfefferDataStruct2.PHI1st, pfefferDataStruct2.PHIt);
                }
                lasFileDataStruct3.delete();
                lasFileDataStruct3 = null;
            }
        }
        return pfefferDataStruct2;
    }

    public static las3Struct setFlowData(pfefferDataListStruct pfefferDataListStruct2, double d, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        las3Struct las3Struct2 = null;
        if (pfefferDataListStruct2 != null) {
            las3Struct2 = new las3Struct();
            las3Struct2.iType = 13;
            las3Struct2.iArray = 0;
            las3Struct2.sType = new String(las3Constants.SECTIONS[las3Struct2.iType]);
            las3Struct2 = las3LoadPfefferData.addParameters(pfefferDataListStruct2, las3Struct2);
            las3Struct2 = las3LoadPfefferData.addCurves(pfefferDataListStruct2, las3Struct2, d, lithologySymbolsListStruct2);
        }
        return las3Struct2;
    }

    public static las3Struct addParameters(pfefferDataListStruct pfefferDataListStruct2, las3Struct las3Struct2) {
        String string = "";
        if (pfefferDataListStruct2 != null && las3Struct2 != null) {
            int n;
            las3Struct2.iParamRows = 4;
            las3Struct2.iParamCols = 6;
            las3Struct2.sParams = new String[las3Struct2.iParamRows][las3Struct2.iParamCols];
            for (n = 0; n < las3Struct2.iParamRows; ++n) {
                for (int i = 0; i < 6; ++i) {
                    las3Struct2.sParams[n][i] = new String("");
                }
            }
            block8: for (n = 0; n < las3Struct2.iParamRows; ++n) {
                las3Struct2.sParams[n][0] = new String(PARAM[n][0]);
                las3Struct2.sParams[n][3] = new String(PARAM[n][1]);
                las3Struct2.sParams[n][1] = new String(PARAM[n][2]);
                las3Struct2.sParams[n][4] = new String(PARAM[n][3]);
                switch (n) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        las3Struct2.sParams[n][2] = new String(pfefferDataListStruct2.source);
                        continue block8;
                    }
                    case 2: {
                        string = cmnString.getDate();
                        if (pfefferDataListStruct2.sCreated.length() > 0) {
                            string = pfefferDataListStruct2.sCreated;
                        }
                        las3Struct2.sParams[n][2] = new String(string);
                        continue block8;
                    }
                    case 3: {
                        string = cmnString.getDate();
                        las3Struct2.sParams[n][2] = new String(string);
                    }
                }
            }
        }
        return las3Struct2;
    }

    public static las3Struct addCurves(pfefferDataListStruct pfefferDataListStruct2, las3Struct las3Struct2, double d, lithologySymbolsListStruct lithologySymbolsListStruct2) {
        int n = 0;
        String string = "";
        String string2 = "";
        double d2 = 0.0;
        if (pfefferDataListStruct2 != null && las3Struct2 != null) {
            int n2;
            las3Struct2.iCurveRows = 42;
            las3Struct2.iCurveCols = 6;
            las3Struct2.sCurves = new String[las3Struct2.iCurveRows][las3Struct2.iCurveCols];
            for (int i = 0; i < 42; ++i) {
                for (n2 = 0; n2 < 6; ++n2) {
                    las3Struct2.sCurves[n][n2] = new String("");
                }
                las3Struct2.sCurves[n][0] = new String(pfefferStandardTools.P_CURVES[i][1]);
                las3Struct2.sCurves[n][1] = new String(pfefferStandardTools.P_CURVES[i][3]);
                las3Struct2.sCurves[n][3] = new String(pfefferStandardTools.P_CURVES[i][2]);
                las3Struct2.sCurves[n][4] = new String(pfefferStandardTools.P_CURVES[i][6]);
                ++n;
            }
            las3Struct2.iRows = pfefferDataListStruct2.iCount;
            las3Struct2.iColumns = las3Struct2.iCurveRows;
            las3Struct2.sData = new String[las3Struct2.iRows][las3Struct2.iColumns];
            for (n2 = 0; n2 < pfefferDataListStruct2.iCount; ++n2) {
                las3Struct2.sData[n2][0] = new String(pfefferDataListStruct2.stItem[n2].sKEY);
                string2 = pfefferDataListStruct2.stItem[n2].sZone;
                if ((double)string2.length() == 0.0) {
                    string2 = "" + d;
                }
                las3Struct2.sData[n2][1] = new String(string2);
                las3Struct2.sData[n2][2] = new String("" + pfefferDataListStruct2.stItem[n2].depthStart);
                las3Struct2.sData[n2][3] = new String("" + pfefferDataListStruct2.stItem[n2].depthEnd);
                las3Struct2.sData[n2][4] = new String("" + d);
                if (lithologySymbolsListStruct2 != null && pfefferDataListStruct2.stItem[n2].iLithology != -1) {
                    las3Struct2.sData[n2][4] = new String(lithologySymbolsListStruct2.stItem[pfefferDataListStruct2.stItem[n2].iLithology].sName);
                }
                las3Struct2.sData[n2][5] = new String(pfefferDataListStruct2.stItem[n2].sWaterModel);
                las3Struct2.sData[n2][6] = new String("" + pfefferDataListStruct2.stItem[n2].A);
                las3Struct2.sData[n2][7] = new String("" + pfefferDataListStruct2.stItem[n2].M);
                las3Struct2.sData[n2][8] = new String("" + pfefferDataListStruct2.stItem[n2].N);
                las3Struct2.sData[n2][9] = new String("" + pfefferDataListStruct2.stItem[n2].Rw);
                las3Struct2.sData[n2][10] = new String("" + pfefferDataListStruct2.stItem[n2].Rsh);
                las3Struct2.sData[n2][11] = new String("" + pfefferDataListStruct2.stItem[n2].Phish);
                las3Struct2.sData[n2][12] = new String("" + d);
                if (pfefferDataListStruct2.stItem[n2].iRt > -1) {
                    las3Struct2.sData[n2][12] = new String(lasStandardTools.LAS_TOOLS[pfefferDataListStruct2.stItem[n2].iRt][1]);
                }
                las3Struct2.sData[n2][13] = new String("" + d);
                if (pfefferDataListStruct2.stItem[n2].iRxo > -1) {
                    las3Struct2.sData[n2][13] = new String(lasStandardTools.LAS_TOOLS[pfefferDataListStruct2.stItem[n2].iRxo][1]);
                }
                las3Struct2.sData[n2][14] = new String("" + d);
                las3Struct2.sData[n2][15] = new String("" + d);
                las3Struct2.sData[n2][16] = new String("" + d);
                if (pfefferDataListStruct2.stItem[n2].iVsh > -1) {
                    las3Struct2.sData[n2][14] = new String(lasStandardTools.LAS_TOOLS[pfefferDataListStruct2.stItem[n2].iVsh][1]);
                    las3Struct2.sData[n2][15] = new String("" + pfefferDataListStruct2.stItem[n2].dClean);
                    las3Struct2.sData[n2][16] = new String("" + pfefferDataListStruct2.stItem[n2].dShale);
                }
                las3Struct2.sData[n2][17] = new String("" + d);
                las3Struct2.sData[n2][18] = new String("" + d);
                las3Struct2.sData[n2][19] = new String("" + d);
                las3Struct2.sData[n2][20] = new String("" + d);
                las3Struct2.sData[n2][21] = new String("" + d);
                if (pfefferDataListStruct2.stItem[n2].iPHIt > -1) {
                    las3Struct2.sData[n2][17] = new String(pfefferMath.PHI_TYPE[pfefferDataListStruct2.stItem[n2].iPHIt]);
                    if (pfefferDataListStruct2.stItem[n2].iPHI1 > -1) {
                        las3Struct2.sData[n2][18] = new String(lasStandardTools.LAS_TOOLS[pfefferDataListStruct2.stItem[n2].iPHI1][1]);
                    }
                    if (pfefferDataListStruct2.stItem[n2].iPHI2 > -1) {
                        las3Struct2.sData[n2][19] = new String(lasStandardTools.LAS_TOOLS[pfefferDataListStruct2.stItem[n2].iPHI2][1]);
                    }
                    las3Struct2.sData[n2][20] = new String("" + pfefferDataListStruct2.stItem[n2].dGrain);
                    las3Struct2.sData[n2][21] = new String("" + pfefferDataListStruct2.stItem[n2].dFluid);
                }
                las3Struct2.sData[n2][22] = new String("NO");
                if (pfefferDataListStruct2.stItem[n2].iPHIVsh == 1) {
                    las3Struct2.sData[n2][22] = new String("YES");
                }
                las3Struct2.sData[n2][23] = new String("" + pfefferDataListStruct2.stItem[n2].dPHIShale1);
                las3Struct2.sData[n2][24] = new String("" + pfefferDataListStruct2.stItem[n2].dPHIShale2);
                las3Struct2.sData[n2][25] = new String("" + d);
                las3Struct2.sData[n2][26] = new String("" + d);
                las3Struct2.sData[n2][27] = new String("" + d);
                if (pfefferDataListStruct2.stItem[n2].iPHI2nd > -1) {
                    las3Struct2.sData[n2][25] = new String(lasStandardTools.LAS_TOOLS[pfefferDataListStruct2.stItem[n2].iPHI2nd][1]);
                    las3Struct2.sData[n2][26] = new String("" + pfefferDataListStruct2.stItem[n2].dtGrain);
                    las3Struct2.sData[n2][27] = new String("" + pfefferDataListStruct2.stItem[n2].dtFluid);
                }
                las3Struct2.sData[n2][28] = new String("NO");
                if (pfefferDataListStruct2.stItem[n2].iPHI2ndVsh == 1) {
                    las3Struct2.sData[n2][28] = new String("YES");
                }
                las3Struct2.sData[n2][29] = new String("" + pfefferDataListStruct2.stItem[n2].dPHI2ndShale);
                las3Struct2.sData[n2][30] = new String("" + pfefferDataListStruct2.stItem[n2].dPhiCut);
                las3Struct2.sData[n2][31] = new String("" + pfefferDataListStruct2.stItem[n2].dSwCut);
                las3Struct2.sData[n2][32] = new String("" + pfefferDataListStruct2.stItem[n2].dVshCut);
                las3Struct2.sData[n2][33] = new String("" + pfefferDataListStruct2.stItem[n2].dBvwCut);
                las3Struct2.sData[n2][34] = new String("" + pfefferDataListStruct2.stItem[n2].P);
                las3Struct2.sData[n2][35] = new String("" + pfefferDataListStruct2.stItem[n2].Q);
                las3Struct2.sData[n2][36] = new String("" + pfefferDataListStruct2.stItem[n2].R);
                las3Struct2.sData[n2][37] = new String("" + pfefferDataListStruct2.stItem[n2].dThickness);
                las3Struct2.sData[n2][38] = new String("" + pfefferDataListStruct2.stItem[n2].dHydroCarbon);
                las3Struct2.sData[n2][39] = new String("" + pfefferDataListStruct2.stItem[n2].dPay);
                las3Struct2.sData[n2][40] = new String("" + pfefferDataListStruct2.stItem[n2].dPorosity);
                las3Struct2.sData[n2][41] = new String("" + pfefferDataListStruct2.stItem[n2].dSaturation);
            }
        }
        return las3Struct2;
    }

    public static las3Struct setPfefferData(pfefferDataListStruct pfefferDataListStruct2, double d) {
        las3Struct las3Struct2 = null;
        if (pfefferDataListStruct2 != null) {
            las3Struct2 = new las3Struct();
            las3Struct2.iType = 14;
            las3Struct2.iArray = 0;
            las3Struct2.sType = new String(las3Constants.SECTIONS[las3Struct2.iType]);
            las3Struct2 = las3LoadPfefferData.addPfParameters(pfefferDataListStruct2, las3Struct2);
            las3Struct2 = las3LoadPfefferData.addPfCurves(pfefferDataListStruct2, las3Struct2, d);
        }
        return las3Struct2;
    }

    public static las3Struct addPfParameters(pfefferDataListStruct pfefferDataListStruct2, las3Struct las3Struct2) {
        if (pfefferDataListStruct2 != null && las3Struct2 != null) {
            las3Struct2.iParamRows = 1;
            las3Struct2.iParamCols = 6;
            las3Struct2.sParams = new String[las3Struct2.iParamRows][las3Struct2.iParamCols];
            for (int i = 0; i < 6; ++i) {
                las3Struct2.sParams[0][i] = new String("");
            }
            las3Struct2.sParams[0][0] = new String(PARAM[0][0]);
            las3Struct2.sParams[0][3] = new String(PARAM[0][1]);
            las3Struct2.sParams[0][1] = new String(PARAM[0][2]);
            las3Struct2.sParams[0][4] = new String(PARAM[0][3]);
        }
        return las3Struct2;
    }

    public static las3Struct addPfCurves(pfefferDataListStruct pfefferDataListStruct2, las3Struct las3Struct2, double d) {
        int n = 0;
        String string = "";
        String string2 = "";
        double d2 = 0.0;
        int n2 = 0;
        if (pfefferDataListStruct2 != null && las3Struct2 != null) {
            int n3;
            las3Struct2.iCurveRows = 19;
            las3Struct2.iCurveCols = 6;
            las3Struct2.sCurves = new String[las3Struct2.iCurveRows][las3Struct2.iCurveCols];
            for (int i = 0; i < 19; ++i) {
                for (n3 = 0; n3 < 6; ++n3) {
                    las3Struct2.sCurves[n][n3] = new String("");
                }
                las3Struct2.sCurves[n][0] = new String(pfefferStandardTools.CURVES[i][1]);
                las3Struct2.sCurves[n][1] = new String(pfefferStandardTools.CURVES[i][3]);
                las3Struct2.sCurves[n][3] = new String(pfefferStandardTools.CURVES[i][2]);
                las3Struct2.sCurves[n][4] = new String(pfefferStandardTools.CURVES[i][6]);
                ++n;
            }
            n2 = 0;
            for (n3 = 0; n3 < pfefferDataListStruct2.iCount; ++n3) {
                n2 += pfefferDataListStruct2.stItem[n3].iRows;
            }
            las3Struct2.iRows = n2;
            las3Struct2.iColumns = las3Struct2.iCurveRows;
            las3Struct2.sData = new String[las3Struct2.iRows][las3Struct2.iColumns];
            n = 0;
            for (n3 = 0; n3 < pfefferDataListStruct2.iCount; ++n3) {
                for (int i = 0; i < pfefferDataListStruct2.stItem[n3].iRows; ++i) {
                    if (n >= n2) continue;
                    las3Struct2.sData[n][0] = new String(pfefferDataListStruct2.stItem[n3].sKEY + "_" + n);
                    las3Struct2.sData[n][1] = new String("" + pfefferDataListStruct2.stItem[n3].depth[i]);
                    las3Struct2.sData[n][2] = new String("" + pfefferDataListStruct2.stItem[n3].thick[i]);
                    las3Struct2.sData[n][3] = new String("" + pfefferDataListStruct2.stItem[n3].Rt[i]);
                    las3Struct2.sData[n][4] = new String("" + pfefferDataListStruct2.stItem[n3].PHIt[i]);
                    las3Struct2.sData[n][5] = new String("" + pfefferDataListStruct2.stItem[n3].Vsh[i]);
                    las3Struct2.sData[n][6] = new String("" + pfefferDataListStruct2.stItem[n3].PHI1st[i]);
                    las3Struct2.sData[n][7] = new String("" + pfefferDataListStruct2.stItem[n3].PHI2nd[i]);
                    las3Struct2.sData[n][8] = new String("" + pfefferDataListStruct2.stItem[n3].Rwa[i]);
                    las3Struct2.sData[n][9] = new String("" + pfefferDataListStruct2.stItem[n3].Ro[i]);
                    las3Struct2.sData[n][11] = new String("" + pfefferDataListStruct2.stItem[n3].Ma[i]);
                    las3Struct2.sData[n][12] = new String("" + pfefferDataListStruct2.stItem[n3].Sw[i]);
                    las3Struct2.sData[n][13] = new String("" + pfefferDataListStruct2.stItem[n3].BVW[i]);
                    las3Struct2.sData[n][14] = new String("" + pfefferDataListStruct2.stItem[n3].Pay[i]);
                    las3Struct2.sData[n][15] = new String("" + pfefferDataListStruct2.stItem[n3].PHIr[i]);
                    las3Struct2.sData[n][16] = new String("" + pfefferDataListStruct2.stItem[n3].Rxo[i]);
                    las3Struct2.sData[n][17] = new String("" + pfefferDataListStruct2.stItem[n3].Sxo[i]);
                    las3Struct2.sData[n][18] = new String("" + pfefferDataListStruct2.stItem[n3].BVF[i]);
                    ++n;
                }
            }
        }
        return las3Struct2;
    }
}

